<?php
/**
* Created by PhpStorm.
* User: claiton.nazaret
* Date: 03/07/2018
* Time: 14:06
*/

class ArquivoConfiguracao {

	private $path;
	private $arquivo;
	private $ext;
	private $modo;
	private $mensagem = array();
	private $dados;

	/**
	* ArquivoConfiguracao constructor.
	* @param $path
	* @param $arquivo
	* @param $ext
	* @param $modo
	*/
	public function __construct($dados) {
		$this->path = __DIR__ . "/../library/conf/";
		$this->arquivo = "dbConfig";
		$this->ext = ".xml";
		$this->modo = "w+";
		$this->dados = $dados;
	}

	public function gerarArquivo() {
		$retorno = array(
			"status" => false,
			"msg" => "Não foi possível gerar o arquivo de configuração: \n\n"
		);
		if($this->verificaDiretorio() == 1){
			$retorno['status'] = true;
			if($this->gerarArquivos() == 0){
				$retorno['status'] = false;
			}
		}
		$retorno['msg'] = implode("<br/>", $this->mensagem);
		return $retorno;
	}

	private function gerarArquivos() {
		$ret = 1;
		//dbConfig.xml
		$completePath = $this->path . $this->arquivo . $this->ext;
		$this->mensagem[] = (!file_exists($completePath) ?
		"Gerando arquivo $this->arquivo." : "Sobrescrevendo arquivo $this->arquivo existente.");
		$conteudo = $this->getXmlDbConfig();
		$openDbConfig = fopen($completePath, $this->modo);
		if($openDbConfig){
			chmod($completePath, 0777);
		}
		fwrite($openDbConfig, $conteudo);
		if(!fclose($openDbConfig)){
			$ret = 0;
			$this->mensagem[] = "Erro ao salvar o arquivo $this->arquivo. Tente novamente mais tarde";
		}else{
			$flywayConf = __DIR__."/../WebSocialUpdate/flyway/conf/flyway.conf";
			$conteudo = $this->getFileFlyway();
			$this->mensagem[] = (!file_exists($flywayConf) ?
			"Gerando arquivo flyway.conf." : "Sobrescrevendo arquivo flyway.conf existente.");
			$openFlyway = fopen($flywayConf, $this->modo);
			fwrite($openFlyway, $conteudo);
			if (!fclose($openFlyway)) {
				$ret = 0;
				unlink($completePath);
				$this->mensagem[] = "Erro ao salvar o arquivo flyway.conf. Tente novamente mais tarde";
			} else {
				$xml = simplexml_load_file($completePath);
				$host = base64_decode($xml->conexao->host);
				$banco = base64_decode($xml->conexao->dbname);
				$porta = base64_decode($xml->conexao->porta);
				$user = base64_decode($xml->conexao->user);
				$pass = base64_decode($xml->conexao->password);
				$conn = base64_decode($xml->conexao->typeconn);
				$adapter = base64_decode($xml->conexao->adapter);

				if($conn == "PDO_PGSQL"){
					if ($adapter == "PDO_OCI") {
						$ret = 0;
						$this->mensagem[] = "Adapter PDO_OCI so pode ser utilizado com base Oracle!";
					}else{
						$db = pg_connect("host=$host dbname=$banco user=$user port=$porta password=$pass options='--client_encoding=UTF8'");
						pg_set_client_encoding( $db,'UNICODE');
					}
				}else{
					if ($adapter == "PDO_PGSQL") {
						$ret = 0;
						$this->mensagem[] = "Adapter PDO_PGSQL so pode ser utilizado com base Postgres!";
					}else{
						$db = oci_connect($user, $pass,
						"(DESCRIPTION = (ADDRESS = (PROTOCOL = TCP)(HOST = $host)(PORT = $porta)) (CONNECT_DATA = (SERVICE_NAME = $banco)))");
					}
				}
				if(!$db){
					$this->mensagem[] = "Não conectou!";
					$ret = 0;
				}else{
					$this->mensagem[] = "Conectado!";
				}
			}
		}
		return $ret;
	}

	private function verificaDiretorio() {
		$ret = 1;
		if (!is_dir($this->path)) {
			if (mkdir($this->path, 0777)) {
				$this->mensagem[] = " * Diretório $this->path gerado.";
			} else {
				$this->mensagem[] = " - Não foi possível gerar o diretório.";
				$ret = 0;
			};
		}
		return $ret;
	}

	/**
	* @return array
	*/
	public function getMensagem() {
		return $this->mensagem;
	}

	private function getXmlDbConfig() {
		return "<?xml version=\"1.0\"?>
						<conexoes>
							<conexao>
								<host>".base64_encode($this->dados['host'])."</host>
								<dbname>".base64_encode($this->dados['banco'])."</dbname>
								<porta>".base64_encode($this->dados['porta'])."</porta>
								<user>".base64_encode($this->dados['usuario'])."</user>
								<password>".base64_encode($this->dados['senha'])."</password>
								<adapter>".base64_encode($this->dados['conexao'])."</adapter>
								<charset>".base64_encode("UTF-8")."</charset>
								<typeconn>".base64_encode($this->dados['conexao'])."</typeconn>
							</conexao>
						</conexoes>";
	}

	private function getFileFlyway(){
		$host = $this->dados['host'];
		$banco = $this->dados['banco'];
		$porta = $this->dados['porta'];
		$usuario = $this->dados['usuario'];
		$senha = $this->dados['senha'];
		return "######## ip_servidor:porta/banco_dados ########\n
		flyway.url=jdbc:postgresql://$host:$porta/$banco?currentSchema=social
		flyway.driver=org.postgresql.Driver
		# usuario
		flyway.user=$usuario
		# senha
		flyway.password=$senha
		flyway.validateOnMigrate=false";
	}
}

$dados = [
	"conexao" => $_GET['conexao'],
	"host"    => $_GET['host'],
	"banco"   => $_GET['banco'],
	"porta"   => $_GET['porta'],
	"usuario" => $_GET['usuario'],
	"senha"   => $_GET['senha'],
];
$conf = new ArquivoConfiguracao($dados);
header('Content-Type: application/json');
echo json_encode($conf->gerarArquivo());
