<?php
    ini_set("display_errors", 1);
    define("DS", DIRECTORY_SEPARATOR);
    define("SOCIAL", dirname(__FILE__) . DS);
    define("SAUDE", dirname(__FILE__) . DS);
    define("COMUM", dirname( SOCIAL ) . DS . "WebSocialComum" . DS);
    define("LINKCOMUM", "/WebSocialComum" );
    define("LINKSAUDE", "/WebSocialSaude" );
    function getBancoInstancia() {
        $arquivoXml = COMUM . "library/conf/dbConfig.xml";
        $xml = simplexml_load_file($arquivoXml);
	
        $banco = base64_decode($xml->conexao->adapter);
        $host = base64_decode($xml->conexao->host);
	$dbname = base64_decode($xml->conexao->dbname);
	$usuario = base64_decode($xml->conexao->user);
	$porta = base64_decode($xml->conexao->porta);
	$senha = base64_decode($xml->conexao->password);
	//
        $parametros = array("host"   =>$host,
                            "dbname" =>$dbname,
                            "usuario"=>$usuario,
                            "porta"  =>$porta,
                            "senha"  =>$senha,
                            "banco"  =>$banco);
        return $parametros;
	
    }


    function bd_connect(){
        $array_banco =  getBancoInstancia();
        if($array_banco["banco"] == "PDO_PGSQL"){
             define("CONN",pg_connect("host=$array_banco[host] "
                           . "dbname=$array_banco[dbname] "
                           . "user=$array_banco[usuario] "
                           . "port=$array_banco[porta] "
                           . "password=$array_banco[senha] options='--client_encoding=UTF8'") or die("Conexão Postgres falhou"));
            pg_set_client_encoding( UNICODE);
            
        }else if($array_banco["banco"] == "PDO_OCI"){
            define("CONN",oci_connect("social",
                              "social", 
                              '(DESCRIPTION = (ADDRESS = (PROTOCOL = TCP)(HOST = 192.168.1.88)(PORT = 1521)) (CONNECT_DATA = (SERVICE_NAME = orcl.168.1.88) (SID = ORCL)))'));
        }
    }

    function bd_query($sql){
        $banco =  getBancoInstancia()["banco"];
        if($banco == "PDO_PGSQL"){
            $stid = pg_query($sql);
        }else if($banco == "PDO_OCI"){
           $stid = oci_parse(CONN, $sql);
           oci_execute($stid);
        }
        return $stid;
    }

   function bd_fetch_array($stmt){
       $banco =  getBancoInstancia()["banco"];
        if($banco == "PDO_PGSQL"){
            $regs = pg_fetch_array($stmt);
        }else if($banco == "PDO_OCI"){
            $regs = oci_fetch_array($stmt, OCI_ASSOC+OCI_RETURN_NULLS);
        }
        return $regs;
   }
   
   function bd_num_rows($stmt){
       $banco =  getBancoInstancia()["banco"];
        if($banco == "PDO_PGSQL"){
            $num = pg_num_rows($stmt);
        }else if($banco == "PDO_OCI"){
            $num = oci_num_rows($stmt);
        }
        return $num;
   }
   
   function bd_fetch_assoc($stmt){
       $banco =  getBancoInstancia()["banco"];
        if($banco == "PDO_PGSQL"){
            $regs = pg_fetch_assoc($stmt);
        }else if($banco == "PDO_OCI"){
            $regs = oci_fetch_assoc($stmt);
        }
        return $regs;
   }