<?php

/** Variável global para pegar número de linhas */
$DB_NUM_ROWS = 0;

/** Executa uma query
 * @return resource_link
 * @param $stmt Parâmetro
 */
function db_query($stmt, $log = true)
{
    global $DB_NUM_ROWS;
    $resource_result = @ pg_query($stmt);

    switch (db_parseFirstCommand($stmt)) {
        case 'UPDATE':
        case 'DELETE':
        case 'INSERT':
            $DB_NUM_ROWS = @ pg_affected_rows($resource_result);
            break;
        default :
            $DB_NUM_ROWS = @ pg_num_rows($resource_result);
    }

    if ($log) {
        GLOBAL $LOG_MSG, $id_login;
        /*		$stmt_log = "INSERT INTO log ".
                    "(usr_codigo, log_msg, log_arquivo, log_qs, log_ip, log_sql) ".
                    "VALUES (".
                        "". ( intval($id_login) ) .",".
                        "'". $LOG_MSG ."',".
                        "'". $_SERVER['PHP_SELF'] ."',".
                        "'". $_SERVER['QUERY_STRING'] ."',".
                        "'". $_SERVER['REMOTE_ADDR'] ."',".
                        "'". addslashes($stmt) . "') ";

                db_query( $stmt_log, false );
        */
    }

    if (!$resource_result) {
        $err_msg = @ pg_last_error();
        die("<p>Erro com sql:<pre>$stmt</pre>$err_msg</p>");
    }

    return $resource_result;
}

/** Pega uma 'row' (linha/array) inteiro de uma query
 * @param    $stmt    string
 * @return    mixed
 */
function db_getRow($stmt)
{
    $q = db_query($stmt);
    return pg_fetch_array($q);
}

/** 'Pega' o valor de uma coluna específica
 * @public
 * @param    $stmt    string
 * @return    mixed
 */
function db_get($stmt)
{
    $q = db_query($stmt);
    $row = pg_fetch_array($q);
    return $row[0];
}

/** "Tenta" pegar o primeiro comando do Stmt
 * @param    $sql String da sql
 * @return    String (strtoupper) com o 1o comando
 */
function db_parseFirstCommand($sql)
{
    $fc = @ preg_split("/ /", $sql);
    return strtoupper($fc[0]);
}

/**
 * Seleciona o próximo valor do auto-incremento
 * @param string $seq nome da sequência
 * @author Falci
 */
function nextVal($seq)
{
    $query = pg_query("SELECT nextval('$seq');");
    $res = pg_fetch_array($query);
    return $res[0];
}

/**
 * Retorna o uni_codigo baseado na tabela de logon (id_login via session)
 * @return int uni_codigo
 */
function getUnidadeByLogon()
{
    $sql = "SELECT uni_codigo FROM logon WHERE id_login={$_SESSION['id_login']} ORDER BY dt_entrada DESC";
    $query = pg_query($sql);
    if (!pg_num_rows($query))
        die("Session vazia");
    $res = pg_fetch_array($query);
    return $res['uni_codigo'];
}

/**
 * Retorna o uni_codigo baseado na tabela de logon (id_login via session)
 * @return int uni_codigo
 */
function getTipoUnidadeByLogon()
{
    $sql = "SELECT uni_codigo FROM logon WHERE id_login={$_SESSION['id_login']} ORDER BY dt_entrada DESC";
    $query = pg_query($sql);
    if (!pg_num_rows($query))
        die("Session vazia");
    $temp = pg_fetch_array($query);

    $sqlTipo = "SELECT uni_tipo FROM unidade WHERE uni_codigo = $temp[uni_codigo];";
    $queryTipo = pg_query($sqlTipo);
    if (!pg_num_rows($queryTipo))
        die("Session vazia");
    $resTipo = pg_fetch_array($queryTipo);
    return $resTipo[uni_tipo];
}

/**
 * Retorna o set_codigo baseado na tabela de logon (id_login via session)
 * @return int uni_codigo
 */
function getSetorByLogon()
{
    $sql = "SELECT cod_setor FROM logon WHERE id_login={$_SESSION['id_login']};";
    $query = pg_query($sql) or die("$sql\n" . pg_last_error());
    if (!pg_num_rows($query))
        die("Session vazia");
    $res = pg_fetch_array($query);
    return $res[cod_setor];
}

/**
 * Retorna o valor de uma configuração no banco
 * @param string $chave
 * @return mixed valor salvo no banco
 */
function getConfig($chave)
{
    $sql = "SELECT * FROM config WHERE conf_chave='$chave'";
    $query = pg_query($sql);
    //die($sql);
    if (!pg_num_rows($query))
        return NULL;

    $row = pg_fetch_object($query);
    switch ($row->conf_tipo) {
        case 1:
            return (string)$row->conf_valor_string;
            break;
        case 2:
            return ($row->conf_valor_bool == 't' ? TRUE : FALSE);
            break;
        case 3:
            return (int)$row->conf_valor_int;
            break;
        case 4:
            return (string)$row->conf_valor_data;
            break;
        default:
            return (string)$row->conf_valor_string;
            break;
    }
}

function mesmaVersaoBanco($chave, $sistema = FALSE)
{
    if (!$sistema)
        $sistema = $_SESSION['versao'];

    // versão minima para funcionar
    $min = getConfig($chave);
    list($geracao, $versao, $bancoMin) = explode(".", $min);
    list($geracao, $versao, $bancoSis, $biuld) = explode(".", $sistema);
    //echo "banco".$bancoMin . "sis".$bancoSis;

    return (bool)($bancoMin === $bancoSis);
}

function versaoBancoESistema($chave, $sistema = FALSE)
{
    if (!$sistema)
        $sistema = $_SESSION['versao'];

    // versão minima para funcionar
    $min = getConfig($chave);
    list($geracao, $versao, $bancoMin) = explode(".", $min);
    list($geracao, $versao, $bancoSis, $biuld) = explode(".", $sistema);
    //echo "banco".$bancoMin . "sis".$bancoSis;

    echo $min . "|" . $sistema;
}

/**
 * Retorna o nome do usuario logado baseado na tabela de logon (id_login via session)
 * @return Strin usr_nome
 */
function getNomeUsuario()
{

    $sql = "SELECT usr_nome
				  FROM logon l
				  JOIN usuarios u
				    ON u.usr_codigo = l.id_login
				  WHERE id_login=" . ($_SESSION['id_login'] == '' ? $_SESSION['usr_codigo'] : $_SESSION['id_login']) . ";";
    //die($sql);
    $query = pg_query($sql);
    if (!pg_num_rows($query))
        die("Session vazia");
    $res = pg_fetch_array($query);
    return $res[usr_nome];
}

pg_set_client_encoding(UNICODE);
