<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 02/01/2019
 * Time: 15:30
 */

include_once '../global.php';
include_once $_SESSION['root'] . $_SESSION['comum'] . 'library/php/funcoes.inc.php';
pg_set_client_encoding( 'UNICODE');

class Login {

	private $usuario;
	private $senha;
	private $erros;
	private $retorno = [
		"status" => false,
		"statusUsuario" => false,
		"statusSenha" => false,
		"mensagem" => "",
		"dados" => [
			"trocasenha" => "N",
			"logon" => [],
			"unidades" => [],
			"especialidades" => [],
			"setores" => []
		]
	];

	/**
	 * Login constructor.
	 * @param $usuario
	 * @param $senha
	 */
	public function __construct($usuario=null, $senha=null) {
		$this->usuario = $usuario;
		$this->senha = $senha;
		$this->erros = [
			"une" => "* Usuário não encontrado",
			"si" => "* Senha incorreta",
		];
	}

	public function logar($sistema){
		$trocaSenha = $this->verificaTrocaSenha();
		if(!empty($trocaSenha)){
			$this->retorno['status'] = true;
			$this->retorno['dados']['usr_codigo'] = $trocaSenha['usr_codigo'];
			$this->retorno['dados']['trocasenha'] = $trocaSenha['usr_troca_senha'];
			if($trocaSenha['usr_troca_senha'] == "N"){
				$this->retorno = $this->checkAuth($sistema);
			}
		}else{
			$this->retorno['statusUsuario'] = true;
			$this->retorno['mensagem'] = $this->erros['une'];
		}
		return $this->retorno;
	}

	public function confirma(){
		$result = pg_query("SELECT usr_codigo 
										 FROM usuarios 
									    WHERE usr_codigo = $this->usuario 
									      AND usr_senha = '$this->senha'");
		$res = pg_fetch_array($result);
		if(!empty($res)){
			$this->retorno['status'] = true;
		};
		return $this->retorno;
	}

	public function atualiza(){
		$result = pg_query("UPDATE usuarios 
										  SET usr_senha = '$this->senha', usr_troca_senha = 'N' 
									    WHERE usr_codigo = $this->usuario");
		$this->retorno['status'] = boolval($result);
		return $this->retorno;
	}

	public function carregaEspecialidades($usr_codigo, $uni_codigo = FALSE){
		$compl = ($uni_codigo ? " AND uni.uni_codigo = $uni_codigo " : "");
		$query = pg_query("SELECT 
					esp.esp_codigo, 
					esp.esp_nome 
				  FROM especialidade esp
				  JOIN medico_especialidade mes ON mes.esp_codigo=esp.esp_codigo
				  JOIN unidade uni ON uni.uni_codigo = mes.uni_codigo
				 WHERE med_codigo = $usr_codigo $compl
				   AND mes_ativo <> 'I'");
		if(pg_num_rows($query) > 0){
			while($row = pg_fetch_array($query)){
				$this->retorno['dados']['especialidades'][] = $row;
			}
		}
	}

	public function carregaSetores($usr_codigo, $uni_codigo = FALSE){
		$compl = ($uni_codigo ? " AND uni.uni_codigo = $uni_codigo " : "");
		$query = pg_query("SELECT 
											set.set_codigo, 
											set.set_nome 
										FROM setor set
										JOIN usuarios_setores uset ON set.set_codigo=uset.set_codigo 
										JOIN usuarios usr ON uset.usr_codigo=usr.usr_codigo 
										JOIN unidade uni ON set.uni_codigo=uni.uni_codigo 
									   WHERE usr.usr_codigo =$usr_codigo $compl 
									     AND ativo = 'S'");
		if(pg_num_rows($query) > 0){
			while($row = pg_fetch_array($query)){
				$this->retorno['dados']['setores'][] = $row;
			}
		}
	}

	public function logon($dados) {
		$fields = "id_login, dt_entrada, dt_atualizacao, sis_saude, ";
		$fields .= (!empty($dados['set_codigo']) ? "cod_setor," : "");
		$fields .= (!empty($dados['esp_codigo']) ? "esp_codigo," : "");
		$fields .= (!empty($dados['uni_codigo']) ? "uni_codigo," : "");

		$values = "$dados[usr_codigo], NOW(), NOW(), TRUE, ";
		$values .= (!empty($dados['set_codigo']) ? $dados['set_codigo']."," : "");
		$values .= (!empty($dados['esp_codigo']) ? $dados['esp_codigo']."," : "");
		$values .= (!empty($dados['uni_codigo']) ? $dados['uni_codigo']."," : "");

		$sql = "INSERT INTO logon (" .substr($fields, 0, strlen($fields)-1). ") 
					 VALUES (" .substr($values, 0, strlen($values)-1). ")";
		$query = pg_query($sql);

		if($query){
			session_start();
			$_SESSION['login'];
			$_SESSION[md5("id")] = base64_encode($dados['usr_codigo']);
			return $this->retorno['status'] = true;
		}else{
			$this->retorno['status'] = false;
			$this->retorno['mensagem'] = pg_result_error($query);

			return $this->retorno;
		}
	}

	public function logonSocial($dados) {
		$fields = "id_login, dt_entrada, dt_atualizacao, sis_saude, ";
		$fields .= (!empty($dados['esp_codigo']) ? "esp_codigo," : "");
		$fields .= (!empty($dados['uni_codigo']) ? "uni_codigo," : "");

		$values = "$dados[usr_codigo], NOW(), NOW(), FALSE, ";
		$values .= (!empty($dados['esp_codigo']) ? $dados['esp_codigo']."," : "");
		$values .= (!empty($dados['uni_codigo']) ? $dados['uni_codigo']."," : "");

		$sql = "INSERT INTO logon (" .substr($fields, 0, strlen($fields)-1). ") 
					 VALUES (" .substr($values, 0, strlen($values)-1). ")";
		$query = pg_query($sql);

		if($query){
			session_start();
			$_SESSION['login'];
			$_SESSION['usr_codigo'] = $dados['usr_codigo'];
			$_SESSION[md5("id")] = base64_encode($dados['usr_codigo']);
			return $this->retorno['status'] = true;
		}else{
			$this->retorno['status'] = false;
			$this->retorno['mensagem'] = pg_result_error($query);

			return $this->retorno;
		}
	}

	public function carregaCombos($dados) {
		$this->carregaEspecialidades($dados['usr_codigo'], $dados['uni_codigo']);
		$this->carregaSetores($dados['usr_codigo'], $dados['uni_codigo']);
		return $this->retorno;
	}

	private function verificaTrocaSenha(){
		$result = pg_query("SELECT usr_codigo, usr_troca_senha FROM usuarios WHERE usr_login = '$this->usuario'");
		return ($result ? pg_fetch_array($result) : []);
	}

	private function checkAuth($sistema){
		$result = pg_query("SELECT usr_codigo 
										 FROM usuarios 
										WHERE usr_login = '$this->usuario'
										  AND usr_senha = '$this->senha'");
		if(pg_num_rows($result) > 0){
			$this->retorno['status'] = true;
			$usr_codigo = pg_fetch_array($result)['usr_codigo'];
			if($sistema == "SAUDE"){
				$this->carregaDadosSaude($usr_codigo);
			}else{
				$this->carregaDadosSocial($usr_codigo);
			}
		}else{
			$this->retorno['status'] = false;
			$this->retorno['statusSenha'] = true;
			$this->retorno['mensagem'] = $this->erros['si'];
		}
		return $this->retorno;
	}

	private function carregaDadosSaude($usr_codigo) {
		$sql = "SELECT 
					uni.uni_codigo,
					uni.uni_desc 
				  FROM unidade AS uni
				  JOIN unidade_usuarios uu ON uu.uni_codigo=uni.uni_codigo
				 WHERE usr_codigo = $usr_codigo
				   AND cnes_ativo = 'A'
				 ORDER BY uni_desc";
		$result = pg_query($sql);
		if(pg_num_rows($result) > 0){
			while($row = pg_fetch_array($result)){
				$this->retorno['dados']['unidades'][] = $row;
			}

			$this->buscaDadosLogonSaude($usr_codigo, $this->retorno['dados']['unidades'][0]);
		}
	}

	private function carregaDadosSocial($usr_codigo) {
		$sql = "SELECT
				  DISTINCT
				  uni.uni_codigo,
				  uni.uni_desc
				FROM usuarios usr
				  JOIN unidade_usuarios unu ON usr.usr_codigo = unu.usr_codigo
				  JOIN unidade uni ON uni.uni_codigo = unu.uni_codigo
				  JOIN medico_especialidade mes ON uni.uni_codigo = mes.uni_codigo
				WHERE unu.usr_codigo = $usr_codigo AND uni_as = TRUE";
		$result = pg_query($sql);
		while($row = pg_fetch_array($result)){
			$this->retorno['dados']['unidades'][] = $row;
		}

		if(pg_num_rows($result) > 0){
			while($row = pg_fetch_array($result)){
				$this->retorno['dados']['unidades'][] = $row;
			}

			$this->buscaDadosLogonSocial($usr_codigo, $this->retorno['dados']['unidades'][0]);
		}
	}

	private function buscaDadosLogonSaude($usr_codigo, $uni_codigo) {
		$result = pg_query("SELECT * 
									     FROM logon 
									    WHERE id_login = $usr_codigo 
									      AND sis_saude IS TRUE
									    ORDER BY dt_entrada DESC 
									    LIMIT 1");
		if(pg_num_rows($result) > 0){
			$res = pg_fetch_array($result);
			$this->retorno['dados']['logon'] = $res;
			$this->carregaEspecialidades($usr_codigo, $res['uni_codigo']);
			$this->carregaSetores($usr_codigo, $res['uni_codigo']);
		}else{
			$this->carregaEspecialidades($usr_codigo, $uni_codigo);
		}
	}

	private function buscaDadosLogonSocial($usr_codigo, $uni_codigo) {
		$result = pg_query("SELECT * 
									     FROM logon 
									    WHERE id_login = $usr_codigo 
									      AND sis_saude IS FALSE
									    ORDER BY dt_entrada DESC 
									    LIMIT 1");
		if(pg_num_rows($result) > 0){
			$res = pg_fetch_array($result);
			$this->retorno['dados']['logon'] = $res;
			$this->carregaEspecialidades($usr_codigo, $res['uni_codigo']);
		}else{
			$this->carregaEspecialidades($usr_codigo, $uni_codigo);
		}
	}
}

$acao = $_POST['acao'];
switch ($acao){
	case "logar":
		$usuario = $_POST['usuario'];
		$senha = md5($_POST['senha']);
		$sistema = $_POST['sistema'];
		echo json_encode((new Login($usuario, $senha))->logar($sistema));
		break;
	case "redefinir":
		$senha = md5($_POST['senha']);
		$novasenha = md5($_POST['novasenha']);
		break;
	case "confirma":
		$usuario = $_POST['usuario'];
		$senha = md5($_POST['senha']);
		echo json_encode((new Login($usuario, $senha))->confirma());
		break;
	case "atualiza":
		$usuario = $_POST['usuario'];
		$senha = md5($_POST['senha']);
		echo json_encode((new Login($usuario, $senha))->atualiza());
		break;
	case "logon":
		$dados = $_POST;
		echo json_encode((new Login())->logon($dados));
		break;
	case "logon-social":
		$dados = $_POST;
		echo json_encode((new Login())->logonSocial($dados));
		break;
	case "carregarCombos":
		$dados = $_POST;
		echo json_encode((new Login())->carregaCombos($dados));
		break;
}
