<?php
    include_once "../library/php/db.inc.php";

    function validaDadosDomicilio($dom_codigo){
        $sql = "(SELECT  d.dom_codigo,
                (ds_tipo_logradouro ||' '||r.rua_nome) as rua_nome,
                    (CASE WHEN cast( cast( dom_numero as integer ) as char ) = '0' THEN 'S/N' ELSE cast( cast( dom_numero as integer ) as char(60) ) END) AS dom_numero,
                    COALESCE(dom_complemento,'&nbsp;'),
                    r.rua_cep,
                    b.bai_nome,
                    u.usu_nome,
                    d.tipo_imovel
                FROM domicilio d
                INNER JOIN rua r ON r.rua_codigo = d.rua_codigo
                LEFT JOIN bairro b ON b.bai_codigo = r.bai_codigo
                LEFT JOIN usuario u ON u.usu_codigo = d.usu_codigo_responsavel
                INNER JOIN tb_ms_tipo_logradouro tpl ON tpl.co_tipo_logradouro = r.co_tipo_logradouro
                WHERE d.dom_codigo = $dom_codigo)";
        $query = pg_query($sql) or die($sql . pg_last_error());
        echo json_encode(pg_fetch_array($query));
    }

    if(isset($_POST['action']) && !empty($_POST['action'])) {
        $action = $_POST['action'];
        $dom_codigo = $_POST['dom_codigo'];
        switch($action) {
            case 'validaDomicilio' : validaDadosDomicilio($dom_codigo); break;
        }
    }
?>