<?php

class GeradorRelatorio {

	/**
	* *******IMPORTANTE*******
	* Instalar o JDK Java 1.8
	**/
	public function gerar($sistema, $relatorio, array $params){
		set_time_limit(2000);
		if(!isset($_SESSION)){
			session_start();
		}
		// die(json_encode($params));
    if( $_SESSION['modulo'] == "WebSocialSaude/"){
      $usr_logado = $_SESSION['logon']['usr']->usr_codigo;
    } else if($_SESSION['modulo'] == "WebSocialSocial/" ) {
      $usr_logado = $_SESSION['login']['usr_codigo'];
    }

    if($usr_logado == null)
      $params['medCodigo'] = $_SESSION['med_codigo'];

		$params = $this->encry($sistema,$relatorio, $params, $usr_logado);
		// Descomente esta linha para visualizar os parametros enviados a api de relatorios
//		 die($params);
		$fileJar = __DIR__."/".$this->getJar();
		if ($fileJar != null) {
			$out = shell_exec("java -Xmx1g -jar $fileJar $params");
		} else {
			return array("status" => false, "mensagem" => "Arquivo JAR não encontrado!");
		}
		return $this->abrirRelatorio($out);
	}

	private function encry($sistema, $relatorio, array $params, $usr_logado){
		$conn = $this->getConnection();
		$parametros = [
			"sistema" => $sistema,
			"relatorio" => $relatorio,
			"parametros" => $this->emptyIsNull($params)
		];
		$usr = base64_encode(json_encode($usr_logado));
		$params = base64_encode(json_encode($parametros));
		$conn = base64_encode(json_encode($conn));
		return $params.' '.$conn.' '.$usr;
	}

	private function getJar(){
		$types = array( 'jar' );
		$dir = new DirectoryIterator(__DIR__."/");
		foreach ($dir as $fileInfo) {
			$ext = strtolower( $fileInfo->getExtension() );
			if( in_array( $ext, $types ) ) return $fileInfo->getFilename();
		}
		return null;
	}

	private function getConnection(){
		$arquivo = __DIR__.'/../library/conf/dbConfig.xml';
		$xml = simplexml_load_file($arquivo);
		$host = base64_decode($xml->conexao->host);
		$banco = base64_decode($xml->conexao->dbname);
		$usuario = base64_decode($xml->conexao->user);
		$porta = base64_decode($xml->conexao->porta);
		$senha = base64_decode($xml->conexao->password);
		$typeconn = base64_decode($xml->conexao->typeconn);

		return [
			"host" => $host,
			"porta" => $porta,
			"banco" => $banco,
			"username" => $usuario,
			"password" => $senha,
			"driver" => $typeconn
		];
	}

	private function abrirRelatorio($out) {
		if($out){
			if (strpos($out, "[path_relatorio]") !== false) {
				$outArr = explode("[path_relatorio]", $out);
				// die(json_encode($outArr));
				$url = trim($outArr[1]);
				if(strpos($url, "WebSocialComum") !== false){
					$url_alterada = explode("WebSocialComum", $url);
					$url_alterada = $_SERVER['PHP_SELF']."../../../../WebSocialComum".$url_alterada[1];
				}
				$file = explode("report/", $url_alterada);
				$file_name = $file[1];
				return array("status" => true, "mensagem" => $url_alterada, "filename" => $file_name);
			} else {
				if(strpos($out, "[erro]") !== false){
					$outArr = explode("[erro]", $out);
					$erro = trim($outArr[1]);
					return array("status" => false, "mensagem" => $erro);
				}
				return array("status" => false, "mensagem" => "Arquivo PDF não gerado!");
			}
		}else{
			return array("status" => false, "mensagem" => "Erro ao executar a API de relatórios!");
		}
	}

	private function emptyIsNull($dados=array()){
		foreach ($dados as $key => $dado){
			if(empty($dado)){
				$dados[$key] = NULL;
			}
		}
		return $dados;
	}
}
