<?php

/*
 * @author: Leonardo Abreu.
 * @since : 10/10/2016.
 * @description: Script inserção na tabela bpa, com o esp_cdigo do medico que realizou o processo,
 *               caso o mesmo nao tenha mais de uma especialidade.
 */

session_start();
require_once '../global.php';
define("DS", DIRECTORY_SEPARATOR);
define("COMUM", dirname(SOCIAL) . DS . "WebSocialComum" . DS);
define("LINKCOMUM", "/WebSocialComum");


$_SESSION[modulo] = "WebSocialSaude/"; $_SESSION[root] = $_SERVER[DOCUMENT_ROOT] . "/"; $_SESSION[linkroot] = "http://" . $_SERVER[HTTP_HOST] . "/"; $_SESSION[comum] = "WebSocialComum/"; $_SESSION[modulo] = "WebSocialSaude/"; require_once $_SESSION[root].$_SESSION[modulo]."sessao_controller.php";

$sessao = new TempoSessao();
$sessao->primeiraPagina();

$base = bd_base();

echo "Conectando com a base de dados de: " . $base;
echo "..<br>";
echo "Começando a inserção dos dados..";
echo "<br>";

$retorno = getDadosParaInsercao();
inserindoNaBPA($retorno);

function bd_base() {
    $arquivoXml = COMUM . "library/conf/dbConfig.xml";
    $xml = simplexml_load_file($arquivoXml);
    $dbname = base64_decode($xml->conexao->dbname);
    return $dbname;
}

function getDadosParaInsercao() {
    $sql = "SELECT b.usr_codigo, me.esp_codigo, b.esp_codigo, b.uni_codigo
            FROM bpa b
            LEFT JOIN medico_especialidade me ON me.esp_codigo = b.esp_codigo
            WHERE bpa_data BETWEEN '2016-01-01' AND now()::date 
            GROUP BY b.usr_codigo, me.esp_codigo, b.esp_codigo, b.uni_codigo
            ORDER BY usr_codigo";

    $result = pg_query($sql);

    if (!$result) {
        die("Falha em executar a query 'getDadosParaInsercao()'!");
    }

    $registros = pg_fetch_array($result);

    while ($registros) {
        $dadosRetorno[] = $registros;
        $registros = pg_fetch_array($result);
    }

    return $dadosRetorno;
}

function inserindoNaBPA($dadosConsulta) {

    for ($i = 0; $i < count($dadosConsulta); $i++) {
        if ($dadosConsulta[$i]['usr_codigo'] == '1') {
            continue;
        }
        if ($dadosConsulta[$i]['esp_codigo'] == null ||
                $dadosConsulta[$i]['esp_codigo'] == "null" ||
                $dadosConsulta[$i]['esp_codigo'] == "") {
            continue;
        } else {
            $insert = "UPDATE bpa
                            SET esp_codigo = " . $dadosConsulta[$i]['esp_codigo'] .
                    " WHERE usr_codigo = " . $dadosConsulta[$i]['usr_codigo'];

            //echo $insert . "<br>";
            $rs = pg_query($insert);

            if (!$rs) {
                echo 'Falha na inserção!. Erro: ' . $insert;
            }
        }
    }
    echo "Dados na tabela BPA atualizados com sucesso!";
}
