<?php

/*
 * @author: Leonardo Abreu.
 * @since : 11/11/2016.
 * @description: Script inserção na tabela bpa, com o esp_cdigo do medico que realizou o processo,
 *               caso o mesmo nao tenha mais de uma especialidade.
 */

session_start();
require_once '../global.php';
define("DS", DIRECTORY_SEPARATOR);
define("COMUM", dirname(SOCIAL) . DS . "WebSocialComum" . DS);
define("LINKCOMUM", "/WebSocialComum");
$_SESSION[modulo] = "WebSocialSaude/"; $_SESSION[root] = $_SERVER[DOCUMENT_ROOT] . "/"; $_SESSION[linkroot] = "http://" . $_SERVER[HTTP_HOST] . "/"; $_SESSION[comum] = "WebSocialComum/"; $_SESSION[modulo] = "WebSocialSaude/"; require_once $_SESSION[root].$_SESSION[modulo]."sessao_controller.php";

$sessao = new TempoSessao();
$sessao->primeiraPagina();

$base = bd_base();

echo "Conectando com a base de dados de: " . $base;
echo "..<br>";
echo "Começando a inserção dos dados..";
echo "<br>";

$retorno = getDadosParaInsercao();
atualizandoNaBPA($retorno);

function bd_base() {
    $arquivoXml = COMUM . "library/conf/dbConfig.xml";
    $xml = simplexml_load_file($arquivoXml);
    $dbname = base64_decode($xml->conexao->dbname);
    return $dbname;
}

function getDadosParaInsercao() {
    $sql = "SELECT  b.bpa_codigo,
                    b.esp_codigo,
                    b.usr_codigo,
                    ag.esp_codigo as age_esp,
                    ag.med_codigo as age_med
            FROM bpa b
            INNER JOIN procedimento_atendimento pa ON b.bpa_origem_codigo = pa.pat_codigo AND b.bpa_origem = 'procedimento_atendimento'
            INNER JOIN atendimento a ON a.ate_codigo = pa.ate_codigo
            INNER JOIN agendamento ag ON ag.age_codigo = a.age_codigo
            INNER JOIN especialidade e ON e.esp_codigo = b.esp_codigo
            WHERE b.usr_codigo = ag.med_codigo 
		  AND b.esp_codigo != ag.esp_codigo
            ORDER BY b.bpa_codigo desc";

    $result = pg_query($sql);

    if (!$result) {
        die("Falha em executar a query 'getDadosParaInsercao()'!");
    }

    $registros = pg_fetch_array($result);

    while ($registros) {
        $dadosRetorno[] = $registros;
        $registros = pg_fetch_array($result);
    }

    return $dadosRetorno;
}

function atualizandoNaBPA($dadosConsulta) {

    for ($i = 0; $i < count($dadosConsulta); $i++) {
        $insert = "UPDATE bpa
                        SET esp_codigo = " . $dadosConsulta[$i]['age_esp'] .
                " WHERE bpa_codigo = " .$dadosConsulta[$i]['bpa_codigo'];

        //echo $insert . "<br>";
        $rs = pg_query($insert);

        if (!$rs) {
            echo 'Falha na inserção!. Erro: ' . $insert;
        }
    }
    echo "Dados na tabela BPA atualizados com sucesso!" . count($dadosConsulta) .'registros';
}
