<?php
    class CnesServer {

        private $nome    = null;
        private $host    = null;
        private $banco   = null;
        private $usuario = null;
        private $porta   = null;
        private $senha   = null;
        private $driver  = null;

        private $CODIGO_SISTEMA = "014";

	    /**
	     * CnesServer constructor.
	     */
	    public function __construct() {
		    $arquivoXml = __DIR__ . "/../WebSocialComum/library/conf/dbConfig.xml";;

		    $xml            = simplexml_load_file($arquivoXml);
		    $this->nome     = base64_decode($xml->conexao->nome);
		    $this->host     = base64_decode($xml->conexao->host);
		    $this->banco    = base64_decode($xml->conexao->dbname);
		    $this->usuario  = base64_decode($xml->conexao->user);
		    $this->porta    = base64_decode($xml->conexao->porta);
		    $this->senha    = base64_decode($xml->conexao->password);
		    $this->driver   = base64_decode($xml->conexao->adapter);
	    }

	    private function getChaveAtivacao(){
	    	$conn = pg_connect("host=$this->host dbname=$this->banco port=$this->porta user=$this->usuario password=$this->senha");
		    $sql = "SELECT conf_valor_string FROM config WHERE conf_chave='CHAVE_ATIVACAO_SAUDE'";
		    $result = pg_query($conn, $sql);
		    $anexo = pg_fetch_array($result);
	    	return [
			    "chave" => $anexo['conf_valor_string'],
			    "codigo" => $this->CODIGO_SISTEMA
		    ];
	    }

	    private function getConnectionParams(){
	    	return [
			    "host" => $this->host,
			    "porta" => $this->porta,
			    "banco" => $this->banco,
			    "username" => $this->usuario,
			    "password" => $this->senha,
			    "driver" => $this->driver
		    ];
	    }

	    private function codificaParametros(){
		    $chave = base64_encode(json_encode($this->getChaveAtivacao()));
		    $conection = base64_encode(json_encode($this->getConnectionParams()));
	    	return ($chave." ".$conection);
	    }

	    public function init(){
	    	$java_exec = "..\\WebSocialComum\\WebSocialUpdate\\flyway\\jre\\bin\\java.exe -jar ";
	    	$jar_ativador = "..\\WebSocialComum\\ativacao\\WebComumAtivador.jar ";
		    if (strpos(PHP_OS, 'WIN') !== false) {
			    $a = shell_exec("e-sus\cnes.cmd $this->host:$this->porta/$this->banco $this->usuario $this->senha");

			    $b = shell_exec("$java_exec  WebSaudeIntegracaoSIGTAP.jar $this->host:$this->porta/$this->banco $this->usuario $this->senha");

			    $c = shell_exec($java_exec . $jar_ativador . $this->codificaParametros());

		    } else {
			    $a = exec("e-sus/cnes.sh $this->host:$this->porta/$this->banco $this->usuario $this->senha");

			    $b = exec("java -jar WebSaudeIntegracaoSIGTAP.jar $this->host:$this->porta/$this->banco $this->usuario '$this->senha'",$out);

			    $c = exec("java -jar $jar_ativador" . $this->codificaParametros(),$out1);

		    }

		    $mensagem = "";
		    if(strpos($c, "[erro]") !== FALSE){
			    $ce_explode = explode("[erro]", $c);
			    $mensagem = $ce_explode[1];
		    }

		    return $mensagem;
	    }

    }

	$c = new CnesServer();
    echo json_encode(array("mensagem" => utf8_encode($c->init())));
?>
