<?php
  //Coluna,Tamanho,Inicio,Fim,Tipo
function getMeta($file) {

    $out = array();
    foreach ($file as $line) {

        $l = explode(",", $line);
        $out[] = array(
            "coluna" => strtolower($l[0]),
            "tamanho" => $l[1],
            "inicio" => $l[2],
            "fim" => $l[3],
            "tipo" => $l[4]
        );
    }

    return $out;
}

// pega uma parte da $str, baseado no layout em $meta
function getDados($meta, $linha) {
    $out = array();
    foreach ($meta as $key => $value) {
        $out [] = substr($linha, $value['inicio'] - 1, $value['tamanho']);
    }

    return $out;
}

/* tb_ocupacao => especialidade */

function tb_ocupacao(&$sqlInsert, &$sqlUpdate, $dados, $meta) {
    $nome = ($nome);
    list($cod, $nome) = getDados($meta, $dados);

    $sqlUpdate = 'UPDATE especialidade
                         SET esp_nome=\'%1$s\',
                             cod_cbo=\'%2$s\'
                       WHERE cod_cbo=\'%2$s\'
                             OR esp_nome=\'%1$s\';'; // caso haja uma especialização muito antiga, a descrição será diferente,
    // o update não pega, e o insert d erro (duplica o cbo)
    $sqlUpdate = sprintf($sqlUpdate, $nome, $cod);

    $sqlInsert = "INSERT INTO especialidade(
            				  esp_nome, 
            				  cod_cbo)
    				   VALUES ('%s', '%s');";
    $sqlInsert = sprintf($sqlInsert, $nome, $cod);
}

/* tb_cid => cid10 */

function tb_cid(&$sqlInsert, &$sqlUpdate, $dados, $meta) {
    $nome = ($nome);
    list($cod, $nome, $agravo, $sexo, $estadio, $vlCampos) = getDados($meta, $dados);

    $sqlUpdate = "UPDATE cid10
                        SET cd10_descricao = '%s', 
                            cd10_restricaosexo = '%s'
                   WHERE cd10_codigo_cid = '%s';";
    $sqlUpdate = sprintf($sqlUpdate, $nome, $sexo, $cod);

    $sqlInsert = "INSERT INTO cid10(
                                    cd10_codigo_cid,
                                    cd10_descricao,
                                    cd10_restricaosexo)
                            VALUES ('%s', '%s', '%s');";
    $sqlInsert = sprintf($sqlInsert, $cod, $nome, $sexo);
}

/* tb_procedimento => procedimento */

function tb_procedimento(&$sqlInsert, &$sqlUpdate, $dados, $meta) {

    foreach ($meta as $m => $a) {
        if (in_array('qt_tempo_permanencia', $a, true)) {
            $validador = 1;
        }
    }
    $nome = ($nome);
    list($cod, $nome, $complexidade, $sexo, $max, $dias, $pontos, $iMin, $iMax, $sh, $sa, $sp, $finan, $rub, $qt_tempo, $dt) = getDados($meta, $dados);

    $sqlUpdate = "UPDATE procedimento 
                        SET proc_nome = '%s',
                            proc_sexo_novo = '%s',
                            proc_idade_minima = '%s',
                            proc_idade_maxima = '%s',
                            proc_qtdemaxima = '%s',
                            proc_qtdedias = '%s',
                            proc_vlsh = '%s',
                            proc_vlsa = '%s',
                            proc_vlsp = '%s',
                            proc_qtdepontos = '%s',
                            proc_cofinan = '%s',
                            proc_corubrica = '%s',
                            proc_complexidade = '%s',
                            proc_dtcompetencia= '%s',
                            proc_qt_tempo_permanencia  = '%s'
                  WHERE proc_codigo_sus = '%s'";

    $sqlUpdate = sprintf($sqlUpdate, $nome, $sexo, $iMin, $iMax, $max, 
                         $dias, addCaracter($sh, ".", 8), addCaracter($sa, ".", 8), 
                         addCaracter($sp, ".", 8), $pontos, $finan, $rub, 
                         $complexidade, $dt, $qt_tempo, $cod);

    $sqlInsert = "INSERT INTO procedimento (proc_nome,
                                            proc_sexo_novo,
                                            proc_idade_minima,
                                            proc_idade_maxima,
                                            proc_qtdemaxima,
                                            proc_qtdedias,
                                            proc_vlsh,
                                            proc_vlsa,
                                            proc_vlsp,
                                            proc_qtdepontos,
                                            proc_cofinan,
                                            proc_corubrica,
                                            proc_complexidade,
                                            proc_codigo_sus,
                                            proc_dtcompetencia,
                                            proc_qt_tempo_permanencia
                                ) VALUES ('%s','%s','%s','%s','%s',
                                          '%s','%s','%s','%s','%s',
                                          '%s','%s','%s','%s','%s', '%s') ";
   
    
    $sqlInsert = sprintf($sqlInsert, $nome, $sexo, $iMin, $iMax, $max, $dias, $sh, $sa, $sp, $pontos, $finan, $rub, $complexidade, $cod, $dt, $qt_tempo);
  //  echo $sqlInsert."xixixixix<br/>";
    $sqlInsertH = "INSERT INTO tb_procedimento(
				            co_procedimento, no_procedimento, tp_complexibilidade, tp_sexo, 
				            qt_maxima_execucao, qt_dias_permanencia, qt_pontos, vl_idade_minima, 
				            vl_idade_maxima, vl_sh, vl_sa, vl_sp, co_financiamento, co_rubrica, 
				            qt_tempo_permanencia,dt_competencia)
				    VALUES ('%s', '%s', '%s', '%s', 
				            '%s', '%s', '%s', '%s', 
				            '%s', '%s', '%s', '%s', 
                                            '%s', '%s', '%s','%s')";

                                    
    $historico = sprintf($sqlInsertH, $cod, $nome, $complexidade, $sexo, $max, $dias, $pontos, $iMin, $iMax, $sh, $sa, $sp, $finan, $rub, $dt, $qt_tempo);
    debug("Historico: " . $historico, 2);
    pg_query($historico);
    
}

function rl_procedimento_cid(&$sqlInsert, &$sqlUpdate, $dados, $meta) {
    list($proc, $cid, $principal, $dt) = getDados($meta, $dados);
    $sqlUpdate = "UPDATE rl_procedimento_cid
                        SET st_principal='%s', dt_competencia='%s'
                   WHERE co_procedimento='%s' 
                         AND co_cid='%s';";
    
    $sqlUpdate = sprintf($sqlUpdate, $principal, $dt, $proc, $cid);

    $sqlInsertM = "INSERT INTO %s (co_procedimento, co_cid, st_principal, dt_competencia)
                           VALUES ('%s', '%s', '%s', '%s');";
    $sqlInsert = sprintf($sqlInsertM, "rl_procedimento_cid", $proc, $cid, $principal, $dt);
    $historico = sprintf($sqlInsertM, "rl_procedimento_cid_historico", $proc, $cid, $principal, $dt);
    debug("Historico: " . $historico, 2);
    pg_query($historico);
}

function rl_procedimento_ocupacao(&$sqlInsert, &$sqlUpdate, $dados, $meta) {
    list($proc, $ocupacao, $dt) = getDados($meta, $dados);
    $sqlUpdate = "UPDATE rl_procedimento_ocupacao
                        SET dt_competencia='%s'
                   WHERE co_procedimento='%s'
                         AND co_ocupacao='%s' ;";
    $sqlUpdate = sprintf($sqlUpdate, $dt, $proc, $ocupacao);

    $sqlInsertM = "INSERT INTO %s (co_procedimento, co_ocupacao, dt_competencia)
                           VALUES ('%s', '%s', '%s');";
    $sqlInsert = sprintf($sqlInsertM, "rl_procedimento_ocupacao", $proc, $ocupacao, $dt);
    $historico = sprintf($sqlInsertM, "rl_procedimento_ocupacao_historico", $proc, $ocupacao, $dt);
    debug("Historico: " . $historico, 2);
    pg_query($historico);
}

function debug($msg, $level) {
    global $debug;
    if (!$debug || $debug > $level) {
        return FALSE;
    }

    printf("<pre>%s</pre>", preg_replace("/[ \n\t]+/", " ", $msg));
    ob_flush();
    return TRUE;
}

/**
 * @deprecated
 */
function logFile($str) {
    return true; // desativado
    /*$dir = dirname(__FILE__);
    $h = fopen("$dir/log.log", "a");
    fputs($h, $str . "\n");
    fclose($h);*/
}

function apagar() {
    $dir = "tmp/";
    if (is_dir($dir)) { // verifica se realmente  uma pasta
        if ($handle = opendir($dir)) {
            while ($file = readdir($handle)) { // varre cada um dos arquivos da pasta
                if (($file == ".") || ( $file == "..")) {
                    continue;
                }
                if (!is_dir($file)) {
                    // caso seja não seja um diretório, exclui
                    unlink($dir . $file);
                    logFile("apagado: {$dir}$file");
                }
            }
        } else {
            return false;
        }
        closedir($handle);

        return true;
    } else {
        return false;
    }
}

function addCaracter($var, $caracter, $lim) {
    $tamanho = strlen($var);
    if ($tamanho > $lim) {
        $quebra = $tamanho / $lim;
        $ini = 0;
        $fim = $lim;

        for ($i = 0; $i <= intval($quebra); $i++) {
            if ($i == intval($quebra)) {
                $nova .= substr($var, $ini, $lim);
            } else {
                $nova .= substr($var, $ini, $lim) . $caracter;
            }

            $ini = $fim;
            $fim = $fim + $lim;
        }
        return $nova;
    } else {
        return $var;
    }
}
