<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 08/03/2018
 * Time: 12:08
 */

namespace Saude\Horus;

use PDO;

class Connection {

	private $conn;

	/**
	 * Connection constructor.
	 */
	public function __construct() {
		if (file_exists('COMUM' . "/library/conf/dbConfig.xml")) {
			$arquivoXml = 'COMUM' . "/library/conf/dbConfig.xml";
		} elseif (file_exists(__DIR__ . "/../../WebSocialComum/library/conf/dbConfig.xml")) {
			$arquivoXml = __DIR__ . "/../../WebSocialComum/library/conf/dbConfig.xml";
		} else {
			die("Arquivo de configuração do banco de dados não encontrado. (session)");
		}
		$xml = simplexml_load_file($arquivoXml);
		$host = base64_decode($xml->conexao->host);
		$banco = base64_decode($xml->conexao->dbname);
		$usuario = base64_decode($xml->conexao->user);
		$porta = base64_decode($xml->conexao->porta);
		$senha = base64_decode($xml->conexao->password);

		try {
			$this->conn =  new PDO("pgsql:host=$host;port=$porta;dbname=$banco", $usuario, $senha);
			$this->conn->setAttribute(PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
			$this->conn->query("SET NAMES 'UTF-8'");
		} catch (\PDOException $e) {
			die('Connection failed: ' . $e->getMessage());
		}
	}

	public function select($sql, $multiple=TRUE) {
		try {
			$query = $this->conn->prepare($sql);
			$query->execute();
			if($query->rowCount() > 0){
				return ($multiple ? $query->fetchAll(\PDO::FETCH_ASSOC) : $query->fetch(\PDO::FETCH_ASSOC));
			}else{
				return false;
			}

		} catch (\PDOException $e) {
			return 'Select failed: ' . $e->getMessage();
		}
	}

	public function save($sql, array $params) {
		try {
			$query = $this->conn->prepare($sql);
			$this->conn->beginTransaction();
			$query->execute($params);
			$this->conn->commit();
			return $this->conn->lastInsertId();
		} catch (\PDOException $e) {
			$this->conn->rollBack();
			return 'Save / Update Error: ' . $e->getMessage();
		}
	}

	public function delete($table, array $ids) {
		try {
			$qrcolumn = $this->conn->query("select column_name from information_schema.columns where table_name = '$table' LIMIT 1");
			$column = $qrcolumn->fetch(\PDO::FETCH_COLUMN);
			$condition = implode(', ', array_map('pg_escape_string', $ids));
			$query = $this->conn->prepare("DELETE FROM $table WHERE $column IN ($condition)");
			$this->conn->beginTransaction();
			$query->execute();
			$this->conn->commit();
			return "OK";
		} catch (\PDOException $e) {
			$this->conn->rollBack();
			return 'Delete Error: ' . $e->getMessage();
		}
	}
}