<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 18/04/2018
 * Time: 15:21
 */

namespace Saude\Horus;


abstract class TP_ESTAB {
	const ALMOXARIFADO_CENTRAL  = "A";
	const ALMOXARIFADO_REGIONAL = "R";
	const FARMACIA_UNIDADE      = "F";

	static function getConstants() {
		try {
			$oClass = new \ReflectionClass(__CLASS__);
			return $oClass->getConstants();
		} catch (\ReflectionException $e) {
			die($e->getMessage());
		}
	}
}

abstract class TP_PRODUTO {
	const BASICO        = "A";
	const ESPECIALIZADO = "E";
	const ESTRATEGICO   = "S";

	static function getConstants() {
		try {
			$oClass = new \ReflectionClass(__CLASS__);
			return $oClass->getConstants();
		} catch (\ReflectionException $e) {
			die($e->getMessage());
		}
	}
}

abstract class TP_IDENTIFICACAO {
	const CNES = "CNES";
	const CNPJ = "CNPJ";

	static function getConstants() {
		try {
			$oClass = new \ReflectionClass(__CLASS__);
			return $oClass->getConstants();
		} catch (\ReflectionException $e) {
			die($e->getMessage());
		}
	}
}

abstract class TP_ENTRADA {
	const ENTRADA_EVENTUAL            = "E-EVENTUAL";
	const ENTRADA_ORDINARIA           = "E-O";
	const AJUSTE_ESTOQUE              = "E-AE";
	const DOACAO                      = "E-D";
	const PERMUTA                     = "E-PER";
	const SALDO_IMPLANTACAO           = "E-SI";
	const TRANSFERENCIA_REMANEJAMENTO = "E-T";

	static function getConstants() {
		try {
			$oClass = new \ReflectionClass(__CLASS__);
			return $oClass->getConstants();
		} catch (\ReflectionException $e) {
			die($e->getMessage());
		}
	}
}

abstract class TP_SAIDA {
	const AJUSTE_ESTOQUE              = "S-AE";
	const AMOSTRA_EXPOSICAO_ANALISE   = "S-AEA";
	const TRANSFERENCIA_REMANEJAMENTO = "S-TR";
	const PERDA                       = "S-PE";
	const DOACAO                      = "S-D";
	const VALIDADE_VENCIDA            = "S-VV";
	const DISTRIBUICAO                = "S-DD";
	const DEVOLUCAO_ENTRADA_PRODUTO   = "S-DEP";
	const DEVOLUCAO_EMPRESTIMO        = "S-EE";
	const EMPRESTIMO                  = "S-E";
	const APREENSAO_SANITARIA         = "S-AS";
	const USUARIO_SUS_SEM_CNS         = "S-PA";

	static function getConstants() {
		try {
			$oClass = new \ReflectionClass(__CLASS__);
			return $oClass->getConstants();
		} catch (\ReflectionException $e) {
			die($e->getMessage());
		}
	}
}

abstract class TP_PROGRAMA_SAUDE {
	const ALIMENTACAO_NUTRICAO        = "NUTRI";
	const ANEMIA_FALCIFORME           = "FALCI";
	const BRUCELOSE                   = "BRUC";
	const CALAMIDADE_PUBLICA          = "CALPUB";
	const CHAGAS                      = "CHAGAS";
	const COAGULOPATIAS               = "COAGULO";
	const COLERA                      = "COL";
	const DENGUE                      = "DENGUE";
	const DOENCA_ENXERTO_HOSPEDEIRO   = "DEH";
	const DST_AIDS                    = "DST";
	const ESPECIALIZADO               = "ESP";
	const ESQUISTOSSOMOSE             = "ESQUIS";
	const FEBRE_MACULOSA              = "FM";
	const FILARIOSE                   = "FILAR";
	const GEOHELMINTIASES             = "GEOHEL";
	const HANSENIASE                  = "HANS";
	const INFECCOES_OPORTUNISTAS      = "INFEC";
	const INFLUENZA                   = "INFLU";
	const JUDICIALIZACAO              = "JUD";
	const LEISHMANIOSE                = "LEISH";
	const LUPUS_ERITEMATOSO_SISTEMICO = "LES";
	const MALARIA                     = "MAL";
	const MENINGITE                   = "MENIN";
	const MICOSES_SISTEMICAS          = "MICSIS";
	const MIELOMA_MULTIPLO            = "MIEL";
	const PRODUTOS_SAUDE              = "PRODSAUDE";
	const SAUDE_CRIANCA               = "SAUDECRIAN";
	const SAUDE_MULHER                = "SAUDMULHER";
	const SAUDE_MENTAL                = "SAUDMENTAL";
	const SAUDE_PRISIONAL             = "SAUDEPRISI";
	const SIFILIS                     = "SIF";
	const TABAGISMO                   = "TBG";
	const TOXOPLASMOSE                = "TOXO";
	const TRACOMA                     = "TRACO";
	const TUBERCULOSE                 = "TB";

	static function getConstants() {
		try {
			$oClass = new \ReflectionClass(__CLASS__);
			return $oClass->getConstants();
		} catch (\ReflectionException $e) {
			die($e->getMessage());
		}
	}
}