<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 09/03/2018
 * Time: 15:35
 */

namespace Saude\Horus;

use SoapClient, Exception;
require_once "Connection.php";

define('HOMOLOGACAO', 'H');
define('PRODUCAO', 'P');

class SoapHorus {
	private $sincrono;
	private $SOAP_URL_PROD = 'http://horusws.saude.gov.br/horus-ws-service/HorusWSService/HorusWS?wsdl';
	private $SOAP_URL_HOMO = 'http://horusws.treinamento.saude.gov.br/horus-ws-service/HorusWSService/HorusWS?wsdl';
	protected $client;
	private $cadastroHorus = false;

	/**
	 * @return mixed
	 */
	public function getCadastroHorus() {
		return $this->cadastroHorus;
	}


	/**
	 * Horus constructor.
	 * @param $client
	 */
	public function __construct() {
		$conn = new Connection();
		$config = $conn->select("SELECT conf_valor_bool FROM config WHERE conf_chave = 'HORUS_TYPE'", FALSE);
		$this->sincrono = boolval($config['conf_valor_bool']);
		$this->initSoap();
	}

	private function initVariables(){
		$conn = new Connection();
		$config = $conn->select("SELECT conf_valor_bool FROM config WHERE conf_chave = 'MODO_PRODUCAO_HORUS'", FALSE);
		$tp_amb = (boolval($config['conf_valor_bool']) ? "P" : "H");
		$ambiente = ($tp_amb == 'P' ? $this->SOAP_URL_PROD : $this->SOAP_URL_HOMO);
		$sqlHorus = "SELECT 
							hor_cad_login AS login, 
							hor_cad_senha AS password 
						   FROM horus_cadastro 
						  WHERE upper(hor_cad_ambiente) = UPPER('$tp_amb') 
						    AND hor_cad_ativo = true";
		$auth = $conn->select($sqlHorus, false);
		$this->cadastroHorus = $auth;
		if($auth){
			return [
				'wsdl' => $ambiente,
				'usuario' => $auth['login'],
				'senha' => $auth['password']
			];
		}else{
			return null;
		}
	}

	public function initSoap() {
		try {
			$var = $this->initVariables();
			$this->client = null;
			if($var){
				set_time_limit(0);
				$cache_dir = __DIR__."/cache";
				ini_set("soap.wsdl_cache_dir", $cache_dir);
				ini_set('default_socket_timeout', 5000);
				$options = array(
					'login' => $var['usuario'],
					'password' => $var['senha'],
					"exceptions" => true,
					"trace" => true,
					"connection_timeout"=>"5000",
					"cache_wsdl"=>WSDL_CACHE_MEMORY
				);
				$this->client = new SoapClient($var['wsdl'], $options);
			}
		} catch (Exception $e) {
			Util::returnError(__FUNCTION__, $e);
		}
	}

	public function isSincrono() {
		return $this->sincrono;
	}

	public function getDados() {
		session_start();
		$conn = new Connection();
		$unidade = $conn->select("SELECT uni_codigo_ibge, uni_cnes FROM unidade WHERE uni_codigo = " . $_SESSION['uni_codigo'], false);
		$COD_IBGE = $unidade['uni_codigo_ibge'];
		$COD_CNES = $unidade['uni_cnes'];
		return [
			'idOrigem' => "M",
			'coIBGE' => $COD_IBGE,
			'coCNES' => $COD_CNES
		];
	}
}