<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 08/03/2018
 * Time: 16:54
 */

namespace Saude\Horus;

use SoapFault;

abstract class Util {
	static $INFO = "info";
	static $WARNING = "warning";
	static $ERROR = "error";

	/**
	 * @param $function
	 * @param \Exception $e
	 * @return \Exception
	 */
	public static function returnError($function, \Exception $e) {
		$msg = sprintf("[%s] %s", self::decamelize($function), json_encode($e)."\n");
		self::logMsg($msg, self::$ERROR);
		return $e;
	}

	private static function decamelize($string) {
		return strtolower(preg_replace(['/([a-z\d])([A-Z])/', '/([^_])([A-Z][a-z])/'], '$1_$2', $string));
	}

	public static function ver($var, $d = null) {
		echo '<pre>';
		var_dump($var);
		if ($d) {
			die;
		}
		echo '<pre>';
	}

	public static function logMsg( $msg, $level = 'info')
	{
		date_default_timezone_set('America/Sao_Paulo');
		$file = __DIR__.'/log/horus.log';
		if(!file_exists($file)){
			$cabecalho = sprintf(
				"%s".PHP_EOL."%s".PHP_EOL."%s".PHP_EOL."%s".PHP_EOL.PHP_EOL,
				"+-+ +-+ +-+ +-+ +-+ +-+ +-+   +-+   +-+ +-+ +-+ +-+ +-+",
					"|E| |l| |o| |t| |e| |c| |h|   |-|   |H| |o| |r| |u| |s|",
					  "+-+ +-+ +-+ +-+ +-+ +-+ +-+   +-+   +-+ +-+ +-+ +-+ +-+",
					  "+++++++++++++++++++   Log de Erros  +++++++++++++++++++", PHP_EOL);
			file_put_contents($file, $cabecalho, FILE_APPEND);
		}
		$levelStr = '';
		switch ( $level )
		{
			case 'info':
				// nível de informação
				$levelStr = 'INFO';
				break;

			case 'warning':
				// nível de aviso
				$levelStr = 'WARNING';
				break;

			case 'error':
				// nível de erro
				$levelStr = 'ERROR';
				break;
		}

		$date = date( 'Y-m-d H:i:s');
		$msg = sprintf( "[%s] [%s]: %s%s", $date, $levelStr, $msg, PHP_EOL );
		file_put_contents( $file, $msg, FILE_APPEND );
	}
}