<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 08/03/2018
 * Time: 12:14
 */

namespace Saude\Horus\Async;


interface AsyncArgs {
	/**
	 * @param $nuProtocoloEntrada = '17100000023000003132';
	 * @param $dtRecebimento = '31-10-2017 15:34:12';
	 * @return mixed
	 */
	public static function consultarInconsistencias($nuProtocoloEntrada, $dtRecebimento);

	/**
	 * @param $nuProtocoloEntrada = '17100000023000003132';
	 * @param $dtRecebimento = '31-10-2017 15:34:12';
	 * @return mixed
	 */
	public static function consultarInconsistencias_v2($nuProtocoloEntrada, $dtRecebimento);
	/**
	 * @param $nuProtocoloEntrada = '17100000023000003132';
	 * @param $dtRecebimento = '31-10-2017 15:34:12';
	 * @return mixed
	 */
	public static function consultarResultadoProcessamento($nuProtocoloEntrada, $dtRecebimento);
	/**
	 * @param $nuProtocoloEntrada = '17100000023000003132';
	 * @param $dtRecebimento = '31-10-2017 15:34:12';
	 * @return mixed
	 */
	public static function consultarResultadoProcessamento_v2($nuProtocoloEntrada, $dtRecebimento);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $coRegistroOrigem = '123';
	 * @param $qtLMEavaliadaC1 = '30';
	 * @param $qtLMEavaliadaC2 = '30';
	 * @param $qtLMEavaliadaC3 = '30';
	 * @param $coProcedimento = '0604010010';
	 * @param $dtAvaliacao = '30-10-2017';
	 * @param $avAdequacao = 'N';
	 * @param $coCNES = '5717493';
	 * @param $coCNS = '700600555663867';
	 * @return mixed
	 */
	public static function informarAvaliacaoDeferidaEmLote($idOrigem, $coIBGE, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS);

	/**
	 * @param array $avaliacoes = [
	 *        [ //exemplo registro 1
	 *            'coRegistroOrigem'  => '123'                  //obrigatório
	 *            ,'qtLMEavaliadaC1'   => '30'                   //obrigatório
	 *            ,'qtLMEavaliadaC2'   => '30'                   //opcional
	 *            ,'qtLMEavaliadaC3'   => '30'                   //opcional
	 *            ,'coProcedimento'    => '0604010010'           //obrigatório
	 *            ,'dtAvaliacao'       => '30-10-2018'           //obrigatório
	 *            ,'avAdequacao'       => 'N'                    //obrigatório
	 *            ,'coCNES'            => '5717493'              //obrigatório
	 *            ,'coCNS'             => '700600555663867'      //obrigatório
	 *        ],
	 *        [ //exemplo registro 2
	 *            'coRegistroOrigem'  => '321'                  //obrigatório
	 *            ,'qtLMEavaliadaC1'   => '30'                   //obrigatório
	 *            ,'qtLMEavaliadaC2'   => ''                     //opcional
	 *            ,'qtLMEavaliadaC3'   => ''                     //opcional
	 *            ,'coProcedimento'    => '0604010010'           //obrigatório
	 *            ,'dtAvaliacao'       => '30-10-2018'           //obrigatório
	 *            ,'avAdequacao'       => 'N'                    //obrigatório
	 *            ,'coCNES'            => '5717493'              //obrigatório
	 *            ,'coCNS'             => '700600555663867'      //obrigatório
	 *        ]
	 * ];
	 * @return mixed
	 */
	public static function informarAvaliacaoDeferidaEmLote_v2(array $avaliacoes);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $idIdentificacao = 'CNES';
	 * @param $coCNES = '5717493';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '123';
	 * @param $dtValidade = '10-01-2020';
	 * @param $qtProduto = '123';
	 * @param $dtRegistro = '08-11-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $dtCompetencia = '11-2017';
	 * @param $nuCNS = '700600555663867';
	 * @param $peso = '70.10';
	 * @param $altura = '175';
	 * @param $cid_10 = 'F20.0';
	 * @param $coCNES1 = '5717493';
	 * @param $nuCRM = '1234';
	 * @param $ufCRM = 'DF';
	 * @return mixed
	 */
	public static function informarDispensacaoMedicamentoEmLote($idOrigem, $coIBGE, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM);

	/**
	 * @param array $registros = [
	 *    [ //exemplo registro 1
	 *        'estabelecimento' => [   //obrigatório
	 *            'idIdentificacao' => 'CNES'    //obrigatório
	 *            ,'coCNES'         => '5717493' //opcional
	 *            ,'nuCNPJ'         => ''        //opcional
	 *        ]
	 *        ,'produto'        => [   //obrigatório
	 *            'coRegistroOrigem' => '123'             //opcional
	 *            ,'nuProduto'       => 'EBR0266630U0118' //obrigatório
	 *            ,'nuLote'          => '123'             //obrigatório
	 *            ,'dtValidade'      => '01-01-2020'      //obrigatório
	 *            ,'qtProduto'       => '123'             //obrigatório
	 *            ,'dtRegistro'      => '30-10-2017'      //obrigatório
	 *            ,'sgProgramaSaude' => 'DST'             //opcional
	 *            ,'coIUM'           => '123'             //opcional
	 *            ,'dtCompetencia'   => '10-2017'         //opcional
	 *        ]
	 *        ,'paciente'   => [                      //obrigatório
	 *            'nuCNS'   => '700600555663867'      //obrigatório
	 *            ,'peso'   => '70.10'                //opcional
	 *            ,'altura' => '175'                  //opcional
	 *            ,'cid-10' => 'F20.0'                //opcional
	 *        ]
	 *        ,'prescritor' => [                      //obrigatório
	 *            'coCNES'  => '5717493'              //opcional
	 *            ,'nuCRM'  => '1234'                 //opcional
	 *            ,'ufCRM'  => 'DF'                   //opcional
	 *        ]
	 *    ]
	 * ];
	 * @return mixed
	 */
	public static function informarDispensacaoMedicamentoEmLote_v2(array $registros);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '123';
	 * @param $dtValidade = '01-01-2020';
	 * @param $qtProduto = '123';
	 * @param $dtRegistro = '30-10-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $nuCNPJFabricante = '00530493000171';
	 * @param $noFabricanteInternacional = 'FABRICANTE';
	 * @param $nuNotaFiscal = '1324';
	 * @param $nuValorUnitario = '1234.1234';
	 * @param $nuCNPJDistribuidor = '00530493000171';
	 * @param $tpEntradaEstoque = 'E-O';
	 * @return mixed
	 */
	public static function informarEntradaMedicamentoEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante,  $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque);

	/**
	 * @param array $registros = [
	 * [ //exemplo registro 1
	 *     'estabelecimento'                => [                  //obrigatório
	 *         'coCNES'                     => '5717493'          //opcional
	 *         ,'coTipoEstabelecimento'     => 'A'                //opcional
	 *     ]
	 *     ,'produto'                       => [                  //obrigatório
	 *         'coRegistroOrigem'           => '123'              //opcional
	 *         ,'nuProduto'                 => 'EBR0266630U0118'  //obrigatório
	 *         ,'nuLote'                    => '123'              //obrigatório
	 *         ,'dtValidade'                => '01-01-2020'       //obrigatório
	 *         ,'qtProduto'                 => '123'              //obrigatório
	 *         ,'dtRegistro'                => '30-10-2017'       //obrigatório
	 *         ,'sgProgramaSaude'           => 'DST'              //opcional
	 *         ,'coIUM'                     => '123'              //opcional
	 *         ,'nuCNPJFabricante'          => '00530493000171'   //opcional
	 *         ,'noFabricanteInternacional' => 'FABRICANTE'       //opcional
	 *         ,'nuNotaFiscal'              => '1324'             //obrigatório
	 *         ,'nuValorUnitario'           => '1234.1234'        //obrigatório
	 *         ,'nuCNPJDistribuidor'        => '00530493000171'   //obrigatório
	 *         ,'tpEntradaEstoque'          => 'E-O'              //obrigatório
	 *     ]
	 * ]
	 * @return mixed
	 */
	public static function informarEntradaMedicamentoEmLote_v2(array $registros);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '123';
	 * @param $dtValidade = '10-10-2020';
	 * @param $qtProduto = '132';
	 * @param $dtRegistro = '30-11-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @return mixed
	 */
	public static function informarPosicaoEstoqueEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude);

	/**
	 * @param array $registros = [
	 *      [ //exemplo registro 1
	 *         'estabelecimento'          => [                        //obrigatório
	 *             'coCNES'                 => '5717493'                //opcional
	 *             ,'coTipoEstabelecimento' => 'A'                      //opcional
	 *         ]
	 *         ,'produto'              => [                        //obrigatório
	 *             'coRegistroOrigem'  => '123'                    //opcional
	 *             ,'nuProduto'        => 'EBR0266630U0118'        //obrigatório
	 *             ,'nuLote'           => '123'                    //obrigatório
	 *             ,'dtValidade'       => '01-01-2020'             //obrigatório
	 *             ,'qtProduto'        => '123'                    //obrigatório
	 *             ,'dtRegistro'       => '30-10-2017'             //obrigatório
	 *             ,'sgProgramaSaude'  => 'DST'                    //opcional
	 *             ,'coIUM'            => '123'                    //opcional
	 *         ]
	 *      ]
	 * ];
	 * @return mixed
	 */
	public static function informarPosicaoEstoqueEmLote_v2($idOrigem, $coIBGE, array $registros, $data_competencia_horus);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '123';
	 * @param $dtValidade = '10-10-2020';
	 * @param $qtProduto = '123';
	 * @param $dtRegistro = '08-11-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $nuCNPJFabricante = '10176265000107';
	 * @param $tpSaida = 'S-AE';
	 * @param $idIdentificacao = 'CNES';
	 * @param $coCNES =  '5717493';
	 * @return mixed
	 */
	public static function informarSaidaMedicamentoEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $tpSaida, $idIdentificacao, $coCNES);

	/**
	 * @param array $registros = [
	 *     [ //exemplo registro 1
	 *         'estabelecimento'             => [                        //obrigatório
	 *             'coCNES'                  => '5717493'                //opcional
	 *             ,'coTipoEstabelecimento'  => 'A'                      //opcional
	 *         ]
	 *         ,'produto'                       => [                        //obrigatório
	 *             'coRegistroOrigem'           => '123'                    //opcional
	 *             ,'nuProduto'                 => 'EBR0266630U0118'        //obrigatório
	 *             ,'nuLote'                    => '123'                    //obrigatório
	 *             ,'dtValidade'                => '01-01-2020'             //obrigatório
	 *             ,'qtProduto'                 => '123'                    //obrigatório
	 *             ,'dtRegistro'                => '08-11-2017'             //obrigatório
	 *             ,'sgProgramaSaude'           => 'DST'                    //opcional
	 *             ,'coIUM'                     => '123'                    //opcional
	 *             ,'nuCNPJFabricante'          => '10176265000107'         //opcional
	 *             ,'noFabricanteInternacional' => 'FABRICANTE'             //opcional
	 *             ,'tpSaida'                   => 'S-AE'                   //obrigatório
	 *         ]
	 *         ,'estabelecimento-destino' => [                        //obrigatório
	 *             'idIdentificacao'      => 'CNES'                   //obrigatório
	 *             ,'coCNES'              => '5717493'                //opcional
	 *             ,'nuCNPJ'              => '10176265000107'         //opcional
	 *         ]
	 *     ]
	 * ];
	 * @return mixed
	 */
	public static function informarSaidaMedicamentoEmLote_v2(array $registros);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $nuProtocoloEntrada = '17100000023000003132';
	 * @param $coRegistroOrigem = '123';
	 * @param $qtLMEavaliadaC1 = '31';
	 * @param $qtLMEavaliadaC2 = '31';
	 * @param $qtLMEavaliadaC3 = '31';
	 * @param $coProcedimento = '0604010010';
	 * @param $dtAvaliacao = '15-10-2017';
	 * @param $avAdequacao = 'N';
	 * @param $coCNES = '5717493';
	 * @param $coCNS = '700600555663867';
	 * @param $coRegistro = '5083';
	 * @return mixed
	 */
	public static function retificarAvaliacaoDeferidaEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS, $coRegistro);

	/**
	 * @param $nuProtocoloEntrada
	 * @param array $avaliacoes = [
	 *     [ //exemplo registro 1
	 *         'coRegistroOrigem'  => '123'                  //opcional
	 *         ,'qtLMEavaliadaC1'   => '31'                   //obrigatório
	 *         ,'qtLMEavaliadaC2'   => '31'                   //opcional
	 *         ,'qtLMEavaliadaC3'   => '31'                   //opcional
	 *         ,'coProcedimento'    => '0604010010'           //obrigatório
	 *         ,'dtAvaliacao'       => '15-10-2017'           //obrigatório
	 *         ,'avAdequacao'       => 'N'                    //obrigatório
	 *         ,'coCNES'            => '5717493'              //obrigatório
	 *         ,'coCNS'             => '700600555663867'      //obrigatório
	 *         ,'coRegistro'        => '5083'                 //obrigatório
	 *     ]
	 * ];
	 * @return mixed
	 */
	public static function retificarAvaliacaoDeferidaEmLote_v2($nuProtocoloEntrada, array $avaliacoes);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $nuProtocoloEntrada = '17110000023000003262';
	 * @param $idIdentificacao = 'CNES';
	 * @param $coCNES = '5717493';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '123';
	 * @param $dtValidade = '10-01-2020';
	 * @param $qtProduto = '123';
	 * @param $dtRegistro = '08-11-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $dtCompetencia = '11-2017';
	 * @param $coRegistro = '854785';
	 * @param $nuCNS = '700600555663867';
	 * @param $peso = '70.10';
	 * @param $altura = '175';
	 * @param $cid_10 = 'F20.0';
	 * @param $coCNES1 = '5717493';
	 * @param $nuCRM = '1234';
	 * @param $ufCRM = 'DF';
	 * @return mixed
	 */
	public static function retificarDispensacaoMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $coRegistro, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM);

	/**
	 * @param $nuProtocoloEntrada
	 * @param array $registros = [
	 *     [ //exemplo registro 1
	 *         'estabelecimento'        => [                      //obrigatório
	 *             'idIdentificacao'    => 'CNES'                 //obrigatório
	 *             ,'coCNES'            => '5717493'              //opcional
	 *             ,'nuCNPJ'            => ''                     //opcional
	 *         ]
	 *         ,'produto'               => [                      //obrigatório
	 *             'coRegistroOrigem'   => '123'                  //opcional
	 *             ,'nuProduto'         => 'EBR0266630U0118'      //obrigatório
	 *             ,'nuLote'            => '123'                  //obrigatório
	 *             ,'dtValidade'        => '01-01-2020'           //obrigatório
	 *             ,'qtProduto'         => '123'                  //obrigatório
	 *             ,'dtRegistro'        => '30-10-2017'           //obrigatório
	 *             ,'sgProgramaSaude'   => 'DST'                  //opcional
	 *             ,'coIUM'             => '123'                  //opcional
	 *             ,'dtCompetencia'     => '10-2017'              //opcional
	 *             ,'coRegistro'        => '854785'               //obrigatório
	 *         ]
	 *         ,'paciente'              => [                      //obrigatório
	 *             'nuCNS'              => '700600555663867'      //obrigatório
	 *             ,'peso'              => '70.10'                //opcional
	 *             ,'altura'            => '175'                  //opcional
	 *             ,'cid-10'            => 'F20.0'                //opcional
	 *         ]
	 *         ,'prescritor'            => [                      //obrigatório
	 *             'coCNES'             => '5717493'              //opcional
	 *             ,'nuCRM'             => '1234'                 //opcional
	 *             ,'ufCRM'             => 'DF'                   //opcional
	 *         ]
	 *     ]
	 * ];
	 * @return mixed
	 */
	public static function retificarDispensacaoMedicamentoEmLote_v2($nuProtocoloEntrada, array $registros);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $nuProtocoloEntrada = '17100000023000003137';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '123';
	 * @param $dtValidade = '01-01-2020';
	 * @param $qtProduto = '123';
	 * @param $dtRegistro = '30-10-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $nuCNPJFabricante = '00530493000171';
	 * @param $noFabricanteInternacional = 'FABRICANTE';
	 * @param $nuNotaFiscal = '1324';
	 * @param $nuValorUnitario = '1234.1234';
	 * @param $nuCNPJDistribuidor = '00530493000171';
	 * @param $tpEntradaEstoque = 'E-O';
	 * @param $coRegistro = '5088';
	 * @return mixed
	 */
	public static function retificarEntradaMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque, $coRegistro);

	/**
	 * @param $nuProtocoloEntrada
	 * @param array $registros = [
	 *     [ //exemplo registro 1
	 *         'estabelecimento'                => [                  //obrigatório
	 *             'coCNES'                     => '5717493'          //opcional
	 *             ,'coTipoEstabelecimento'     => 'A'                //opcional
	 *         ]
	 *         ,'produto'                       => [                  //obrigatório
	 *             'coRegistroOrigem'           => '123'              //opcional
	 *             ,'nuProduto'                 => 'EBR0266630U0118'  //obrigatório
	 *             ,'nuLote'                    => '123'              //obrigatório
	 *             ,'dtValidade'                => '01-01-2020'       //obrigatório
	 *             ,'qtProduto'                 => '123'              //obrigatório
	 *             ,'dtRegistro'                => '30-10-2017'       //obrigatório
	 *             ,'sgProgramaSaude'           => 'DST'              //opcional
	 *             ,'coIUM'                     => '123'              //opcional
	 *             ,'nuCNPJFabricante'          => '00530493000171'   //opcional
	 *             ,'noFabricanteInternacional' => 'FABRICANTE'       //opcional
	 *             ,'nuNotaFiscal'              => '1324'             //obrigatório
	 *             ,'nuValorUnitario'           => '1234.1234'        //obrigatório
	 *             ,'nuCNPJDistribuidor'        => '00530493000171'   //obrigatório
	 *             ,'tpEntradaEstoque'          => 'E-O'              //obrigatório
	 *             ,'coRegistro'                => '5088'             //obrigatório
	 *         ]
	 *     ]
	 * ]
	 * @return mixed
	 */
	public static function retificarEntradaMedicamentoEmLote_v2($nuProtocoloEntrada, array $registros);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $nuProtocoloEntrada = '17110000023000003228';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '123';
	 * @param $dtValidade = '10-10-2020';
	 * @param $qtProduto = '132';
	 * @param $dtRegistro = '30-11-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $coRegistro = '90580';
	 * @return mixed
	 */
	public static function retificarPosicaoEstoqueEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $coRegistro);

	/**
	 * @param $nuProtocoloEntrada
	 * @param array $registros = [
	 *     [ //exemplo registro 1
	 *         'estabelecimento'            => [                        //obrigatório
	 *             'coCNES'                 => '5717493'                //opcional
	 *             ,'coTipoEstabelecimento' => 'A'                      //opcional
	 *         ]
	 *         ,'produto'                   => [                        //obrigatório
	 *             'coRegistroOrigem'       => '123'                    //opcional
	 *             ,'nuProduto'             => 'EBR0266630U0118'        //obrigatório
	 *             ,'nuLote'                => '123'                    //obrigatório
	 *             ,'dtValidade'            => '01-01-2020'             //obrigatório
	 *             ,'qtProduto'             => '123'                    //obrigatório
	 *             ,'dtRegistro'            => '30-10-2017'             //obrigatório
	 *             ,'sgProgramaSaude'       => 'DST'                    //opcional
	 *             ,'coIUM'                 => '123'                    //opcional
	 *             ,'coRegistro'            => '90580'                  //obrigatório
	 *         ]
	 *     ]
	 * ];
	 * @return mixed
	 */
	public static function retificarPosicaoEstoqueEmLote_v2($nuProtocoloEntrada, array $registros);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $nuProtocoloEntrada = '17110000023000003228';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '123';
	 * @param $dtValidade = '10-10-2020';
	 * @param $qtProduto = '123';
	 * @param $dtRegistro = '08-11-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $nuCNPJFabricante = '10176265000107';
	 * @param $tpSaida = 'S-AE';
	 * @param $coRegistro = '20506';
	 * @param $idIdentificacao = 'CNES';
	 * @param $coCNES =  '5717493';
	 * @return mixed
	 */
	public static function retificarSaidaMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $tpSaida, $coRegistro, $idIdentificacao, $coCNES);

	/**
	 * @param $nuProtocoloEntrada = '17110000023000003228'; //obrigatório
	 * @param array $registros = [
	 *   [ //exemplo registro 1
	 *      'estabelecimento'               => [                        //obrigatório
	 *        'coCNES'                      => '5717493'                //opcional
	 *       ,'coTipoEstabelecimento'       => 'A'                      //opcional
	 *     ]
	 *     ,'produto'                       => [                        //obrigatório
	 *        'coRegistroOrigem'            => '123'                    //opcional
	 *       ,'nuProduto'                   => 'EBR0266630U0118'        //obrigatório
	 *       ,'nuLote'                      => '123'                    //obrigatório
	 *       ,'dtValidade'                  => '01-01-2020'             //obrigatório
	 *       ,'qtProduto'                   => '123'                    //obrigatório
	 *       ,'dtRegistro'                  => '08-11-2017'             //obrigatório
	 *       ,'sgProgramaSaude'             => 'DST'                    //opcional
	 *       ,'coIUM'                       => '123'                    //opcional
	 *       ,'nuCNPJFabricante'            => '10176265000107'         //opcional
	 *       ,'noFabricanteInternacional'   => 'FABRICANTE'             //opcional
	 *       ,'tpSaida'                     => 'S-AE'                   //obrigatório
	 *       ,'coRegistro'                  => '20506'                  //obrigatório
	 *     ]
	 *     ,'estabelecimento-destino'       => [                        //obrigatório
	 *        'idIdentificacao'             => 'CNES'                   //obrigatório
	 *       ,'coCNES'                      => '5717493'                //opcional
	 *       ,'nuCNPJ'                      => '10176265000107'         //opcional
	 *     ]
	 *   ]
	 * ];
	 * @return mixed
	 */
	public static function retificarSaidaMedicamentoEmLote_v2($nuProtocoloEntrada, array $registros);
}
