<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 08/03/2018
 * Time: 13:57
 */

namespace Saude\Horus\Async;

require_once __DIR__."/AsyncArgs.php";

abstract class AsyncArguments implements AsyncArgs {

	public static function consultarInconsistencias($nuProtocoloEntrada, $dtRecebimento) {
		return ['hor:protocolo' => ['nuProtocoloEntrada' => $nuProtocoloEntrada,
			'dtRecebimento' => $dtRecebimento]];
	}

	public static function consultarInconsistencias_v2($nuProtocoloEntrada, $dtRecebimento) {
		return ['hor:protocolo' => ['nuProtocoloEntrada' => $nuProtocoloEntrada, 'dtRecebimento' => $dtRecebimento]];
	}

	public static function consultarResultadoProcessamento($nuProtocoloEntrada, $dtRecebimento) {
		return ['hor:protocolo' => ['nuProtocoloEntrada' => $nuProtocoloEntrada,
			'dtRecebimento' => $dtRecebimento]];
	}

	public static function consultarResultadoProcessamento_v2($nuProtocoloEntrada, $dtRecebimento) {
		return ['hor:protocolo' => ['nuProtocoloEntrada' => $nuProtocoloEntrada, 'dtRecebimento' => $dtRecebimento]];
	}

	public static function informarAvaliacaoDeferidaEmLote($idOrigem, $coIBGE, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS) {
		return ['hor:informarAvaliacaoDeferidaEmLote' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE],
			'avaliacoes' => ['avaliacao' => ['coRegistroOrigem' => $coRegistroOrigem,
				'qtLMEavaliadaC1' => $qtLMEavaliadaC1,
				'qtLMEavaliadaC2' => $qtLMEavaliadaC2,
				'qtLMEavaliadaC3' => $qtLMEavaliadaC3,
				'coProcedimento' => $coProcedimento,
				'dtAvaliacao' => $dtAvaliacao,
				'avAdequacao' => $avAdequacao,
				'coCNES' => $coCNES,
				'coCNS' => $coCNS]
			]]];
	}

	public static function informarAvaliacaoDeferidaEmLote_v2(array $avaliacoes) {
		self::removeOptional($avaliacoes);
		return [
			'hor:informarAvaliacaoDeferidaEmLote' => [
				'identificacao' => ['idOrigem' => ID_ORIGEM, 'coIBGE' => CO_IBGE]
				, 'avaliacoes' => $avaliacoes
			]
		];
	}

	public static function informarDispensacaoMedicamentoEmLote($idOrigem, $coIBGE, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM) {
		return ['hor:informarDispensacaoMedicamentoEmLote' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE],
			'registro' => ['estabelecimento' => ['idIdentificacao' => $idIdentificacao, 'coCNES' => $coCNES],
				'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude,
					'dtCompetencia' => $dtCompetencia],
				'paciente' => ['nuCNS' => $nuCNS,
					'peso' => $peso,
					'altura' => $altura,
					'cid-10' => $cid_10],
				'prescritor' => ['coCNES' => $coCNES1,
					'nuCRM' => $nuCRM,
					'ufCRM' => $ufCRM]
			]]];
	}

	public static function informarDispensacaoMedicamentoEmLote_v2(array $registros) {
		self::removeOptional($registros);
		return [
			'hor:informarDispensacaoMedicamentoEmLote' => [
				'identificacao' => ['idOrigem' => ID_ORIGEM, 'coIBGE' => CO_IBGE]
				, 'registro' => $registros
			]
		];
	}

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '123';
	 * @param $dtValidade = '01-01-2020';
	 * @param $qtProduto = '123';
	 * @param $dtRegistro = '30-10-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $nuCNPJFabricante = '00530493000171';
	 * @param $noFabricanteInternacional = 'FABRICANTE';
	 * @param $nuNotaFiscal = '1324';
	 * @param $nuValorUnitario = '1234.1234';
	 * @param $nuCNPJDistribuidor = '00530493000171';
	 * @param $tpEntradaEstoque = 'E-O';
	 * @return mixed
	 */
	public static function informarEntradaMedicamentoEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque) {
		return ['hor:informarEntradaMedicamentoEmLote' =>
			['identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE],
				'registro' => ['estabelecimento' => ['coCNES' => $coCNES, 'coTipoEstabelecimento' => $coTipoEstabelecimento],
					'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
						'nuProduto' => $nuProduto,
						'nuLote' => $nuLote,
						'dtValidade' => $dtValidade,
						'qtProduto' => $qtProduto,
						'dtRegistro' => $dtRegistro,
						'sgProgramaSaude' => $sgProgramaSaude,
						'nuCNPJFabricante' => $nuCNPJFabricante,
						'nuNotaFiscal' => $nuNotaFiscal,
						'noFabricanteInternacional' => $noFabricanteInternacional,
						'nuValorUnitario' => $nuValorUnitario,
						'nuCNPJDistribuidor' => $nuCNPJDistribuidor,
						'tpEntradaEstoque' => $tpEntradaEstoque]
				]]];
	}

	public static function informarEntradaMedicamentoEmLote_v2(array $registros) {
		self::removeOptional($registros);
		return [
			'hor:informarEntradaMedicamentoEmLote' => [
				'identificacao' => ['idOrigem' => ID_ORIGEM, 'coIBGE' => CO_IBGE]
				, 'registro' => $registros
			]
		];
	}

	public static function informarPosicaoEstoqueEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude) {
		return ['hor:informarPosicaoEstoqueEmLote' =>
			['identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE],
				'registro' => [
					'estabelecimento' => ['coCNES' => $coCNES, 'coTipoEstabelecimento' => $coTipoEstabelecimento],
					'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
						'nuProduto' => $nuProduto,
						'nuLote' => $nuLote,
						'dtValidade' => $dtValidade,
						'qtProduto' => $qtProduto,
						'dtRegistro' => $dtRegistro]
				]]];
	}

	public static function informarPosicaoEstoqueEmLote_v2($idOrigem, $coIBGE, array $registrosSemFormatacao, $data_competencia_horus) {
		self::removeOptional($registros);

		$registrosFormatados = [];
		foreach($registrosSemFormatacao as $registro){
			$registrosFormatados[] = [
				'estabelecimento' => ['coCNES' => $registro['uni_cnes'], 'coTipoEstabelecimento' => $registro['set_tipo_estab']],
				'produto' => ['coRegistroOrigem' => $registro['uni_codigo_ibge'],
													   'nuProduto' => $registro['nuProduto'],
														    'nuLote' => $registro['sal_lote'],
														'dtValidade' => $registro['sal_validade'],
														 'qtProduto' => $registro['posicao_estoque'],
														'dtRegistro' => $data_competencia_horus]
			];
		}

		return [
			'hor:informarPosicaoEstoqueEmLote' => [
				'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE]
				, 'registro' => $registrosFormatados
			]
		];
	}

	public static function informarSaidaMedicamentoEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $tpSaida, $idIdentificacao, $coCNES) {
		return ['hor:informarSaidaMedicamentoEmLote' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE],
			'registro' => [
				'estabelecimento' => ['coCNES' => $coCNES, 'coTipoEstabelecimento' => $coTipoEstabelecimento],
				'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude,
					'nuCNPJFabricante' => $nuCNPJFabricante,
					'tpSaida' => $tpSaida],
				'estabelecimento-destino' => ['idIdentificacao' => $idIdentificacao, 'coCNES' => $coCNES]
			]]];
	}

	public static function informarSaidaMedicamentoEmLote_v2(array $registros) {
		self::removeOptional($registros);
		return [
			'hor:informarSaidaMedicamentoEmLote' => [
				'identificacao' => ['idOrigem' => ID_ORIGEM, 'coIBGE' => CO_IBGE]
				, 'registro' => $registros
			]
		];
	}

	public static function retificarAvaliacaoDeferidaEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS, $coRegistro) {
		return ['hor:retificarAvaliacaoDeferidaEmLote' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada],
			'avaliacoes' => ['avaliacao' =>
				['coRegistroOrigem' => $coRegistroOrigem,
					'qtLMEavaliadaC1' => $qtLMEavaliadaC1,
					'qtLMEavaliadaC2' => $qtLMEavaliadaC2,
					'qtLMEavaliadaC3' => $qtLMEavaliadaC3,
					'coProcedimento' => $coProcedimento,
					'dtAvaliacao' => $dtAvaliacao,
					'avAdequacao' => $avAdequacao,
					'coCNES' => $coCNES,
					'coCNS' => $coCNS,
					'coRegistro' => $coRegistro]
			]]];
	}

	public static function retificarAvaliacaoDeferidaEmLote_v2($nuProtocoloEntrada, array $avaliacoes) {
		self::removeOptional($avaliacoes);
		return [
			'hor:retificarAvaliacaoDeferidaEmLote' => [
				'identificacao' => ['idOrigem' => ID_ORIGEM, 'coIBGE' => CO_IBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada]
				, 'avaliacoes' => $avaliacoes
			]
		];
	}

	public static function retificarDispensacaoMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $coRegistro, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM) {
		return ['hor:retificarDispensacaoMedicamentoEmLote' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada],
			'registro' => [
				'estabelecimento' => ['idIdentificacao' => $idIdentificacao, 'coCNES' => $coCNES],
				'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude,
					'dtCompetencia' => $dtCompetencia,
					'coRegistro' => $coRegistro],
				'paciente' => ['nuCNS' => $nuCNS,
					'peso' => $peso,
					'altura' => $altura,
					'cid-10' => $cid_10],
				'prescritor' => ['coCNES' => $coCNES1,
					'nuCRM' => $nuCRM,
					'ufCRM' => $ufCRM]
			]]];
	}

	public static function retificarDispensacaoMedicamentoEmLote_v2($nuProtocoloEntrada, array $registros) {
		self::removeOptional($registros);
		return [
			'hor:retificarDispensacaoMedicamentoEmLote' => [
				'identificacao' => ['idOrigem' => ID_ORIGEM, 'coIBGE' => CO_IBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada]
				, 'registro' => $registros
			]
		];
	}

	public static function retificarEntradaMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque, $coRegistro) {
		return ['hor:informarEntradaMedicamentoEmLote' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada],
			'registro' => ['estabelecimento' => ['coCNES' => $coCNES, 'coTipoEstabelecimento' => $coTipoEstabelecimento],
				'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude,
					'nuCNPJFabricante' => $nuCNPJFabricante,
					'noFabricanteInternacional' => $noFabricanteInternacional,
					'nuNotaFiscal' => $nuNotaFiscal,
					'nuValorUnitario' => $nuValorUnitario,
					'nuCNPJDistribuidor' => $nuCNPJDistribuidor,
					'tpEntradaEstoque' => $tpEntradaEstoque,
					'coRegistro' => $coRegistro]
			]]];
	}

	public static function retificarEntradaMedicamentoEmLote_v2($nuProtocoloEntrada, array $registros) {
		self::removeOptional($registros);
		return [
			'hor:retificarEntradaMedicamentoEmLote' => [
				'identificacao' => ['idOrigem' => ID_ORIGEM, 'coIBGE' => CO_IBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada]
				, 'registro' => $registros
			]
		];
	}

	public static function retificarPosicaoEstoqueEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $coRegistro) {
		return ['hor:retificarPosicaoEstoqueEmLote' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada],
			'registro' => ['estabelecimento' => ['coCNES' => $coCNES, 'coTipoEstabelecimento' => $coTipoEstabelecimento],
				'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude,
					'coRegistro' => $coRegistro]
			]]];
	}

	public static function retificarPosicaoEstoqueEmLote_v2($nuProtocoloEntrada, array $registros) {
		self::removeOptional($registros);
		return [
			'hor:retificarPosicaoEstoqueEmLote' => [
				'identificacao' => ['idOrigem' => ID_ORIGEM, 'coIBGE' => CO_IBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada]
				, 'registro' => $registros
			]
		];
	}

	public static function retificarSaidaMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $tpSaida, $coRegistro, $idIdentificacao, $coCNES) {
		return ['hor:retificarSaidaMedicamentoEmLote' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada],
			'registro' => [
				'estabelecimento' => ['coCNES' => $coCNES, 'coTipoEstabelecimento' => $coTipoEstabelecimento],
				'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude,
					'nuCNPJFabricante' => $nuCNPJFabricante,
					'tpSaida' => $tpSaida,
					'coRegistro' => $coRegistro],
				'estabelecimento-destino' => ['idIdentificacao' => $idIdentificacao, 'coCNES' => $coCNES]
			]]];
	}

	public static function retificarSaidaMedicamentoEmLote_v2($nuProtocoloEntrada, array $registros) {
		self::removeOptional($registros);
		return [
			'hor:retificarSaidaMedicamentoEmLote' => [
				'identificacao' => ['idOrigem' => ID_ORIGEM, 'coIBGE' => CO_IBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada]
				, 'registro' => $registros
			]
		];
	}

	private static function removeOptional($registros) {
		// remove os itens em branco
		foreach ($registros as $key_reg => &$registro) {
			foreach ($registro as $key_args => &$arguments) {
				if (is_array($arguments)) {
					foreach ($arguments as $key_arg => &$argument) {
						if ($argument == '') {
							unset($arguments[$key_arg]);
						};
					};
				} elseif (!is_array($arguments) && $arguments == '') {
					unset($registro[$key_args]);
				};
			};
		};
	}
}
