<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 08/03/2018
 * Time: 12:13
 */

namespace Saude\Horus\Async;

require_once __DIR__."/Async.php";
require_once __DIR__."/AsyncArguments.php";
require_once __DIR__."/AsyncProtocolosImpl.php";
require_once __DIR__."/../Util.php";
require_once __DIR__."/../SoapHorus.php";

use Saude\Horus\SoapHorus;
use Saude\Horus\Util;
use SoapFault;

class AsyncController extends AsyncProtocolosImpl implements Async {

	/**
	 * SyncController constructor.
	 * @param $soapClient
	 */
	public function __construct() {
		parent::__construct();
	}

	public function consultarInconsistencias($nuProtocoloEntrada, $dtRecebimento) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::consultarInconsistencias($nuProtocoloEntrada, $dtRecebimento)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function consultarInconsistencias_v2($nuProtocoloEntrada, $dtRecebimento) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::consultarInconsistencias_v2($nuProtocoloEntrada, $dtRecebimento)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function consultarResultadoProcessamento($nuProtocoloEntrada, $dtRecebimento) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::consultarResultadoProcessamento($nuProtocoloEntrada, $dtRecebimento)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function consultarResultadoProcessamento_v2($nuProtocoloEntrada, $dtRecebimento) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::consultarResultadoProcessamento_v2($nuProtocoloEntrada, $dtRecebimento)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarAvaliacaoDeferidaEmLote($idOrigem, $coIBGE, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::informarAvaliacaoDeferidaEmLote($idOrigem, $coIBGE, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarAvaliacaoDeferidaEmLote_v2(array $avaliacoes) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::informarAvaliacaoDeferidaEmLote_v2($avaliacoes)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarDispensacaoMedicamentoEmLote($idOrigem, $coIBGE, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::informarDispensacaoMedicamentoEmLote($idOrigem, $coIBGE, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarDispensacaoMedicamentoEmLote_v2(array $registros) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::informarDispensacaoMedicamentoEmLote_v2($registros)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarEntradaMedicamentoEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::informarEntradaMedicamentoEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarEntradaMedicamentoEmLote_v2(array $registros) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::informarEntradaMedicamentoEmLote_v2($registros)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarPosicaoEstoqueEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::informarPosicaoEstoqueEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarPosicaoEstoqueEmLote_v2($idOrigem, $coIBGE, array $registros, $data_competencia_horus) {
		try {
			$protocolo = $this->client->__call(
				"informarPosicaoEstoqueEmLote",
				AsyncArguments::informarPosicaoEstoqueEmLote_v2($idOrigem, $coIBGE, $registros, $data_competencia_horus)
			);

			$competenciaFormatada = date('Y-m-d',strtotime($data_competencia_horus));

			$this->protInformarPosicaoEstoqueEmLote($protocolo, $competenciaFormatada);

			return "Competência enviada com sucesso!";
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return $e->getMessage();
		}
	}

	public function informarSaidaMedicamentoEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $tpSaida, $idIdentificacao, $coCNES) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::informarSaidaMedicamentoEmLote($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $tpSaida, $idIdentificacao, $coCNES)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarSaidaMedicamentoEmLote_v2(array $registros) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::informarPosicaoEstoqueEmLote_v2($registros)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarAvaliacaoDeferidaEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS, $coRegistro) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::retificarAvaliacaoDeferidaEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS, $coRegistro)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarAvaliacaoDeferidaEmLote_v2($nuProtocoloEntrada, array $avaliacoes) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::retificarAvaliacaoDeferidaEmLote_v2($nuProtocoloEntrada, $avaliacoes)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarDispensacaoMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $coRegistro, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::retificarDispensacaoMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $coRegistro, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarDispensacaoMedicamentoEmLote_v2($nuProtocoloEntrada, array $registros) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::retificarDispensacaoMedicamentoEmLote_v2($nuProtocoloEntrada, $registros)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarEntradaMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque, $coRegistro) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::retificarEntradaMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque, $coRegistro)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarEntradaMedicamentoEmLote_v2($nuProtocoloEntrada, array $registros) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::retificarEntradaMedicamentoEmLote_v2($nuProtocoloEntrada, $registros)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarPosicaoEstoqueEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $coRegistro) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::retificarPosicaoEstoqueEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $coRegistro)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarPosicaoEstoqueEmLote_v2($nuProtocoloEntrada, array $registros) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::retificarPosicaoEstoqueEmLote_v2($nuProtocoloEntrada, $registros)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarSaidaMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $tpSaida, $coRegistro, $idIdentificacao, $coCNES) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::retificarSaidaMedicamentoEmLote($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $tpSaida, $coRegistro, $idIdentificacao, $coCNES)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarSaidaMedicamentoEmLote_v2($nuProtocoloEntrada, array $registros) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				AsyncArguments::retificarSaidaMedicamentoEmLote_v2($nuProtocoloEntrada, $registros)
			);
			return $protocolo;
		} catch (SoapFault $e) {
			return Util::returnError(__FUNCTION__, $e);
		}
	}
}
