<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 08/03/2018
 * Time: 12:14
 */

namespace Saude\Horus\Sync;


interface SyncArgs {
	/**
	 * @param $nuProtocoloEntrada = '17100000023000003112';
	 * @param $dtRecebimento = '31-10-2017 16:31:20';
	 * @return mixed
	 */
	public static function excluirRegistros($nuProtocoloEntrada, $dtRecebimento);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $coRegistroOrigem = '123';
	 * @param $qtLMEavaliadaC1 = '31';
	 * @param $qtLMEavaliadaC2 = '31';
	 * @param $qtLMEavaliadaC3 = '31';
	 * @param $coProcedimento = '0604010010';
	 * @param $dtAvaliacao = '15-10-2017';
	 * @param $avAdequacao = 'N';
	 * @param $coCNES = '5717493';
	 * @param $coCNS = '700600555663867';
	 * @return mixed
	 */
	public static function informarAvaliacaoDeferida($idOrigem, $coIBGE, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $idIdentificacao = 'CNES';
	 * @param $coCNES = '5717493';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';m
	 * @param $nuLote = '1234';
	 * @param $dtValidade = '30-11-2020';
	 * @param $qtProduto = '123';
	 * @param $dtRegistro = '08-11-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $dtCompetencia = '11-2017';
	 * @param $nuCNS = '700600555663867';
	 * @param $peso = '77.10';
	 * @param $altura = '125';
	 * @param $cid_10 = 'F20.0';
	 * @param $coCNES1 = '5717493';
	 * @param $nuCRM = '1234';
	 * @param $ufCRM = 'DF';
	 * @return mixed
	 */
	public static function informarDispensacaoMedicamento($idOrigem, $coIBGE,$idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '12345';
	 * @param $dtValidade = '01-01-2020';
	 * @param $qtProduto = '12345';
	 * @param $dtRegistro = '30-10-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $nuCNPJFabricante = '00530493000171';
	 * @param $noFabricanteInternacional = 'FABRICANTE';
	 * @param $nuNotaFiscal = '1324';
	 * @param $nuValorUnitario = '1234.1234';
	 * @param $nuCNPJDistribuidor = '00530493000171';
	 * @param $tpEntradaEstoque = 'E-O';
	 * @return mixed
	 */
	public static function informarEntradaMedicamento($idOrigem, $coIBGE,$coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '12345';
	 * @param $dtValidade = '01-01-2020';
	 * @param $qtProduto = '3';
	 * @param $dtRegistro = '30-10-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @return mixed
	 */
	public static function informarPosicaoEstoque($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '132';
	 * @param $dtValidade = '30-10-2020';
	 * @param $qtProduto = '132';
	 * @param $dtRegistro = '01-11-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $nuCNPJFabricante = '10176265000107';
	 * @param $tpSaida = 'S-AE';
	 * @param $idIdentificacao = 'CNES';
	 * @param $coCNES =  '5717493';
	 * @return mixed
	 */
	public static function informarSaidaMedicamento($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $tpSaida, $idIdentificacao, $coCNES);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $nuProtocoloEntrada = '17100000023000003135';
	 * @param $coRegistroOrigem = '123';
	 * @param $qtLMEavaliadaC1 = '30';
	 * @param $qtLMEavaliadaC2 = '31';
	 * @param $qtLMEavaliadaC3 = '31';
	 * @param $coProcedimento = '0604010010';
	 * @param $dtAvaliacao = '15-10-2017';
	 * @param $avAdequacao = 'N';
	 * @param $coCNES = '5717493';
	 * @param $coCNS = '700600555663867';
	 * @param $coRegistro = '5086';
	 * @return mixed
	 */
	public static function retificarAvaliacaoDeferida($idOrigem, $coIBGE, $nuProtocoloEntrada, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS, $coRegistro);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $nuProtocoloEntrada = '17110000023000003262';
	 * @param $idIdentificacao = 'CNES';
	 * @param $coCNES = '5717493';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '1234';
	 * @param $dtValidade = '30-11-2020';
	 * @param $qtProduto = '123';
	 * @param $dtRegistro = '08-11-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $dtCompetencia = '11-2017';
	 * @param $coRegistro = '12547';
	 * @param $nuCNS = '700600555663867';
	 * @param $peso = '77.10';
	 * @param $altura = '125';
	 * @param $cid_10 = 'F20.0';
	 * @param $coCNES1 = '5717493';
	 * @param $nuCRM = '1234';
	 * @param $ufCRM = 'DF';
	 * @return mixed
	 */
	public static function retificarDispensacaoMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $coRegistro, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $nuProtocoloEntrada = '17100000023000003139';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '12345';
	 * @param $dtValidade = '01-01-2020';
	 * @param $qtProduto = '12345';
	 * @param $dtRegistro = '30-10-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $nuCNPJFabricante = '00530493000171';
	 * @param $noFabricanteInternacional = 'FABRICANTE';
	 * @param $nuNotaFiscal = '1324';
	 * @param $nuValorUnitario = '1234.1234';
	 * @param $nuCNPJDistribuidor = '00530493000171';
	 * @param $tpEntradaEstoque = 'E-O';
	 * @param $coRegistro = '5090';
	 * @return mixed
	 */
	public static function retificarEntradaMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque, $coRegistro);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $nuProtocoloEntrada = '17110000023000003228';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = '12345';
	 * @param $dtValidade = '01-01-2020';
	 * @param $qtProduto = '3';
	 * @param $dtRegistro = '30-10-2017';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $coRegistro = '32589';
	 * @return mixed
	 */
	public static function retificarPosicaoEstoque($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $coRegistro);

	/**
	 * @param $idOrigem = 'E';
	 * @param $coIBGE = '23';
	 * @param $nuProtocoloEntrada = '17110000023000003262';
	 * @param $coCNES = '5717493';
	 * @param $coTipoEstabelecimento = 'A';
	 * @param $coRegistroOrigem = '123';
	 * @param $nuProduto = 'EBR0266630U0118';
	 * @param $nuLote = 'ABC123';
	 * @param $dtValidade = '10-10-2020';
	 * @param $qtProduto = '1234';
	 * @param $dtRegistro = '01-11-2018';
	 * @param $sgProgramaSaude = 'DST';
	 * @param $nuCNPJFabricante = '10176265000107';
	 * @param $tpSaida = 'S-AE';
	 * @param $coRegistro  = '78547';
	 * @param $idIdentificacao = 'CNES';
	 * @param $coCNES =  '5717493';
	 * @return mixed
	 */
	public static function retificarSaidaMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $tpSaida, $coRegistro, $idIdentificacao, $coCNES);
}