<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 08/03/2018
 * Time: 13:58
 */

namespace Saude\Horus\Sync;

require_once __DIR__."/SyncArgs.php";

abstract class SyncArguments implements SyncArgs {

	public static function excluirRegistros($nuProtocoloEntrada, $dtRecebimento) {
		return [
			'hor:excluirRegistro' => [
				'protocolo'=> [
					'nuProtocoloEntrada'=>$nuProtocoloEntrada,
					'dtRecebimento'=>$dtRecebimento]
			]
		];
	}

	public static function informarAvaliacaoDeferida($idOrigem, $coIBGE, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS) {
		return ['hor:informarAvaliacaoDeferida' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE],
			'avaliacao' => [   'coRegistroOrigem' => $coRegistroOrigem,
				'qtLMEavaliadaC1' => $qtLMEavaliadaC1,
				'qtLMEavaliadaC2' => $qtLMEavaliadaC2,
				'qtLMEavaliadaC3' => $qtLMEavaliadaC3,
				'coProcedimento' => $coProcedimento,
				'dtAvaliacao' => $dtAvaliacao,
				'avAdequacao' => $avAdequacao,
				'coCNES' => $coCNES,
				'coCNS' => $coCNS],
		]];
	}

	public static function informarDispensacaoMedicamento($idOrigem, $coIBGE, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM) {
		return ['hor:informarDispensacaoMedicamento' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE],
			'estabelecimento' => ['idIdentificacao' => $idIdentificacao, 'coCNES' => $coCNES],
			'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
				'nuProduto' => $nuProduto,
				'nuLote' => $nuLote,
				'dtValidade' => $dtValidade,
				'qtProduto' => $qtProduto,
				'dtRegistro' => $dtRegistro,
				'sgProgramaSaude' => $sgProgramaSaude,
				'dtCompetencia' => $dtCompetencia],
			'paciente' => ['nuCNS' => $nuCNS,
				'peso' => $peso,
				'altura' => $altura,
				'cid-10' => $cid_10],
			'prescritor' => ['coCNES' => $coCNES1,
				'nuCRM' => $nuCRM,
				'ufCRM' => $ufCRM]]
		];
	}

	public static function informarEntradaMedicamento($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque) {
		return ['hor:informarEntradaMedicamento' =>
			['identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE],
				'estabelecimento' => ['coCNES' => $coCNES, 'coTipoEstabelecimento' => $coTipoEstabelecimento],
				'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude,
					'nuCNPJFabricante' => $nuCNPJFabricante,
					'noFabricanteInternacional' => $noFabricanteInternacional,
					'nuNotaFiscal' => $nuNotaFiscal,
					'nuValorUnitario' => $nuValorUnitario,
					'nuCNPJDistribuidor' => $nuCNPJDistribuidor,
					'tpEntradaEstoque' => $tpEntradaEstoque]]
		];
	}

	public static function informarPosicaoEstoque($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude) {
		return ['hor:informarPosicaoEstoque' =>
			['identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE],
				'estabelecimento' => ['coCNES' => $coCNES,
					'coTipoEstabelecimento' => $coTipoEstabelecimento],
				'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude]]
		];
	}

	public static function informarSaidaMedicamento($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $tpSaida, $idIdentificacao, $coCNES) {
		return ['hor:informarSaidaMedicamento' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE],
			'estabelecimento' => ['coCNES' => $coCNES,
				'coTipoEstabelecimento' => $coTipoEstabelecimento],
			'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
				'nuProduto' => $nuProduto,
				'nuLote' => $nuLote,
				'dtValidade' => $dtValidade,
				'qtProduto' => $qtProduto,
				'dtRegistro' => $dtRegistro,
				'sgProgramaSaude' => $sgProgramaSaude,
				'nuCNPJFabricante' => $nuCNPJFabricante,
				'noFabricanteInternacional' => $noFabricanteInternacional,
				'tpSaida' => $tpSaida],
			'estabelecimento-destino' => [
				'idIdentificacao' => $idIdentificacao,
				'coCNES' => $coCNES
			]
		]];
	}

	public static function retificarAvaliacaoDeferida($idOrigem, $coIBGE, $nuProtocoloEntrada, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS, $coRegistro) {
		return ['hor:retificarAvaliacaoDeferida' => [
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE, 'nuProtocoloEntrada' => $nuProtocoloEntrada],
			'avaliacao' => ['coRegistroOrigem' => $coRegistroOrigem,
				'qtLMEavaliadaC1' => $qtLMEavaliadaC1,
				'qtLMEavaliadaC2' => $qtLMEavaliadaC2,
				'qtLMEavaliadaC3' => $qtLMEavaliadaC3,
				'coProcedimento' => $coProcedimento,
				'dtAvaliacao' => $dtAvaliacao,
				'avAdequacao' => $avAdequacao,
				'coCNES' => $coCNES,
				'coCNS' => $coCNS,
				'coRegistro' => $coRegistro],
		]];
	}

	public static function retificarDispensacaoMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $coRegistro, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM) {
		return ['hor:informarDispensacaoMedicamento' =>
			['identificacao' => ['idOrigem' => $idOrigem,'coIBGE' => $coIBGE,'nuProtocoloEntrada' => $nuProtocoloEntrada],
				'estabelecimento' => ['idIdentificacao' => $idIdentificacao,'coCNES' => $coCNES],
				'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude,
					'dtCompetencia' => $dtCompetencia,
					'coRegistro' => $coRegistro],
				'paciente' => ['nuCNS' => $nuCNS,
					'peso' => $peso,
					'altura' => $altura,
					'cid-10' => $cid_10],
				'prescritor' => ['coCNES' => $coCNES1,
					'nuCRM' => $nuCRM,
					'ufCRM' => $ufCRM]]
		];
	}

	public static function retificarEntradaMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque, $coRegistro) {
		$retorno = ['hor:retificiarEntradaMedicamento' =>
			['identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE,'nuProtocoloEntrada' => $nuProtocoloEntrada],
				'estabelecimento' => ['coCNES' => $coCNES,'coTipoEstabelecimento' => $coTipoEstabelecimento],
				'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude,
					'nuCNPJFabricante' => $nuCNPJFabricante,
					'noFabricanteInternacional' => $noFabricanteInternacional,
					'nuNotaFiscal' => $nuNotaFiscal,
					'nuValorUnitario' => $nuValorUnitario,
					'nuCNPJDistribuidor' => $nuCNPJDistribuidor,
					'tpEntradaEstoque' => $tpEntradaEstoque,
					'coRegistro' => $coRegistro]]
		];
		self::removeOptional($retorno);
		return $retorno;
	}

	public static function retificarPosicaoEstoque($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $coRegistro) {
		return ['hor:retificarPosicaoEstoque' =>[
			'identificacao' => ['idOrigem' => $idOrigem, 'coIBGE' => $coIBGE,'nuProtocoloEntrada' => $nuProtocoloEntrada],
			'estabelecimento' => ['coCNES' => $coCNES, 'coTipoEstabelecimento' => $coTipoEstabelecimento],
			'produto' => ['coRegistroOrigem' => $coRegistroOrigem,
				'nuProduto' => $nuProduto,
				'nuLote' => $nuLote,
				'dtValidade' => $dtValidade,
				'qtProduto' => $qtProduto,
				'dtRegistro' => $dtRegistro,
				'sgProgramaSaude' => $sgProgramaSaude,
				'coRegistro' => $coRegistro]
		]];
	}

	public static function retificarSaidaMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $tpSaida, $coRegistro, $idIdentificacao, $coCNES) {
		return [
			'hor:retificarSaidaMedicamento' => [
				'identificacao' => [
					'idOrigem' => $idOrigem,
					'coIBGE' => $coIBGE,
					'nuProtocoloEntrada' => $nuProtocoloEntrada
				],
				'estabelecimento' => [
					'coCNES' => $coCNES,
					'coTipoEstabelecimento' => $coTipoEstabelecimento
				],
				'produto' => [
					'nuProduto' => $nuProduto,
					'nuLote' => $nuLote,
					'dtValidade' => $dtValidade,
					'qtProduto' => $qtProduto,
					'dtRegistro' => $dtRegistro,
					'sgProgramaSaude' => $sgProgramaSaude,
					'nuCNPJFabricante' => $nuCNPJFabricante,
					'noFabricanteInternacional' => $noFabricanteInternacional,
					'tpSaida' => $tpSaida,
					'coRegistro' => $coRegistro],
				'estabelecimento-destino' => [
					'idIdentificacao' => $idIdentificacao,
					'coCNES' => $coCNES
				]
			]];
	}

	private static function removeOptional($registros) {
		// remove os itens em branco
		foreach ($registros as $key_reg => &$registro) {
			foreach ($registro as $key_args => &$arguments) {
				if (is_array($arguments)) {
					foreach ($arguments as $key_arg => &$argument) {
						if ($argument == '') {
							unset($arguments[$key_arg]);
						};
					};
				} elseif (!is_array($arguments) && $arguments == '') {
					unset($registro[$key_args]);
				};
			};
		};
	}
}