<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 08/03/2018
 * Time: 12:13
 */

namespace Saude\Horus\Sync;

require_once __DIR__ . "/Sync.php";
require_once __DIR__ . "/SyncArguments.php";
require_once __DIR__ . "/SyncProtocolosImpl.php";
require_once __DIR__ . "/../Util.php";

use Saude\Horus\Util;
use SoapFault;

class SyncController extends SyncProtocolosImpl implements Sync {

	/**
	 * SyncController constructor.
	 */
	public function __construct() {
		parent::__construct();
	}

	public function excluirRegistros($nuProtocoloEntrada, $dtRecebimento) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::excluirRegistros($nuProtocoloEntrada, $dtRecebimento)
			);
			$this->protExcluirRegistros($protocolo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarAvaliacaoDeferida($idOrigem, $coIBGE, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::informarAvaliacaoDeferida($idOrigem, $coIBGE, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS)
			);
			$this->protInformarAvaliacaoDeferida($protocolo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarDispensacaoMedicamento($idOrigem, $coIBGE, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::informarDispensacaoMedicamento($idOrigem, $coIBGE, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM)
			);
			$this->protInformarDispensacaoMedicamento($protocolo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarEntradaMedicamento($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque, $tipo = NULL) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::informarEntradaMedicamento($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque)
			);
			$this->protInformarEntradaMedicamento($protocolo, $tipo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarPosicaoEstoque($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::informarPosicaoEstoque($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude)
			);
			$this->protInformarPosicaoEstoque($protocolo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function informarSaidaMedicamento($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $tpSaida, $idIdentificacao, $coCNES, $tipo = NULL) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::informarSaidaMedicamento($idOrigem, $coIBGE, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $tpSaida, $idIdentificacao, $coCNES)
			);
			$this->protInformarSaidaMedicamento($protocolo, $tipo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarAvaliacaoDeferida($idOrigem, $coIBGE, $nuProtocoloEntrada, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS, $coRegistro) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::retificarAvaliacaoDeferida($idOrigem, $coIBGE, $nuProtocoloEntrada, $coRegistroOrigem, $qtLMEavaliadaC1, $qtLMEavaliadaC2, $qtLMEavaliadaC3, $coProcedimento, $dtAvaliacao, $avAdequacao, $coCNES, $coCNS, $coRegistro)
			);
			$this->protRetificarAvaliacaoDeferida($protocolo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarDispensacaoMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $coRegistro, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::retificarDispensacaoMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $idIdentificacao, $coCNES, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $dtCompetencia, $coRegistro, $nuCNS, $peso, $altura, $cid_10, $coCNES1, $nuCRM, $ufCRM)
			);
			$this->protRetificarDispensacaoMedicamento($protocolo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarEntradaMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque, $coRegistro) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::retificarEntradaMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $nuNotaFiscal, $nuValorUnitario, $nuCNPJDistribuidor, $tpEntradaEstoque, $coRegistro)
			);
			$this->protRetificarEntradaMedicamento($protocolo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarPosicaoEstoque($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $coRegistro) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::retificarPosicaoEstoque($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $coRegistroOrigem, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $coRegistro)
			);
			$this->protRetificarPosicaoEstoque($protocolo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}

	public function retificarSaidaMedicamento($idOrigem,$coIBGE,$nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $tpSaida, $coRegistro, $idIdentificacao, $coCNES) {
		try {
			$protocolo = $this->client->__call(
				__FUNCTION__,
				SyncArguments::retificarSaidaMedicamento($idOrigem, $coIBGE, $nuProtocoloEntrada, $coCNES, $coTipoEstabelecimento, $nuProduto, $nuLote, $dtValidade, $qtProduto, $dtRegistro, $sgProgramaSaude, $nuCNPJFabricante, $noFabricanteInternacional, $tpSaida, $coRegistro, $idIdentificacao, $coCNES)
			);
			$this->protRetificarSaidaMedicamento($protocolo);
			return $protocolo;
		} catch (SoapFault $e) {
			$this->gravaErro($e);
			return Util::returnError(__FUNCTION__, $e);
		}
	}
}