<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 25/04/2018
 * Time: 10:17
 */

namespace Saude\Horus\Sync;

require_once __DIR__."/../Connection.php";
require_once __DIR__."/../SoapHorus.php";
require_once __DIR__."/SyncProtocolos.php";

use Saude\Horus\Connection;
use Saude\Horus\SoapHorus;

class SyncProtocolosImpl extends SoapHorus implements SyncProtocolos {

	private $SAIDA = "S";
	private $ENTRADA = "E";
	private $DISPENSACAO = "D";
	private $EXCLUSAO = "X";
	private $RETIFICACAO = "R";
	private $TRANSFERENCIA_SAIDA = "TS";
	private $TRANSFERENCIA_ENTRADA = "TE";
	private $POSICAO_ESTOQUE = "PE";

	private $conn;
	private $sql = "INSERT INTO horus_protocolo (hp_registro, hp_registro_origem, hp_tipo_registro, hp_nu_protocolo, hp_data)
					VALUES (:registro, :registroOrigem, :tipo, :protocolo, :datetime)";

	public function __construct() {
		$this->conn = new Connection();
		parent::__construct();
	}

	public function protExcluirRegistros($protocolo) {
		$this->gravaProtocoloComum($protocolo, $this->EXCLUSAO);
	}

	public function protInformarAvaliacaoDeferida($protocolo) {
		// TODO: Implement protInformarAvaliacaoDeferida() method.
	}

	public function protInformarDispensacaoMedicamento($protocolo) {
		$this->gravaProtocoloComum($protocolo, $this->DISPENSACAO);
	}

	public function protInformarEntradaMedicamento($protocolo, $tipo=NULL) {
		$tp = ($tipo ? $this->TRANSFERENCIA_ENTRADA : $this->ENTRADA);
		$this->gravaProtocoloComum($protocolo, $tp);
	}

	public function protInformarPosicaoEstoque($protocolo) {
		$tp = ($this->POSICAO_ESTOQUE);
		$this->gravaProtocoloComum($protocolo, $tp);
  }

  public function protRetificarPosicaoEstoque($protocolo) {
		// TODO: Implement protRetificarPosicaoEstoque() method.
	}

	public function protInformarSaidaMedicamento($protocolo, $tipo=NULL) {
		$tp = ($tipo ? $this->TRANSFERENCIA_SAIDA : $this->SAIDA);
		$this->gravaProtocoloComum($protocolo, $tp);
	}

	public function protRetificarAvaliacaoDeferida($protocolo) {
		// TODO: Implement protRetificarAvaliacaoDeferida() method.
	}

	public function protRetificarDispensacaoMedicamento($protocolo) {
		// TODO: Implement protRetificarDispensacaoMedicamento() method.
	}

	public function protRetificarEntradaMedicamento($protocolo) {
		$this->gravaProtocoloComum($protocolo, $this->RETIFICACAO);
	}

	public function protRetificarSaidaMedicamento($protocolo) {
		$this->gravaProtocoloComum($protocolo, $this->RETIFICACAO);
	}

	public function gravaErro($protocolo){
		$inc = null;
		$dt = new \DateTime();
		$sql = "INSERT INTO horus_erros (he_codigo, he_mensagem, he_campo, he_valor, he_datatime)
				VALUES (:codigo, :mensagem, :campo, :valor, :datatime)";
		if(isset($protocolo->detail->inconsistencia)){
			$inc = $protocolo->detail->inconsistencia;
			$args = [
				"codigo"   => $inc->codigo,
				"mensagem" => $inc->mensagem,
				"campo"    => $inc->campo,
				"valor"    => $inc->valor,
				"datatime" => $dt->format('Ymd His')
			];
			$this->conn->save($sql, $args);
		}

		if(isset($protocolo->detail->Failure)){
			$inc = $protocolo->detail->Failure;
			$args = [
				"codigo"   => $inc->Code,
				"mensagem" => $inc->Detail,
				"campo"    => $inc->Reason,
				"valor"    => null,
				"datatime" => $dt->format('Ymd His')
			];

		}

		if(isset($protocolo->faultstring)){
			$args = [
				"codigo"   => $protocolo->faultcode,
				"mensagem" => $protocolo->faultstring,
				"campo"    => "Erro no servidor SOAP do hórus",
				"valor"    => null,
				"datatime" => $dt->format('Ymd His')
			];
			$this->conn->save($sql, $args);
		}
	}

	public function atualizaProtocolo($protocolo, $mov_codigo) {
		$sql = "UPDATE horus_protocolo
				   SET mov_codigo = :mov_codigo
				 WHERE hp_nu_protocolo = :nu_protocolo";
		$this->conn->save($sql, ["mov_codigo" => $mov_codigo, "nu_protocolo" => $protocolo]);
	}

	private function gravaProtocoloComum($protocolo, $tipo){
		$prod = isset($protocolo->produto) ? $protocolo->produto : null;
		$prot = isset($protocolo->protocolo) ? $protocolo->protocolo : null;
		$data = isset($prot) ? \DateTime::createFromFormat('d-m-Y H:i:s', $prot->dtRecebimento) : null;
		$args = [
			"registro" => (isset($prod) ? $prod->coRegistro : null),
			"registroOrigem" => (isset($prod) ? $prod->coRegistroOrigem : null),
			"tipo" => $tipo,
			"protocolo" => (isset($prot) ? $prot->nuProtocoloEntrada : null),
			"datetime" => (isset($data) ? $data->format('Ymd His') : null)
		];
		$this->conn->save($this->sql, $args);
	}
}
