<?php
	session_start();
	require_once $_SESSION[root].$_SESSION[comum]."library/php/db.inc.php";
	require_once $_SESSION[root].$_SESSION[comum]."library/php/funcoes.inc.php";

$_SESSION[modulo] = "WebSocialSaude/"; $_SESSION[root] = $_SERVER[DOCUMENT_ROOT] . "/"; $_SESSION[linkroot] = "http://" . $_SERVER[HTTP_HOST] . "/"; $_SESSION[comum] = "WebSocialComum/"; $_SESSION[modulo] = "WebSocialSaude/"; require_once $_SESSION[root].$_SESSION[modulo]."sessao_controller.php";

$sessao = new TempoSessao();
$sessao->primeiraPagina();


/**
 * LAYOUT PARA MUNICIPIOS : CARTO NACIONAL DE SAUDE
 * VERSÃO 2.2.0.0
 * Release 1
*/

class LayoutCritica
{
	/* fase de testes ? */
	var $debug = false;
	
	/** constantes */
	var $VERSAO = '02.00';
	
	/** Codigos */
	var $ibge 				= '';
	var $cid_codigo		= '';
	var $cid_nome		= '';
	
	/** Geracao do arquivo */
	var $diretorio 			= 'datasus/';
	var $separador 		= "\n";
	var $fileHandler 		= null;
	var $arquivo 			= '';
		
	/** REGISTRO TIPO HEADER GERAL DO ARQUIVO (Tamanho do registro: 1083) */
	var $HeaderStr		= '';
	var $Header			= '';
	
	/** REGISTRO TIPO REGISTRO DETALHE DO DOMICILIO (Tamanho do registro: 1083) */
	var $DomicilioStr	= '';
	var $Domicilio 		= '';
	
	/** REGISTRO TIPO REGISTRO DETALHE DO USUARIO (Tamanho do registro: 1083) */
	var $UsuarioStr		= '';
	var $Usuario 			= '';
	var $contadorUsu	= 0;
	
	/** REGISTRO TIPO TRAILLER DE ARQUIVO DE MUNICIPIO (Tamanho do registro: 1083) */
	var $TraillerStr		= '';
	var $Trailler				= '';
	
	/** contador geral !  */
	var $contador = 0;
	
	/** form */
	var $tipo_filtro = 0;	 // 1 : menor igual, 2 : maior igual, 3 : entre duas datas
	var $data_ini;
	var $data_fim;
	
	/** resultado */
	var $mensagem = '';
	
	/** login */
	var $id_login = 0;
	
	/** Construtor */
	function LayoutCritica( $ibge, $debug = false )
	{
		if( $debug )
			error_reporting( E_ALL | E_STRICT );	
		
		$this->ibge 			= substr( $ibge, 0, 7 );
		$this->debug			= $debug;
		$row						= db_getRow("SELECT cid_codigo, cid_nome FROM cidade WHERE cid_codigo_ibge = '{$ibge}'");
		$this->cid_codigo 	= $row[0];
		$this->cid_nome 	= substr( $row[1], 0, 40 );

	} // function LayoutCritica
	
	/**
		Código IGBE dos Lotes (7 posições) +
		Data (aammdd) +
		Identificador do arquivo (6 últimas posições de um seqüencial de quantidade de arquivo) +.DTS
	*/
	function criaArquivo() 
	{
		$pk_lc = db_get("SELECT NEXTVAL( 'layout_critica_lc_codigo_seq' )");
		$this->arquivo =  sprintf( "%07d" . "%6s" . "%06d" . ".DTS", 
			$this->ibge,
			date('ymd'),
			$pk_lc
		);
		
		if( $this->debug ) { print "<pre>\nArquivo:\n"; print $this->arquivo; print "</pre>"; }
		
		$Buffer = '';
		
		// Cabecalho
		$this->criaHeader( );
		
		$Buffer .= $this->Header . $this->separador;
		
		// Verifica quais sao as familias (domicilios) desta cidade ARRUMAR
		$stmt_dom0	= "SELECT DISTINCT fam_codigo FROM familia WHERE cid_codigo = {$this->cid_codigo}";
		if( ! empty( $this->tipo_filtro ) )
		{
			switch( $this->tipo_filtro )
			{
				case 1:
					$stmt_dom0 .= " AND fam_dt_inclusao <= '{$this->data_ini}'";
					break;
				case 2:
					$stmt_dom0 .= " AND fam_dt_inclusao >= '{$this->data_ini}'";
					break;
				case 3:
					$stmt_dom0 .= " AND fam_dt_inclusao BETWEEN '{$this->data_ini}' AND '{$this->data_fim}'";
					break;
			}
		}
		
		$qry_dom0		= db_query( $stmt_dom0 );
		
		if( $this->debug ) { print "<pre>\nHeader:\n"; var_dump($this->Header); print "\n$stmt_dom0</pre>"; }

		// percorre as familias 
		while( $row_dom0 = pg_fetch_row($qry_dom0) )
		{
			$stmt_dom1 	= '
				SELECT f.*, m.*,
				( CASE WHEN f.fam_dt_alteracao IS NULL THEN 1 ELSE 9 END ) as tipo_op_dom
				FROM familia AS f
				LEFT JOIN microarea AS m ON m.mic_codigo = f.mic_codigo
				WHERE f.fam_codigo='.$row_dom0[ 0 ];	
			$row_dom1 	= db_getRow( $stmt_dom1 );
			
			$this->criaDomicilio( $row_dom1 );
			
			$Buffer .= $this->Domicilio . $this->separador;
			if( $this->debug ) { print "<pre>\nDomicilio:\n"; var_dump($this->Domicilio); print "\n$stmt_dom1</pre>"; }
			
			// percorre os usuarios desta familia/domicilio
			$stmt_usu0 = "
				SELECT u.*, 
				( CASE WHEN u.dt_alteracao IS NULL THEN 1 ELSE 9 END ) as tipo_op_usu
				FROM usuario AS u 
				WHERE u.fam_codigo=".$row_dom0[ 0 ];
			
			if( ! empty( $this->tipo_filtro ) )
			{
				switch( $this->tipo_filtro )
				{
					case 1:
						$stmt_usu0 .= " AND dt_inclusao <= '{$this->data_ini}'";
						break;
					case 2:
						$stmt_usu0 .= " AND dt_inclusao >= '{$this->data_ini}'";
						break;
					case 3:
						$stmt_usu0 .= " AND dt_inclusao BETWEEN '{$this->data_ini}' AND '{$this->data_fim}'";
						break;
				}
			}
			$qry_usu0 = db_query( $stmt_usu0 );
			
			if( $this->debug ) { print "<pre>\nSQL Usuario:\n$stmt_usu0</pre>"; }
			
			$this->contadorUsu = 0;
			
			while( $row_usu0 = pg_fetch_array( $qry_usu0 ) )
			{
				$this->contadorUsu++;
				$this->criaUsuario( $row_usu0 );
				$Buffer .= $this->Usuario . $this->separador;
				if( $this->debug ) { print "<pre>\nUsuario:\n"; var_dump($this->Usuario); print "</pre>"; }
				exit;
			}
		}
		
		// finaliza
		$this->criaTrailler();
		$Buffer .= $this->Trailler . $this->separador;
		
		if( $this->debug ) { print "<pre>\nTrailler:\n"; var_dump($this->Trailler); print "</pre>"; }
		
		// gera o arquivo
		$this->fileHandler = fopen( $this->diretorio . $this->arquivo, 'w+' );
		if( ! $this->fileHandler ) die("N&atilde;o foi poss&iacute;vel abrir o arquivo <strong>{$this->arquivo}</strong> !");

		if( ! fwrite( $this->fileHandler, $Buffer ) )
		{
			print "N&atilde;o foi poss&iacute;vel escrever no o arquivo <strong>{$this->arquivo}</strong> !";
		}
		
		fclose( $this->fileHandler );
		
		/** gerando LOG */
		$data_fim = ( empty($this->data_fim) ? 'null' : "'{$this->data_fim}'" );
		$stmt_log = "INSERT INTO layout_critica ( lc_codigo,  lc_data_cad, lc_periodo_ini, lc_periodo_fim, 
			usr_codigo, cid_codigo, lc_arquivo, lc_tipo_filtro )
		VALUES ( $pk_lc, NOW(), '{$this->data_ini}', {$data_fim}, {$this->id_login}, {$this->cid_codigo}, 
			'{$this->arquivo}', {$this->tipo_filtro} )";
		
		db_query($stmt_log);
		
		$this->mensagem = "Arquivo criado \"<strong><a href='{$this->diretorio}{$this->arquivo}' title='Baixar arquivo'>{$this->arquivo}</a></strong>\" em \"<strong>{$this->diretorio}</strong>\"
			@ \"<strong>". date('d/m/Y H:i') ."</strong>\"";
		
		if( $this->debug ) { $this->mensagem = "<br /><em>debug mode on</em><br />".$this->mensagem; }
		
		return true;
	}

	/** Cria a Header */
	function criaHeader( )
	{
		$this->contador ++;
		$this->HeaderStr = 
					"%07d".
					"%1d".
					"%07d".
					"%40s".
					"%5s".
					"%3s".
					"%20s".
					"%5s".
					"%8s".
					"%38s".
					"%10s".
					"%939s";
					
		$this->Header = sprintf(  $this->HeaderStr,
			$this->contador ++,					# sequencial
			0, 												# fixo
			$this->ibge,								# Deve ser um código de município válido, segundo tabela do IBGE.
			substr( $this->cid_nome, 0, 40 ),	# Nome do município de residência de todos os usuários do arquivo. 
			'',													# fixo
			'',													# fixo
			date( 'd/m/Y H:i:s' ),					# fixo
			$this->VERSAO,							# fixo
			'',													# fixo
			substr( $this->arquivo, 0, 38 ),	# OBRIGATORIO
			'LAYOUTMUN',								# fixo
			''													# fixo
		);
		
		return $this;
		
	} // function criaHeader()
	
	/** Cria o Domicilio */
	function criaDomicilio( $rowDom )
	{
		$this->contador++;
		$this->DomicilioStr = 
					"%07d".
					"%1d".
					"%48s".
					"%16s".
					"%4s".
					"%10s".
					"%20s".
					"%20s".
					"%02d".
					"%04d".
					"%02d".
					"%03d".
					"%03d".
					"%50s".
					"%7s".
					"%15s".
					"%30s".
					"%8s".
					"%03d".
					"%09d".
					"%02d".
					"%02d".
					"%1s".
					"%1s".
					"%1s".
					"%1s".
					"%1s".
					"%1s".
					"%1s".
					"%07d".
					"%40s".
					"%06d".
					"%20s".
					"%1d".
					"%1d".
					"%48s".
					"%687s";

			$this->Domicilio = sprintf(  $this->DomicilioStr,
				$this->contador,														# 01. sequencial
				2, 																			# fixo! 02
				'', 																			# fixo 03
				substr( $rowDom['fam_dom_id'], 0, 16 ),				# 04. Código do Domicílio do usuário
				substr( $rowDom['fam_nr_ficha'], 0, 4 ),				# 05. Número da Ficha
				substr( $rowDom['fam_dt_cadastro'], 0, 10 ),		# 06. Data de preenchimento do formulario
				substr( $rowDom['fam_dt_inclusao'], 0, 20 ),		# 07. Data de inclusão do domicilio.
				'',																				# fixo :  Data de alteração do domicilio.
				substr( $rowDom['seg_codigo'], 0, 2 ),					# 09. Código de segmento.		3
				substr( $rowDom['area_codigo'], 0, 4 ),				# 10. Código de área. 
				substr( $rowDom['mic_codigo'], 0 , 2 ),				# 11. Código de micro área. 
				substr( $rowDom['fam_codigo'], 0, 3),					# 12. Código família.	1
				substr( $rowDom['log_tipo'],	0, 3 ),						# 13. Código que identifica o tipo de logradouro.	21
				substr( $rowDom['fam_endereco'], 0, 50 ),			# 14. Nome do logradouro.	5
				substr( $rowDom['fam_numero_res'],  0, 7 ),		# 15. Número do Logradouro	18
				substr( $rowDom['fam_complemento'], 0, 15 ),	# 16. Complemento do Logradouro 	6
				substr( $rowDom['fam_bairro'], 0, 30 ), 				# 17. Nome do Bairro		19
				substr( $rowDom['fam_cep'], 0, 8 ),						# 18. CEP do Logradouro		7
				'',																				# 19.Número do DDD
				substr( $rowDom['fam_telefone'], 0, 9 ),				# 20.Número do Telefone
				substr( $rowDom['fam_nr_pessoas'], 0 , 2 ),		# 21.Quantidade de pessoas vinculadas ao domicílio.		9
				substr( $rowDom['fam_comodos'], 0, 2 ),				# 22.Quantidade de cômodos do domicílio		11
				substr( $rowDom['fam_energia'], 0,  1),				# 23.Indica se o domicílio possui  Energia Elétrica	12
				substr( $rowDom['fam_esgoto'], 0, 1 ),				# 24.Indica se o domicílio possui esgoto sanitário	13
				substr( $rowDom['fam_tipo_domicilio'], 0, 1 ),		# 25.Indica o tipo de Domicílio		14
				substr( $rowDom['fam_destino_lixo'], 0, 1 ),			# 26.Indica o de destino do lixo do domicílio
				substr( $rowDom['fam_agua'], 0, 1),					# 27.Indica o tipo de abastecimento de água do domicílio
				substr( $rowDom['fam_tratamento_agua'], 0, 1 ),# 28.Indica o tipo de tratamento de água do domicílio	16
				2,																				# 29. Indica o programa de cobertura do domicílio.
				$this->ibge,															# 30. Código IBGE do município onde está localizado o domicílio.
				$this->cid_nome,													# 31. Nome do Município, segundo IBGE, onde está localizado o domicílio.
				substr( $rowDom['fam_cadastrador'], 0, 6 )	,		# 32.Número do Cadastrador.		17
				'',																				# 33.Campo reservado para o Datasus.
				substr( $rowDom['tipo_op_dom'], 0, 1 ),				# 34.Indica o tipo de operação referente ao domicílio : 1 – Inclusão 4 – Correção (Para corrigir problemas retornados pelo DATASUS) 8 – Cerreção de Alteração 9 –  Alteração
				1,																				# fixo! 35.Indicador de Arquivo
				substr( $rowDom['fam_codigo'], 0, 48 ),				# 36.Código que identifica o domicílio no município.
				'' 																				# fixo! 37. Campo reservado para o Datasus.		
		);
	
	} // function criaDomicilio()
	
	/** Cria o Usuario */
	function criaUsuario( $rowUsu )
	{
		$this->contador ++;
		$this->UsuarioStr = 
					"%07d".
					"%01d".
					"%58s".
					"%20s".
					"%04d".
					"%70s".
					"%70s".
					"%1d".
					"%02d".
					"%02d".
					"%10s".
					"%1s".
					"%70s".
					"%70s".
					"%70s".
					"%70s".
					"%015d".
					"%011d".
					"%011d".
					"%02d".
					"%20s".
					"%8s".
					"%4s".
					"%8s".
					"%10s".
					"%1s".
					"%02d".
					"%011d".
					"%4s".
					"%2s".
					"%10s".
					"%07d".
					"%05d".
					"%2s".
					"%10s".
					"%013d".
					"%04d".
					"%04d".
					"%03d".
					"%10s".
					"%16d".
					"%10s".
					"%10s".
					"%20s".
					"%20s".
					"%5s".
					"%48s".
					"%7s".
					"%16s".
					"%7s".
					"%40s".
					"%3s".
					"%6s".
					"%15s".					
					"%07d".
					"%1s".
					"%1s".
					"%1s".
					"%1s".
					"%1s".
					"%1s".
					"%20s".
					"%1d".
					"%02d".
					"%1d".
					"%1d".
					"%8s".
					"%5s".
					"%58s".
					"%48s";

			$this->Usuario = sprintf(  $this->UsuarioStr,
					$this->contador,														# 01. Número seqüencial do registro dentro do arquivo
					3, 																			# fixo! 02. Indicador de registro tipo USUARIO   
					'',																				# fixo! 03.Código do Usuário
					'',																				# fixo! 04.Numero de Uso Municipal
					$rowUsu['usu_nr_ficha'],											# 05.Numero da Ficha										familia coluna 2
					substr( $rowUsu['usu_nome'], 0, 70 ),					# 06.Nome do Usuário										2
					'', 																			# fixo! 07.Nome fonético do usuário
					$rowUsu['rac_codigo'], 											# 08.Código de raça/cor 									37
					$rowUsu['usu_st_conjugal'],									# 09.Código de situação conjugal 									->andre ficou de criar este campo
					$rowUsu['usu_escolaridade'],									# 10.Código de escolaridade 							68
					$rowUsu['usu_datanasc'], 										# 11.Data de nascimento 								6
					$rowUsu['usu_sexo'],												# 12. Sexo 														5	
					substr( $rowUsu['usu_pai'], 0, 70 ),						# 13.Nome do Pai 											36
					'',																				# 14.Nome Fonético do Pai 												
					substr( $rowUsu['usu_mae'] , 0, 70 ),					# 15.Nome da Mãe 											35
					'',																				# 16. Nome fonético da mãe 											
					substr( $rowUsu['usu_cartao_sus'], 0, 15 ),			# 17. Número do CNS – Cartão Nacional de Saúde		16
					substr( $rowUsu['usu_pis_pasep'], 0, 11 ),			# 18. PIS/PASEP 												13
					substr( $rowUsu['usu_cpf'], 0, 11 ), 						# 19. CPF 														14
					substr( $rowUsu['usu_tipo_certidao'] , 0, 2 ),		# 20. Código do Tipo de Certidão 					17
					substr( $rowUsu['usu_cert_cartorio'] , 0, 20 ),		# 21. Nome do Cartório – Certidão					18
					substr( $rowUsu['usu_cert_livro'] , 0, 8 ),				# 22. Número do Livro – Certidão					19
					substr( $rowUsu['usu_cert_lv_fls'] , 0, 4 ),				# 23. Número da  Folha – Certidão					20
					substr( $rowUsu['usu_cert_termo'] , 0, 8 ),			# 24. Número do Termo – Certidão				21
					$rowUsu['usu_cert_emissao'], 								# 25. Data da Emissão – Certidão					22
					$rowUsu['usu_freq_escolar'] ,									# 26. Indica se o usuário freqüenta escola ou não	51
					$rowUsu['usu_rg_emissor'] ,									# 27. Identidade –  Código do Órgão Emissor	26
					substr( $rowUsu['usu_rg'], 0, 11 ),						# 28. Identidade – Número								23
					substr( $rowUsu['usu_rg_compl'], 0, 4 ),				# 29. Identidade - Complemento 					24
					$rowUsu['uf_sigla_rg'] ,										# 30. Identidade – Sigla da UF Emissora			25
					$rowUsu['usu_rg_dt_emissao'] ,								# 31. Identidade – Data de Emissão				27
					substr( $rowUsu['usu_ctps'], 0, 7 ),						# 32. CTPS – Número										28
					substr( $rowUsu['usu_ctps_serie'], 0, 5 ),				# 33. CTPS - Número de Série							29
					$rowUsu['uf_sigla_ctps'] ,									# 34. CTPS - Sigla da UF Emissora					30
					$rowUsu['usu_ctps_dt_emissao'] ,							# 35. CTPS – Data de Emissão						31
					substr( $rowUsu['usu_tit_eleitor'], 0, 13 ),			# 36.  Título de Eleitor – Número e DV				32
					substr( $rowUsu['usu_tit_eleitor_zona'] , 0, 4 ),	# 37. Título de Eleitor – Zona							33
					substr( $rowUsu['usu_tit_eleitor_secao'], 0, 4 ),	# 38. Título de Eleitor – Seção							34
					substr( $rowUsu['cd_nacionalidade'], 0, 3 ),			# 39. Código da Nacionalidade						57
					$rowUsu['usu_dt_entrada_pais'],							# 40. Data de Entrada no País						8				
					substr( $rowUsu['nr_portaria_naturalizacao'], 0, 16 ),	# 41. Naturalização – Número da Portaria			65
					$rowUsu['dt_naturalizacao'],									# 42. Naturalização – Data									58	
					$rowUsu['dt_preenchimento_form'],						# 43. Data de Preenchimento do formulário		59	
					$rowUsu['dt_inclusao'],											# 44. Data de Inclusão do usuário						60				
					$rowUsu['dt_alteracao'],											#	45. Data de Alteração do usuário					61				
					substr( $rowUsu['usu_nr_lote'], 0, 5 ),					# 46. Lote – Número do lote do usuário
					substr( $rowUsu['id_domicilio'], 0, 48 ),				# 47. Identificador do Domicílio do usuário			63				
					substr( $rowUsu['usu_end_cidade'], 0, 7 ),			# 48. Município de residência do usuário			44
					substr( $rowUsu['id_domicilio'], 0, 16 ),				# 49.Código do Domicílio do usuário		63
					$rowUsu['muni_cd_cod_ibge_nasc'],						# 50. Município – Nascimento (Código do IBGE)	56
					substr( $rowUsu['usu_cidade_nasc'], 0, 40 ),		# 51. Nome do Município – Nascimento							
					$rowUsu['usu_cbo_r'],												# 52. Código do CBOR							12
					substr( $rowUsu['usu_cadastrador'], 0, 6 ),			# 53. Identificação do cadastrador da ficha de usuário.
					'',																				# 54. Identificador de máquina
					$this->ibge,															# 55. Código do Município
					$rowUsu['usu_bolsa_alimentacao'],						# 56. Indica se o usuário participa do programa social Bolsa Alimentação
					$rowUsu['usu_prodea'],											# 57. Indica se o usuário participa do programa social PRODEA
					'',																				# fixo! 58. Campo reservado  
					'',																				# fixo! 59. Campo reservado  
					'',																				# fixo! 60. Campo reservado  
					'',																				# fixo! 61. Campo reservado  
					'',																				# fixo! 62. Campo reservado  
					$rowUsu['tipo'],														# 63. Indicador de operação: 1 – Inclusão 4 – Correção (Para corrigir problemas retornados pelo DATASUS) 5 – Confirmação de Homônimo 7 – Confirmação de Homônimo com novo documento 8 – Correção de Alteração 9 – Alteração
					$this->contadorUsu,												# 64. Numero seqüencial da pessoa no domicilio
					1,																				# 65. Indica se o usuário está vinculado  ao Domicílio
					1,																				# 66. Indica se o usuário está vinculado ao SIAB
					substr( $rowUsu['usu_nome_operador'], 0, 8 ),	# 67. Nome do Operador
					$this->VERSAO,														# 68. Versão
					$rowUsu['usu_codigo'],											# 69. Código de Usuário Municipal
					$rowUsu['fam_codigo']											# 70. Código de Domicilio Municipal
		);		

		return $this;
	
	} // function criaUsuario()
	
	/** Cria o Trailler */
	function criaTrailler()
	{
		$this->contador ++;
		$this->TraillerStr = 
					"%07d".
					"%01d".
					"%07d".
					"%40s".
					"%08d".
					"%1020s"
		;

		$this->Trailler = sprintf(  $this->TraillerStr,
					$this->contador,									# Número Seqüencial do registro
					9,															# fixo! Indicador de registro tipo trailler de arquivo de município (Valor:  )
					substr( $this->ibge, 0, 7 ),				# Código do Município (IBGE)
					substr( $this->cid_nome, 0, 40 ),		# Nome do Municipio
					$this->contador,									# Quantidade de registros do município,incluindo header e trailler
					''															# fixo! Filler 

		);			

		return $this;
	
	} // function criaTrailler()
	
}

// castro: 4104907
// SANTA DE DE GOIAS 5219258

/*$LC = new LayoutCritica( $ibge = 5219258, $debug = ! true ) ;
$LC->tipo_filtro = 0;
$LC->data_ini = '20/03/2007';
$LC->criaArquivo();
print $LC->mensagem;*/

?>