<?php


class Menu
{

    private $id_login;

    private $atalhos;
    private $cadastros;
    private $atendimentos;
    private $agendamentos;
    private $internacao;
    private $materiais;
    private $farmacia;
    private $p_federais;
    private $transporte;

    /**
     * Menu constructor.
     * @param $id_login
     */
    public function __construct($id_login, $permissoes)
    {
        $this->id_login = $id_login;

        $this->atalhos = [
            "Pacientes" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=paciente.php",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Domicílio" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=domicilio.php",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Laboratório" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=exame/exa_listapedidoexame.php&id_login=$this->id_login",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Consultas" => [
                "url" => "zf/agendamento/index/menu",
                "zf" => true,
                "ativo" => true,
                "separador" => false
            ],
            "Dispensação" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/farmacia/farmacia",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Leitos" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/leito/internacao/index",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Vacinas" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/default/vacina/",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Prontuário" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/prontuario/",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "ativo" => true
        ];
        $this->cadastros = [
            "Pacientes" => [
                "Adicionar" => [
                    "url" => "zf/default/paciente/form-paciente",
                    "zf" => true,
                    "ativo" => (SelPerm($id_login, 'paciente.php') != "0"),
                    "separador" => false
                ],
                "Listar" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=paciente.php&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'paciente.php') != "0"),
                    "separador" => false
                ],
                "ativo" => (SelPerm($id_login, 'paciente.php') != "0")
            ],
            "Profissionais" => [
                "Especialidades" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=especialidade.php&acao=form_espec&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'especialidade.php') != "0"),
                    "separador" => false
                ],
                "Profissionais Externos" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/medicos/cadastro-medicos/lista",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'medico.php') != "0"),
                    "separador" => false
                ],
                "ativo" => ((SelPerm($id_login, 'medico.php') != "0") || (SelPerm($id_login, 'especialidade.php') != "0"))
            ],
            "Fila de Espera" => [
                "Cadastro" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/filaespera/fila/index",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Solicitações" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/filaespera/filas-usuario/index",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "ativo" => true
            ],
            "Unidade de Saúde" => [
                "Adicionar" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=unidade.php&acao=form_add&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'unidade.php') != "0"),
                    "separador" => false
                ],
                "Listar" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=unidade.php&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'unidade.php') != "0"),
                    "separador" => false
                ],
                "ativo" => $permissoes['MODULO_UNIDADES'] && (SelPerm($id_login, 'unidade.php') != "0")
            ],
            "Feriados" => [
                "Adicionar" => [
                    "url" => "feriado.php?acao=form_add&id_login=$id_login",
                    "zf" => true,
                    "ativo" => (SelPerm($id_login, 'feriado.php') != "0"),
                    "separador" => false
                ],
                "Listar" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=feriado.php&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'feriado.php') != "0"),
                    "separador" => false
                ],
                "ativo" => (SelPerm($id_login, 'feriado.php') != "0")
            ],
            "Familia" => [
                "Domicilio" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=domicilio.php&id_login=$id_login",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Logradouro" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/default/rua",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Bairro" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/domicilio/bairro",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "ativo" => true
            ],
            "Exames" => [
                "Listar" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=exame/exa_listapedidoexame.php&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'exame/exa_listapedidoexame.php') != "0"),
                    "separador" => false
                ],
                "Configurações Laudos" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=laudos/tipoExames.php&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'laudos/tipoExames.php') != "0"),
                    "separador" => (SelPerm($id_login, 'laudos/tipoExames.php') != "0")
                ],
                "Cadastro de Orientações" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=cadastroOrientacoes.php&acao=&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'cadastroOrientacoes.php') != "0"),
                    "separador" => !(SelPerm($id_login, 'vinculaExamesOrientacao.php') != "0")
                ],
                "Vincular Orientações" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=vinculaExamesOrientacao.php&acao=&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'vinculaExamesOrientacao.php') != "0"),
                    "separador" => (SelPerm($id_login, 'vinculaExamesOrientacao.php') != "0")
                ],
                "Cadastro de Observações" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=laudos/cadastroObservacoes.php&acao=&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'laudos/cadastroObservacoes.php') != "0"),
                    "separador" => false
                ],
                "Vincular Observações" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=vinculaProcedimentosObservacoes.php&acao=&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'vinculaProcedimentosObservacoes.php') != "0"),
                    "separador" => true
                ],
                "Grupo de Exames" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/laboratorio/grupo-de-exames",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Tipos de Método" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=exa_tipodemetodo.php",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'exa_tipodemetodo.php') != "0"),
                    "separador" => false
                ],
                "Tipos de Material" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=exa_tipodematerial.php",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'exa_tipodematerial.php') != "0"),
                    "separador" => false
                ],
                "Categoria de Exames" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=exa_categoriadeexames.php",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'exa_categoriadeexames.php') != "0"),
                    "separador" => false
                ],
                "SubExames" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=exa_subexames.php",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'exa_subexames.php') != "0"),
                    "separador" => false
                ],
                "ativo" => true
            ],
            "Vacinas" => [
                "Adicionar" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=cadastroVacina.php?id_login=$id_login",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Geladeira" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=geladeiraVacina.php?id_login=$id_login",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Temperaturas" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=temperaturaGeladeira.php&&id_login=$id_login",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Campanhas" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/default/vacina/campanha",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "ativo" => true
            ],
            "Procedimentos" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/procedimento-classificacao/procedimento/index",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Secretaria" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=secretaria.php&id_login=$id_login",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Guichê de Atendimento" => [
                "url" => "/WebSocialSaude/zf/default/guiche",
                "target" => "_blank",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Grupos de Doença" => [
                "Cadastro" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=grupo_doencas.php&id_login=$id_login",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Vínculo" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=vincular_grupos_doencas.php&id_login=$id_login",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "ativo" => true
            ],
            "Prestador de Serviços" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=prestador.php&id_login=$id_login",
                "zf" => false,
                "ativo" => $permissoes['MODULO_PRESTADOR'] && (SelPerm($id_login, 'prestador.php') != "0"),
                "separador" => false
            ],
            "Raio X" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/default/raiox",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Duplicação" => [
                "Paciente" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/duplicacao/paciente",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Logradouro" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/duplicacao/rua",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Bairros" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/duplicacao/bairro",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Produto" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/duplicacao/produto",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "ativo" => true,
            ],
            "Fabricante" => [
                "url" => "zf/default/fabricante",
                "zf" => true,
                "ativo" => true,
                "separador" => false
            ],
            "Convenios/Contratos" => [
                "url" => "zf/agenda/convenio",
                "zf" => true,
                "ativo" => true,
                "separador" => false
            ],
            "Fornecedores" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=../WebSocialComum/fornecedor.php&acao=form_forn",
                "zf" => false,
                "ativo" => (SelPerm($id_login, 'materiais.php') != "0"),
                "separador" => false
            ],
            "ativo" => true
        ];
        $this->atendimentos = [
            "Porta de Entrada" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=portadeEntrada/portadeentrada2.php&id_login=$id_login",
                "zf" => false,
                "ativo" => true,
                "separador" => true
            ],
            "Atendimentos" => [
                "Individual" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/atendimento/atendimento-simplificado/index/tipo/ai",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Odontológico" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/ficha-odontologica",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "ativo" => true
            ],
            "Visita Domiciliar" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/atendimento/atendimento-simplificado/index/tipo/vd",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Procedimentos" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/atendimento/atendimento-simplificado/index/tipo/p",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Atividade Coletiva" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/atividade-coletiva",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Cadastros" => [
                "Individual" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/default/paciente/form-paciente",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Domiciliar" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=domicilio.php",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "ativo" => true
            ],
            "Consumo Alimentar" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/consumo-alimentar",
                "zf" => false,
                "ativo" => true,
                "separador" => true
            ],
            "Sind. Neuro. Zika/Microcefalia" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/ficha-complementar",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Vacinação" => [
                "url" => "zf/programas-federais/ficha-vacinacao",
                "zf" => true,
                "ativo" => true,
                "separador" => false
            ],
            "ativo" => true
        ];
        $this->agendamentos = [
            "Interno" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/agendamento",
                "zf" => false,
                "ativo" => (SelPerm($id_login, 'fazer_agendamento.php') != "0"),
                "separador" => false
            ],
            "Externo" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/agendamento-externo",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Conveniado" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/agenda/agenda/novo",
                "zf" => false,
                "ativo" => true,
                "separador" => true
            ],
            "Vinc. Estabelecimento/Profissionais" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/agenda/convenio/agendamento-estabelecimentos-de-saude",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Distribuição de Vagas" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/agenda/distribuicao",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "Recepção de Pacientes" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/agenda/recepcao",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "ativo" => true
        ];
        $this->internacao = [
            "Cadastros" => [
                "Categoria" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/leito/categoria",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Quartos" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=hospitalar/cadquarto.php",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Leitos" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=hospitalar/cadleito.php",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "ativo" => true
            ],
            "Dispensação" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/leito/medicamentos",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "ativo" => true
        ];
        $this->materiais = [
            "Cadastros" => [
                "Setor/Centro Estocador" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=setor.php&acao=form_setor&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'setor.php') != "0"),
                    "separador" => false
                ],
                "Fornecedor" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=../WebSocialComum/fornecedor.php&acao=form_forn&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, '../WebSocialComum/fornecedor.php') != "0"),
                    "separador" => false
                ],
                "Produtos" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/produto/index",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'materiais.php') != "0"),
                    "separador" => false
                ],
                "Estoque Mínimo" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=estoqueminimo.php&acao=form_materiais&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'materiais.php') != "0"),
                    "separador" => false
                ],
                "Tipos de Produto" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/materiais/tipo-produto/index",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'materiais.php') != "0"),
                    "separador" => false
                ],
                "Grupos de Produto" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=grupo.php&acao=form_grupo",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'materiais.php') != "0"),
                    "separador" => false
                ],
                "ativo" => true
            ],
            "Movimentação" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/materiais/movimentacao",
                "zf" => false,
                "ativo" => (SelPerm($id_login, 'zf/materiais/movimentacao') != "0"),
                "separador" => false
            ],
            "Inventário" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/materiais/inventario",
                "zf" => false,
                "ativo" => (SelPerm($id_login, 'zf/materiais/inventario') != "0"),
                "separador" => false
            ],
            "ativo" => (
                (SelPerm($id_login, 'grupo.php') != "0") ||
                (SelPerm($id_login, 'setor.php') != "0") ||
                (SelPerm($id_login, '../WebSocialComum/fornecedor.php') != "0") ||
                (SelPerm($id_login, 'zf/materiais/movimentacao') != "0") ||
                (SelPerm($id_login, 'materiais.php') != "0")
            )
        ];
        $this->farmacia = [
            "Admin. Dispensação" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/farmacia/farmacia/administracao",
                "zf" => false,
                "ativo" => (SelPerm($id_login, 'dispensacao.php') != "0"),
                "separador" => false
            ],
            "Dispensação" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/farmacia/farmacia",
                "zf" => false,
                "ativo" => (SelPerm($id_login, 'dispensacao.php') != "0"),
                "separador" => true
            ],
            "Psicotrópicos" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=psico.php&acao=&id_login=$id_login",
                "zf" => false,
                "ativo" => (SelPerm($id_login, 'psico.php') != "0"),
                "separador" => false
            ],
            "Cotas por Paciente" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=cota_paciente.php&acao=&id_login=$id_login",
                "zf" => false,
                "ativo" => (SelPerm($id_login, 'cota_paciente.php') != "0"),
                "separador" => false
            ],
            "Programas" => [
                "Atendimento" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=programa_atendimento.php&acao=&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'programa_atendimento.php') != "0"),
                    "separador" => false
                ],
                "Produto" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=programa_produto.php&acao=&id_login=$id_login",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'programa_produto.php') != "0"),
                    "separador" => false
                ],
                "ativo" => (
                    (SelPerm($id_login, 'programa_atendimento.php') != "0") ||
                    (SelPerm($id_login, 'programa_produto.php') != "0")
                ),
                "separador" => false
            ],
            "ativo" => (
                (SelPerm($id_login, 'dispensacao.php') != "0") ||
                (SelPerm($id_login, 'psico.php') != "0") ||
                (SelPerm($id_login, 'cota_paciente.php') != "0")
            )
        ];
        $this->p_federais = [
            "BPA" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/bpa/index",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "CNES" => [
                "Importação" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/cnes",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "ativo" => $permissoes['IMPORTACAO_CNES']
            ],
            "ESUS" => [
                "Exportação" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/esus/exportacao",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'zf/programas-federais/esus') != "0"),
                    "separador" => false
                ],
                "Histórico" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/esus/historico-exportacao",
                    "zf" => false,
                    "ativo" => (SelPerm($id_login, 'zf/programas-federais/esus') != "0"),
                    "separador" => false
                ],
                "Inconsistências" => [
                    "Atend. Individual" => [
                        "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/atendimento-individual/inconsistencias",
                        "zf" => false,
                        "ativo" => true,
                        "separador" => false
                    ],
                    "Atividade Coletiva" => [
                        "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/atividade-coletiva/inconsistencias",
                        "zf" => false,
                        "ativo" => true,
                        "separador" => false
                    ],
                    "Cadastro Individual" => [
                        "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/cadastro-individual/inconsistencias",
                        "zf" => false,
                        "ativo" => true,
                        "separador" => false
                    ],
                    "Procedimentos" => [
                        "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/ficha-procedimento/inconsistencias",
                        "zf" => false,
                        "ativo" => true,
                        "separador" => false
                    ],
                    "Visita Domiciliar" => [
                        "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/visita-domiciliar/inconsistencias",
                        "zf" => false,
                        "ativo" => true,
                        "separador" => false
                    ],
                    "Odontologia" => [
                        "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/ficha-odontologica/inconsistencias",
                        "zf" => false,
                        "ativo" => true,
                        "separador" => false
                    ],
                    "Cadastro Domiciliar" => [
                        "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/cadastro-domiciliar/inconsistencias",
                        "zf" => false,
                        "ativo" => true,
                        "separador" => false
                    ],
                    "Vacinação" => [
                        "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/ficha-vacinacao/inconsistencias",
                        "zf" => false,
                        "ativo" => true,
                        "separador" => false
                    ],
                    "Sind. Neuro. Zika/Microcefalia" => [
                        "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/ficha-complementar/inconsistencias",
                        "zf" => false,
                        "ativo" => true,
                        "separador" => false
                    ],
                    "Consumo Alimentar" => [
                        "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/consumo-alimentar/inconsistencias",
                        "zf" => false,
                        "ativo" => true,
                        "separador" => false
                    ],
                    "ativo" => true
                ],
                "ativo" => true
            ],
            "HÓRUS" => [
                "CATMAT" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/default/produto/atualiza-catmat",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Listagem de Protocolos" => [
                  "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/horus/lista-protocolos",
                  "zf" => false,
                  "ativo" => true,
                  "separador" => false
                ],
                "Log de Erros" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/horus/log-erros",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Manual de Instalação" => [
                    "url" => $_SERVER['PHP_SELF'] . "/../horus/arquivos/manual.pdf",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Posição de Estoque" => [
                  "url" => $_SERVER['PHP_SELF'] . "?link=zf/programas-federais/horus/posicao-estoque-em-lote",
                  "zf" => false,
                  "ativo" => true,
                  "separador" => false
              ],
                "ativo" => true
            ],
            "ativo" => true
        ];
        $this->transporte = [
            "Cadastros" => [
                "Veículos" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/transporte/veiculo",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Viagem" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/transporte/viagem",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "Locais" => [
                    "url" => $_SERVER['PHP_SELF'] . "?link=zf/transporte/locais",
                    "zf" => false,
                    "ativo" => true,
                    "separador" => false
                ],
                "ativo" => true
            ],
            "Agenda de Pacientes" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=zf/transporte/viagem-usuario",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
            "ativo" => true
        ];
    }

    /**
     * @return mixed
     */
    public function getMENUPRINCIPAL()
    {
        $this->sortArray($this->atalhos);
        $this->sortArray($this->cadastros);
        $this->sortArray($this->atendimentos);
        $this->sortArray($this->materiais);
        $this->sortArray($this->p_federais);
        return [
            "<i class='fas fa-running fa-lg' title='Atalhos Rápidos'></i>" => $this->atalhos,
            "Cadastros" => $this->cadastros,
            "Atendimentos" => $this->atendimentos,
            "Agendamentos" => $this->agendamentos,
            "Internação" => $this->internacao,
            "Materiais" => $this->materiais,
            "Farmácia" => $this->farmacia,
            "Prog. Federais" => $this->p_federais,
            "Transporte" => $this->transporte,
            "Relatórios" => [
                "url" => $_SERVER['PHP_SELF'] . "?link=rel_index.php&id_login=$this->id_login",
                "zf" => false,
                "ativo" => true,
                "separador" => false
            ],
        ];
    }

    //Funções de ordenação
    private function isAssoc(array $arr)
    {
        return array_keys($arr) !== range(0, count($arr) - 1);
    }

    private function sortArray(&$arr)
    {
        if ($this->isAssoc($arr)) {
            ksort($arr);
        } else {
            asort($arr);
        }
        foreach ($arr as &$a) {
            if (is_array($a)) {
                $this->sortArray($a);
            }
        }
    }
}

$query = pg_query("SELECT * FROM config");
while ($row = pg_fetch_array($query)) {
    switch ($row['conf_chave']) {
        case "MODULO_UNIDADES" :
            $permissoes['MODULO_UNIDADES'] = ($row['conf_valor_bool'] == "t" ? true : false);
            break;
        case "MODULO_PRESTADOR" :
            $permissoes['MODULO_PRESTADOR'] = ($row['conf_valor_bool'] == "t" ? true : false);
            break;
        case "INTEGRACAO_ALMOXARIFADO" :
            $permissoes['INTEGRACAO_ALMOXARIFADO'] = ($row['conf_valor_bool'] == "t" ? true : false);
            break;
    }
    $permissoes['IMPORTACAO_CNES'] = true;
}

$menu = (new Menu($id_login, $permissoes))->getMENUPRINCIPAL();

$menuUsuario = [
    "Usuários" => [
        "url" => $_SERVER['PHP_SELF'] . "?link=zf/usuarios/usuarios",
        "zf" => false,
        "ativo" => (SelPerm($id_login, 'usuarios.php') != "0"),
        "separador" => false,
    ],
    "Permissões" => [
        "Usuários" => [
            "url" => $_SERVER['PHP_SELF'] . "?link=permissoes_usuarios.php&acao=form_perm&id_login=$id_login",
            "zf" => false,
            "ativo" => (SelPerm($id_login, 'permissoes_usuarios.php') != "0"),
            "separador" => false,
        ],
        "Acesso" => [
            "url" => $_SERVER['PHP_SELF'] . "?link=permissoes.php&acao=form_perm&id_login=$id_login",
            "zf" => false,
            "ativo" => (SelPerm($id_login, 'permissoes.php') != "0"),
            "separador" => false,
        ],
        "ativo" => ((SelPerm($id_login, 'permissoes.php') != "0") || (SelPerm($id_login, 'permissoes_usuarios.php') != "0")),
    ],
    "Log" => [
        "url" => $_SERVER['PHP_SELF'] . "?link=log.php&id_login=$id_login",
        "zf" => false,
        "ativo" => (SelPerm($id_login, 'link=log.php') != "0"),
        "separador" => true,
    ],
    "Alterar Senha" => [
        "url" => $_SERVER['PHP_SELF'] . "?link=alterarsenha.php&id_login=$id_login",
        "zf" => false,
        "ativo" => true,
        "separador" => false,
    ]
];
