<?php

@header('Content-Type: text/html; charset=UTF-8');
require_once '../global.php';
require_once COMUM . "/library/php/funcoes.db.php";
$common = new commonClass(FALSE);

$hoje = date("d/m/Y");
$tempoSql = "SELECT conf_valor_int FROM config WHERE conf_chave = 'TEMPO_ESPERA'";
$tempoQuery = pg_query($tempoSql);
$tempo = pg_fetch_row($tempoQuery);

$uni_codigo = getUnidadeByLogon();
$uni_tipo = getTipoUnidadeByLogon();

if($uni_tipo == 'H') {
    $sql = "SELECT a.age_codigo, 
	pc_clas_risco, 
	u.usr_codigo, 
	u.usr_nome, 
	usu.usu_nome, 
	to_char(age_data,'DD/MM/YYYY')as age_data,
	a.age_horario as age_hora, 
	a.age_tipo, 
	a.age_item, 
	e.esp_nome, 
	a.age_atendido,
	a.age_status,
        a.proc_codigo,
	to_char(usu_datanasc,'DD/MM/YYYY')as datanasc,
	age_ordem,
	0 as io_situacao_internacao
  FROM agendamento AS a 
  LEFT JOIN pre_consulta pre 
    ON pre.age_codigo = a.age_codigo 
  JOIN usuarios AS u 
    ON u.usr_codigo=a.med_codigo 
  JOIN especialidade AS e 
    ON e.esp_codigo=a.esp_codigo 
  JOIN usuario AS usu 
    ON usu.usu_codigo=a.usu_codigo 
 WHERE age(now(), to_timestamp(age_data || ' ' || age_horario, 'YYYY-MM-DD HH24:MI')) < $tempo[0] * interval '1 hour'
   AND a.uni_codigo=$uni_codigo 
   AND a.age_atendido NOT IN ('A', 'N', 'T')
   ORDER BY med_codigo,age_ordem,age_codigo";
} else {
    $sql = "SELECT a.age_codigo, 
	pc_clas_risco, 
	u.usr_codigo, 
	u.usr_nome, 
	usu.usu_nome, 
	to_char(age_data,'DD/MM/YYYY')as age_data,
	a.age_horario as age_hora, 
	a.age_tipo, 
	a.age_item, 
	e.esp_nome, 
	a.age_atendido,
	a.age_status,
        a.proc_codigo,
	to_char(usu_datanasc,'DD/MM/YYYY')as datanasc,
	age_ordem,
	0 as io_situacao_internacao
  FROM agendamento AS a 
  LEFT JOIN pre_consulta pre 
    ON pre.age_codigo = a.age_codigo 
  JOIN usuarios AS u 
    ON u.usr_codigo=a.med_codigo 
  JOIN especialidade AS e 
    ON e.esp_codigo=a.esp_codigo 
  JOIN usuario AS usu 
    ON usu.usu_codigo=a.usu_codigo 
  WHERE age_data = '$hoje'
   AND a.uni_codigo=$uni_codigo 
   AND a.age_atendido NOT IN ('A', 'N', 'T')
   ORDER BY med_codigo,age_ordem,age_codigo";

}
$query = pg_query($sql);

function openTable()
{
    echo <<< TBL
	<table class="grid ui-widget ui-widget-content ui-corner-all">
		<thead>
			<tr class="ui-widget-header">
				<th width="250">Especialidade</th>
				<th width="40">Data</th>
				<th width="40">Hora</th>
				<th width="250">Paciente</th>
				<th width="60">Data Nasc.</th>
				<th colspan="2" width="150">Status</th>
				<th width="50">Op&ccedil;&otilde;es</th>
			</tr>
		<thead>
		<tbody>		
TBL;
}

$tipoAt = array(
    "CB" => "Cl&iacute;nica B&aacute;sica",
    "ES" => "Especialidade"
);
$tipoAg = array(
    "PC" => "Agendamento",
    "AL" => "Agendam. Livre"
);

$opcoes = '<img src="' . LINKSAUDE . '/imgsBotoes/editar_on.png" class="editar" alt="Editar" title="Editar" rel="%1$d" status="%2$s" style="cursor:pointer;"/>
					<img src="' . LINKSAUDE . '/imgsBotoes/excluir.png" class="falta" alt="Cancelar" title="Cancelar" rel="%1$d" status="%2$s" style="cursor:pointer;"/>';

// este input controla a ordem da fila
$opcoes .= '<input type="hidden" name="ordem[]" value="%1$d" />';
?>
<style>
    table tbody tr td {
        cursor: n-resize;
    }
</style>
<script type="text/javascript">
    $(function () {

        $("#fila .abas").tabs();
        $("#novo a").focus();

        // adiciona opção "drag 'n drop" na tabela para ordenar o recepcionamento.
        $("table tbody").sortable({
            revert: true,
            axis: "y",
            stop: function (e, u) {
                var arr = $("input[name^=ordem]");
                var ordem = [];
                arr.each(function () {
                    ordem.push(this.value);
                });

                window.console && console.log('enviando...');
                $.ajax({
                    url: 'ordem.php',
                    type: 'post',
                    data: {
                        ordem: ordem
                    },
                    success: function () {
                        window.console && console.log('reordenado!');
                    }
                });

            }
        });
        $("td, th").disableSelection();

        $(".falta").click(function () {
            var age_codigo = $(this).attr("rel");
            var status = $(this).attr("status").trim().toString();

            console.log(status);
            if(status == "S"){
                document.getElementById('falta-m').removeAttribute('disabled');
                document.getElementById('falta-p').removeAttribute('disabled');
                document.getElementById('falta-c').removeAttribute('disabled');
                $("#msg").dialog({
                    modal: true,
                    width: 300,
                    height: 200,
                    buttons: {
                        "Não Cancelar": function () {
                            $("#msg").dialog("destroy");
                            document.getElementById('falta-c').setAttribute('disabled','true');

                        },
                        "Cancelar Agendamento": function () {
                            $.ajax({
                                url: "registrar.php",
                                type: "POST",
                                data: {
                                    age_codigo: age_codigo,
                                    motivo: $("#msg input:checked").val()
                                },
                                success: function () {
                                    $("#tabs").tabs("load", 1);
                                    $("#msg").dialog("destroy");
                                }
                            });

                            return false;
                        }
                    }
                });
            } else if(status != "E" && status != "I"){
                document.getElementById('falta-p').removeAttribute('disabled');
                document.getElementById('falta-m').removeAttribute('disabled');

            $("#msg").dialog({
                modal: true,
                width: 300,
                height: 200,
                buttons: {
                    "Não Cancelar": function () {
                        $("#msg").dialog("destroy");
                            document.getElementById('falta-c').setAttribute('disabled','true');

                    },
                    "Cancelar Agendamento": function () {
                        $.ajax({
                            url: "registrar.php",
                            type: "POST",
                            data: {
                                age_codigo: age_codigo,
                                motivo: $("#msg input:checked").val()
                            },
                            success: function () {
                                $("#tabs").tabs("load", 1);
                                $("#msg").dialog("destroy");
                            }
                        });

                        return false;
                    }
                }
            });
            }
            else {
                alert("Atenção. Paciente em atendimento!");
            }


        });

        $(".editar").click(function () {
            var age_codigo = $(this).attr("rel");
            location.href = "portadeentrada2.php?age_codigo=" + age_codigo;
        });

    });

    function mostarAjuda() {
        $("#ajuda-dialog").dialog({
            modal: true,
            width: 300,
            height: 120,
            buttons: {
                "OK": function () {
                    $("#ajuda-dialog").dialog("destroy");
                }
            }
        });

    }
</script>
<div id="fila">
    <div id="msg" title="Cancelar Agendamento" style="display: none">
        <input type="radio" name="falta" disabled="true" value="M" id="falta-m" checked/> <label for="falta-m">Falta Medica</label><br/>
        <input type="radio" name="falta" disabled="true" value="P" id="falta-p"/> <label for="falta-p">Paciente Ausentou-se</label><br/>
        <input type="radio" name="falta" disabled="true" value="C" id="falta-c"/> <label for="falta-c">Cancelar agendamento</label><br/>

    </div>
    <div id="ajuda-dialog" title="Ajuda" style="display: none">
        <span>Para alterar a ordem dos pacientes na fila, clique no nome do paciente e arraste at&eacute; a posi&ccedil;&atilde;o desejada.</span>
    </div>
    <span id="novo" style="float:left">
        <a href="#" onclick="window.location=window.location;return false;">
            <?= $common->commonButton("Adicionar Novo Paciente", "javascript:void(0);", "adicionar.png", NULL); ?>
        </a>
    </span>
    <span style="float:left">
        <a href="#"
           onclick="mostarAjuda();"><?= $common->commonButton("Ajuda", "javascript:void(0);", "help.png", NULL); ?></a>
    </span>
    <div style="clear:both"></div>
    <?php
    $ultimoMedico = 0;
    while ($r = pg_fetch_array($query)) {
        if ($ultimoMedico != $r['usr_codigo']) {
            if ($ultimoMedico) {
                echo "</table></div></div>"; // tabela que lista os agendamentos
                echo $common->closeTab();
            }

            $ultimoMedico = $r['usr_codigo'];
            echo "<div class=\"order\">";
            echo $common->menuTab($r['usr_nome'], NULL, "tabs_" . $r['usr_codigo'], "abas");
            echo $common->bodyTab('1');
            openTable();
        }

        //Relação de status novos
        $status = "";
        switch (trim($r['age_status'])){
            case 'R':
                $status = "Recepcionado";
                break;
            case 'RP':
	            $status = "Recepcionado com Triagem";
                break;
	        case 'E':
		        $status = "Realizando Triagem";
		        break;
	        case 'EM':
		        $status = "Realizando Consulta";
		        break;
	        case 'P':
		        $status = "Triagem Realizada";
		        break;
	        case 'PF':
		        $status = "Triagem Finalizada";
		        break;
	        case 'A':
		        $status = "Consulta Realizada";
		        break;
	        case 'AF':
		        $status = "Consulta Finalizado";
		        break;
            default:
                $status = "";
                break;
        }


        if ($r['age_atendido'] == "S") {
            $sts = "<font>Aguardando Triagem</font>";
        }
        if ($r['age_atendido'] == "P") {
            $sts = "<font>Aguardando M&eacute;dico</font>";
        }
        if ($r['age_atendido'] == "F") {
            $sts = "<font>Paciente Ausentou-se</font>";
        }
        if ($r['age_atendido'] == "M") {
            $sts = "<font>Falta M&eacute;dica</font>";
        }
        if ($r['age_atendido'] == "C") {
            $sts = "<font>Cancelado / Erro de digitacao</font>";
        }
        if ($r['age_atendido'] == "E" or $r['age_atendido'] == "I") {
            $sts = "<font>Em atendimento</font>";
        }
        if ($r['io_situacao_internacao'] == 1) {
            $sts = "<font>Aguardando Internacao</font>";
        }
        if ($r['io_situacao_internacao'] == 2) {
            $sts = "<font>Internado/Observa&ccedil;&atilde;o</font>";
        }
        if ($r['io_situacao_internacao'] == 3) {
            $sts = "<font>Internado/Observa&ccedil;&atilde;o</font>";
        }
        if ($r['pc_clas_risco'] == 1) {
            $cor = "red";
        } else if ($r['pc_clas_risco'] == 2) {
            $cor = "orange";
        } else if ($r['pc_clas_risco'] == 3) {
            $cor = "GoldenRod";
        } else if ($r['pc_clas_risco'] == 4) {
            $cor = "green";
        } else if ($r['pc_clas_risco'] == 5){
            $cor = "blue";
        }else {
            $cor = "";
        }
        echo "	<tr>
				<td style='color:$cor' width=\"250\" class=\"ui-widget ui-widget-content\">" . $r['esp_nome'] . "</td>
				<td style='color:$cor' width=\"40\" class=\"ui-widget ui-widget-content c\">" . $r['age_data'] . "</td>
				<td style='color:$cor' width=\"40\" class=\"ui-widget ui-widget-content c\">" . $r['age_hora'] . "</td>
				<td style='color:$cor' width=\"250\" class=\"ui-widget ui-widget-content\">" . $r['usu_nome'] . "</td>
				<td style='color:$cor' width=\"60\" class=\"ui-widget ui-widget-content\">" . $r['datanasc'] . "</td>
				<td style='color:$cor' width=\"150\" class=\"ui-widget ui-widget-content c a\"><b>" . $status . "</b></td>
				<td style='color:$cor' width=\"150\" class=\"ui-widget ui-widget-content c a\"><b>" . $sts . "</b></td>
				<td width=\"50\" class=\"ui-widget ui-widget-content c a\">" . sprintf($opcoes, $r['age_codigo'], $r['age_atendido']) . "</td>
			</tr>\n";

    }
    if ($ultimoMedico) {
        echo "<tbody></table></div></div>"; // tabela que lista os agendamentos
        echo $common->closeTab();
    } else {
        echo "<br /><em>Nenhum paciente na fila de espera.</em>";
    }
    ?></div>
