<?php
include_once "../global.php";
include_once "../../WebSocialComum/library/php/funcoes.db.php";
?>
<html>
<head>
    <title>Porta de Entrada</title>
    <meta charset="UTF-8">
    <?php
    $id_login = $_SESSION["id_login"];

    $sqlAgenda = "SELECT *,
                    to_char(usu_datanasc,'DD/MM/YYYY')as data
                        FROM agendamento a
                        JOIN usuario u
                            ON u.usu_codigo = a.usu_codigo
                        JOIN especialidade e
                            ON e.esp_codigo = a.esp_codigo
                        JOIN especialidade_procedimento ep
                            ON e.esp_codigo = ep.esp_codigo
                        WHERE age_codigo = $age_codigo";
    $queryAgenda = pg_query($sqlAgenda);
    $regAgenda = pg_fetch_array($queryAgenda);

    $common = new commonClass();
    $form = new classForm();
    $table = new tableClass();
    echo "<link type=\"text/css\" href=\"" . LINKSAUDE . "/estiloPE.css\" rel=\"stylesheet\"/>";
    echo $common->incJquery();
    $sqlMedico = "SELECT DISTINCT(u.usr_codigo),u.usr_nome
                                        FROM usuarios AS u
                                        JOIN medico_especialidade AS me
                                        ON me.med_codigo=u.usr_codigo
                                    WHERE u.usr_tipo_medico IN ('M','E','D','A','P')
                                    AND u.usr_ativo = 'S'
                                    AND me.uni_codigo = " . $_SESSION['uni_codigo'] . "
                                    AND me.mes_ativo = 'A'
                                    ORDER BY u.usr_nome;";

    $optionEsp = array(
        "nome" => "especialidade",
        "valor" => $regAgenda['esp_codigo'],
        "option" => ($regAgenda['esp_codigo'] == null ? "Selecione um profissional" : "$regAgenda[esp_nome]"),
        "disabledFirst" => ($regAgenda['esp_codigo'] == null ? "S" : ""),
        "idDiv" => null,
        "sel" => $regAgenda['esp_codigo'],
        "fSize" => "style='width:580px;'"
    );
    $optionProc = array(
        "nome" => "procedimento",
        "valor" => $regAgenda['proc_codigo'],
        "option" => ($regAgenda['proc_codigo'] == null ? "Selecione uma especialidade" : "$regAgenda[proc_codigo]"),
        "disabledFirst" => ($regAgenda['proc_codigo'] == null ? "S" : ""),
        "idDiv" => null,
        "sel" => $regAgenda['proc_codigo'],
        "fSize" => "style='width:580px;'"
    );
    $optionMed = array(
        "nome" => "medico",
        "valor" => NULL,
        "sql" => $sqlMedico,
        "js" => NULL,
        "idDiv" => NULL,
        "sel" => $regAgenda['med_codigo'],
        "fSize" => "style='width:580px;'"
    );

    $selectProcedimento = $form->inputSelect($optionProc);
    $selectEspecialidade = $form->inputSelect($optionEsp);
    $selectMedico = $form->inputSelect($optionMed);

    ?>
    <link rel="stylesheet" href="/WebSocialSaude/lib/themes/base/jquery.ui.all.css">
    <link rel="stylesheet" href="/WebSocialSaude/lib/themes/ui-lightness/jquery-ui-1.8.10.custom.css">
    <link rel="stylesheet" href="/WebSocialSaude/zf/public/css/portadeentrada.css">
    <script type="text/javascript" src="/WebSocialComum/library/js/jquery-1.6.2.min.js"></script>
    <script type="text/javascript" src="/WebSocialSaude/lib/ui/jquery-ui-1.8.16.custom.min.js"></script>
    <script type="text/javascript" src="/WebSocialComum/library/js/jquery.buscar.js"></script>
    <script type="text/javascript">
        function guiaDeComparecimento(age_codigo) {
            var url = "guiaDeComparecimento.php?age_codigo=" + age_codigo;
            window.open(url, null, 'height=750,width=750,status=yes,toolbar=no,menubar=no,location=no');
        }

        function wbio() {
            window.open('../biometria/validar.php', null,
                'height=268,width=230,status=yes,toolbar=no,menubar=no,location=no,scrollbars=yes');
        }


        function buscaEsp() {
            var url = "../selectEspDoMed.ajax.php?usr_codigo=" + $("#medico").val() + "&age_codigo=" + $("#age_codigo").val();
            $.ajax({
                url: url,
                success: function (txt) {
                    $("#especialidade").html(txt);
                    $("#especialidade").focus();
                    buscaProc();
                    buscaTipo();
                }
            });
        }

        function buscaTipo() {
            var url = "../selectTipoConsulta.ajax.php?usr_codigo=" + $("#medico").val() + "&age_codigo=" + $("#age_codigo").val();
            $.ajax({
                url: url,
                success: function (txt) {
                    if (txt.length > 0) {
                        $("#box-tipo_consulta").show();
                        $("#tipo_consulta").html(txt);
                        $("#tipo_consulta").focus();
                    } else {
                        $("#box-tipo_consulta").hide();
                    }

                }
            });
        }

        function buscaProc() {
            console.log($("#especialidade").val());
            console.log($("#age_codigo").val());
            var url = "../selectProcDaEsp.ajax.php?esp_codigo=" + $("#especialidade").val() + "&age_codigo=" + $("#age_codigo").val();
            $.ajax({
                url: url,
                success: function (txt) {
                    console.log(txt);
                    $("#procedimento").html(txt);
                    $("#procedimento").focus();
                }
            });
        }

        function carregaEstratificacaoPaciente(codPaciente) {
            var risco_familiar = "";
            var cor_risco = "";

            if (codPaciente !== "") {
                $.ajax({
                    url: "/WebSocialSaude/zf/default/paciente/busca-dados-estratificacao",
                    type: "POST",
                    dataType: "JSON",
                    async: true,
                    data: {codPaciente: codPaciente},
                    success: function (data) {
                        switch (data.estrat_risco_familiar) {
                            case "B":
                                risco_familiar = "Baixo";
                                cor_risco = "#008000";
                                break;
                            case "M":
                                risco_familiar = "Médio";
                                cor_risco = "#ff8600";
                                break;
                            case "A":
                                risco_familiar = "Alto";
                                cor_risco = "#ff342e";
                                break;
                        }
                        $("#risco_familiar").prop("value", risco_familiar);
                        $("#risco_familiar").css("color", cor_risco);
                    }
                });
            } else {
                return false;
            }
        }

        $(function () {

            $("#box-tipo_consulta").hide();

            $(".paciente").click(function () {
                var usu_codigo = $("#usu_codigo").val();
                if (usu_codigo > 1) {
                    var link = "../zf/paciente/form-paciente/pessoa/" + usu_codigo + "/poupup/1";
                } else {
                    link = "../zf/default/paciente/form-paciente/poupup/1";
                }
                window.open(link, "name", "scrollbars=1,height=800,width=900", 'width=850,height=700');
            });

            $("#medico").change(function () {
                buscaEsp();
            }).focus();

            $("#especialidade").change(function () {
                buscaProc();
            }).focus();

            if ($("#age_codigo").val() != "") {
                buscaEsp();
            }

            $("#buscar").buscar({
                callback: function (event, ui) {
                    var usu_codigo = $("#usu_codigo").val();

                    carregaEstratificacaoPaciente(usu_codigo);
                    verificaVacina(usu_codigo);

                    if (ui.item) {
                        $("#iframe").show("normal").find("iframe").attr("src", "historico.php?usu_codigo=" + usu_codigo);
                        $("#final a").focus();
                    }
                }
            });

            $("#tabs").bind("tabsselect", function (event, ui) {
                var selectedTab = $("#tabs").tabs('option', 'selected');

                if (selectedTab == 1) {
                    window.location.href = window.location.href;
                    event.preventDefault();
                    return false;
                }
            });

            $("#final a").click(function () {
                if (!validarDados()) {
                    return false;
                }

                var array_valores = "";
                $.ajax({
                    url: "registrar.php",
                    type: "POST",
                    data: {
                        usu_codigo: $("#usu_codigo").val(),
                        usr_codigo: $("#medico").val(),
                        esp_codigo: $("#especialidade").val(),
                        proc_codigo: $("#procedimento").val(),
                        age_codigo: $("#age_codigo").val(),
                        tipo_consulta: $("#tipo_consulta").val()
                    },
                    success: function (r) {
                        window.console && console.log("registrar.php: " + r);
                        if (r == 0) {
                            alert("Este paciente j&aacute; possui agendamento para hoje");
                        }
                        $('#tabs').tabs("select", 1);
                        array_valores = r.split('-');
                        if ($("#guia_diagnostico").val() == 1) {
                            window.open('../zf/relatorio/usuario/guia-diagnostico/usu_codigo/' + $("#usu_codigo").val() + "/age_codigo/" + array_valores[2] + "/med_codigo/" + $("#medico").val(), '_blank');
                        }
                    }
                });

                return false;
            });

            function validarDados() {
                if ($("#medico").val() == 0) {
                    alert("Selecione um profissional.");
                    $("#medico").focus();
                    return false;
                }
                if (!$("#especialidade").val()) {
                    alert("Selecione a especialidade do profissional.");
                    $("#especialidade").focus();
                    return false;
                }
                if (!$("#procedimento").val()) {
                    alert("Selecione um procedimento.");
                    $("#buscar").select();
                    return false;
                }
                if (!$("#usu_codigo").val()) {
                    alert("Selecione um paciente.");
                    $("#buscar").select();
                    return false;
                }
                return true;
            }

        });

        function buscarPorUsuCodigo(usu_codigo) {

            $.ajax({
                url: '/WebSocialSaude/buscaGenerica.php?tipo=usu_cod_bio',
                datatype: 'JSON',
                type: 'GET',
                data: {
                    term: usu_codigo
                },
                success: function (json) {
                    if (json && json[0].id) {
                        for (var i in json[0].data) {
                            $("#" + i).val(json[0].data[i]);
                        }
                        window.console && console.log("achou: " + usu_codigo);
                        var usu_codigo = $("#usu_codigo").val();

                        $("#iframe").show("normal").find("iframe").attr("src", "historico.php?usu_codigo=" + usu_codigo);
                        $("#final a").focus();

                    }
                }
            });
        }

        function retornaPac(usu_codigo, usu_nome) {
            $("#usu_codigo").val(usu_codigo);
            $("#usu_nome").val(usu_nome);
        }

        function verificaVacina(usu_codigo) {
            $.ajax({
                url: "/WebSocialSaude/zf/default/vacina/vacinas-pendentes",
                type: "POST",
                dataType: "JSON",
                async: true,
                data: {id: usu_codigo},
                success: function (txt) {
                    if (txt.success) {
                        alert("Este paciente possui vacinas pendentes, favor encaminhá-lo ao setor de Vacina.")
                    }
                }
            });
        }

    </script>
</head>
<body>
<?= $common->menuTab(array("Porta de Entrada", "Fila de Atendimento", "Atendidos"), "", "tabs", FALSE, array(1 => "fila.php")); ?>
<?= $common->bodyTab('1'); ?>
<div class="principal">
    <section>
        <form method="POST" action="">
            <input type="hidden" name="usu_codigo" id="usu_codigo" value="<?= $regAgenda['usu_codigo']; ?>"/>
            <input type="hidden" name="age_codigo" id="age_codigo" value="<?= $regAgenda['age_codigo']; ?>"/>
            <div id="box-select" style="margin-left: 5px">

                <div class="clear"></div>


                <label style="font-size: 12px;"><b> Profissional </b></label>
                <br/>
                <div id="td-pro">
                    <?= $selectMedico; ?>
                </div>

            </div>

            <div class="clear"></div>
            <div id="box-select" style="width:580px; margin-left: 5px">

                <label style="font-size: 12px;"><b> Especialidade </b></label>

                <div id="td-esp">

                    <select style="width:580px;" id="especialidade" name="especialidade" n=""
                            class="inputForm"></select>

                </div>

            </div>

            <div class="clear"></div>

            <div id="box-select" style="width:580px;  margin-left: 5px">

                <label style="font-size: 12px;"><b> Procedimento </b></label>
                <div class="clear"></div>


                <div id="td-proc">

                    <select style="width:580px" id="procedimento" name="procedimento" n=""
                            class="inputForm"></select>

                </div>

            </div>

            <div id="box-tipo_consulta" style="width:580px;  margin-left: 5px">

                <label style="font-size: 12px;"><b> Tipo de Consulta </b></label>


                <div id="td-tipo_consulta">

                    <select style="width:580px" id="tipo_consulta" name="tipo_consulta" n=""
                            class="inputForm"></select>

                </div>

            </div>
            <div class="clear"></div>

            <div id="bloco" style="width:580px">
                <?= $form->inputText('buscar', $regAgenda['usu_nome'], 'Buscar', '42', null); ?>
                <a href="#" class="ui-button paciente" style="float: right;"><img
                            src=../imgs/btn_paciente_novo_editar.png border="0"/></a><br/>
                <?= $form->inputText('usu_nome', $regAgenda['usu_nome'], 'Nome do Paciente', '60', NULL, NULL, NULL, "S"); ?>
                <?= $form->inputText('usu_prontuario', $regAgenda['usu_prontuario'], 'Prontu&aacute;rio', '30', NULL, NULL, NULL, "S"); ?>
                <?= $form->inputText('usu_datanasc', $regAgenda['data'], 'Data de Nascimento', '30', NULL, NULL, NULL, "S"); ?>
                <?= $form->inputText('usu_mae', $regAgenda['usu_mae'], 'Nome da M&atilde;e', '60', NULL, NULL, NULL, "S"); ?>
                <?= $form->inputText('usu_pai', $regAgenda['usu_pai'], 'Nome do Pai', '60', NULL, NULL, NULL, "S"); ?>
                <? if (getConfig("USU_CODIGO_RESPONSAVEL") == 1) {
                    echo $form->inputText('nomeres', $valor, 'Respons&aacute;vel', '60', NULL, NULL, NULL, "S");
                    echo $form->inputText('psf_area', NULL, 'PSF', '60', NULL, NULL, NULL, "S");
                } ?>
                <?= $form->inputText('risco_familiar', NULL, 'Risco familiar', '60', NULL, NULL, NULL, "S", NULL, NULL, NUll, 'inputForm estratificacao'); ?>
                <input type="hidden" name="guia_diagnostico" id="guia_diagnostico"
                       value="<?= getConfig("GUIA_DIAGNOSTICO") ?>">
                <div id="final" style="margin-left: 219px;">
                    <a href='#'><img src="imgs/addpacatend.png"></a>
                </div>

            </div>
        </form>
    </section>
    <section>
        <div id="iframe">
            <iframe name=fazer src='about:blank' frameborder=no marginheight=0 marginwidth=0
                    scrolling=no width=100%
                    height=380>
            </iframe>
        </div>
    </section>
</div>
<div class="clear"></div>
<?= $common->closeTab(); ?>
<?= $common->bodyTab('2'); ?>
<?= $common->closeTab(); ?>
<?= $common->bodyTab('3'); ?>
<?php echo $form->openForm($_SERVER['PHP_SELF'] . "?#tabs-3", "POST", "busca");
$arrayBusca = array("nome" => "Nome", "nomeProf" => "Profissional", "data" => "Data");
echo $form->inputSelect("tipoBusca", $arrayBusca, "Tipo Busca");
$buscaCampo = $form->inputText("buscar", null, "Buscar", "55");
echo $form->hiddenForm("acao", "busca");
if ($_POST['acao'] == "busca") {
    $tipoBusca = $_POST['tipoBusca'];
    $condicao = $_POST["buscar"];
    if ($tipoBusca == 'nome') {
        $where = "AND " . (is_numeric($condicao) ? "usu_codigo = $condicao" : "usu_nome ILIKE '%$condicao%'") . "";
    } else if ($tipoBusca == 'nomeProf') {
        $where = "AND " . (is_numeric($condicao) ? "usr_codigo = $condicao" : "usr_nome ILIKE '%$condicao%'") . "";
    } else if ($tipoBusca == 'data') {
        $where = "AND to_char(ag.age_data,'DD/MM/YYYY') ilike '%$condicao%'";
    }
} else {
    $where = "AND ag.age_data = CURRENT_DATE";
}
$buscaButton = $common->commonButton("buscar", null, "buscar.png", "onClick=\"document.busca.submit()\"");
echo $table->openTable("table", null, null, 0);
echo $table->criaLinha(array($buscaCampo, $buscaButton), array(550));
echo $table->closeTable();
$sqlLogon = "SELECT * FROM logon WHERE id_login = $id_login ORDER BY dt_entrada DESC LIMIT 1";
$queryLogon = pg_query($sqlLogon);
$regLogon = pg_fetch_array($queryLogon);
$sqlAtendimento = "SELECT ag.age_codigo, at.ate_codigo,
                                            to_char(ag.age_data,'DD/MM/YYYY') as age_data,
                                            pc.pc_codigo,
                                            io.io_codigo,
                                            u.usu_nome,
                                            ag.med_codigo,
                                            usr_nome
                                        FROM agendamento ag
                                        LEFT JOIN atendimento at
                                            ON ag.age_codigo = at.age_codigo
                                        LEFT JOIN atendimento_internacao ai
                                            ON at.ate_codigo = ai.ate_codigo
                                        LEFT JOIN internacao_observacao io
                                            ON io.io_codigo = ai.io_codigo
                                        LEFT JOIN usuario u
                                            ON u.usu_codigo = ag.usu_codigo
                                        LEFT JOIN pre_consulta pc
                                            ON pc.age_codigo = ag.age_codigo
                                        JOIN usuarios usr
                                            ON usr.usr_codigo = ag.med_codigo
                                    WHERE (at.ate_codigo is not null OR pc_codigo is not null)
                                    $where
                                    AND ag.uni_codigo = $regLogon[uni_codigo]
                                    ORDER BY ag.med_codigo,age_codigo DESC";

$queryAtendimento = pg_query($sqlAtendimento) or DIE ($sqlAtendimento . pg_last_error());
$numAtendimentos = pg_num_rows($queryAtendimento);
echo $table->openTable("lista", null, null, 0);
echo $table->criaLinha(array("Data da Consulta", "Nome do Paciente", "Nome do Profissional", "Op&ccedil;&otilde;es"), null, null, "S");
if ($numAtendimentos == 0) {
    echo $table->criaLinha(array("Nenhum Registro Encontrado"), null, array(3));
}
while ($regAtendimento = pg_fetch_array($queryAtendimento)) {
    $botaoGuia = $common->commonButton("GUIA DE COMPARECIMENTO", NULL, "historico.png", "onClick=\"guiaDeComparecimento($regAtendimento[age_codigo])\"");
    echo $table->criaLinha(array("$regAtendimento[age_data]", "$regAtendimento[usu_nome]", "$regAtendimento[usr_nome]", "$botaoGuia"));
}
echo $table->closeTable();
echo $form->closeForm();
?>
<?= $common->closeTab(); ?>
</body>
</html>
