<?php
/**
* Created by PhpStorm.
* User: claiton.nazaret
* Date: 21/02/2018
* Time: 10:03
*/

use Slim\App;
use Slim\Http\Request;
use Slim\Http\Response;

date_default_timezone_set('America/Sao_Paulo');

require __DIR__ . '/vendor/autoload.php';
define('PATH_COMUM', __DIR__.'/../../WebSocialComum/');
define('PATH_SAUDE', __DIR__.'/../../WebSocialSaude/');
define("DATA_BR", "d/m/Y");
define("DATATIME_BR", "d/m/Y H:i:s");
setlocale(LC_MONETARY,"pt_BR", "ptb");

class EsoRest
{
  protected $retornos = [
    "retorno" => [],
    "status" => 404
  ];

  private $configuration = [
    "settings" => [
      'determineRouteBeforeAppMiddleware' => true,
      'displayErrorDetails' => true,
      'addContentLengthHeader' => false,
      'debug' => true,
      'httpVersion' => '1.1',
      'routerCacheFile' => false
    ]
  ];

  /**
  * EsoRest constructor.
  */
  public function __construct()
  {
    $this->run();
  }

  private function run()
  {
    $c = new \Slim\Container($this->configuration);

    $c['notAllowedHandler'] = function ($c) {
      return function ($methods) use ($c) {
        $this->retornos = [
          'retorno' => [
            'message' => 'somente os métodos [' . implode(', ', $methods) . '] são permitidos.'
          ],
          'status' => 405
        ];

        return $c['response']->withJson(['response' => $this->retornos['retorno']], $this->retornos['status']);
      };
    };

    $c['notFoundHandler'] = function ($c) {
      return function () use ($c) {
        $this->retornos = [
          'retorno' => [
            'message' => ''
          ],
          'status' => 404
        ];

        return $c['response']->withJson(['response' => $this->retornos['retorno']], $this->retornos['status']);
      };
    };

    $c['errorHandler'] = function ($c) {
      return function ($exception) use ($c) {
        $this->retornos = [
          'retorno' => [
            'type' => 'errorHandler',
            'message' => 'ocorreu um erro na sua chamada: ' . json_encode($exception) . '.'
          ],
          'status' => 500
        ];

        return $c['response']->withJson(['response' => $this->retornos['retorno']], $this->retornos['status']);
      };
    };

    $c['phpErrorHandler'] = function ($c) {
      return function ($exception) use ($c) {
        $this->retornos = [
          'retorno' => [
            'type' => 'phpErrorHandler',
            'message' => 'ocorreu um erro na sua chamada: ' . json_encode($exception) . '.'
          ],
          'status' => 501
        ];

        return $c['response']->withJson(['response' => $this->retornos['retorno']], $this->retornos['status']);
      };
    };

    $app = new App($c);

    $app->add(function (Request $req, Response $res, callable $next) {
      $res = $next($req, $res);

      if(strpos($req->getRequestTarget(), "filadeespera") !== false){
        return $res->withJson($this->retornos['retorno'], $this->retornos['status']);
      }

      return $res->withJson(['response' => $this->retornos['retorno']], $this->retornos['status']);
    });

    //Rest Saúde
    $app->group("/saude", function() {
      $produto = new \App\Route\ProdutoRoute();
      $this->retornos = $produto->run($this);

      $movimento = new \App\Route\MovimentacaoRoute();
      $this->retornos = $movimento->run($this);

      $horus = new \App\Route\HorusRoute();
      $this->retornos = $horus->run($this);

      $fila = new \App\Route\FilaDeEsperaRoute();
      $this->retornos = $fila->run($this);

      $agenTIC = new \App\Route\AgenTicRoute();
      $this->retornos = $agenTIC->run($this);
    });

    //Rest Ingá Digital
    $inga = new \App\Route\IngaDigitalRoute();
    $this->retornos = $inga->run($app);

    $app->run();
  }
}

$eso = new EsoRest();
