<?php
namespace App\Controller;

use GuzzleHttp\Client;

class AgenTicCtrl extends AbstractCtrl {

	private $http;
	private $url;

	public function __construct() {
		$this->http = new Client();
		$this->url = 'https://api.enginedigital.com.br/agentic';
	}

	public function gerarToken($parametros) {
		try {
			$response = $this->http->request('POST', $this->url . '/oauth/token', [
				'headers' => [
					'Authorization' => 'Basic ' . base64_encode('angular:@ngul@r0'),
					'Content-Type' => 'application/x-www-form-urlencoded',
				],
				'form_params' => [
					"username" => $parametros['username'],
					"password" => $parametros['password'],
					"grant_type" => $parametros['grant_type'],
				],
			]);

			self::setRetornos(200, 'OK', json_decode($response->getBody()->getContents()));
		} catch (\Exception $e) {
			self::setRetornos(404, $e->getMessage(), NULL);
		}

		return self::getRetornos();
	}

	public function refreshToken($parametros) {
		try {
			$response = $this->http->request('POST', $this->url . '/oauth/token', [
				'headers' => [
					'Authorization' => 'Basic ' . base64_encode('angular:@ngul@r0'),
					'Content-Type' => 'application/x-www-form-urlencoded',
				],
				'form_params' => [
					"refresh_token" => $parametros['refresh_token'],
					"grant_type" => $parametros['grant_type'],
				],
			]);
			self::setRetornos(200, 'OK', json_decode($response->getBody()->getContents()));
		} catch (\Exception $e) {
			self::setRetornos(404, $e->getMessage(), NULL);
		}

		return self::getRetornos();
	}

	public function cadastraPaciente($parametros) {
		try {
			$response = $this->http->request('POST', $this->url . '/rest/v2/pacientes/broadcast', [
				'headers' => [
					'Authorization' => 'Bearer ' . $parametros['access_token'],
					'Content-Type' => 'application/json',
				],
				'body' => json_encode([
					[
						"nome" => $parametros['nome'],
						"dataCadastro" => $parametros['dataCadastro'],
						"dataAlteracao" => $parametros['dataAlteracao'],
						"dataNascimento" => $parametros['dataNascimento'],
						"usaFacebook" => $parametros['usaFacebook'],
						"usaWhatsapp" => $parametros['usaWhatsapp'],
						"usaTelegram" => $parametros['usaTelegram'],
						"usaSms" => $parametros['usaSms'],
						"codigoPrestador" => $parametros['codigoPrestador'],
						"atualizar" => $parametros['atualizar'],
						"ativo" => $parametros['ativo'],
						"codigoEmpresa" => $parametros['codigoEmpresa'],
						"estado" => $parametros['estado'],
						"cidade" => $parametros['cidade'],
					],
				]),
			]);

			self::setRetornos(200, 'OK', json_decode($response->getBody()->getContents()));
		} catch (\Exception $e) {
			self::setRetornos(404, $e->getMessage(), NULL);
		}

		return self::getRetornos();
	}

	public function cadastraMedico($parametros) {
		try {
			$response = $this->http->request('POST', $this->url . '/rest/v2/medicos/broadcast', [
				'headers' => [
					'Authorization' => 'Bearer ' . $parametros['access_token'],
					'Content-Type' => 'application/json',
				],
				'body' => json_encode([
					[
						"nome" => $parametros['nome'],
						"dataCadastro" => $parametros['dataCadastro'],
						"dataAlteracao" => $parametros['dataAlteracao'],
						"ativo" => $parametros['ativo'],
						"codigoPrestador" => $parametros['codigoPrestador'],
						"codigoEmpresa" => $parametros['codigoEmpresa'],
						"especialidade" => $parametros['especialidade'],
						"conselhoProfissional" => $parametros['conselhoProfissional'],
						"numeroConselho" => $parametros['numeroConselho'],
						"estado" => $parametros['estado'],
						"cidade" => $parametros['cidade'],
					],
				]),
			]);

			self::setRetornos(200, 'OK', json_decode($response->getBody()->getContents()));
		} catch (\Exception $e) {
			self::setRetornos(404, $e->getMessage(), NULL);
		}

		return self::getRetornos();
	}

	public function cadastraAgendamento($parametros) {
		try {
			$response = $this->http->request('POST', $this->url . '/rest/v2/agendamentos/broadcast', [
				'headers' => [
					'Authorization' => 'Bearer ' . $parametros['access_token'],
					'Content-Type' => 'application/json',
				],
				'body' => json_encode([
					[
						"dataAlteracao" => $parametros['dataAlteracao'],
						"dataCadastro" => $parametros['dataCadastro'],
						"dataAgendamento" => $parametros['dataAgendamento'],
						"celular" => $parametros['celular'],
						"hora" => $parametros['hora'],
						"tipo" => $parametros['tipo'],
						"status" => $parametros['status'],
						"realizada" => $parametros['realizada'],
						"codigoEmpresa" => $parametros['codigoEmpresa'],
						"codigoPaciente" => $parametros['codigoPaciente'],
						"codigoMedico" => $parametros['codigoMedico'],
						"codigoPrestador" => $parametros['codigoPrestador'],
					],
				]),
			]);

			self::setRetornos(200, 'OK', json_decode($response->getBody()->getContents()));
		} catch (\Exception $e) {
			self::setRetornos(404, $e->getMessage(), NULL);
		}

		return self::getRetornos();
	}

}
