<?php
/**
* Created by PhpStorm.
* User: claiton.nazaret
* Date: 12/03/2018
* Time: 11:22
*/

namespace App\Controller;

use App\Model\MovimentoModel;
use App\Model\ProdutoModel;
use App\Repository\MovimentacaoRepo;

class MovimentoCtrl extends AbstractCtrl implements MovimentacaoRepo {

	private $model;

	/**
	* MovimentoCtrl constructor.
	* @param $model
	*/
	public function __construct() {
		$this->model = new MovimentoModel();
	}

	public function abrirInventario($dados) {
		$inventario = $this->model->abrirInventario($dados);
		if (gettype($inventario) == 'string') {
			$msg = "Já existe um inventario aberto com esses parâmetros! Inventário: " . $inventario;
			self::setRetornos(307, $msg);
		} elseif ($inventario) {
			self::setRetornos(201, 'OK', $inventario);
		} else {
			self::setRetornos(404, 'Erro ao salvar inventário!');
		}

		return self::getRetornos();
	}

	public function findInventarioById($inv_codigo) {
		$inventario = $this->model->findInventarioById($inv_codigo);
		if ($inventario) {
			self::setRetornos(200, 'OK', $inventario);
		}

		return self::getRetornos();
	}

	public function findAllInventario() {
		$inventario = $this->model->findAllInventario();
		if (is_array($inventario) && count($inventario) > 0) {
			self::setRetornos(200, 'OK', $inventario);
		}

		return self::getRetornos();
	}

	public function carregaProdutosInventario($dados) {
		$inventario = $this->model->carregaProdutosInventario($dados);
		if (is_array($inventario) && count($inventario) > 0) {
			self::setRetornos(200, 'OK', $inventario);
		} else {
			self::setRetornos(404, $inventario);
		}

		return self::getRetornos();
	}

	public function alteraProdutoInventario($dados) {
		$inventario = $this->model->alteraProdutoInventario($dados);
		if ($inventario) {
			self::setRetornos(201, 'OK', $inventario);
		} else {
			self::setRetornos(404, 'Erro ao alterar produto!');
		}

		return self::getRetornos();
	}

	public function processarInventario($inv_codigo) {
		$inventario = $this->model->processarInventario($inv_codigo);
		if (is_array($inventario) && count($inventario) > 0) {
			self::setRetornos(201, 'OK', $inventario);
		} else {
			self::setRetornos(404, $inventario);
		}

		return self::getRetornos();
	}

	public function abrirLote($dados) {
		$lote = $this->model->abrirLote($dados);
		if ($lote) {
			self::setRetornos(201, 'OK', $lote);
		} else {
			self::setRetornos(404, 'Erro ao salvar o lote!');
		}

		return self::getRetornos();
	}

	public function alteraLote($dados) {
		$lote = $this->model->alteraLote($dados);
		if ($lote) {
			self::setRetornos(201, 'OK', $lote);
		} else {
			self::setRetornos(404, 'Erro ao alterar o lote!');
		}

		return self::getRetornos();
	}

	public function removeLote($dados) {
		$lote = $this->model->removeLote($dados);
		if (gettype($lote) == 'string') {
			self::setRetornos(307, $lote);
		} elseif ($lote) {
			self::setRetornos(201, 'OK', 'Lote removido com sucesso!');
		} else {
			self::setRetornos(404, 'Erro ao remover o lote!');
		}

		return self::getRetornos();
	}

	public function findLoteByProduct($invp_codigo) {
		$lote = $this->model->findLoteByProduct($invp_codigo);
		if ($lote) {
			self::setRetornos(200, 'OK', $lote);
		}

		return self::getRetornos();
	}

	public function findAllLote() {
		$lote = $this->model->findAllLote();
		if ($lote) {
			self::setRetornos(200, 'OK', $lote);
		}

		return self::getRetornos();
	}

	public function cancelaInventario($inv_codigo) {
		$inventario = $this->model->cancelaInventario($inv_codigo);
		if (gettype($inventario) == 'string') {
			self::setRetornos(307, $inventario);
		} elseif ($inventario) {
			self::setRetornos(201, 'OK', 'Inventário cancelado com sucesso!');
		} else {
			self::setRetornos(404, 'Erro ao cancelar o inventário!');
		}

		return self::getRetornos();
	}

}
