<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 23/02/2018
 * Time: 14:51
 */

namespace App\Controller;


use App\Entity\Produto;
use App\Model\ProdutoModel;

class ProdutoCtrl extends AbstractCtrl {

	private $model;

	/**
	 * ProdutoCtrl constructor.
	 * @param $service
	 */
	public function __construct() {
		$this->model = new ProdutoModel();
	}

	public function findById($id) {
		$produto = $this->model->findById($id);
		if($produto){
			self::setRetornos(200, 'OK', $produto->toArray());
		}
		return self::getRetornos();
	}

	public function findAll($filtro) {
		$produtos = $this->model->findAll($filtro);
		if(count($produtos) > 0){
			self::setRetornos(200, 'OK', $produtos);
		}
		return self::getRetornos();
	}

	public function save($object) {
		$ret = $this->model->save($object);
		if(gettype($ret) == 'array'){
			$mensagem = "Produto ".(isset($object['pro_codigo']) ? 'atualizado' : 'salvo')." com sucesso";
			self::setRetornos(201, $mensagem, $ret, 1);
		}else{
			$mensagem = "Ocorreu um erro ao "
				.(isset($object['pro_codigo']) ? 'atualizar o produto ' : 'salvar o produto ')
				.$object['pro_nome']
				.". Tente novamente mais tarde. \n\n".$ret;
			self::setRetornos(404, $mensagem);
		}
		return self::getRetornos();
	}

	public function delete($id) {
		$ret = $this->model->delete($id);
		if(empty($ret)){
			self::setRetornos(204, true, "Produto excluído com sucesso");
		}else{
			self::setRetornos(404, false, $ret);
		}
		return self::getRetornos();
	}
}