<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 23/02/2018
 * Time: 10:37
 */

namespace App\Entity;

use Doctrine\ORM\Internal\Hydration\AbstractHydrator;
use Doctrine\ORM\PersistentCollection;
use Doctrine\ORM\Proxy\Proxy;
use Doctrine\ORM\Query;

abstract class AbstractEntity
{
    public static function _toArray($entity)
    {
        $result = array();
        $methods = get_class_methods($entity);
        foreach($methods as $method) {
            if ('get' == substr($method, 0, 3)) {
                $result[lcfirst(substr($method, 3))] = $entity->$method();
            }
            if ('is' == substr($method, 0, 2)) {
                $result[lcfirst(substr($method, 2))] = $entity->$method();
            }
        }
        return $result;
    }

	private static function _toSnakeCase($field_name) {
		return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $field_name));
    }

    public static function _returnArray($entity){
    	if(isset($entity)){
		    return $entity->toArray();
	    }
	    return $entity;
    }

	public static function _returnDate($date, $format="Y-m-d H:i:s"){
		if(isset($date)){
			return $date->format($format);
		}
		return $date;
	}

	public static function _returnDecimalBR($valor, $decimais=2){
		if(isset($valor)){
			return number_format($valor, $decimais, ',', '.');
		}
		return $valor;
	}

}