<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 17:43
 */

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use DateTime;

/**
 * @Entity
 * @Table(name="agendamento")
 */
class Agendamento extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_age_codigo")
	 * @Column(name="age_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $age_data;
	/**
	 * @OneToOne(targetEntity="Usuario")
	 * @JoinColumn(name="usr_codigo", referencedColumnName="usr_codigo", fieldName="med_codigo")
	 */
	private $medico;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $age_hora;
	/**
	 * @OneToOne(targetEntity="Cidadao")
	 * @JoinColumn(name="usu_codigo", referencedColumnName="usu_codigo")
	 */
	private $usuario;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $age_tipo;
	/**
	 * @var string
	 * @Column(type="string", length=1, options={"default": "N"})
	 */
	private $age_atendido;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $age_paciente;
	/**
	 * @OneToOne(targetEntity="Unidade")
	 * @JoinColumn(name="uni_codigo", referencedColumnName="uni_codigo")
	 */
	private $unidade;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $age_item;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $age_status;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $esp_codigo;
	/**
	 * @var double
	 * @Column(type="decimal", precision=9, scale=2, options={"default": 0})
	 */
	private $age_valor_proc;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $agt_codigo;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usr_codigo_alt;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usr_codigo_cad;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $dt_cadastro;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $age_item2;
	/**
	 * @var DateTime
	 * @Column(type="datetimetz")
	 */
	private $dt_atualizacao;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $age_data_atend;
	/**
	 * @var string
	 * @Column(type="string", length=1, options={"default": "N"})
	 */
	private $age_emergencia;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $age_timestamp;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $proc_codigo_sus;
	/**
	 * @var integer
	 * @Column(type="integer", options={"default": 0}, nullable=false)
	 */
	private $age_ordem;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $coni_codigo;
	/**
	 * @var DateTime
	 * @Column(type="time")
	 */
	private $age_horario;
	/**
	 * @OneToOne(targetEntity="TipoAtendimento")
	 * @JoinColumn(name="tat_codigo", referencedColumnName="tat_codigo")
	 */
	private $tipo_atendimento;
	/**
	 * @OneToOne(targetEntity="TipoFicha")
	 * @JoinColumn(name="tpf_codigo", referencedColumnName="tpf_codigo")
	 */
	private $tipo_ficha;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $age_cod_conv;
	/**
	 * @OneToOne(targetEntity="TipoConsulta")
	 * @JoinColumn(name="tp_cod", referencedColumnName="tp_cod")
	 */
	private $tipo_consulta;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $proc_codigo;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usr_cod_atendendo;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $usr_cod_status;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $datahora_status;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return DateTime
	 */
	public function getAgeData() {
		return self::_returnDate($this->age_data);
	}

	/**
	 * @param DateTime $age_data
	 */
	public function setAgeData($age_data) {
		$this->age_data = $age_data;
	}

	/**
	 * @return mixed
	 */
	public function getMedico() {
		return self::_returnArray($this->medico);
	}

	/**
	 * @param mixed $medico
	 */
	public function setMedico($medico) {
		$this->medico = $medico;
	}

	/**
	 * @return string
	 */
	public function getAgeHora() {
		return $this->age_hora;
	}

	/**
	 * @param string $age_hora
	 */
	public function setAgeHora($age_hora) {
		$this->age_hora = $age_hora;
	}

	/**
	 * @return mixed
	 */
	public function getUsuario() {
		return self::_returnArray($this->usuario);
	}

	/**
	 * @param mixed $usuario
	 */
	public function setUsuario($usuario) {
		$this->usuario = $usuario;
	}

	/**
	 * @return string
	 */
	public function getAgeTipo() {
		return $this->age_tipo;
	}

	/**
	 * @param string $age_tipo
	 */
	public function setAgeTipo($age_tipo) {
		$this->age_tipo = $age_tipo;
	}

	/**
	 * @return string
	 */
	public function getAgeAtendido() {
		return $this->age_atendido;
	}

	/**
	 * @param string $age_atendido
	 */
	public function setAgeAtendido($age_atendido) {
		$this->age_atendido = $age_atendido;
	}

	/**
	 * @return string
	 */
	public function getAgePaciente() {
		return $this->age_paciente;
	}

	/**
	 * @param string $age_paciente
	 */
	public function setAgePaciente($age_paciente) {
		$this->age_paciente = $age_paciente;
	}

	/**
	 * @return mixed
	 */
	public function getUnidade() {
		return self::_returnArray($this->unidade);
	}

	/**
	 * @param mixed $unidade
	 */
	public function setUnidade($unidade) {
		$this->unidade = $unidade;
	}

	/**
	 * @return string
	 */
	public function getAgeItem() {
		return $this->age_item;
	}

	/**
	 * @param string $age_item
	 */
	public function setAgeItem($age_item) {
		$this->age_item = $age_item;
	}

	/**
	 * @return string
	 */
	public function getAgeStatus() {
		return $this->age_status;
	}

	/**
	 * @param string $age_status
	 */
	public function setAgeStatus($age_status) {
		$this->age_status = $age_status;
	}

	/**
	 * @return int
	 */
	public function getEspCodigo() {
		return $this->esp_codigo;
	}

	/**
	 * @param int $esp_codigo
	 */
	public function setEspCodigo($esp_codigo) {
		$this->esp_codigo = $esp_codigo;
	}

	/**
	 * @return float
	 */
	public function getAgeValorProc() {
		return $this->age_valor_proc;
	}

	/**
	 * @param float $age_valor_proc
	 */
	public function setAgeValorProc($age_valor_proc) {
		$this->age_valor_proc = $age_valor_proc;
	}

	/**
	 * @return int
	 */
	public function getAgtCodigo() {
		return $this->agt_codigo;
	}

	/**
	 * @param int $agt_codigo
	 */
	public function setAgtCodigo($agt_codigo) {
		$this->agt_codigo = $agt_codigo;
	}

	/**
	 * @return int
	 */
	public function getUsrCodigoAlt() {
		return $this->usr_codigo_alt;
	}

	/**
	 * @param int $usr_codigo_alt
	 */
	public function setUsrCodigoAlt($usr_codigo_alt) {
		$this->usr_codigo_alt = $usr_codigo_alt;
	}

	/**
	 * @return int
	 */
	public function getUsrCodigoCad() {
		return $this->usr_codigo_cad;
	}

	/**
	 * @param int $usr_codigo_cad
	 */
	public function setUsrCodigoCad($usr_codigo_cad) {
		$this->usr_codigo_cad = $usr_codigo_cad;
	}

	/**
	 * @return DateTime
	 */
	public function getDtCadastro() {
		return self::_returnDate($this->dt_cadastro);
	}

	/**
	 * @param DateTime $dt_cadastro
	 */
	public function setDtCadastro($dt_cadastro) {
		$this->dt_cadastro = $dt_cadastro;
	}

	/**
	 * @return string
	 */
	public function getAgeItem2() {
		return $this->age_item2;
	}

	/**
	 * @param string $age_item2
	 */
	public function setAgeItem2($age_item2) {
		$this->age_item2 = $age_item2;
	}

	/**
	 * @return DateTime
	 */
	public function getDtAtualizacao() {
		return self::_returnDate($this->dt_atualizacao);
	}

	/**
	 * @param DateTime $dt_atualizacao
	 */
	public function setDtAtualizacao($dt_atualizacao) {
		$this->dt_atualizacao = $dt_atualizacao;
	}

	/**
	 * @return DateTime
	 */
	public function getAgeDataAtend() {
		return self::_returnDate($this->age_data_atend);
	}

	/**
	 * @param DateTime $age_data_atend
	 */
	public function setAgeDataAtend($age_data_atend) {
		$this->age_data_atend = $age_data_atend;
	}

	/**
	 * @return string
	 */
	public function getAgeEmergencia() {
		return $this->age_emergencia;
	}

	/**
	 * @param string $age_emergencia
	 */
	public function setAgeEmergencia($age_emergencia) {
		$this->age_emergencia = $age_emergencia;
	}

	/**
	 * @return DateTime
	 */
	public function getAgeTimestamp() {
		return self::_returnDate($this->age_timestamp);
	}

	/**
	 * @param DateTime $age_timestamp
	 */
	public function setAgeTimestamp($age_timestamp) {
		$this->age_timestamp = $age_timestamp;
	}

	/**
	 * @return string
	 */
	public function getProcCodigoSus() {
		return $this->proc_codigo_sus;
	}

	/**
	 * @param string $proc_codigo_sus
	 */
	public function setProcCodigoSus($proc_codigo_sus) {
		$this->proc_codigo_sus = $proc_codigo_sus;
	}

	/**
	 * @return int
	 */
	public function getAgeOrdem() {
		return $this->age_ordem;
	}

	/**
	 * @param int $age_ordem
	 */
	public function setAgeOrdem($age_ordem) {
		$this->age_ordem = $age_ordem;
	}

	/**
	 * @return int
	 */
	public function getConiCodigo() {
		return $this->coni_codigo;
	}

	/**
	 * @param int $coni_codigo
	 */
	public function setConiCodigo($coni_codigo) {
		$this->coni_codigo = $coni_codigo;
	}

	/**
	 * @return DateTime
	 */
	public function getAgeHorario() {
		return self::_returnDate($this->age_horario);
	}

	/**
	 * @param DateTime $age_horario
	 */
	public function setAgeHorario($age_horario) {
		$this->age_horario = $age_horario;
	}

	/**
	 * @return mixed
	 */
	public function getTipoAtendimento() {
		return self::_returnArray($this->tipo_atendimento);
	}

	/**
	 * @param mixed $tipo_atendimento
	 */
	public function setTipoAtendimento($tipo_atendimento) {
		$this->tipo_atendimento = $tipo_atendimento;
	}

	/**
	 * @return mixed
	 */
	public function getTipoFicha() {
		return self::_returnArray($this->tipo_ficha);
	}

	/**
	 * @param mixed $tipo_ficha
	 */
	public function setTipoFicha($tipo_ficha) {
		$this->tipo_ficha = $tipo_ficha;
	}

	/**
	 * @return string
	 */
	public function getAgeCodConv() {
		return $this->age_cod_conv;
	}

	/**
	 * @param string $age_cod_conv
	 */
	public function setAgeCodConv($age_cod_conv) {
		$this->age_cod_conv = $age_cod_conv;
	}

	/**
	 * @return mixed
	 */
	public function getTipoConsulta() {
		return self::_returnArray($this->tipo_consulta);
	}

	/**
	 * @param mixed $tipo_consulta
	 */
	public function setTipoConsulta($tipo_consulta) {
		$this->tipo_consulta = $tipo_consulta;
	}

	/**
	 * @return int
	 */
	public function getProcCodigo() {
		return $this->proc_codigo;
	}

	/**
	 * @param int $proc_codigo
	 */
	public function setProcCodigo($proc_codigo) {
		$this->proc_codigo = $proc_codigo;
	}

	/**
	 * @return int
	 */
	public function getUsrCodAtendendo() {
		return $this->usr_cod_atendendo;
	}

	/**
	 * @param int $usr_cod_atendendo
	 */
	public function setUsrCodAtendendo($usr_cod_atendendo) {
		$this->usr_cod_atendendo = $usr_cod_atendendo;
	}

	/**
	 * @return int
	 */
	public function getUsrCodStatus() {
		return $this->usr_cod_status;
	}

	/**
	 * @param int $usr_cod_status
	 */
	public function setUsrCodStatus($usr_cod_status) {
		$this->usr_cod_status = $usr_cod_status;
	}

	/**
	 * @return DateTime
	 */
	public function getDatahoraStatus() {
		return self::_returnDate($this->datahora_status);
	}

	/**
	 * @param DateTime $datahora_status
	 */
	public function setDatahoraStatus($datahora_status) {
		$this->datahora_status = $datahora_status;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}

abstract class AgeTipo {
	const ESPECIALIDADE  = "ES";
	const CLINICA_BASICA = "CB";
}

abstract class AgeAtendido {
	const RECEPCIONADO        = "S";
	const ATENDIDO            = "A";
	const AGENDADO            = "N";
	const TRANSFERIDO         = "T";
	const FALTOSO             = "F";
	const EM_ATENDIMENTO      = "E";
	const ATENDIMENTO_INCLUSO = "I";
	const FALTA_MEDICA        = "M";
}

abstract class AgeStatus {
	const RECEPCIONADO            = "R";
	const RECEPCIONADO_PRE_CONS   = "RP";
	const EM_ATENDIMENTO          = "E";
	const EM_ATENDIMENTO_MEDICO   = "EM";
	const PRE_CONSULTA            = "P";
	const PRE_CONSULTA_FINALIZADA = "PF";
	const ATENDIMENTO             = "A";
	const ATENDIMENTO_FINALIZADO  = "AF";
}