<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 13:28
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;
use DateTime;

/**
 * @Entity
 * @Table(name="atendimento")
 */
class Atendimento extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_ate_codigo")
	 * @Column(name="ate_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var DateTime
	 * @Column(type="date", nullable=false)
	 */
	private $ate_data;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $ate_hora;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $med_codigo;
	/**
	 * @OneToOne(targetEntity="Cidadao")
	 * @JoinColumn(name="usu_codigo", referencedColumnName="usu_codigo")
	 */
	private $cidadao;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $ate_descatend;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $ate_observacao;
	/**
	 * @OneToOne(targetEntity="Agendamento")
	 * @JoinColumn(name="age_codigo", referencedColumnName="age_codigo")
	 */
	private $agendamento;
	/**
	 * @var double
	 * @Column(type="decimal", precision=9, scale=2, options={"default": 0})
	 */
	private $ate_valor_proc;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $ate_datafinal;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $uni_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $ate_horafinal;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $ate_pressao;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $ate_temperatura;
	/**
	 * @var string
	 * @Column(type="string", length=300)
	 */
	private $ate_diagnostico;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $cd10_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $ate_encaminhamento;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $ate_acidentetrab;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $hos_codigo;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $ate_reclamacao;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $ate_exame_fisico;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $ate_tratamento;
	/**
	 * @var string
	 * @Column(type="string", length=50)
	 */
	private $esp_codigo_encaminhamento;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $ate_curativo;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $ate_curativos;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $ate_peso;
	/**
	 * @var double
	 * @Column(type="decimal", precision=3, scale=3)
	 */
	private $ate_altura;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $ate_finalizado;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $sispn_codigo;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $ate_tipo_consulta_prenatal;
	/**
	 * @var string
	 * @Column(type="string", length=30)
	 */
	private $ate_observacao_prenatal;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $ate_classificacao_prenatal;
	/**
	 * @var boolean
	 * @Column(type="boolean", nullable=false, options={"default": false})
	 */
	private $ate_puericultura;
	/**
	 * @var boolean
	 * @Column(type="boolean", nullable=false, options={"default": false})
	 */
	private $ate_pre_natal;
	/**
	 * @var boolean
	 * @Column(type="boolean", nullable=false, options={"default": false})
	 */
	private $ate_cancer;
	/**
	 * @var boolean
	 * @Column(type="boolean", nullable=false, options={"default": false})
	 */
	private $ate_dst;
	/**
	 * @var boolean
	 * @Column(type="boolean", nullable=false, options={"default": false})
	 */
	private $ate_diabetes;
	/**
	 * @var boolean
	 * @Column(type="boolean", nullable=false, options={"default": false})
	 */
	private $ate_hipertensao;
	/**
	 * @var boolean
	 * @Column(type="boolean", nullable=false, options={"default": false})
	 */
	private $ate_hanseniase;
	/**
	 * @var boolean
	 * @Column(type="boolean", nullable=false, options={"default": false})
	 */
	private $ate_tuberculose;
	/**
	 * @var boolean
	 * @Column(type="boolean", nullable=false, options={"default": false})
	 */
	private $ate_outros;
	/**
	 * @OneToOne(targetEntity="Cid10")
	 * @JoinColumn(name="cd10_codigo", referencedColumnName="cd10_codigo")
	 */
	private $cd10s;
	/**
	 * @OneToOne(targetEntity="Cid10")
	 * @JoinColumn(name="cd10_codigo", referencedColumnName="cd10_codigo")
	 */
	private $cd10t;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $ate_data_insert;
	/**
	 * @OneToOne(targetEntity="Usuario")
	 * @JoinColumn(name="usr_codigo", referencedColumnName="usr_codigo")
	 */
	private $gd_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $ate_atendido;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $ate_cod_conv;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $ate_simplificado;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $ate_tipo;
	/**
	 * @OneToOne(targetEntity="TbLocalAtendimento")
	 * @JoinColumn(name="usr_codigo", referencedColumnName="usr_codigo")
	 */
	private $local_atendimento;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $ate_somente_procedimento;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $ate_nasf_aval;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $ate_nasf_proc;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $ate_nasf_presc;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $turno;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $st_fora_area;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $neces_especial;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $gestante;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $st_visita_compartilhada;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $esp_codigo;
	/**
	 * @var double
	 * @Column(type="decimal", precision=9, scale=3)
	 */
	private $vd_peso;
	/**
	 * @var double
	 * @Column(type="decimal", precision=9, scale=1)
	 */
	private $vd_altura;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return DateTime
	 */
	public function getAteData() {
		return self::_returnDate($this->ate_data);
	}

	/**
	 * @param DateTime $ate_data
	 */
	public function setAteData($ate_data) {
		$this->ate_data = $ate_data;
	}

	/**
	 * @return string
	 */
	public function getAteHora() {
		return $this->ate_hora;
	}

	/**
	 * @param string $ate_hora
	 */
	public function setAteHora($ate_hora) {
		$this->ate_hora = $ate_hora;
	}

	/**
	 * @return int
	 */
	public function getMedCodigo() {
		return $this->med_codigo;
	}

	/**
	 * @param int $med_codigo
	 */
	public function setMedCodigo($med_codigo) {
		$this->med_codigo = $med_codigo;
	}

	/**
	 * @return mixed
	 */
	public function getCidadao() {
		return self::_returnArray($this->cidadao);
	}

	/**
	 * @param mixed $cidadao
	 */
	public function setCidadao($cidadao) {
		$this->cidadao = $cidadao;
	}

	/**
	 * @return string
	 */
	public function getAteDescatend() {
		return $this->ate_descatend;
	}

	/**
	 * @param string $ate_descatend
	 */
	public function setAteDescatend($ate_descatend) {
		$this->ate_descatend = $ate_descatend;
	}

	/**
	 * @return string
	 */
	public function getAteObservacao() {
		return $this->ate_observacao;
	}

	/**
	 * @param string $ate_observacao
	 */
	public function setAteObservacao($ate_observacao) {
		$this->ate_observacao = $ate_observacao;
	}

	/**
	 * @return mixed
	 */
	public function getAgendamento() {
		return self::_returnArray($this->agendamento);
	}

	/**
	 * @param mixed $agendamento
	 */
	public function setAgendamento($agendamento) {
		$this->agendamento = $agendamento;
	}

	/**
	 * @return float
	 */
	public function getAteValorProc() {
		return $this->ate_valor_proc;
	}

	/**
	 * @param float $ate_valor_proc
	 */
	public function setAteValorProc($ate_valor_proc) {
		$this->ate_valor_proc = $ate_valor_proc;
	}

	/**
	 * @return DateTime
	 */
	public function getAteDatafinal() {
		return self::_returnDate($this->ate_datafinal);
	}

	/**
	 * @param DateTime $ate_datafinal
	 */
	public function setAteDatafinal($ate_datafinal) {
		$this->ate_datafinal = $ate_datafinal;
	}

	/**
	 * @return int
	 */
	public function getUniCodigo() {
		return $this->uni_codigo;
	}

	/**
	 * @param int $uni_codigo
	 */
	public function setUniCodigo($uni_codigo) {
		$this->uni_codigo = $uni_codigo;
	}

	/**
	 * @return string
	 */
	public function getAteHorafinal() {
		return $this->ate_horafinal;
	}

	/**
	 * @param string $ate_horafinal
	 */
	public function setAteHorafinal($ate_horafinal) {
		$this->ate_horafinal = $ate_horafinal;
	}

	/**
	 * @return string
	 */
	public function getAtePressao() {
		return $this->ate_pressao;
	}

	/**
	 * @param string $ate_pressao
	 */
	public function setAtePressao($ate_pressao) {
		$this->ate_pressao = $ate_pressao;
	}

	/**
	 * @return string
	 */
	public function getAteTemperatura() {
		return $this->ate_temperatura;
	}

	/**
	 * @param string $ate_temperatura
	 */
	public function setAteTemperatura($ate_temperatura) {
		$this->ate_temperatura = $ate_temperatura;
	}

	/**
	 * @return string
	 */
	public function getAteDiagnostico() {
		return $this->ate_diagnostico;
	}

	/**
	 * @param string $ate_diagnostico
	 */
	public function setAteDiagnostico($ate_diagnostico) {
		$this->ate_diagnostico = $ate_diagnostico;
	}

	/**
	 * @return int
	 */
	public function getCd10Codigo() {
		return $this->cd10_codigo;
	}

	/**
	 * @param int $cd10_codigo
	 */
	public function setCd10Codigo($cd10_codigo) {
		$this->cd10_codigo = $cd10_codigo;
	}

	/**
	 * @return string
	 */
	public function getAteEncaminhamento() {
		return $this->ate_encaminhamento;
	}

	/**
	 * @param string $ate_encaminhamento
	 */
	public function setAteEncaminhamento($ate_encaminhamento) {
		$this->ate_encaminhamento = $ate_encaminhamento;
	}

	/**
	 * @return string
	 */
	public function getAteAcidentetrab() {
		return $this->ate_acidentetrab;
	}

	/**
	 * @param string $ate_acidentetrab
	 */
	public function setAteAcidentetrab($ate_acidentetrab) {
		$this->ate_acidentetrab = $ate_acidentetrab;
	}

	/**
	 * @return int
	 */
	public function getHosCodigo() {
		return $this->hos_codigo;
	}

	/**
	 * @param int $hos_codigo
	 */
	public function setHosCodigo($hos_codigo) {
		$this->hos_codigo = $hos_codigo;
	}

	/**
	 * @return string
	 */
	public function getAteReclamacao() {
		return $this->ate_reclamacao;
	}

	/**
	 * @param string $ate_reclamacao
	 */
	public function setAteReclamacao($ate_reclamacao) {
		$this->ate_reclamacao = $ate_reclamacao;
	}

	/**
	 * @return string
	 */
	public function getAteExameFisico() {
		return $this->ate_exame_fisico;
	}

	/**
	 * @param string $ate_exame_fisico
	 */
	public function setAteExameFisico($ate_exame_fisico) {
		$this->ate_exame_fisico = $ate_exame_fisico;
	}

	/**
	 * @return string
	 */
	public function getAteTratamento() {
		return $this->ate_tratamento;
	}

	/**
	 * @param string $ate_tratamento
	 */
	public function setAteTratamento($ate_tratamento) {
		$this->ate_tratamento = $ate_tratamento;
	}

	/**
	 * @return string
	 */
	public function getEspCodigoEncaminhamento() {
		return $this->esp_codigo_encaminhamento;
	}

	/**
	 * @param string $esp_codigo_encaminhamento
	 */
	public function setEspCodigoEncaminhamento($esp_codigo_encaminhamento) {
		$this->esp_codigo_encaminhamento = $esp_codigo_encaminhamento;
	}

	/**
	 * @return string
	 */
	public function getAteCurativo() {
		return $this->ate_curativo;
	}

	/**
	 * @param string $ate_curativo
	 */
	public function setAteCurativo($ate_curativo) {
		$this->ate_curativo = $ate_curativo;
	}

	/**
	 * @return string
	 */
	public function getAteCurativos() {
		return $this->ate_curativos;
	}

	/**
	 * @param string $ate_curativos
	 */
	public function setAteCurativos($ate_curativos) {
		$this->ate_curativos = $ate_curativos;
	}

	/**
	 * @return int
	 */
	public function getAtePeso() {
		return $this->ate_peso;
	}

	/**
	 * @param int $ate_peso
	 */
	public function setAtePeso($ate_peso) {
		$this->ate_peso = $ate_peso;
	}

	/**
	 * @return float
	 */
	public function getAteAltura() {
		return $this->ate_altura;
	}

	/**
	 * @param float $ate_altura
	 */
	public function setAteAltura($ate_altura) {
		$this->ate_altura = $ate_altura;
	}

	/**
	 * @return string
	 */
	public function getAteFinalizado() {
		return $this->ate_finalizado;
	}

	/**
	 * @param string $ate_finalizado
	 */
	public function setAteFinalizado($ate_finalizado) {
		$this->ate_finalizado = $ate_finalizado;
	}

	/**
	 * @return int
	 */
	public function getSispnCodigo() {
		return $this->sispn_codigo;
	}

	/**
	 * @param int $sispn_codigo
	 */
	public function setSispnCodigo($sispn_codigo) {
		$this->sispn_codigo = $sispn_codigo;
	}

	/**
	 * @return int
	 */
	public function getAteTipoConsultaPrenatal() {
		return $this->ate_tipo_consulta_prenatal;
	}

	/**
	 * @param int $ate_tipo_consulta_prenatal
	 */
	public function setAteTipoConsultaPrenatal($ate_tipo_consulta_prenatal) {
		$this->ate_tipo_consulta_prenatal = $ate_tipo_consulta_prenatal;
	}

	/**
	 * @return string
	 */
	public function getAteObservacaoPrenatal() {
		return $this->ate_observacao_prenatal;
	}

	/**
	 * @param string $ate_observacao_prenatal
	 */
	public function setAteObservacaoPrenatal($ate_observacao_prenatal) {
		$this->ate_observacao_prenatal = $ate_observacao_prenatal;
	}

	/**
	 * @return string
	 */
	public function getAteClassificacaoPrenatal() {
		return $this->ate_classificacao_prenatal;
	}

	/**
	 * @param string $ate_classificacao_prenatal
	 */
	public function setAteClassificacaoPrenatal($ate_classificacao_prenatal) {
		$this->ate_classificacao_prenatal = $ate_classificacao_prenatal;
	}

	/**
	 * @return bool
	 */
	public function isAtePuericultura() {
		return $this->ate_puericultura;
	}

	/**
	 * @param bool $ate_puericultura
	 */
	public function setAtePuericultura($ate_puericultura) {
		$this->ate_puericultura = $ate_puericultura;
	}

	/**
	 * @return bool
	 */
	public function isAtePreNatal() {
		return $this->ate_pre_natal;
	}

	/**
	 * @param bool $ate_pre_natal
	 */
	public function setAtePreNatal($ate_pre_natal) {
		$this->ate_pre_natal = $ate_pre_natal;
	}

	/**
	 * @return bool
	 */
	public function isAteCancer() {
		return $this->ate_cancer;
	}

	/**
	 * @param bool $ate_cancer
	 */
	public function setAteCancer($ate_cancer) {
		$this->ate_cancer = $ate_cancer;
	}

	/**
	 * @return bool
	 */
	public function isAteDst() {
		return $this->ate_dst;
	}

	/**
	 * @param bool $ate_dst
	 */
	public function setAteDst($ate_dst) {
		$this->ate_dst = $ate_dst;
	}

	/**
	 * @return bool
	 */
	public function isAteDiabetes() {
		return $this->ate_diabetes;
	}

	/**
	 * @param bool $ate_diabetes
	 */
	public function setAteDiabetes($ate_diabetes) {
		$this->ate_diabetes = $ate_diabetes;
	}

	/**
	 * @return bool
	 */
	public function isAteHipertensao() {
		return $this->ate_hipertensao;
	}

	/**
	 * @param bool $ate_hipertensao
	 */
	public function setAteHipertensao($ate_hipertensao) {
		$this->ate_hipertensao = $ate_hipertensao;
	}

	/**
	 * @return bool
	 */
	public function isAteHanseniase() {
		return $this->ate_hanseniase;
	}

	/**
	 * @param bool $ate_hanseniase
	 */
	public function setAteHanseniase($ate_hanseniase) {
		$this->ate_hanseniase = $ate_hanseniase;
	}

	/**
	 * @return bool
	 */
	public function isAteTuberculose() {
		return $this->ate_tuberculose;
	}

	/**
	 * @param bool $ate_tuberculose
	 */
	public function setAteTuberculose($ate_tuberculose) {
		$this->ate_tuberculose = $ate_tuberculose;
	}

	/**
	 * @return bool
	 */
	public function isAteOutros() {
		return $this->ate_outros;
	}

	/**
	 * @param bool $ate_outros
	 */
	public function setAteOutros($ate_outros) {
		$this->ate_outros = $ate_outros;
	}

	/**
	 * @return mixed
	 */
	public function getCd10s() {
		return self::_returnArray($this->cd10s);
	}

	/**
	 * @param mixed $cd10s
	 */
	public function setCd10s($cd10s) {
		$this->cd10s = $cd10s;
	}

	/**
	 * @return mixed
	 */
	public function getCd10t() {
		return self::_returnArray($this->cd10t);
	}

	/**
	 * @param mixed $cd10t
	 */
	public function setCd10t($cd10t) {
		$this->cd10t = $cd10t;
	}

	/**
	 * @return DateTime
	 */
	public function getAteDataInsert() {
		return self::_returnDate($this->ate_data_insert);
	}

	/**
	 * @param DateTime $ate_data_insert
	 */
	public function setAteDataInsert($ate_data_insert) {
		$this->ate_data_insert = $ate_data_insert;
	}

	/**
	 * @return mixed
	 */
	public function getGdCodigo() {
		return self::_returnArray($this->gd_codigo);
	}

	/**
	 * @param mixed $gd_codigo
	 */
	public function setGdCodigo($gd_codigo) {
		$this->gd_codigo = $gd_codigo;
	}

	/**
	 * @return string
	 */
	public function getAteAtendido() {
		return $this->ate_atendido;
	}

	/**
	 * @param string $ate_atendido
	 */
	public function setAteAtendido($ate_atendido) {
		$this->ate_atendido = $ate_atendido;
	}

	/**
	 * @return int
	 */
	public function getAteCodConv() {
		return $this->ate_cod_conv;
	}

	/**
	 * @param int $ate_cod_conv
	 */
	public function setAteCodConv($ate_cod_conv) {
		$this->ate_cod_conv = $ate_cod_conv;
	}

	/**
	 * @return bool
	 */
	public function isAteSimplificado() {
		return $this->ate_simplificado;
	}

	/**
	 * @param bool $ate_simplificado
	 */
	public function setAteSimplificado($ate_simplificado) {
		$this->ate_simplificado = $ate_simplificado;
	}

	/**
	 * @return string
	 */
	public function getAteTipo() {
		return $this->ate_tipo;
	}

	/**
	 * @param string $ate_tipo
	 */
	public function setAteTipo($ate_tipo) {
		$this->ate_tipo = $ate_tipo;
	}

	/**
	 * @return mixed
	 */
	public function getLocalAtendimento() {
		return self::_returnArray($this->local_atendimento);
	}

	/**
	 * @param mixed $local_atendimento
	 */
	public function setLocalAtendimento($local_atendimento) {
		$this->local_atendimento = $local_atendimento;
	}

	/**
	 * @return bool
	 */
	public function isAteSomenteProcedimento() {
		return $this->ate_somente_procedimento;
	}

	/**
	 * @param bool $ate_somente_procedimento
	 */
	public function setAteSomenteProcedimento($ate_somente_procedimento) {
		$this->ate_somente_procedimento = $ate_somente_procedimento;
	}

	/**
	 * @return bool
	 */
	public function isAteNasfAval() {
		return $this->ate_nasf_aval;
	}

	/**
	 * @param bool $ate_nasf_aval
	 */
	public function setAteNasfAval($ate_nasf_aval) {
		$this->ate_nasf_aval = $ate_nasf_aval;
	}

	/**
	 * @return bool
	 */
	public function isAteNasfProc() {
		return $this->ate_nasf_proc;
	}

	/**
	 * @param bool $ate_nasf_proc
	 */
	public function setAteNasfProc($ate_nasf_proc) {
		$this->ate_nasf_proc = $ate_nasf_proc;
	}

	/**
	 * @return bool
	 */
	public function isAteNasfPresc() {
		return $this->ate_nasf_presc;
	}

	/**
	 * @param bool $ate_nasf_presc
	 */
	public function setAteNasfPresc($ate_nasf_presc) {
		$this->ate_nasf_presc = $ate_nasf_presc;
	}

	/**
	 * @return int
	 */
	public function getTurno() {
		return $this->turno;
	}

	/**
	 * @param int $turno
	 */
	public function setTurno($turno) {
		$this->turno = $turno;
	}

	/**
	 * @return bool
	 */
	public function isStForaArea() {
		return $this->st_fora_area;
	}

	/**
	 * @param bool $st_fora_area
	 */
	public function setStForaArea($st_fora_area) {
		$this->st_fora_area = $st_fora_area;
	}

	/**
	 * @return bool
	 */
	public function isNecesEspecial() {
		return $this->neces_especial;
	}

	/**
	 * @param bool $neces_especial
	 */
	public function setNecesEspecial($neces_especial) {
		$this->neces_especial = $neces_especial;
	}

	/**
	 * @return bool
	 */
	public function isGestante() {
		return $this->gestante;
	}

	/**
	 * @param bool $gestante
	 */
	public function setGestante($gestante) {
		$this->gestante = $gestante;
	}

	/**
	 * @return bool
	 */
	public function isStVisitaCompartilhada() {
		return $this->st_visita_compartilhada;
	}

	/**
	 * @param bool $st_visita_compartilhada
	 */
	public function setStVisitaCompartilhada($st_visita_compartilhada) {
		$this->st_visita_compartilhada = $st_visita_compartilhada;
	}

	/**
	 * @return int
	 */
	public function getEspCodigo() {
		return $this->esp_codigo;
	}

	/**
	 * @param int $esp_codigo
	 */
	public function setEspCodigo($esp_codigo) {
		$this->esp_codigo = $esp_codigo;
	}

	/**
	 * @return float
	 */
	public function getVdPeso() {
		return $this->vd_peso;
	}

	/**
	 * @param float $vd_peso
	 */
	public function setVdPeso($vd_peso) {
		$this->vd_peso = $vd_peso;
	}

	/**
	 * @return float
	 */
	public function getVdAltura() {
		return $this->vd_altura;
	}

	/**
	 * @param float $vd_altura
	 */
	public function setVdAltura($vd_altura) {
		$this->vd_altura = $vd_altura;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}