<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 17:09
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="secretaria")
 */
class Secretaria extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @Column(name="codigo_secretaria", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=50, nullable=false)
	 */
	private $nome_secretaria;
	/**
	 * @var string
	 * @Column(type="string", length=30, nullable=false)
	 */
	private $cnes_secretaria;
	/**
	 * @var string
	 * @Column(type="string", length=30, nullable=false)
	 */
	private $cnpj_secretaria;
	/**
	 * @var string
	 * @Column(type="string", length=30, nullable=false)
	 */
	private $endereco_secretaria;
	/**
	 * @var string
	 * @Column(type="string", length=10, nullable=false)
	 */
	private $numero_end_secretaria;
	/**
	 * @var string
	 * @Column(type="string", length=3)
	 */
	private $sec_sigla;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $usu_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $nome_cidade;
	/**
	 * @var string
	 * @Column(type="string", length=3)
	 */
	private $tipo_secretaria;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $telefone_secretaria;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $sec_as;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $sec_bairro;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getNomeSecretaria() {
		return $this->nome_secretaria;
	}

	/**
	 * @param string $nome_secretaria
	 */
	public function setNomeSecretaria($nome_secretaria) {
		$this->nome_secretaria = $nome_secretaria;
	}

	/**
	 * @return string
	 */
	public function getCnesSecretaria() {
		return $this->cnes_secretaria;
	}

	/**
	 * @param string $cnes_secretaria
	 */
	public function setCnesSecretaria($cnes_secretaria) {
		$this->cnes_secretaria = $cnes_secretaria;
	}

	/**
	 * @return string
	 */
	public function getCnpjSecretaria() {
		return $this->cnpj_secretaria;
	}

	/**
	 * @param string $cnpj_secretaria
	 */
	public function setCnpjSecretaria($cnpj_secretaria) {
		$this->cnpj_secretaria = $cnpj_secretaria;
	}

	/**
	 * @return string
	 */
	public function getEnderecoSecretaria() {
		return $this->endereco_secretaria;
	}

	/**
	 * @param string $endereco_secretaria
	 */
	public function setEnderecoSecretaria($endereco_secretaria) {
		$this->endereco_secretaria = $endereco_secretaria;
	}

	/**
	 * @return string
	 */
	public function getNumeroEndSecretaria() {
		return $this->numero_end_secretaria;
	}

	/**
	 * @param string $numero_end_secretaria
	 */
	public function setNumeroEndSecretaria($numero_end_secretaria) {
		$this->numero_end_secretaria = $numero_end_secretaria;
	}

	/**
	 * @return string
	 */
	public function getSecSigla() {
		return $this->sec_sigla;
	}

	/**
	 * @param string $sec_sigla
	 */
	public function setSecSigla($sec_sigla) {
		$this->sec_sigla = $sec_sigla;
	}

	/**
	 * @return int
	 */
	public function getUsuCodigo() {
		return $this->usu_codigo;
	}

	/**
	 * @param int $usu_codigo
	 */
	public function setUsuCodigo($usu_codigo) {
		$this->usu_codigo = $usu_codigo;
	}

	/**
	 * @return string
	 */
	public function getNomeCidade() {
		return $this->nome_cidade;
	}

	/**
	 * @param string $nome_cidade
	 */
	public function setNomeCidade($nome_cidade) {
		$this->nome_cidade = $nome_cidade;
	}

	/**
	 * @return string
	 */
	public function getTipoSecretaria() {
		return $this->tipo_secretaria;
	}

	/**
	 * @param string $tipo_secretaria
	 */
	public function setTipoSecretaria($tipo_secretaria) {
		$this->tipo_secretaria = $tipo_secretaria;
	}

	/**
	 * @return string
	 */
	public function getTelefoneSecretaria() {
		return $this->telefone_secretaria;
	}

	/**
	 * @param string $telefone_secretaria
	 */
	public function setTelefoneSecretaria($telefone_secretaria) {
		$this->telefone_secretaria = $telefone_secretaria;
	}

	/**
	 * @return bool
	 */
	public function isSecAs() {
		return $this->sec_as;
	}

	/**
	 * @param bool $sec_as
	 */
	public function setSecAs($sec_as) {
		$this->sec_as = $sec_as;
	}

	/**
	 * @return string
	 */
	public function getSecBairro() {
		return $this->sec_bairro;
	}

	/**
	 * @param string $sec_bairro
	 */
	public function setSecBairro($sec_bairro) {
		$this->sec_bairro = $sec_bairro;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}