<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 12/03/2018
 * Time: 14:13
 */

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="setor")
 */
class Setor extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_setor")
	 * @Column(name="set_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $set_nome;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $set_estoque;
	/**
	 * @OneToOne(targetEntity="App\Entity\Unidade")
	 * @JoinColumn(name="uni_codigo", referencedColumnName="uni_codigo")
	 */
	private $unidade;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $set_farmacia;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $set_distribuidor;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $set_transferencia;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $ativo;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $mostra_saldo_estoque;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $mostra_alerta_estoque;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $qtd_dias_alerta;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getSetNome() {
		return $this->set_nome;
	}

	/**
	 * @param string $set_nome
	 */
	public function setSetNome($set_nome) {
		$this->set_nome = $set_nome;
	}

	/**
	 * @return string
	 */
	public function getSetEstoque() {
		return $this->set_estoque;
	}

	/**
	 * @param string $set_estoque
	 */
	public function setSetEstoque($set_estoque) {
		$this->set_estoque = $set_estoque;
	}

	/**
	 * @return mixed
	 */
	public function getUnidade() {
		return self::_returnArray($this->unidade);
	}

	/**
	 * @param mixed $unidade
	 */
	public function setUnidade($unidade) {
		$this->unidade = $unidade;
	}

	/**
	 * @return string
	 */
	public function getSetFarmacia() {
		return $this->set_farmacia;
	}

	/**
	 * @param string $set_farmacia
	 */
	public function setSetFarmacia($set_farmacia) {
		$this->set_farmacia = $set_farmacia;
	}

	/**
	 * @return string
	 */
	public function getSetDistribuidor() {
		return $this->set_distribuidor;
	}

	/**
	 * @param string $set_distribuidor
	 */
	public function setSetDistribuidor($set_distribuidor) {
		$this->set_distribuidor = $set_distribuidor;
	}

	/**
	 * @return string
	 */
	public function getSetTransferencia() {
		return $this->set_transferencia;
	}

	/**
	 * @param string $set_tranferencia
	 */
	public function setSetTransferencia($set_transferencia) {
		$this->set_transferencia = $set_transferencia;
	}

	/**
	 * @return string
	 */
	public function getAtivo() {
		return $this->ativo;
	}

	/**
	 * @param string $ativo
	 */
	public function setAtivo($ativo) {
		$this->ativo = $ativo;
	}

	/**
	 * @return string
	 */
	public function getMostraSaldoEstoque() {
		return $this->mostra_saldo_estoque;
	}

	/**
	 * @param string $mostra_saldo_estoque
	 */
	public function setMostraSaldoEstoque($mostra_saldo_estoque) {
		$this->mostra_saldo_estoque = $mostra_saldo_estoque;
	}

	/**
	 * @return string
	 */
	public function getMostraAlertaEstoque() {
		return $this->mostra_alerta_estoque;
	}

	/**
	 * @param string $mostra_alerta_estoque
	 */
	public function setMostraAlertaEstoque($mostra_alerta_estoque) {
		$this->mostra_alerta_estoque = $mostra_alerta_estoque;
	}

	/**
	 * @return int
	 */
	public function getQtdDiasAlerta() {
		return $this->qtd_dias_alerta;
	}

	/**
	 * @param int $qtd_dias_alerta
	 */
	public function setQtdDiasAlerta($qtd_dias_alerta) {
		$this->qtd_dias_alerta = $qtd_dias_alerta;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}
