<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 12/03/2018
 * Time: 14:17
 */

namespace App\Entity;

use Doctrine\Mapping as ORM;
use DateTime;

/**
 * @Entity
 * @Table(name="unidade")
 */
class Unidade extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_uni_codigo")
	 * @Column(name="uni_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */private $uni_desc;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $uni_endereco;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $uni_responsavel;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $uni_movimenta_estoque;
	/**
	 * @var string
	 * @Column(type="string", length=25)
	 */
	private $uni_cnpj;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $uni_tipo;
	/**
	 * @var string
	 * @Column(type="integer")
	 */
	private $uni_cnes;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $uni_numero;
	/**
	 * @var string
	 * @Column(type="string", length=9)
	 */
	private $uni_cep;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $uni_codigo_ibge;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $cod_ins;
	/**
	 * @var string
	 * @Column(type="string", length=31)
	 */
	private $cnes_unidade_id;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_bairro;
	/**
	 * @var string
	 * @Column(type="string", length=14)
	 */
	private $cnes_cnpj_mant;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_pfpj_ind;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_cod_siasus;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_nivel_dep;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_r_social;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_complement;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $cnes_reg_saude;
	/**
	 * @var string
	 * @Column(type="string", length=6)
	 */
	private $cnes_micro_reg;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $cnes_dist_sanit;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $cnes_dist_admin;
	/**
	 * @var string
	 * @Column(type="string", length=40)
	 */
	private $cnes_telefone;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_fax;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_e_mail;
	/**
	 * @var string
	 * @Column(type="string", length=11)
	 */
	private $cnes_cpf;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cod_esfadm;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $cnes_cod_ativ;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_reten_trib;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cod_natorg;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cod_client;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_num_alvara;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $cnes_data_exped;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_ind_orgexp;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_tp_unid_id;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cod_turnat;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_codnivhier;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_ind_uniesp;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_indvincsus;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_d_tercsih;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_sigestgest;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codmungest;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_statusmov;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codsiasus1;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codsiasus2;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codsiasus3;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codsiasus4;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codsiasus5;
	/**
	 * @var Datetime
	 * @Column(type="datetime")
	 */
	private $cnes_data_atu;
	/**
	 * @var string
	 * @Column(type="string", length=12)
	 */
	private $cnes_usuario;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_ativo;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $uni_bairro;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $uni_as;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $uni_astipo;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $uni_asnumero;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $uni_asbairro;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $uni_cnes_importacao = false;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $uni_cnes_importador_ignorar = false;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getUniDesc() {
		return $this->uni_desc;
	}

	/**
	 * @param string $uni_desc
	 */
	public function setUniDesc($uni_desc) {
		$this->uni_desc = $uni_desc;
	}

	/**
	 * @return string
	 */
	public function getUniEndereco() {
		return $this->uni_endereco;
	}

	/**
	 * @param string $uni_endereco
	 */
	public function setUniEndereco($uni_endereco) {
		$this->uni_endereco = $uni_endereco;
	}

	/**
	 * @return string
	 */
	public function getUniResponsavel() {
		return $this->uni_responsavel;
	}

	/**
	 * @param string $uni_responsavel
	 */
	public function setUniResponsavel($uni_responsavel) {
		$this->uni_responsavel = $uni_responsavel;
	}

	/**
	 * @return string
	 */
	public function getUniMovimentaEstoque() {
		return $this->uni_movimenta_estoque;
	}

	/**
	 * @param string $uni_movimenta_estoque
	 */
	public function setUniMovimentaEstoque($uni_movimenta_estoque) {
		$this->uni_movimenta_estoque = $uni_movimenta_estoque;
	}

	/**
	 * @return string
	 */
	public function getUniCnpj() {
		return $this->uni_cnpj;
	}

	/**
	 * @param string $uni_cnpj
	 */
	public function setUniCnpj($uni_cnpj) {
		$this->uni_cnpj = $uni_cnpj;
	}

	/**
	 * @return string
	 */
	public function getUniTipo() {
		return $this->uni_tipo;
	}

	/**
	 * @param string $uni_tipo
	 */
	public function setUniTipo($uni_tipo) {
		$this->uni_tipo = $uni_tipo;
	}

	/**
	 * @return string
	 */
	public function getUniCnes() {
		return $this->uni_cnes;
	}

	/**
	 * @param string $uni_cnes
	 */
	public function setUniCnes($uni_cnes) {
		$this->uni_cnes = $uni_cnes;
	}

	/**
	 * @return string
	 */
	public function getUniNumero() {
		return $this->uni_numero;
	}

	/**
	 * @param string $uni_numero
	 */
	public function setUniNumero($uni_numero) {
		$this->uni_numero = $uni_numero;
	}

	/**
	 * @return string
	 */
	public function getUniCep() {
		return $this->uni_cep;
	}

	/**
	 * @param string $uni_cep
	 */
	public function setUniCep($uni_cep) {
		$this->uni_cep = $uni_cep;
	}

	/**
	 * @return string
	 */
	public function getUniCodigoIbge() {
		return $this->uni_codigo_ibge;
	}

	/**
	 * @param string $uni_codigo_ibge
	 */
	public function setUniCodigoIbge($uni_codigo_ibge) {
		$this->uni_codigo_ibge = $uni_codigo_ibge;
	}

	/**
	 * @return int
	 */
	public function getCodIns() {
		return $this->cod_ins;
	}

	/**
	 * @param int $cod_ins
	 */
	public function setCodIns($cod_ins) {
		$this->cod_ins = $cod_ins;
	}

	/**
	 * @return string
	 */
	public function getCnesUnidadeId() {
		return $this->cnes_unidade_id;
	}

	/**
	 * @param string $cnes_unidade_id
	 */
	public function setCnesUnidadeId($cnes_unidade_id) {
		$this->cnes_unidade_id = $cnes_unidade_id;
	}

	/**
	 * @return string
	 */
	public function getCnesBairro() {
		return $this->cnes_bairro;
	}

	/**
	 * @param string $cnes_bairro
	 */
	public function setCnesBairro($cnes_bairro) {
		$this->cnes_bairro = $cnes_bairro;
	}

	/**
	 * @return string
	 */
	public function getCnesCnpjMant() {
		return $this->cnes_cnpj_mant;
	}

	/**
	 * @param string $cnes_cnpj_mant
	 */
	public function setCnesCnpjMant($cnes_cnpj_mant) {
		$this->cnes_cnpj_mant = $cnes_cnpj_mant;
	}

	/**
	 * @return string
	 */
	public function getCnesPfpjInd() {
		return $this->cnes_pfpj_ind;
	}

	/**
	 * @param string $cnes_pfpj_ind
	 */
	public function setCnesPfpjInd($cnes_pfpj_ind) {
		$this->cnes_pfpj_ind = $cnes_pfpj_ind;
	}

	/**
	 * @return string
	 */
	public function getCnesCodSiasus() {
		return $this->cnes_cod_siasus;
	}

	/**
	 * @param string $cnes_cod_siasus
	 */
	public function setCnesCodSiasus($cnes_cod_siasus) {
		$this->cnes_cod_siasus = $cnes_cod_siasus;
	}

	/**
	 * @return string
	 */
	public function getCnesNivelDep() {
		return $this->cnes_nivel_dep;
	}

	/**
	 * @param string $cnes_nivel_dep
	 */
	public function setCnesNivelDep($cnes_nivel_dep) {
		$this->cnes_nivel_dep = $cnes_nivel_dep;
	}

	/**
	 * @return string
	 */
	public function getCnesRSocial() {
		return $this->cnes_r_social;
	}

	/**
	 * @param string $cnes_r_social
	 */
	public function setCnesRSocial($cnes_r_social) {
		$this->cnes_r_social = $cnes_r_social;
	}

	/**
	 * @return string
	 */
	public function getCnesComplement() {
		return $this->cnes_complement;
	}

	/**
	 * @param string $cnes_complement
	 */
	public function setCnesComplement($cnes_complement) {
		$this->cnes_complement = $cnes_complement;
	}

	/**
	 * @return string
	 */
	public function getCnesRegSaude() {
		return $this->cnes_reg_saude;
	}

	/**
	 * @param string $cnes_reg_saude
	 */
	public function setCnesRegSaude($cnes_reg_saude) {
		$this->cnes_reg_saude = $cnes_reg_saude;
	}

	/**
	 * @return string
	 */
	public function getCnesMicroReg() {
		return $this->cnes_micro_reg;
	}

	/**
	 * @param string $cnes_micro_reg
	 */
	public function setCnesMicroReg($cnes_micro_reg) {
		$this->cnes_micro_reg = $cnes_micro_reg;
	}

	/**
	 * @return string
	 */
	public function getCnesDistSanit() {
		return $this->cnes_dist_sanit;
	}

	/**
	 * @param string $cnes_dist_sanit
	 */
	public function setCnesDistSanit($cnes_dist_sanit) {
		$this->cnes_dist_sanit = $cnes_dist_sanit;
	}

	/**
	 * @return string
	 */
	public function getCnesDistAdmin() {
		return $this->cnes_dist_admin;
	}

	/**
	 * @param string $cnes_dist_admin
	 */
	public function setCnesDistAdmin($cnes_dist_admin) {
		$this->cnes_dist_admin = $cnes_dist_admin;
	}

	/**
	 * @return string
	 */
	public function getCnesTelefone() {
		return $this->cnes_telefone;
	}

	/**
	 * @param string $cnes_telefone
	 */
	public function setCnesTelefone($cnes_telefone) {
		$this->cnes_telefone = $cnes_telefone;
	}

	/**
	 * @return string
	 */
	public function getCnesFax() {
		return $this->cnes_fax;
	}

	/**
	 * @param string $cnes_fax
	 */
	public function setCnesFax($cnes_fax) {
		$this->cnes_fax = $cnes_fax;
	}

	/**
	 * @return string
	 */
	public function getCnesEMail() {
		return $this->cnes_e_mail;
	}

	/**
	 * @param string $cnes_e_mail
	 */
	public function setCnesEMail($cnes_e_mail) {
		$this->cnes_e_mail = $cnes_e_mail;
	}

	/**
	 * @return string
	 */
	public function getCnesCpf() {
		return $this->cnes_cpf;
	}

	/**
	 * @param string $cnes_cpf
	 */
	public function setCnesCpf($cnes_cpf) {
		$this->cnes_cpf = $cnes_cpf;
	}

	/**
	 * @return string
	 */
	public function getCnesCodEsfadm() {
		return $this->cnes_cod_esfadm;
	}

	/**
	 * @param string $cnes_cod_esfadm
	 */
	public function setCnesCodEsfadm($cnes_cod_esfadm) {
		$this->cnes_cod_esfadm = $cnes_cod_esfadm;
	}

	/**
	 * @return string
	 */
	public function getCnesCodAtiv() {
		return $this->cnes_cod_ativ;
	}

	/**
	 * @param string $cnes_cod_ativ
	 */
	public function setCnesCodAtiv($cnes_cod_ativ) {
		$this->cnes_cod_ativ = $cnes_cod_ativ;
	}

	/**
	 * @return string
	 */
	public function getCnesRetenTrib() {
		return $this->cnes_reten_trib;
	}

	/**
	 * @param string $cnes_reten_trib
	 */
	public function setCnesRetenTrib($cnes_reten_trib) {
		$this->cnes_reten_trib = $cnes_reten_trib;
	}

	/**
	 * @return string
	 */
	public function getCnesCodNatorg() {
		return $this->cnes_cod_natorg;
	}

	/**
	 * @param string $cnes_cod_natorg
	 */
	public function setCnesCodNatorg($cnes_cod_natorg) {
		$this->cnes_cod_natorg = $cnes_cod_natorg;
	}

	/**
	 * @return string
	 */
	public function getCnesCodClient() {
		return $this->cnes_cod_client;
	}

	/**
	 * @param string $cnes_cod_client
	 */
	public function setCnesCodClient($cnes_cod_client) {
		$this->cnes_cod_client = $cnes_cod_client;
	}

	/**
	 * @return string
	 */
	public function getCnesNumAlvara() {
		return $this->cnes_num_alvara;
	}

	/**
	 * @param string $cnes_num_alvara
	 */
	public function setCnesNumAlvara($cnes_num_alvara) {
		$this->cnes_num_alvara = $cnes_num_alvara;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDataExped() {
		return self::_returnDate($this->cnes_data_exped);
	}

	/**
	 * @param DateTime $cnes_data_exped
	 */
	public function setCnesDataExped($cnes_data_exped) {
		$this->cnes_data_exped = $cnes_data_exped;
	}

	/**
	 * @return string
	 */
	public function getCnesIndOrgexp() {
		return $this->cnes_ind_orgexp;
	}

	/**
	 * @param string $cnes_ind_orgexp
	 */
	public function setCnesIndOrgexp($cnes_ind_orgexp) {
		$this->cnes_ind_orgexp = $cnes_ind_orgexp;
	}

	/**
	 * @return string
	 */
	public function getCnesTpUnidId() {
		return $this->cnes_tp_unid_id;
	}

	/**
	 * @param string $cnes_tp_unid_id
	 */
	public function setCnesTpUnidId($cnes_tp_unid_id) {
		$this->cnes_tp_unid_id = $cnes_tp_unid_id;
	}

	/**
	 * @return string
	 */
	public function getCnesCodTurnat() {
		return $this->cnes_cod_turnat;
	}

	/**
	 * @param string $cnes_cod_turnat
	 */
	public function setCnesCodTurnat($cnes_cod_turnat) {
		$this->cnes_cod_turnat = $cnes_cod_turnat;
	}

	/**
	 * @return string
	 */
	public function getCnesCodnivhier() {
		return $this->cnes_codnivhier;
	}

	/**
	 * @param string $cnes_codnivhier
	 */
	public function setCnesCodnivhier($cnes_codnivhier) {
		$this->cnes_codnivhier = $cnes_codnivhier;
	}

	/**
	 * @return string
	 */
	public function getCnesIndUniesp() {
		return $this->cnes_ind_uniesp;
	}

	/**
	 * @param string $cnes_ind_uniesp
	 */
	public function setCnesIndUniesp($cnes_ind_uniesp) {
		$this->cnes_ind_uniesp = $cnes_ind_uniesp;
	}

	/**
	 * @return string
	 */
	public function getCnesIndvincsus() {
		return $this->cnes_indvincsus;
	}

	/**
	 * @param string $cnes_indvincsus
	 */
	public function setCnesIndvincsus($cnes_indvincsus) {
		$this->cnes_indvincsus = $cnes_indvincsus;
	}

	/**
	 * @return string
	 */
	public function getCnesDTercsih() {
		return $this->cnes_d_tercsih;
	}

	/**
	 * @param string $cnes_d_tercsih
	 */
	public function setCnesDTercsih($cnes_d_tercsih) {
		$this->cnes_d_tercsih = $cnes_d_tercsih;
	}

	/**
	 * @return string
	 */
	public function getCnesSigestgest() {
		return $this->cnes_sigestgest;
	}

	/**
	 * @param string $cnes_sigestgest
	 */
	public function setCnesSigestgest($cnes_sigestgest) {
		$this->cnes_sigestgest = $cnes_sigestgest;
	}

	/**
	 * @return string
	 */
	public function getCnesCodmungest() {
		return $this->cnes_codmungest;
	}

	/**
	 * @param string $cnes_codmungest
	 */
	public function setCnesCodmungest($cnes_codmungest) {
		$this->cnes_codmungest = $cnes_codmungest;
	}

	/**
	 * @return string
	 */
	public function getCnesStatusmov() {
		return $this->cnes_statusmov;
	}

	/**
	 * @param string $cnes_statusmov
	 */
	public function setCnesStatusmov($cnes_statusmov) {
		$this->cnes_statusmov = $cnes_statusmov;
	}

	/**
	 * @return string
	 */
	public function getCnesCodsiasus1() {
		return $this->cnes_codsiasus1;
	}

	/**
	 * @param string $cnes_codsiasus1
	 */
	public function setCnesCodsiasus1($cnes_codsiasus1) {
		$this->cnes_codsiasus1 = $cnes_codsiasus1;
	}

	/**
	 * @return string
	 */
	public function getCnesCodsiasus2() {
		return $this->cnes_codsiasus2;
	}

	/**
	 * @param string $cnes_codsiasus2
	 */
	public function setCnesCodsiasus2($cnes_codsiasus2) {
		$this->cnes_codsiasus2 = $cnes_codsiasus2;
	}

	/**
	 * @return string
	 */
	public function getCnesCodsiasus3() {
		return $this->cnes_codsiasus3;
	}

	/**
	 * @param string $cnes_codsiasus3
	 */
	public function setCnesCodsiasus3($cnes_codsiasus3) {
		$this->cnes_codsiasus3 = $cnes_codsiasus3;
	}

	/**
	 * @return string
	 */
	public function getCnesCodsiasus4() {
		return $this->cnes_codsiasus4;
	}

	/**
	 * @param string $cnes_codsiasus4
	 */
	public function setCnesCodsiasus4($cnes_codsiasus4) {
		$this->cnes_codsiasus4 = $cnes_codsiasus4;
	}

	/**
	 * @return string
	 */
	public function getCnesCodsiasus5() {
		return $this->cnes_codsiasus5;
	}

	/**
	 * @param string $cnes_codsiasus5
	 */
	public function setCnesCodsiasus5($cnes_codsiasus5) {
		$this->cnes_codsiasus5 = $cnes_codsiasus5;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDataAtu() {
		return self::_returnDate($this->cnes_data_atu);
	}

	/**
	 * @param DateTime $cnes_data_atu
	 */
	public function setCnesDataAtu($cnes_data_atu) {
		$this->cnes_data_atu = $cnes_data_atu;
	}

	/**
	 * @return string
	 */
	public function getCnesUsuario() {
		return $this->cnes_usuario;
	}

	/**
	 * @param string $cnes_usuario
	 */
	public function setCnesUsuario($cnes_usuario) {
		$this->cnes_usuario = $cnes_usuario;
	}

	/**
	 * @return string
	 */
	public function getCnesAtivo() {
		return $this->cnes_ativo;
	}

	/**
	 * @param string $cnes_ativo
	 */
	public function setCnesAtivo($cnes_ativo) {
		$this->cnes_ativo = $cnes_ativo;
	}

	/**
	 * @return string
	 */
	public function getUniBairro() {
		return $this->uni_bairro;
	}

	/**
	 * @param string $uni_bairro
	 */
	public function setUniBairro($uni_bairro) {
		$this->uni_bairro = $uni_bairro;
	}

	/**
	 * @return bool
	 */
	public function isUniAs() {
		return $this->uni_as;
	}

	/**
	 * @param bool $uni_as
	 */
	public function setUniAs($uni_as) {
		$this->uni_as = $uni_as;
	}

	/**
	 * @return string
	 */
	public function getUniAstipo() {
		return $this->uni_astipo;
	}

	/**
	 * @param string $uni_astipo
	 */
	public function setUniAstipo($uni_astipo) {
		$this->uni_astipo = $uni_astipo;
	}

	/**
	 * @return string
	 */
	public function getUniAsnumero() {
		return $this->uni_asnumero;
	}

	/**
	 * @param string $uni_asnumero
	 */
	public function setUniAsnumero($uni_asnumero) {
		$this->uni_asnumero = $uni_asnumero;
	}

	/**
	 * @return string
	 */
	public function getUniAsbairro() {
		return $this->uni_asbairro;
	}

	/**
	 * @param string $uni_asbairro
	 */
	public function setUniAsbairro($uni_asbairro) {
		$this->uni_asbairro = $uni_asbairro;
	}

	/**
	 * @return bool
	 */
	public function isUniCnesImportacao() {
		return $this->uni_cnes_importacao;
	}

	/**
	 * @param bool $uni_cnes_importacao
	 */
	public function setUniCnesImportacao($uni_cnes_importacao) {
		$this->uni_cnes_importacao = $uni_cnes_importacao;
	}

	/**
	 * @return bool
	 */
	public function isUniCnesImportadorIgnorar() {
		return $this->uni_cnes_importador_ignorar;
	}

	/**
	 * @param bool $uni_cnes_importador_ignorar
	 */
	public function setUniCnesImportadorIgnorar($uni_cnes_importador_ignorar) {
		$this->uni_cnes_importador_ignorar = $uni_cnes_importador_ignorar;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}