<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 12/03/2018
 * Time: 14:14
 */

namespace App\Entity;


use Doctrine\Mapping as ORM;
use DateTime;

/**
 * @Entity
 * @Table(name="usuarios")
 */
class Usuario extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_usr_codigo_9041")
	 * @Column(name="usr_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $usr_login;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $usr_senha;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usr_nome;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $usr_email;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usr_funcao;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $usr_msn;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $usr_celular;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $uni_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_requisicao;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_consolidacao_automatica;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_ativo;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_mestre;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_transferencia;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $set_codigo;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usr_cod_ins;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_tipo;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usr_insert;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $usr_dtinsert;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usr_alter;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $usr_dtalter;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_psi;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_assistente_social;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_situacao;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_tipo_medico;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $usr_num_conselho;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $usr_medico_cnes;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $usr_carga_horaria;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $usr_cpf; //                                VARCHAR(15),;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $idbio;
//private $CONSTRAINT usuarios_idbio_fkey;
//private $REFERENCES cadastrodigital,;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_modulos;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $con_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=16)
	 */
	private $cnes_prof_id;
	/**
	 * @var string
	 * @Column(type="string", length=11)
	 */
	private $cnes_pispasep;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_nome_mae;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $cnes_data_nasc;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_cod_mun;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_sexo;
	/**
	 * @var string
	 * @Column(type="string", length=8)
	 */
	private $cnes_num_livro;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $cnes_num_folha;
	/**
	 * @var string
	 * @Column(type="string", length=8)
	 */
	private $cnes_num_termo;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_codorgemis;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $cnes_data_emiss;
	/**
	 * @var string
	 * @Column(type="string", length=14)
	 */
	private $cnes_num_ident;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_sigla_est;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $cnes_dtemiident;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $cnes_data_entra;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_ctps_numer;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $cnes_serie;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_sigestctps;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $cnes_dtemisctps;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_logradouro;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $cnes_numero;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_complement;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_bairrodist;
	/**
	 * @var string
	 * @Column(type="string", length=8)
	 */
	private $cnes_cod_cep;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $cnes_dt_iniativ;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_sigla_uf;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_codescolar;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cod_certid;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_ind_nacio;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_nome_carto;
	/**
	 * @var string
	 * @Column(type="string", length=3)
	 */
	private $cnes_cod_banco;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_nome_pais;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $cnes_num_agenc;
	/**
	 * @var string
	 * @Column(type="string", length=14)
	 */
	private $cnes_conta_cc;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_cod_cns;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_d_tercsih;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_status;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_statusmov;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $cnes_data_atu;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_usuario;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cd_raca;
	/**
	 * @var string
	 * @Column(type="string", length=40)
	 */
	private $cnes_telefone;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cd_sit_fam;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_fr_escolar;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_nome_pai;
	/**
	 * @var string
	 * @Column(type="string", length=3)
	 */
	private $cnes_cd_tp_logr;
	/**
	 * @var string
	 * @Column(type="string", length=13)
	 */
	private $cnes_tit_eleit;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $cnes_zona;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $cnes_secao;
	/**
	 * @var string
	 * @Column(type="string", length=16)
	 */
	private $cnes_portaria;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $cnes_dt_natur;
	/**
	 * @var string
	 * @Column(type="string", length=3)
	 */
	private $cnes_cd_pais;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_tp_sus_nao_sus;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_usu_importado_cnes;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_ativo;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $usr_ibge;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_troca_senha;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_restringe_atendimento_simplificado;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usr_digitador;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usr_odontologia_primeiro_acesso;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getUsrLogin() {
		return $this->usr_login;
	}

	/**
	 * @param string $usr_login
	 */
	public function setUsrLogin($usr_login) {
		$this->usr_login = $usr_login;
	}

	/**
	 * @return string
	 */
	public function getUsrSenha() {
		return $this->usr_senha;
	}

	/**
	 * @param string $usr_senha
	 */
	public function setUsrSenha($usr_senha) {
		$this->usr_senha = $usr_senha;
	}

	/**
	 * @return string
	 */
	public function getUsrNome() {
		return $this->usr_nome;
	}

	/**
	 * @param string $usr_nome
	 */
	public function setUsrNome($usr_nome) {
		$this->usr_nome = $usr_nome;
	}

	/**
	 * @return string
	 */
	public function getUsrEmail() {
		return $this->usr_email;
	}

	/**
	 * @param string $usr_email
	 */
	public function setUsrEmail($usr_email) {
		$this->usr_email = $usr_email;
	}

	/**
	 * @return string
	 */
	public function getUsrFuncao() {
		return $this->usr_funcao;
	}

	/**
	 * @param string $usr_funcao
	 */
	public function setUsrFuncao($usr_funcao) {
		$this->usr_funcao = $usr_funcao;
	}

	/**
	 * @return string
	 */
	public function getUsrMsn() {
		return $this->usr_msn;
	}

	/**
	 * @param string $usr_msn
	 */
	public function setUsrMsn($usr_msn) {
		$this->usr_msn = $usr_msn;
	}

	/**
	 * @return string
	 */
	public function getUsrCelular() {
		return $this->usr_celular;
	}

	/**
	 * @param string $usr_celular
	 */
	public function setUsrCelular($usr_celular) {
		$this->usr_celular = $usr_celular;
	}

	/**
	 * @return int
	 */
	public function getUniCodigo() {
		return $this->uni_codigo;
	}

	/**
	 * @param int $uni_codigo
	 */
	public function setUniCodigo($uni_codigo) {
		$this->uni_codigo = $uni_codigo;
	}

	/**
	 * @return string
	 */
	public function getUsrRequisicao() {
		return $this->usr_requisicao;
	}

	/**
	 * @param string $usr_requisicao
	 */
	public function setUsrRequisicao($usr_requisicao) {
		$this->usr_requisicao = $usr_requisicao;
	}

	/**
	 * @return string
	 */
	public function getUsrConsolidacaoAutomatica() {
		return $this->usr_consolidacao_automatica;
	}

	/**
	 * @param string $usr_consolidacao_automatica
	 */
	public function setUsrConsolidacaoAutomatica($usr_consolidacao_automatica) {
		$this->usr_consolidacao_automatica = $usr_consolidacao_automatica;
	}

	/**
	 * @return string
	 */
	public function getUsrAtivo() {
		return $this->usr_ativo;
	}

	/**
	 * @param string $usr_ativo
	 */
	public function setUsrAtivo($usr_ativo) {
		$this->usr_ativo = $usr_ativo;
	}

	/**
	 * @return string
	 */
	public function getUsrMestre() {
		return $this->usr_mestre;
	}

	/**
	 * @param string $usr_mestre
	 */
	public function setUsrMestre($usr_mestre) {
		$this->usr_mestre = $usr_mestre;
	}

	/**
	 * @return string
	 */
	public function getUsrTransferencia() {
		return $this->usr_transferencia;
	}

	/**
	 * @param string $usr_transferencia
	 */
	public function setUsrTransferencia($usr_transferencia) {
		$this->usr_transferencia = $usr_transferencia;
	}

	/**
	 * @return int
	 */
	public function getSetCodigo() {
		return $this->set_codigo;
	}

	/**
	 * @param int $set_codigo
	 */
	public function setSetCodigo($set_codigo) {
		$this->set_codigo = $set_codigo;
	}

	/**
	 * @return int
	 */
	public function getUsrCodIns() {
		return $this->usr_cod_ins;
	}

	/**
	 * @param int $usr_cod_ins
	 */
	public function setUsrCodIns($usr_cod_ins) {
		$this->usr_cod_ins = $usr_cod_ins;
	}

	/**
	 * @return string
	 */
	public function getUsrTipo() {
		return $this->usr_tipo;
	}

	/**
	 * @param string $usr_tipo
	 */
	public function setUsrTipo($usr_tipo) {
		$this->usr_tipo = $usr_tipo;
	}

	/**
	 * @return string
	 */
	public function getUsrInsert() {
		return $this->usr_insert;
	}

	/**
	 * @param string $usr_insert
	 */
	public function setUsrInsert($usr_insert) {
		$this->usr_insert = $usr_insert;
	}

	/**
	 * @return DateTime
	 */
	public function getUsrDtinsert() {
		return self::_returnDate($this->usr_dtinsert);
	}

	/**
	 * @param DateTime $usr_dtinsert
	 */
	public function setUsrDtinsert($usr_dtinsert) {
		$this->usr_dtinsert = $usr_dtinsert;
	}

	/**
	 * @return string
	 */
	public function getUsrAlter() {
		return $this->usr_alter;
	}

	/**
	 * @param string $usr_alter
	 */
	public function setUsrAlter($usr_alter) {
		$this->usr_alter = $usr_alter;
	}

	/**
	 * @return DateTime
	 */
	public function getUsrDtalter() {
		return self::_returnDate($this->usr_dtalter);
	}

	/**
	 * @param DateTime $usr_dtalter
	 */
	public function setUsrDtalter($usr_dtalter) {
		$this->usr_dtalter = $usr_dtalter;
	}

	/**
	 * @return string
	 */
	public function getUsrPsi() {
		return $this->usr_psi;
	}

	/**
	 * @param string $usr_psi
	 */
	public function setUsrPsi($usr_psi) {
		$this->usr_psi = $usr_psi;
	}

	/**
	 * @return string
	 */
	public function getUsrAssistenteSocial() {
		return $this->usr_assistente_social;
	}

	/**
	 * @param string $usr_assistente_social
	 */
	public function setUsrAssistenteSocial($usr_assistente_social) {
		$this->usr_assistente_social = $usr_assistente_social;
	}

	/**
	 * @return string
	 */
	public function getUsrSituacao() {
		return $this->usr_situacao;
	}

	/**
	 * @param string $usr_situacao
	 */
	public function setUsrSituacao($usr_situacao) {
		$this->usr_situacao = $usr_situacao;
	}

	/**
	 * @return string
	 */
	public function getUsrTipoMedico() {
		return $this->usr_tipo_medico;
	}

	/**
	 * @param string $usr_tipo_medico
	 */
	public function setUsrTipoMedico($usr_tipo_medico) {
		$this->usr_tipo_medico = $usr_tipo_medico;
	}

	/**
	 * @return string
	 */
	public function getUsrNumConselho() {
		return $this->usr_num_conselho;
	}

	/**
	 * @param string $usr_num_conselho
	 */
	public function setUsrNumConselho($usr_num_conselho) {
		$this->usr_num_conselho = $usr_num_conselho;
	}

	/**
	 * @return string
	 */
	public function getUsrMedicoCnes() {
		return $this->usr_medico_cnes;
	}

	/**
	 * @param string $usr_medico_cnes
	 */
	public function setUsrMedicoCnes($usr_medico_cnes) {
		$this->usr_medico_cnes = $usr_medico_cnes;
	}

	/**
	 * @return string
	 */
	public function getUsrCargaHoraria() {
		return $this->usr_carga_horaria;
	}

	/**
	 * @param string $usr_carga_horaria
	 */
	public function setUsrCargaHoraria($usr_carga_horaria) {
		$this->usr_carga_horaria = $usr_carga_horaria;
	}

	/**
	 * @return string
	 */
	public function getUsrCpf() {
		return $this->usr_cpf;
	}

	/**
	 * @param string $usr_cpf
	 */
	public function setUsrCpf($usr_cpf) {
		$this->usr_cpf = $usr_cpf;
	}

	/**
	 * @return int
	 */
	public function getIdbio() {
		return $this->idbio;
	}

	/**
	 * @param int $idbio
	 */
	public function setIdbio($idbio) {
		$this->idbio = $idbio;
	}

	/**
	 * @return string
	 */
	public function getUsrModulos() {
		return $this->usr_modulos;
	}

	/**
	 * @param string $usr_modulos
	 */
	public function setUsrModulos($usr_modulos) {
		$this->usr_modulos = $usr_modulos;
	}

	/**
	 * @return int
	 */
	public function getConCodigo() {
		return $this->con_codigo;
	}

	/**
	 * @param int $con_codigo
	 */
	public function setConCodigo($con_codigo) {
		$this->con_codigo = $con_codigo;
	}

	/**
	 * @return string
	 */
	public function getCnesProfId() {
		return $this->cnes_prof_id;
	}

	/**
	 * @param string $cnes_prof_id
	 */
	public function setCnesProfId($cnes_prof_id) {
		$this->cnes_prof_id = $cnes_prof_id;
	}

	/**
	 * @return string
	 */
	public function getCnesPispasep() {
		return $this->cnes_pispasep;
	}

	/**
	 * @param string $cnes_pispasep
	 */
	public function setCnesPispasep($cnes_pispasep) {
		$this->cnes_pispasep = $cnes_pispasep;
	}

	/**
	 * @return string
	 */
	public function getCnesNomeMae() {
		return $this->cnes_nome_mae;
	}

	/**
	 * @param string $cnes_nome_mae
	 */
	public function setCnesNomeMae($cnes_nome_mae) {
		$this->cnes_nome_mae = $cnes_nome_mae;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDataNasc() {
		return self::_returnDate($this->cnes_data_nasc);
	}

	/**
	 * @param DateTime $cnes_data_nasc
	 */
	public function setCnesDataNasc($cnes_data_nasc) {
		$this->cnes_data_nasc = $cnes_data_nasc;
	}

	/**
	 * @return string
	 */
	public function getCnesCodMun() {
		return $this->cnes_cod_mun;
	}

	/**
	 * @param string $cnes_cod_mun
	 */
	public function setCnesCodMun($cnes_cod_mun) {
		$this->cnes_cod_mun = $cnes_cod_mun;
	}

	/**
	 * @return string
	 */
	public function getCnesSexo() {
		return $this->cnes_sexo;
	}

	/**
	 * @param string $cnes_sexo
	 */
	public function setCnesSexo($cnes_sexo) {
		$this->cnes_sexo = $cnes_sexo;
	}

	/**
	 * @return string
	 */
	public function getCnesNumLivro() {
		return $this->cnes_num_livro;
	}

	/**
	 * @param string $cnes_num_livro
	 */
	public function setCnesNumLivro($cnes_num_livro) {
		$this->cnes_num_livro = $cnes_num_livro;
	}

	/**
	 * @return string
	 */
	public function getCnesNumFolha() {
		return $this->cnes_num_folha;
	}

	/**
	 * @param string $cnes_num_folha
	 */
	public function setCnesNumFolha($cnes_num_folha) {
		$this->cnes_num_folha = $cnes_num_folha;
	}

	/**
	 * @return string
	 */
	public function getCnesNumTermo() {
		return $this->cnes_num_termo;
	}

	/**
	 * @param string $cnes_num_termo
	 */
	public function setCnesNumTermo($cnes_num_termo) {
		$this->cnes_num_termo = $cnes_num_termo;
	}

	/**
	 * @return string
	 */
	public function getCnesCodorgemis() {
		return $this->cnes_codorgemis;
	}

	/**
	 * @param string $cnes_codorgemis
	 */
	public function setCnesCodorgemis($cnes_codorgemis) {
		$this->cnes_codorgemis = $cnes_codorgemis;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDataEmiss() {
		return self::_returnDate($this->cnes_data_emiss);
	}

	/**
	 * @param DateTime $cnes_data_emiss
	 */
	public function setCnesDataEmiss($cnes_data_emiss) {
		$this->cnes_data_emiss = $cnes_data_emiss;
	}

	/**
	 * @return string
	 */
	public function getCnesNumIdent() {
		return $this->cnes_num_ident;
	}

	/**
	 * @param string $cnes_num_ident
	 */
	public function setCnesNumIdent($cnes_num_ident) {
		$this->cnes_num_ident = $cnes_num_ident;
	}

	/**
	 * @return string
	 */
	public function getCnesSiglaEst() {
		return $this->cnes_sigla_est;
	}

	/**
	 * @param string $cnes_sigla_est
	 */
	public function setCnesSiglaEst($cnes_sigla_est) {
		$this->cnes_sigla_est = $cnes_sigla_est;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDtemiident() {
		return self::_returnDate($this->cnes_dtemiident);
	}

	/**
	 * @param DateTime $cnes_dtemiident
	 */
	public function setCnesDtemiident($cnes_dtemiident) {
		$this->cnes_dtemiident = $cnes_dtemiident;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDataEntra() {
		return self::_returnDate($this->cnes_data_entra);
	}

	/**
	 * @param DateTime $cnes_data_entra
	 */
	public function setCnesDataEntra($cnes_data_entra) {
		$this->cnes_data_entra = $cnes_data_entra;
	}

	/**
	 * @return string
	 */
	public function getCnesCtpsNumer() {
		return $this->cnes_ctps_numer;
	}

	/**
	 * @param string $cnes_ctps_numer
	 */
	public function setCnesCtpsNumer($cnes_ctps_numer) {
		$this->cnes_ctps_numer = $cnes_ctps_numer;
	}

	/**
	 * @return string
	 */
	public function getCnesSerie() {
		return $this->cnes_serie;
	}

	/**
	 * @param string $cnes_serie
	 */
	public function setCnesSerie($cnes_serie) {
		$this->cnes_serie = $cnes_serie;
	}

	/**
	 * @return string
	 */
	public function getCnesSigestctps() {
		return $this->cnes_sigestctps;
	}

	/**
	 * @param string $cnes_sigestctps
	 */
	public function setCnesSigestctps($cnes_sigestctps) {
		$this->cnes_sigestctps = $cnes_sigestctps;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDtemisctps() {
		return self::_returnDate($this->cnes_dtemisctps);
	}

	/**
	 * @param DateTime $cnes_dtemisctps
	 */
	public function setCnesDtemisctps($cnes_dtemisctps) {
		$this->cnes_dtemisctps = $cnes_dtemisctps;
	}

	/**
	 * @return string
	 */
	public function getCnesLogradouro() {
		return $this->cnes_logradouro;
	}

	/**
	 * @param string $cnes_logradouro
	 */
	public function setCnesLogradouro($cnes_logradouro) {
		$this->cnes_logradouro = $cnes_logradouro;
	}

	/**
	 * @return string
	 */
	public function getCnesNumero() {
		return $this->cnes_numero;
	}

	/**
	 * @param string $cnes_numero
	 */
	public function setCnesNumero($cnes_numero) {
		$this->cnes_numero = $cnes_numero;
	}

	/**
	 * @return string
	 */
	public function getCnesComplement() {
		return $this->cnes_complement;
	}

	/**
	 * @param string $cnes_complement
	 */
	public function setCnesComplement($cnes_complement) {
		$this->cnes_complement = $cnes_complement;
	}

	/**
	 * @return string
	 */
	public function getCnesBairrodist() {
		return $this->cnes_bairrodist;
	}

	/**
	 * @param string $cnes_bairrodist
	 */
	public function setCnesBairrodist($cnes_bairrodist) {
		$this->cnes_bairrodist = $cnes_bairrodist;
	}

	/**
	 * @return string
	 */
	public function getCnesCodCep() {
		return $this->cnes_cod_cep;
	}

	/**
	 * @param string $cnes_cod_cep
	 */
	public function setCnesCodCep($cnes_cod_cep) {
		$this->cnes_cod_cep = $cnes_cod_cep;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDtIniativ() {
		return self::_returnDate($this->cnes_dt_iniativ);
	}

	/**
	 * @param DateTime $cnes_dt_iniativ
	 */
	public function setCnesDtIniativ($cnes_dt_iniativ) {
		$this->cnes_dt_iniativ = $cnes_dt_iniativ;
	}

	/**
	 * @return string
	 */
	public function getCnesSiglaUf() {
		return $this->cnes_sigla_uf;
	}

	/**
	 * @param string $cnes_sigla_uf
	 */
	public function setCnesSiglaUf($cnes_sigla_uf) {
		$this->cnes_sigla_uf = $cnes_sigla_uf;
	}

	/**
	 * @return string
	 */
	public function getCnesCodescolar() {
		return $this->cnes_codescolar;
	}

	/**
	 * @param string $cnes_codescolar
	 */
	public function setCnesCodescolar($cnes_codescolar) {
		$this->cnes_codescolar = $cnes_codescolar;
	}

	/**
	 * @return string
	 */
	public function getCnesCodCertid() {
		return $this->cnes_cod_certid;
	}

	/**
	 * @param string $cnes_cod_certid
	 */
	public function setCnesCodCertid($cnes_cod_certid) {
		$this->cnes_cod_certid = $cnes_cod_certid;
	}

	/**
	 * @return string
	 */
	public function getCnesIndNacio() {
		return $this->cnes_ind_nacio;
	}

	/**
	 * @param string $cnes_ind_nacio
	 */
	public function setCnesIndNacio($cnes_ind_nacio) {
		$this->cnes_ind_nacio = $cnes_ind_nacio;
	}

	/**
	 * @return string
	 */
	public function getCnesNomeCarto() {
		return $this->cnes_nome_carto;
	}

	/**
	 * @param string $cnes_nome_carto
	 */
	public function setCnesNomeCarto($cnes_nome_carto) {
		$this->cnes_nome_carto = $cnes_nome_carto;
	}

	/**
	 * @return string
	 */
	public function getCnesCodBanco() {
		return $this->cnes_cod_banco;
	}

	/**
	 * @param string $cnes_cod_banco
	 */
	public function setCnesCodBanco($cnes_cod_banco) {
		$this->cnes_cod_banco = $cnes_cod_banco;
	}

	/**
	 * @return string
	 */
	public function getCnesNomePais() {
		return $this->cnes_nome_pais;
	}

	/**
	 * @param string $cnes_nome_pais
	 */
	public function setCnesNomePais($cnes_nome_pais) {
		$this->cnes_nome_pais = $cnes_nome_pais;
	}

	/**
	 * @return string
	 */
	public function getCnesNumAgenc() {
		return $this->cnes_num_agenc;
	}

	/**
	 * @param string $cnes_num_agenc
	 */
	public function setCnesNumAgenc($cnes_num_agenc) {
		$this->cnes_num_agenc = $cnes_num_agenc;
	}

	/**
	 * @return string
	 */
	public function getCnesContaCc() {
		return $this->cnes_conta_cc;
	}

	/**
	 * @param string $cnes_conta_cc
	 */
	public function setCnesContaCc($cnes_conta_cc) {
		$this->cnes_conta_cc = $cnes_conta_cc;
	}

	/**
	 * @return string
	 */
	public function getCnesCodCns() {
		return $this->cnes_cod_cns;
	}

	/**
	 * @param string $cnes_cod_cns
	 */
	public function setCnesCodCns($cnes_cod_cns) {
		$this->cnes_cod_cns = $cnes_cod_cns;
	}

	/**
	 * @return string
	 */
	public function getCnesDTercsih() {
		return $this->cnes_d_tercsih;
	}

	/**
	 * @param string $cnes_d_tercsih
	 */
	public function setCnesDTercsih($cnes_d_tercsih) {
		$this->cnes_d_tercsih = $cnes_d_tercsih;
	}

	/**
	 * @return string
	 */
	public function getCnesStatus() {
		return $this->cnes_status;
	}

	/**
	 * @param string $cnes_status
	 */
	public function setCnesStatus($cnes_status) {
		$this->cnes_status = $cnes_status;
	}

	/**
	 * @return string
	 */
	public function getCnesStatusmov() {
		return $this->cnes_statusmov;
	}

	/**
	 * @param string $cnes_statusmov
	 */
	public function setCnesStatusmov($cnes_statusmov) {
		$this->cnes_statusmov = $cnes_statusmov;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDataAtu() {
		return self::_returnDate($this->cnes_data_atu);
	}

	/**
	 * @param DateTime $cnes_data_atu
	 */
	public function setCnesDataAtu($cnes_data_atu) {
		$this->cnes_data_atu = $cnes_data_atu;
	}

	/**
	 * @return string
	 */
	public function getCnesUsuario() {
		return $this->cnes_usuario;
	}

	/**
	 * @param string $cnes_usuario
	 */
	public function setCnesUsuario($cnes_usuario) {
		$this->cnes_usuario = $cnes_usuario;
	}

	/**
	 * @return string
	 */
	public function getCnesCdRaca() {
		return $this->cnes_cd_raca;
	}

	/**
	 * @param string $cnes_cd_raca
	 */
	public function setCnesCdRaca($cnes_cd_raca) {
		$this->cnes_cd_raca = $cnes_cd_raca;
	}

	/**
	 * @return string
	 */
	public function getCnesTelefone() {
		return $this->cnes_telefone;
	}

	/**
	 * @param string $cnes_telefone
	 */
	public function setCnesTelefone($cnes_telefone) {
		$this->cnes_telefone = $cnes_telefone;
	}

	/**
	 * @return string
	 */
	public function getCnesCdSitFam() {
		return $this->cnes_cd_sit_fam;
	}

	/**
	 * @param string $cnes_cd_sit_fam
	 */
	public function setCnesCdSitFam($cnes_cd_sit_fam) {
		$this->cnes_cd_sit_fam = $cnes_cd_sit_fam;
	}

	/**
	 * @return string
	 */
	public function getCnesFrEscolar() {
		return $this->cnes_fr_escolar;
	}

	/**
	 * @param string $cnes_fr_escolar
	 */
	public function setCnesFrEscolar($cnes_fr_escolar) {
		$this->cnes_fr_escolar = $cnes_fr_escolar;
	}

	/**
	 * @return string
	 */
	public function getCnesNomePai() {
		return $this->cnes_nome_pai;
	}

	/**
	 * @param string $cnes_nome_pai
	 */
	public function setCnesNomePai($cnes_nome_pai) {
		$this->cnes_nome_pai = $cnes_nome_pai;
	}

	/**
	 * @return string
	 */
	public function getCnesCdTpLogr() {
		return $this->cnes_cd_tp_logr;
	}

	/**
	 * @param string $cnes_cd_tp_logr
	 */
	public function setCnesCdTpLogr($cnes_cd_tp_logr) {
		$this->cnes_cd_tp_logr = $cnes_cd_tp_logr;
	}

	/**
	 * @return string
	 */
	public function getCnesTitEleit() {
		return $this->cnes_tit_eleit;
	}

	/**
	 * @param string $cnes_tit_eleit
	 */
	public function setCnesTitEleit($cnes_tit_eleit) {
		$this->cnes_tit_eleit = $cnes_tit_eleit;
	}

	/**
	 * @return string
	 */
	public function getCnesZona() {
		return $this->cnes_zona;
	}

	/**
	 * @param string $cnes_zona
	 */
	public function setCnesZona($cnes_zona) {
		$this->cnes_zona = $cnes_zona;
	}

	/**
	 * @return string
	 */
	public function getCnesSecao() {
		return $this->cnes_secao;
	}

	/**
	 * @param string $cnes_secao
	 */
	public function setCnesSecao($cnes_secao) {
		$this->cnes_secao = $cnes_secao;
	}

	/**
	 * @return string
	 */
	public function getCnesPortaria() {
		return $this->cnes_portaria;
	}

	/**
	 * @param string $cnes_portaria
	 */
	public function setCnesPortaria($cnes_portaria) {
		$this->cnes_portaria = $cnes_portaria;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDtNatur() {
		return self::_returnDate($this->cnes_dt_natur);
	}

	/**
	 * @param DateTime $cnes_dt_natur
	 */
	public function setCnesDtNatur($cnes_dt_natur) {
		$this->cnes_dt_natur = $cnes_dt_natur;
	}

	/**
	 * @return string
	 */
	public function getCnesCdPais() {
		return $this->cnes_cd_pais;
	}

	/**
	 * @param string $cnes_cd_pais
	 */
	public function setCnesCdPais($cnes_cd_pais) {
		$this->cnes_cd_pais = $cnes_cd_pais;
	}

	/**
	 * @return string
	 */
	public function getCnesTpSusNaoSus() {
		return $this->cnes_tp_sus_nao_sus;
	}

	/**
	 * @param string $cnes_tp_sus_nao_sus
	 */
	public function setCnesTpSusNaoSus($cnes_tp_sus_nao_sus) {
		$this->cnes_tp_sus_nao_sus = $cnes_tp_sus_nao_sus;
	}

	/**
	 * @return string
	 */
	public function getCnesUsuImportadoCnes() {
		return $this->cnes_usu_importado_cnes;
	}

	/**
	 * @param string $cnes_usu_importado_cnes
	 */
	public function setCnesUsuImportadoCnes($cnes_usu_importado_cnes) {
		$this->cnes_usu_importado_cnes = $cnes_usu_importado_cnes;
	}

	/**
	 * @return string
	 */
	public function getCnesAtivo() {
		return $this->cnes_ativo;
	}

	/**
	 * @param string $cnes_ativo
	 */
	public function setCnesAtivo($cnes_ativo) {
		$this->cnes_ativo = $cnes_ativo;
	}

	/**
	 * @return int
	 */
	public function getUsrIbge() {
		return $this->usr_ibge;
	}

	/**
	 * @param int $usr_ibge
	 */
	public function setUsrIbge($usr_ibge) {
		$this->usr_ibge = $usr_ibge;
	}

	/**
	 * @return string
	 */
	public function getUsrTrocaSenha() {
		return $this->usr_troca_senha;
	}

	/**
	 * @param string $usr_troca_senha
	 */
	public function setUsrTrocaSenha($usr_troca_senha) {
		$this->usr_troca_senha = $usr_troca_senha;
	}

	/**
	 * @return string
	 */
	public function getUsrRestringeAtendimentoSimplificado() {
		return $this->usr_restringe_atendimento_simplificado;
	}

	/**
	 * @param string $usr_restringe_atendimento_simplificado
	 */
	public function setUsrRestringeAtendimentoSimplificado($usr_restringe_atendimento_simplificado) {
		$this->usr_restringe_atendimento_simplificado = $usr_restringe_atendimento_simplificado;
	}

	/**
	 * @return string
	 */
	public function getUsrDigitador() {
		return $this->usr_digitador;
	}

	/**
	 * @param string $usr_digitador
	 */
	public function setUsrDigitador($usr_digitador) {
		$this->usr_digitador = $usr_digitador;
	}

	/**
	 * @return bool
	 */
	public function isUsrOdontologiaPrimeiroAcesso() {
		return $this->usr_odontologia_primeiro_acesso;
	}

	/**
	 * @param bool $usr_odontologia_primeiro_acesso
	 */
	public function setUsrOdontologiaPrimeiroAcesso($usr_odontologia_primeiro_acesso) {
		$this->usr_odontologia_primeiro_acesso = $usr_odontologia_primeiro_acesso;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}
