<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 12:18
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;
use DateTime;

/**
 * @Entity
 * @Table(name="usuario")
 */
class Cidadao extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_usu_codigo")
	 * @Column(name="usu_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_nome;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $fam_codigo;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $usu_observacao;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_sexo;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $usu_datanasc;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $cid_codigo_nasc;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $usu_dt_entrada_pais;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_sit_familiar;
	/**
	 * @var string
	 * @Column(type="string", length=30)
	 */
	private $usu_ocupacao;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $usu_cbo_r1;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_pis_pasep;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $usu_cpf;
	/**
	 * @var string
	 * @Column(type="string", length=18)
	 */
	private $usu_cartao_p_sus;
	/**
	 * @var string
	 * @Column(type="string", length=30)
	 */
	private $usu_cartao_sus;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $usu_tipo_certidao;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_cert_cartorio;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $usu_cert_livro;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $usu_cert_termo;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $usu_cert_emissao;
	/**
	 * @var string
	 * @Column(type="string", length=16)
	 */
	private $usu_rg;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $usu_rg_compl;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $usu_rg_dt_emissao;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $usu_ctps;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $usu_ctps_serie;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $usu_ctps_dt_emissao;
	/**
	 * @var string
	 * @Column(type="string", length=14)
	 */
	private $usu_tit_eleitor;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $usu_tit_eleitor_zona;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $usu_tit_eleitor_secao;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_mae;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_pai;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $rac_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $usu_cisvir;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $usu_end_rua;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $usu_end_nr;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_end_compl;
	/**
	 * @var string
	 * @Column(type="string", length=30)
	 */
	private $usu_end_bairro;
	/**
	 * @var string
	 * @Column(type="string", length=9)
	 */
	private $usu_end_cep;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_end_cidade;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_cidade_nasc;
	/**
	 * @var string
	 * @Column(type="string", length=17)
	 */
	private $usu_fone;
	/**
	 * @var string
	 * @Column(type="string", length=17)
	 */
	private $usu_celular;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $usu_same;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $usu_prontuario;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $uni_origem;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_freq_escolar;
	/**
	 * @var string
	 * @Column(type="string", length=50)
	 */
	private $uni_unidade_bkp;
	/**
	 * @OneToOne(targetEntity="Usuario")
	 * @JoinColumn(name="usr_cad", referencedColumnName="usr_codigo")
	 */
	private $usuario_cadastro;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $usr_alt;
	/**
	 * @var DateTime
	 * @Column(type="datetimetz")
	 */
	private $dt_add;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $dt_update;
	/**
	 * @var string
	 * @Column(type="string", length=50)
	 */
	private $usu_ibge_codigo;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $id_rua;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $usu_resp_nome;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $usu_resp_doc_tipo;
	/**
	 * @var string
	 * @Column(type="string", length=30)
	 */
	private $usu_resp_doc;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $usr_cad_dt;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $usr_alt_dt;
	/**
	 * @var string
	 * @Column(type="string", length=7, options={"default": ""})
	 */
	private $muni_cd_cod_ibge_resid;
	/**
	 * @var integer
	 * @Column(type="bigint", options={"default": 0})
	 */
	private $uni_unidade;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $muni_cd_cod_ibge_nasc;
	/**
	 * @var string
	 * @Column(type="string", length=58, options={"default": ""})
	 */
	private $id_usuario;
	/**
	 * @var string
	 * @Column(type="string", length=3)
	 */
	private $cd_nacionalidade;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $dt_naturalizacao;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $dt_preenchimento_form;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $dt_inclusao;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $dt_alteracao;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $nr_uso_municipal;
	/**
	 * @var string
	 * @Column(type="string", length=16)
	 */
	private $nr_portaria_naturalizacao;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $uf_codigo_pac;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_escolaridade;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_st_conjugal;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usu_nr_ficha;
	/**
	 * @var string
	 * @Column(type="string", length=6)
	 */
	private $usu_cadastrador;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_bolsa_alimentacao;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_prodea;
	/**
	 * @var string
	 * @Column(type="string", length=8)
	 */
	private $usu_nome_operador;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_situacao_emprego;
	/**
	 * @var double
	 * @Column(type="decimal", precision=20, scale=2)
	 */
	private $usu_renda_media;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $usu_doencas;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $usu_habitos_vida;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $usu_nr_lote;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_reservista;
	/**
	 * @var string
	 * @Column(type="string", length=30)
	 */
	private $usu_cnh_numero;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_cnh_categoria;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $usu_fone_recado;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $usu_email;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_zona_residencia;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_estado_civil;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_conjuge;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $nesp_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_bolsa_familia;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_transporte_publico;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_cert_civil_emissor;
	/**
	 * @var string
	 * @Column(type="string", length=11)
	 */
	private $usu_nis;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $usu_data_cad;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usu_qtd_comodos;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usu_prontuario_num;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $usu_cert_cartorio_nasc;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $usu_cert_livro_nasc;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $usu_cert_lv_fls_nasc;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $usu_cert_termo_nasc;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_gestor;
	/**
	 * @OneToOne(targetEntity="Secretaria")
	 * @JoinColumn(name="codigo_secretaria", referencedColumnName="codigo_secretaria")
	 */
	private $secretaria;
	/**
	 * @var string
	 * @Column(type="string", length=3)
	 */
	private $pais_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=58)
	 */
	private $usu_codigo_sus;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $usu_dt_obito;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_obito;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_uf_cert_civil;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $uf_sigla_rg;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $uf_sigla_ctps;
	/**
	 * @var string
	 * @Column(type="string", length=1, options={"default": "S"})
	 */
	private $usu_ativacao;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $usu_dt_ativacao_desativacao;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $usu_cert_emissao_nasc;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_tipo_esgoto;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_tipo_const_casa;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_rede_eletrica;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_tipo_abast_agua;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $usu_cbo_r;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $usu_cert_lv_fls;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $usu_codigo_pai;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $usu_codigo_mae;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $usu_codigo_conjuge;
	/**
	 * @var string
	 * @Column(type="string", length=32)
	 */
	private $usu_codigo_enc;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_codigo_ver;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $ecd_codigo;
//	/**
//	 * @OneToOne(targetEntity="Domicilio")
//	 * @JoinColumn(name="dom_codigo", referencedColumnName="dom_codigo")
//	 */
	/**
	 * @var string
	 * @Column(type="string", length=30, name="dom_codigo")
	 */
	private $domicilio;
	/**
	 * @var string
	 * @Column(type="string", length=1, options={"default": "N"})
	 */
	private $usu_plano_saude;
	/**
	 * @var string
	 * @Column(type="string", length=30)
	 */
	private $usu_desc_plano_saude;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $etn_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_fator_rh;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $usu_tipo_sanguineo;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_rg_emissor;
	/**
	 * @var boolean
	 * @Column(type="boolean", options={"default": false})
	 */
	private $usu_bloqueado;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $uni_codigo_obito;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $cd10_codigo_obito;
	/**
	 * @var string
	 * @Column(type="string", length=150)
	 */
	private $usu_nome_resp;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $usu_importacao;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usr_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $usu_foto_nome;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $idbio;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $usu_chefe;
	/**
	 * @var mixed
	 * @Column(type="string")
	 */
	private $usu_foto;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $usu_st_responsavel_familiar;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $usu_cns_responsavel_familiar;
	/**
	 * @OneToOne(targetEntity="Unidade")
	 * @JoinColumn(name="uni_codigo", referencedColumnName="uni_codigo")
	 */
	private $unidade;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $estc_codigo;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_as_aposentado;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_as_bpc;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_asdeficiencia;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_asdoc_cnprov;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_asdoc_rgprov;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_asdoc_ctpsprov;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_asdoc_cpfprov;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_asdoc_teprov;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_as_apelido;
	/**
	 * @var boolean
	 * @Column(type="boolean", options={"default": false})
	 */
	private $usu_asps_ativo;
	/**
	 * @var boolean
	 * @Column(type="boolean", options={"default": false})
	 */
	private $usu_asps_ref;
	/**
	 * @var boolean
	 * @Column(type="boolean", options={"default": true})
	 */
	private $as_usu_alfabetizado;
	/**
	 * @var boolean
	 * @Column(type="boolean", options={"default": true})
	 */
	private $as_usu_estuda;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $as_usu_escolaridade;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $as_cond_ocupacao;
	/**
	 * @var boolean
	 * @Column(type="boolean", options={"default": false})
	 */
	private $as_possui_qualificacao;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $as_possui_qualificacao_qual;
	/**
	 * @var double
	 * @Column(type="decimal", precision=20, scale=2)
	 */
	private $as_renda_mensal;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $usu_as_tipo_deficiencia;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_as_cuidado_constante;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $usu_as_resp_cuidado;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_as_doenca_grava;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_as_remedio_controlado;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_as_alcoolatra;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_as_drogado;
	/**
	 * @var boolean
	 * @Column(type="boolean", options={"default": false})
	 */
	private $usu_as_situacao;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $usu_sit_rua;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_deficiencia;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $usu_recado;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $aspsu_parentesco;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_tem_diabete;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_esta_gestante;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $usu_tem_hipertensao;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_filiacao;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_natural;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_situacao_renda;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_fone_comercial;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_endereco_comercial;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_bairro_comercial;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_complemento_comercial;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_municipio_comercial;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_uf_comercial;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_tempo_servico;
	/**
	 * @OneToOne(targetEntity="EsusPais")
	 * @JoinColumn(name="epa_codigo", referencedColumnName="epa_codigo")
	 */
	private $esus_pais;
	/**
	 * @var boolean
	 * @Column(type="boolean", options={"default": false})
	 */
	private $usu_origem_prontuario;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $usu_nome_social;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getUsuNome() {
		return $this->usu_nome;
	}

	/**
	 * @param string $usu_nome
	 */
	public function setUsuNome($usu_nome) {
		$this->usu_nome = $usu_nome;
	}

	/**
	 * @return int
	 */
	public function getFamCodigo() {
		return $this->fam_codigo;
	}

	/**
	 * @param int $fam_codigo
	 */
	public function setFamCodigo($fam_codigo) {
		$this->fam_codigo = $fam_codigo;
	}

	/**
	 * @return string
	 */
	public function getUsuObservacao() {
		return $this->usu_observacao;
	}

	/**
	 * @param string $usu_observacao
	 */
	public function setUsuObservacao($usu_observacao) {
		$this->usu_observacao = $usu_observacao;
	}

	/**
	 * @return string
	 */
	public function getUsuSexo() {
		return $this->usu_sexo;
	}

	/**
	 * @param string $usu_sexo
	 */
	public function setUsuSexo($usu_sexo) {
		$this->usu_sexo = $usu_sexo;
	}

	/**
	 * @return DateTime
	 */
	public function getUsuDatanasc() {
		return self::_returnDate($this->usu_datanasc);
	}

	/**
	 * @param DateTime $usu_datanasc
	 */
	public function setUsuDatanasc($usu_datanasc) {
		$this->usu_datanasc = $usu_datanasc;
	}

	/**
	 * @return int
	 */
	public function getCidCodigoNasc() {
		return $this->cid_codigo_nasc;
	}

	/**
	 * @param int $cid_codigo_nasc
	 */
	public function setCidCodigoNasc($cid_codigo_nasc) {
		$this->cid_codigo_nasc = $cid_codigo_nasc;
	}

	/**
	 * @return DateTime
	 */
	public function getUsuDtEntradaPais() {
		return self::_returnDate($this->usu_dt_entrada_pais);
	}

	/**
	 * @param DateTime $usu_dt_entrada_pais
	 */
	public function setUsuDtEntradaPais($usu_dt_entrada_pais) {
		$this->usu_dt_entrada_pais = $usu_dt_entrada_pais;
	}

	/**
	 * @return string
	 */
	public function getUsuSitFamiliar() {
		return $this->usu_sit_familiar;
	}

	/**
	 * @param string $usu_sit_familiar
	 */
	public function setUsuSitFamiliar($usu_sit_familiar) {
		$this->usu_sit_familiar = $usu_sit_familiar;
	}

	/**
	 * @return string
	 */
	public function getUsuOcupacao() {
		return $this->usu_ocupacao;
	}

	/**
	 * @param string $usu_ocupacao
	 */
	public function setUsuOcupacao($usu_ocupacao) {
		$this->usu_ocupacao = $usu_ocupacao;
	}

	/**
	 * @return int
	 */
	public function getUsuCboR1() {
		return $this->usu_cbo_r1;
	}

	/**
	 * @param int $usu_cbo_r1
	 */
	public function setUsuCboR1($usu_cbo_r1) {
		$this->usu_cbo_r1 = $usu_cbo_r1;
	}

	/**
	 * @return string
	 */
	public function getUsuPisPasep() {
		return $this->usu_pis_pasep;
	}

	/**
	 * @param string $usu_pis_pasep
	 */
	public function setUsuPisPasep($usu_pis_pasep) {
		$this->usu_pis_pasep = $usu_pis_pasep;
	}

	/**
	 * @return string
	 */
	public function getUsuCpf() {
		return $this->usu_cpf;
	}

	/**
	 * @param string $usu_cpf
	 */
	public function setUsuCpf($usu_cpf) {
		$this->usu_cpf = $usu_cpf;
	}

	/**
	 * @return string
	 */
	public function getUsuCartaoPSus() {
		return $this->usu_cartao_p_sus;
	}

	/**
	 * @param string $usu_cartao_p_sus
	 */
	public function setUsuCartaoPSus($usu_cartao_p_sus) {
		$this->usu_cartao_p_sus = $usu_cartao_p_sus;
	}

	/**
	 * @return string
	 */
	public function getUsuCartaoSus() {
		return $this->usu_cartao_sus;
	}

	/**
	 * @param string $usu_cartao_sus
	 */
	public function setUsuCartaoSus($usu_cartao_sus) {
		$this->usu_cartao_sus = $usu_cartao_sus;
	}

	/**
	 * @return int
	 */
	public function getUsuTipoCertidao() {
		return $this->usu_tipo_certidao;
	}

	/**
	 * @param int $usu_tipo_certidao
	 */
	public function setUsuTipoCertidao($usu_tipo_certidao) {
		$this->usu_tipo_certidao = $usu_tipo_certidao;
	}

	/**
	 * @return string
	 */
	public function getUsuCertCartorio() {
		return $this->usu_cert_cartorio;
	}

	/**
	 * @param string $usu_cert_cartorio
	 */
	public function setUsuCertCartorio($usu_cert_cartorio) {
		$this->usu_cert_cartorio = $usu_cert_cartorio;
	}

	/**
	 * @return string
	 */
	public function getUsuCertLivro() {
		return $this->usu_cert_livro;
	}

	/**
	 * @param string $usu_cert_livro
	 */
	public function setUsuCertLivro($usu_cert_livro) {
		$this->usu_cert_livro = $usu_cert_livro;
	}

	/**
	 * @return string
	 */
	public function getUsuCertTermo() {
		return $this->usu_cert_termo;
	}

	/**
	 * @param string $usu_cert_termo
	 */
	public function setUsuCertTermo($usu_cert_termo) {
		$this->usu_cert_termo = $usu_cert_termo;
	}

	/**
	 * @return DateTime
	 */
	public function getUsuCertEmissao() {
		return self::_returnDate($this->usu_cert_emissao);
	}

	/**
	 * @param DateTime $usu_cert_emissao
	 */
	public function setUsuCertEmissao($usu_cert_emissao) {
		$this->usu_cert_emissao = $usu_cert_emissao;
	}

	/**
	 * @return string
	 */
	public function getUsuRg() {
		return $this->usu_rg;
	}

	/**
	 * @param string $usu_rg
	 */
	public function setUsuRg($usu_rg) {
		$this->usu_rg = $usu_rg;
	}

	/**
	 * @return string
	 */
	public function getUsuRgCompl() {
		return $this->usu_rg_compl;
	}

	/**
	 * @param string $usu_rg_compl
	 */
	public function setUsuRgCompl($usu_rg_compl) {
		$this->usu_rg_compl = $usu_rg_compl;
	}

	/**
	 * @return DateTime
	 */
	public function getUsuRgDtEmissao() {
		return self::_returnDate($this->usu_rg_dt_emissao);
	}

	/**
	 * @param DateTime $usu_rg_dt_emissao
	 */
	public function setUsuRgDtEmissao($usu_rg_dt_emissao) {
		$this->usu_rg_dt_emissao = $usu_rg_dt_emissao;
	}

	/**
	 * @return string
	 */
	public function getUsuCtps() {
		return $this->usu_ctps;
	}

	/**
	 * @param string $usu_ctps
	 */
	public function setUsuCtps($usu_ctps) {
		$this->usu_ctps = $usu_ctps;
	}

	/**
	 * @return string
	 */
	public function getUsuCtpsSerie() {
		return $this->usu_ctps_serie;
	}

	/**
	 * @param string $usu_ctps_serie
	 */
	public function setUsuCtpsSerie($usu_ctps_serie) {
		$this->usu_ctps_serie = $usu_ctps_serie;
	}

	/**
	 * @return DateTime
	 */
	public function getUsuCtpsDtEmissao() {
		return self::_returnDate($this->usu_ctps_dt_emissao);
	}

	/**
	 * @param DateTime $usu_ctps_dt_emissao
	 */
	public function setUsuCtpsDtEmissao($usu_ctps_dt_emissao) {
		$this->usu_ctps_dt_emissao = $usu_ctps_dt_emissao;
	}

	/**
	 * @return string
	 */
	public function getUsuTitEleitor() {
		return $this->usu_tit_eleitor;
	}

	/**
	 * @param string $usu_tit_eleitor
	 */
	public function setUsuTitEleitor($usu_tit_eleitor) {
		$this->usu_tit_eleitor = $usu_tit_eleitor;
	}

	/**
	 * @return string
	 */
	public function getUsuTitEleitorZona() {
		return $this->usu_tit_eleitor_zona;
	}

	/**
	 * @param string $usu_tit_eleitor_zona
	 */
	public function setUsuTitEleitorZona($usu_tit_eleitor_zona) {
		$this->usu_tit_eleitor_zona = $usu_tit_eleitor_zona;
	}

	/**
	 * @return string
	 */
	public function getUsuTitEleitorSecao() {
		return $this->usu_tit_eleitor_secao;
	}

	/**
	 * @param string $usu_tit_eleitor_secao
	 */
	public function setUsuTitEleitorSecao($usu_tit_eleitor_secao) {
		$this->usu_tit_eleitor_secao = $usu_tit_eleitor_secao;
	}

	/**
	 * @return string
	 */
	public function getUsuMae() {
		return $this->usu_mae;
	}

	/**
	 * @param string $usu_mae
	 */
	public function setUsuMae($usu_mae) {
		$this->usu_mae = $usu_mae;
	}

	/**
	 * @return string
	 */
	public function getUsuPai() {
		return $this->usu_pai;
	}

	/**
	 * @param string $usu_pai
	 */
	public function setUsuPai($usu_pai) {
		$this->usu_pai = $usu_pai;
	}

	/**
	 * @return string
	 */
	public function getRacCodigo() {
		return $this->rac_codigo;
	}

	/**
	 * @param string $rac_codigo
	 */
	public function setRacCodigo($rac_codigo) {
		$this->rac_codigo = $rac_codigo;
	}

	/**
	 * @return string
	 */
	public function getUsuCisvir() {
		return $this->usu_cisvir;
	}

	/**
	 * @param string $usu_cisvir
	 */
	public function setUsuCisvir($usu_cisvir) {
		$this->usu_cisvir = $usu_cisvir;
	}

	/**
	 * @return string
	 */
	public function getUsuEndRua() {
		return $this->usu_end_rua;
	}

	/**
	 * @param string $usu_end_rua
	 */
	public function setUsuEndRua($usu_end_rua) {
		$this->usu_end_rua = $usu_end_rua;
	}

	/**
	 * @return string
	 */
	public function getUsuEndNr() {
		return $this->usu_end_nr;
	}

	/**
	 * @param string $usu_end_nr
	 */
	public function setUsuEndNr($usu_end_nr) {
		$this->usu_end_nr = $usu_end_nr;
	}

	/**
	 * @return string
	 */
	public function getUsuEndCompl() {
		return $this->usu_end_compl;
	}

	/**
	 * @param string $usu_end_compl
	 */
	public function setUsuEndCompl($usu_end_compl) {
		$this->usu_end_compl = $usu_end_compl;
	}

	/**
	 * @return string
	 */
	public function getUsuEndBairro() {
		return $this->usu_end_bairro;
	}

	/**
	 * @param string $usu_end_bairro
	 */
	public function setUsuEndBairro($usu_end_bairro) {
		$this->usu_end_bairro = $usu_end_bairro;
	}

	/**
	 * @return string
	 */
	public function getUsuEndCep() {
		return $this->usu_end_cep;
	}

	/**
	 * @param string $usu_end_cep
	 */
	public function setUsuEndCep($usu_end_cep) {
		$this->usu_end_cep = $usu_end_cep;
	}

	/**
	 * @return string
	 */
	public function getUsuEndCidade() {
		return $this->usu_end_cidade;
	}

	/**
	 * @param string $usu_end_cidade
	 */
	public function setUsuEndCidade($usu_end_cidade) {
		$this->usu_end_cidade = $usu_end_cidade;
	}

	/**
	 * @return string
	 */
	public function getUsuCidadeNasc() {
		return $this->usu_cidade_nasc;
	}

	/**
	 * @param string $usu_cidade_nasc
	 */
	public function setUsuCidadeNasc($usu_cidade_nasc) {
		$this->usu_cidade_nasc = $usu_cidade_nasc;
	}

	/**
	 * @return string
	 */
	public function getUsuFone() {
		return $this->usu_fone;
	}

	/**
	 * @param string $usu_fone
	 */
	public function setUsuFone($usu_fone) {
		$this->usu_fone = $usu_fone;
	}

	/**
	 * @return string
	 */
	public function getUsuCelular() {
		return $this->usu_celular;
	}

	/**
	 * @param string $usu_celular
	 */
	public function setUsuCelular($usu_celular) {
		$this->usu_celular = $usu_celular;
	}

	/**
	 * @return string
	 */
	public function getUsuSame() {
		return $this->usu_same;
	}

	/**
	 * @param string $usu_same
	 */
	public function setUsuSame($usu_same) {
		$this->usu_same = $usu_same;
	}

	/**
	 * @return string
	 */
	public function getUsuProntuario() {
		return $this->usu_prontuario;
	}

	/**
	 * @param string $usu_prontuario
	 */
	public function setUsuProntuario($usu_prontuario) {
		$this->usu_prontuario = $usu_prontuario;
	}

	/**
	 * @return int
	 */
	public function getUniOrigem() {
		return $this->uni_origem;
	}

	/**
	 * @param int $uni_origem
	 */
	public function setUniOrigem($uni_origem) {
		$this->uni_origem = $uni_origem;
	}

	/**
	 * @return string
	 */
	public function getUsuFreqEscolar() {
		return $this->usu_freq_escolar;
	}

	/**
	 * @param string $usu_freq_escolar
	 */
	public function setUsuFreqEscolar($usu_freq_escolar) {
		$this->usu_freq_escolar = $usu_freq_escolar;
	}

	/**
	 * @return string
	 */
	public function getUniUnidadeBkp() {
		return $this->uni_unidade_bkp;
	}

	/**
	 * @param string $uni_unidade_bkp
	 */
	public function setUniUnidadeBkp($uni_unidade_bkp) {
		$this->uni_unidade_bkp = $uni_unidade_bkp;
	}

	/**
	 * @return mixed
	 */
	public function getUsuarioCadastro() {
		return self::_returnArray($this->usuario_cadastro);
	}

	/**
	 * @param mixed $usuario_cadastro
	 */
	public function setUsuarioCadastro($usuario_cadastro) {
		$this->usuario_cadastro = $usuario_cadastro;
	}

	/**
	 * @return int
	 */
	public function getUsrAlt() {
		return $this->usr_alt;
	}

	/**
	 * @param int $usr_alt
	 */
	public function setUsrAlt($usr_alt) {
		$this->usr_alt = $usr_alt;
	}

	/**
	 * @return DateTime
	 */
	public function getDtAdd() {
		return self::_returnDate($this->dt_add);
	}

	/**
	 * @param DateTime $dt_add
	 */
	public function setDtAdd($dt_add) {
		$this->dt_add = $dt_add;
	}

	/**
	 * @return int
	 */
	public function getDtUpdate() {
		return $this->dt_update;
	}

	/**
	 * @param int $dt_update
	 */
	public function setDtUpdate($dt_update) {
		$this->dt_update = $dt_update;
	}

	/**
	 * @return string
	 */
	public function getUsuIbgeCodigo() {
		return $this->usu_ibge_codigo;
	}

	/**
	 * @param string $usu_ibge_codigo
	 */
	public function setUsuIbgeCodigo($usu_ibge_codigo) {
		$this->usu_ibge_codigo = $usu_ibge_codigo;
	}

	/**
	 * @return int
	 */
	public function getIdRua() {
		return $this->id_rua;
	}

	/**
	 * @param int $id_rua
	 */
	public function setIdRua($id_rua) {
		$this->id_rua = $id_rua;
	}

	/**
	 * @return string
	 */
	public function getUsuRespNome() {
		return $this->usu_resp_nome;
	}

	/**
	 * @param string $usu_resp_nome
	 */
	public function setUsuRespNome($usu_resp_nome) {
		$this->usu_resp_nome = $usu_resp_nome;
	}

	/**
	 * @return string
	 */
	public function getUsuRespDocTipo() {
		return $this->usu_resp_doc_tipo;
	}

	/**
	 * @param string $usu_resp_doc_tipo
	 */
	public function setUsuRespDocTipo($usu_resp_doc_tipo) {
		$this->usu_resp_doc_tipo = $usu_resp_doc_tipo;
	}

	/**
	 * @return string
	 */
	public function getUsuRespDoc() {
		return $this->usu_resp_doc;
	}

	/**
	 * @param string $usu_resp_doc
	 */
	public function setUsuRespDoc($usu_resp_doc) {
		$this->usu_resp_doc = $usu_resp_doc;
	}

	/**
	 * @return DateTime
	 */
	public function getUsrCadDt() {
		return self::_returnDate($this->usr_cad_dt);
	}

	/**
	 * @param DateTime $usr_cad_dt
	 */
	public function setUsrCadDt($usr_cad_dt) {
		$this->usr_cad_dt = $usr_cad_dt;
	}

	/**
	 * @return DateTime
	 */
	public function getUsrAltDt() {
		return self::_returnDate($this->usr_alt_dt);
	}

	/**
	 * @param DateTime $usr_alt_dt
	 */
	public function setUsrAltDt($usr_alt_dt) {
		$this->usr_alt_dt = $usr_alt_dt;
	}

	/**
	 * @return string
	 */
	public function getMuniCdCodIbgeResid() {
		return $this->muni_cd_cod_ibge_resid;
	}

	/**
	 * @param string $muni_cd_cod_ibge_resid
	 */
	public function setMuniCdCodIbgeResid($muni_cd_cod_ibge_resid) {
		$this->muni_cd_cod_ibge_resid = $muni_cd_cod_ibge_resid;
	}

	/**
	 * @return int
	 */
	public function getUniUnidade() {
		return $this->uni_unidade;
	}

	/**
	 * @param int $uni_unidade
	 */
	public function setUniUnidade($uni_unidade) {
		$this->uni_unidade = $uni_unidade;
	}

	/**
	 * @return string
	 */
	public function getMuniCdCodIbgeNasc() {
		return $this->muni_cd_cod_ibge_nasc;
	}

	/**
	 * @param string $muni_cd_cod_ibge_nasc
	 */
	public function setMuniCdCodIbgeNasc($muni_cd_cod_ibge_nasc) {
		$this->muni_cd_cod_ibge_nasc = $muni_cd_cod_ibge_nasc;
	}

	/**
	 * @return string
	 */
	public function getIdUsuario() {
		return $this->id_usuario;
	}

	/**
	 * @param string $id_usuario
	 */
	public function setIdUsuario($id_usuario) {
		$this->id_usuario = $id_usuario;
	}

	/**
	 * @return string
	 */
	public function getCdNacionalidade() {
		return $this->cd_nacionalidade;
	}

	/**
	 * @param string $cd_nacionalidade
	 */
	public function setCdNacionalidade($cd_nacionalidade) {
		$this->cd_nacionalidade = $cd_nacionalidade;
	}

	/**
	 * @return DateTime
	 */
	public function getDtNaturalizacao() {
		return self::_returnDate($this->dt_naturalizacao);
	}

	/**
	 * @param DateTime $dt_naturalizacao
	 */
	public function setDtNaturalizacao($dt_naturalizacao) {
		$this->dt_naturalizacao = $dt_naturalizacao;
	}

	/**
	 * @return DateTime
	 */
	public function getDtPreenchimentoForm() {
		return self::_returnDate($this->dt_preenchimento_form);
	}

	/**
	 * @param DateTime $dt_preenchimento_form
	 */
	public function setDtPreenchimentoForm($dt_preenchimento_form) {
		$this->dt_preenchimento_form = $dt_preenchimento_form;
	}

	/**
	 * @return DateTime
	 */
	public function getDtInclusao() {
		return self::_returnDate($this->dt_inclusao);
	}

	/**
	 * @param DateTime $dt_inclusao
	 */
	public function setDtInclusao($dt_inclusao) {
		$this->dt_inclusao = $dt_inclusao;
	}

	/**
	 * @return DateTime
	 */
	public function getDtAlteracao() {
		return self::_returnDate($this->dt_alteracao);
	}

	/**
	 * @param DateTime $dt_alteracao
	 */
	public function setDtAlteracao($dt_alteracao) {
		$this->dt_alteracao = $dt_alteracao;
	}

	/**
	 * @return string
	 */
	public function getNrUsoMunicipal() {
		return $this->nr_uso_municipal;
	}

	/**
	 * @param string $nr_uso_municipal
	 */
	public function setNrUsoMunicipal($nr_uso_municipal) {
		$this->nr_uso_municipal = $nr_uso_municipal;
	}

	/**
	 * @return string
	 */
	public function getNrPortariaNaturalizacao() {
		return $this->nr_portaria_naturalizacao;
	}

	/**
	 * @param string $nr_portaria_naturalizacao
	 */
	public function setNrPortariaNaturalizacao($nr_portaria_naturalizacao) {
		$this->nr_portaria_naturalizacao = $nr_portaria_naturalizacao;
	}

	/**
	 * @return string
	 */
	public function getUfCodigoPac() {
		return $this->uf_codigo_pac;
	}

	/**
	 * @param string $uf_codigo_pac
	 */
	public function setUfCodigoPac($uf_codigo_pac) {
		$this->uf_codigo_pac = $uf_codigo_pac;
	}

	/**
	 * @return string
	 */
	public function getUsuEscolaridade() {
		return $this->usu_escolaridade;
	}

	/**
	 * @param string $usu_escolaridade
	 */
	public function setUsuEscolaridade($usu_escolaridade) {
		$this->usu_escolaridade = $usu_escolaridade;
	}

	/**
	 * @return string
	 */
	public function getUsuStConjugal() {
		return $this->usu_st_conjugal;
	}

	/**
	 * @param string $usu_st_conjugal
	 */
	public function setUsuStConjugal($usu_st_conjugal) {
		$this->usu_st_conjugal = $usu_st_conjugal;
	}

	/**
	 * @return int
	 */
	public function getUsuNrFicha() {
		return $this->usu_nr_ficha;
	}

	/**
	 * @param int $usu_nr_ficha
	 */
	public function setUsuNrFicha($usu_nr_ficha) {
		$this->usu_nr_ficha = $usu_nr_ficha;
	}

	/**
	 * @return string
	 */
	public function getUsuCadastrador() {
		return $this->usu_cadastrador;
	}

	/**
	 * @param string $usu_cadastrador
	 */
	public function setUsuCadastrador($usu_cadastrador) {
		$this->usu_cadastrador = $usu_cadastrador;
	}

	/**
	 * @return string
	 */
	public function getUsuBolsaAlimentacao() {
		return $this->usu_bolsa_alimentacao;
	}

	/**
	 * @param string $usu_bolsa_alimentacao
	 */
	public function setUsuBolsaAlimentacao($usu_bolsa_alimentacao) {
		$this->usu_bolsa_alimentacao = $usu_bolsa_alimentacao;
	}

	/**
	 * @return string
	 */
	public function getUsuProdea() {
		return $this->usu_prodea;
	}

	/**
	 * @param string $usu_prodea
	 */
	public function setUsuProdea($usu_prodea) {
		$this->usu_prodea = $usu_prodea;
	}

	/**
	 * @return string
	 */
	public function getUsuNomeOperador() {
		return $this->usu_nome_operador;
	}

	/**
	 * @param string $usu_nome_operador
	 */
	public function setUsuNomeOperador($usu_nome_operador) {
		$this->usu_nome_operador = $usu_nome_operador;
	}

	/**
	 * @return string
	 */
	public function getUsuSituacaoEmprego() {
		return $this->usu_situacao_emprego;
	}

	/**
	 * @param string $usu_situacao_emprego
	 */
	public function setUsuSituacaoEmprego($usu_situacao_emprego) {
		$this->usu_situacao_emprego = $usu_situacao_emprego;
	}

	/**
	 * @return float
	 */
	public function getUsuRendaMedia() {
		return $this->usu_renda_media;
	}

	/**
	 * @param float $usu_renda_media
	 */
	public function setUsuRendaMedia($usu_renda_media) {
		$this->usu_renda_media = $usu_renda_media;
	}

	/**
	 * @return string
	 */
	public function getUsuDoencas() {
		return $this->usu_doencas;
	}

	/**
	 * @param string $usu_doencas
	 */
	public function setUsuDoencas($usu_doencas) {
		$this->usu_doencas = $usu_doencas;
	}

	/**
	 * @return string
	 */
	public function getUsuHabitosVida() {
		return $this->usu_habitos_vida;
	}

	/**
	 * @param string $usu_habitos_vida
	 */
	public function setUsuHabitosVida($usu_habitos_vida) {
		$this->usu_habitos_vida = $usu_habitos_vida;
	}

	/**
	 * @return string
	 */
	public function getUsuNrLote() {
		return $this->usu_nr_lote;
	}

	/**
	 * @param string $usu_nr_lote
	 */
	public function setUsuNrLote($usu_nr_lote) {
		$this->usu_nr_lote = $usu_nr_lote;
	}

	/**
	 * @return string
	 */
	public function getUsuReservista() {
		return $this->usu_reservista;
	}

	/**
	 * @param string $usu_reservista
	 */
	public function setUsuReservista($usu_reservista) {
		$this->usu_reservista = $usu_reservista;
	}

	/**
	 * @return string
	 */
	public function getUsuCnhNumero() {
		return $this->usu_cnh_numero;
	}

	/**
	 * @param string $usu_cnh_numero
	 */
	public function setUsuCnhNumero($usu_cnh_numero) {
		$this->usu_cnh_numero = $usu_cnh_numero;
	}

	/**
	 * @return string
	 */
	public function getUsuCnhCategoria() {
		return $this->usu_cnh_categoria;
	}

	/**
	 * @param string $usu_cnh_categoria
	 */
	public function setUsuCnhCategoria($usu_cnh_categoria) {
		$this->usu_cnh_categoria = $usu_cnh_categoria;
	}

	/**
	 * @return string
	 */
	public function getUsuFoneRecado() {
		return $this->usu_fone_recado;
	}

	/**
	 * @param string $usu_fone_recado
	 */
	public function setUsuFoneRecado($usu_fone_recado) {
		$this->usu_fone_recado = $usu_fone_recado;
	}

	/**
	 * @return string
	 */
	public function getUsuEmail() {
		return $this->usu_email;
	}

	/**
	 * @param string $usu_email
	 */
	public function setUsuEmail($usu_email) {
		$this->usu_email = $usu_email;
	}

	/**
	 * @return string
	 */
	public function getUsuZonaResidencia() {
		return $this->usu_zona_residencia;
	}

	/**
	 * @param string $usu_zona_residencia
	 */
	public function setUsuZonaResidencia($usu_zona_residencia) {
		$this->usu_zona_residencia = $usu_zona_residencia;
	}

	/**
	 * @return string
	 */
	public function getUsuEstadoCivil() {
		return $this->usu_estado_civil;
	}

	/**
	 * @param string $usu_estado_civil
	 */
	public function setUsuEstadoCivil($usu_estado_civil) {
		$this->usu_estado_civil = $usu_estado_civil;
	}

	/**
	 * @return string
	 */
	public function getUsuConjuge() {
		return $this->usu_conjuge;
	}

	/**
	 * @param string $usu_conjuge
	 */
	public function setUsuConjuge($usu_conjuge) {
		$this->usu_conjuge = $usu_conjuge;
	}

	/**
	 * @return int
	 */
	public function getNespCodigo() {
		return $this->nesp_codigo;
	}

	/**
	 * @param int $nesp_codigo
	 */
	public function setNespCodigo($nesp_codigo) {
		$this->nesp_codigo = $nesp_codigo;
	}

	/**
	 * @return string
	 */
	public function getUsuBolsaFamilia() {
		return $this->usu_bolsa_familia;
	}

	/**
	 * @param string $usu_bolsa_familia
	 */
	public function setUsuBolsaFamilia($usu_bolsa_familia) {
		$this->usu_bolsa_familia = $usu_bolsa_familia;
	}

	/**
	 * @return string
	 */
	public function getUsuTransportePublico() {
		return $this->usu_transporte_publico;
	}

	/**
	 * @param string $usu_transporte_publico
	 */
	public function setUsuTransportePublico($usu_transporte_publico) {
		$this->usu_transporte_publico = $usu_transporte_publico;
	}

	/**
	 * @return string
	 */
	public function getUsuCertCivilEmissor() {
		return $this->usu_cert_civil_emissor;
	}

	/**
	 * @param string $usu_cert_civil_emissor
	 */
	public function setUsuCertCivilEmissor($usu_cert_civil_emissor) {
		$this->usu_cert_civil_emissor = $usu_cert_civil_emissor;
	}

	/**
	 * @return string
	 */
	public function getUsuNis() {
		return $this->usu_nis;
	}

	/**
	 * @param string $usu_nis
	 */
	public function setUsuNis($usu_nis) {
		$this->usu_nis = $usu_nis;
	}

	/**
	 * @return DateTime
	 */
	public function getUsuDataCad() {
		return self::_returnDate($this->usu_data_cad);
	}

	/**
	 * @param DateTime $usu_data_cad
	 */
	public function setUsuDataCad($usu_data_cad) {
		$this->usu_data_cad = $usu_data_cad;
	}

	/**
	 * @return int
	 */
	public function getUsuQtdComodos() {
		return $this->usu_qtd_comodos;
	}

	/**
	 * @param int $usu_qtd_comodos
	 */
	public function setUsuQtdComodos($usu_qtd_comodos) {
		$this->usu_qtd_comodos = $usu_qtd_comodos;
	}

	/**
	 * @return int
	 */
	public function getUsuProntuarioNum() {
		return $this->usu_prontuario_num;
	}

	/**
	 * @param int $usu_prontuario_num
	 */
	public function setUsuProntuarioNum($usu_prontuario_num) {
		$this->usu_prontuario_num = $usu_prontuario_num;
	}

	/**
	 * @return string
	 */
	public function getUsuCertCartorioNasc() {
		return $this->usu_cert_cartorio_nasc;
	}

	/**
	 * @param string $usu_cert_cartorio_nasc
	 */
	public function setUsuCertCartorioNasc($usu_cert_cartorio_nasc) {
		$this->usu_cert_cartorio_nasc = $usu_cert_cartorio_nasc;
	}

	/**
	 * @return string
	 */
	public function getUsuCertLivroNasc() {
		return $this->usu_cert_livro_nasc;
	}

	/**
	 * @param string $usu_cert_livro_nasc
	 */
	public function setUsuCertLivroNasc($usu_cert_livro_nasc) {
		$this->usu_cert_livro_nasc = $usu_cert_livro_nasc;
	}

	/**
	 * @return string
	 */
	public function getUsuCertLvFlsNasc() {
		return $this->usu_cert_lv_fls_nasc;
	}

	/**
	 * @param string $usu_cert_lv_fls_nasc
	 */
	public function setUsuCertLvFlsNasc($usu_cert_lv_fls_nasc) {
		$this->usu_cert_lv_fls_nasc = $usu_cert_lv_fls_nasc;
	}

	/**
	 * @return string
	 */
	public function getUsuCertTermoNasc() {
		return $this->usu_cert_termo_nasc;
	}

	/**
	 * @param string $usu_cert_termo_nasc
	 */
	public function setUsuCertTermoNasc($usu_cert_termo_nasc) {
		$this->usu_cert_termo_nasc = $usu_cert_termo_nasc;
	}

	/**
	 * @return string
	 */
	public function getUsuGestor() {
		return $this->usu_gestor;
	}

	/**
	 * @param string $usu_gestor
	 */
	public function setUsuGestor($usu_gestor) {
		$this->usu_gestor = $usu_gestor;
	}

	/**
	 * @return mixed
	 */
	public function getSecretaria() {
		return self::_returnArray($this->secretaria);
	}

	/**
	 * @param mixed $secretaria
	 */
	public function setSecretaria($secretaria) {
		$this->secretaria = $secretaria;
	}

	/**
	 * @return string
	 */
	public function getPaisCodigo() {
		return $this->pais_codigo;
	}

	/**
	 * @param string $pais_codigo
	 */
	public function setPaisCodigo($pais_codigo) {
		$this->pais_codigo = $pais_codigo;
	}

	/**
	 * @return string
	 */
	public function getUsuCodigoSus() {
		return $this->usu_codigo_sus;
	}

	/**
	 * @param string $usu_codigo_sus
	 */
	public function setUsuCodigoSus($usu_codigo_sus) {
		$this->usu_codigo_sus = $usu_codigo_sus;
	}

	/**
	 * @return DateTime
	 */
	public function getUsuDtObito() {
		return self::_returnDate($this->usu_dt_obito);
	}

	/**
	 * @param DateTime $usu_dt_obito
	 */
	public function setUsuDtObito($usu_dt_obito) {
		$this->usu_dt_obito = $usu_dt_obito;
	}

	/**
	 * @return string
	 */
	public function getUsuObito() {
		return $this->usu_obito;
	}

	/**
	 * @param string $usu_obito
	 */
	public function setUsuObito($usu_obito) {
		$this->usu_obito = $usu_obito;
	}

	/**
	 * @return string
	 */
	public function getUsuUfCertCivil() {
		return $this->usu_uf_cert_civil;
	}

	/**
	 * @param string $usu_uf_cert_civil
	 */
	public function setUsuUfCertCivil($usu_uf_cert_civil) {
		$this->usu_uf_cert_civil = $usu_uf_cert_civil;
	}

	/**
	 * @return string
	 */
	public function getUfSiglaRg() {
		return $this->uf_sigla_rg;
	}

	/**
	 * @param string $uf_sigla_rg
	 */
	public function setUfSiglaRg($uf_sigla_rg) {
		$this->uf_sigla_rg = $uf_sigla_rg;
	}

	/**
	 * @return string
	 */
	public function getUfSiglaCtps() {
		return $this->uf_sigla_ctps;
	}

	/**
	 * @param string $uf_sigla_ctps
	 */
	public function setUfSiglaCtps($uf_sigla_ctps) {
		$this->uf_sigla_ctps = $uf_sigla_ctps;
	}

	/**
	 * @return string
	 */
	public function getUsuAtivacao() {
		return $this->usu_ativacao;
	}

	/**
	 * @param string $usu_ativacao
	 */
	public function setUsuAtivacao($usu_ativacao) {
		$this->usu_ativacao = $usu_ativacao;
	}

	/**
	 * @return DateTime
	 */
	public function getUsuDtAtivacaoDesativacao() {
		return self::_returnDate($this->usu_dt_ativacao_desativacao);
	}

	/**
	 * @param DateTime $usu_dt_ativacao_desativacao
	 */
	public function setUsuDtAtivacaoDesativacao($usu_dt_ativacao_desativacao) {
		$this->usu_dt_ativacao_desativacao = $usu_dt_ativacao_desativacao;
	}

	/**
	 * @return DateTime
	 */
	public function getUsuCertEmissaoNasc() {
		return self::_returnDate($this->usu_cert_emissao_nasc);
	}

	/**
	 * @param DateTime $usu_cert_emissao_nasc
	 */
	public function setUsuCertEmissaoNasc($usu_cert_emissao_nasc) {
		$this->usu_cert_emissao_nasc = $usu_cert_emissao_nasc;
	}

	/**
	 * @return string
	 */
	public function getUsuTipoEsgoto() {
		return $this->usu_tipo_esgoto;
	}

	/**
	 * @param string $usu_tipo_esgoto
	 */
	public function setUsuTipoEsgoto($usu_tipo_esgoto) {
		$this->usu_tipo_esgoto = $usu_tipo_esgoto;
	}

	/**
	 * @return string
	 */
	public function getUsuTipoConstCasa() {
		return $this->usu_tipo_const_casa;
	}

	/**
	 * @param string $usu_tipo_const_casa
	 */
	public function setUsuTipoConstCasa($usu_tipo_const_casa) {
		$this->usu_tipo_const_casa = $usu_tipo_const_casa;
	}

	/**
	 * @return string
	 */
	public function getUsuRedeEletrica() {
		return $this->usu_rede_eletrica;
	}

	/**
	 * @param string $usu_rede_eletrica
	 */
	public function setUsuRedeEletrica($usu_rede_eletrica) {
		$this->usu_rede_eletrica = $usu_rede_eletrica;
	}

	/**
	 * @return string
	 */
	public function getUsuTipoAbastAgua() {
		return $this->usu_tipo_abast_agua;
	}

	/**
	 * @param string $usu_tipo_abast_agua
	 */
	public function setUsuTipoAbastAgua($usu_tipo_abast_agua) {
		$this->usu_tipo_abast_agua = $usu_tipo_abast_agua;
	}

	/**
	 * @return string
	 */
	public function getUsuCboR() {
		return $this->usu_cbo_r;
	}

	/**
	 * @param string $usu_cbo_r
	 */
	public function setUsuCboR($usu_cbo_r) {
		$this->usu_cbo_r = $usu_cbo_r;
	}

	/**
	 * @return string
	 */
	public function getUsuCertLvFls() {
		return $this->usu_cert_lv_fls;
	}

	/**
	 * @param string $usu_cert_lv_fls
	 */
	public function setUsuCertLvFls($usu_cert_lv_fls) {
		$this->usu_cert_lv_fls = $usu_cert_lv_fls;
	}

	/**
	 * @return int
	 */
	public function getUsuCodigoPai() {
		return $this->usu_codigo_pai;
	}

	/**
	 * @param int $usu_codigo_pai
	 */
	public function setUsuCodigoPai($usu_codigo_pai) {
		$this->usu_codigo_pai = $usu_codigo_pai;
	}

	/**
	 * @return int
	 */
	public function getUsuCodigoMae() {
		return $this->usu_codigo_mae;
	}

	/**
	 * @param int $usu_codigo_mae
	 */
	public function setUsuCodigoMae($usu_codigo_mae) {
		$this->usu_codigo_mae = $usu_codigo_mae;
	}

	/**
	 * @return int
	 */
	public function getUsuCodigoConjuge() {
		return $this->usu_codigo_conjuge;
	}

	/**
	 * @param int $usu_codigo_conjuge
	 */
	public function setUsuCodigoConjuge($usu_codigo_conjuge) {
		$this->usu_codigo_conjuge = $usu_codigo_conjuge;
	}

	/**
	 * @return string
	 */
	public function getUsuCodigoEnc() {
		return $this->usu_codigo_enc;
	}

	/**
	 * @param string $usu_codigo_enc
	 */
	public function setUsuCodigoEnc($usu_codigo_enc) {
		$this->usu_codigo_enc = $usu_codigo_enc;
	}

	/**
	 * @return string
	 */
	public function getUsuCodigoVer() {
		return $this->usu_codigo_ver;
	}

	/**
	 * @param string $usu_codigo_ver
	 */
	public function setUsuCodigoVer($usu_codigo_ver) {
		$this->usu_codigo_ver = $usu_codigo_ver;
	}

	/**
	 * @return string
	 */
	public function getEcdCodigo() {
		return $this->ecd_codigo;
	}

	/**
	 * @param string $ecd_codigo
	 */
	public function setEcdCodigo($ecd_codigo) {
		$this->ecd_codigo = $ecd_codigo;
	}

	/**
	 * @return mixed
	 */
	public function getDomicilio() {
//		return self::_returnArray($this->domicilio);
		return $this->domicilio;
	}

	/**
	 * @param mixed $domicilio
	 */
	public function setDomicilio($domicilio) {
		$this->domicilio = $domicilio;
	}

	/**
	 * @return string
	 */
	public function getUsuPlanoSaude() {
		return $this->usu_plano_saude;
	}

	/**
	 * @param string $usu_plano_saude
	 */
	public function setUsuPlanoSaude($usu_plano_saude) {
		$this->usu_plano_saude = $usu_plano_saude;
	}

	/**
	 * @return string
	 */
	public function getUsuDescPlanoSaude() {
		return $this->usu_desc_plano_saude;
	}

	/**
	 * @param string $usu_desc_plano_saude
	 */
	public function setUsuDescPlanoSaude($usu_desc_plano_saude) {
		$this->usu_desc_plano_saude = $usu_desc_plano_saude;
	}

	/**
	 * @return int
	 */
	public function getEtnCodigo() {
		return $this->etn_codigo;
	}

	/**
	 * @param int $etn_codigo
	 */
	public function setEtnCodigo($etn_codigo) {
		$this->etn_codigo = $etn_codigo;
	}

	/**
	 * @return string
	 */
	public function getUsuFatorRh() {
		return $this->usu_fator_rh;
	}

	/**
	 * @param string $usu_fator_rh
	 */
	public function setUsuFatorRh($usu_fator_rh) {
		$this->usu_fator_rh = $usu_fator_rh;
	}

	/**
	 * @return string
	 */
	public function getUsuTipoSanguineo() {
		return $this->usu_tipo_sanguineo;
	}

	/**
	 * @param string $usu_tipo_sanguineo
	 */
	public function setUsuTipoSanguineo($usu_tipo_sanguineo) {
		$this->usu_tipo_sanguineo = $usu_tipo_sanguineo;
	}

	/**
	 * @return string
	 */
	public function getUsuRgEmissor() {
		return $this->usu_rg_emissor;
	}

	/**
	 * @param string $usu_rg_emissor
	 */
	public function setUsuRgEmissor($usu_rg_emissor) {
		$this->usu_rg_emissor = $usu_rg_emissor;
	}

	/**
	 * @return bool
	 */
	public function isUsuBloqueado() {
		return $this->usu_bloqueado;
	}

	/**
	 * @param bool $usu_bloqueado
	 */
	public function setUsuBloqueado($usu_bloqueado) {
		$this->usu_bloqueado = $usu_bloqueado;
	}

	/**
	 * @return int
	 */
	public function getUniCodigoObito() {
		return $this->uni_codigo_obito;
	}

	/**
	 * @param int $uni_codigo_obito
	 */
	public function setUniCodigoObito($uni_codigo_obito) {
		$this->uni_codigo_obito = $uni_codigo_obito;
	}

	/**
	 * @return int
	 */
	public function getCd10CodigoObito() {
		return $this->cd10_codigo_obito;
	}

	/**
	 * @param int $cd10_codigo_obito
	 */
	public function setCd10CodigoObito($cd10_codigo_obito) {
		$this->cd10_codigo_obito = $cd10_codigo_obito;
	}

	/**
	 * @return string
	 */
	public function getUsuNomeResp() {
		return $this->usu_nome_resp;
	}

	/**
	 * @param string $usu_nome_resp
	 */
	public function setUsuNomeResp($usu_nome_resp) {
		$this->usu_nome_resp = $usu_nome_resp;
	}

	/**
	 * @return string
	 */
	public function getUsuImportacao() {
		return $this->usu_importacao;
	}

	/**
	 * @param string $usu_importacao
	 */
	public function setUsuImportacao($usu_importacao) {
		$this->usu_importacao = $usu_importacao;
	}

	/**
	 * @return int
	 */
	public function getUsrCodigo() {
		return $this->usr_codigo;
	}

	/**
	 * @param int $usr_codigo
	 */
	public function setUsrCodigo($usr_codigo) {
		$this->usr_codigo = $usr_codigo;
	}

	/**
	 * @return string
	 */
	public function getUsuFotoNome() {
		return $this->usu_foto_nome;
	}

	/**
	 * @param string $usu_foto_nome
	 */
	public function setUsuFotoNome($usu_foto_nome) {
		$this->usu_foto_nome = $usu_foto_nome;
	}

	/**
	 * @return int
	 */
	public function getIdbio() {
		return $this->idbio;
	}

	/**
	 * @param int $idbio
	 */
	public function setIdbio($idbio) {
		$this->idbio = $idbio;
	}

	/**
	 * @return string
	 */
	public function getUsuChefe() {
		return $this->usu_chefe;
	}

	/**
	 * @param string $usu_chefe
	 */
	public function setUsuChefe($usu_chefe) {
		$this->usu_chefe = $usu_chefe;
	}

	/**
	 * @return mixed
	 */
	public function getUsuFoto() {
		return $this->usu_foto;
	}

	/**
	 * @param mixed $usu_foto
	 */
	public function setUsuFoto($usu_foto) {
		$this->usu_foto = $usu_foto;
	}

	/**
	 * @return string
	 */
	public function getUsuStResponsavelFamiliar() {
		return $this->usu_st_responsavel_familiar;
	}

	/**
	 * @param string $usu_st_responsavel_familiar
	 */
	public function setUsuStResponsavelFamiliar($usu_st_responsavel_familiar) {
		$this->usu_st_responsavel_familiar = $usu_st_responsavel_familiar;
	}

	/**
	 * @return string
	 */
	public function getUsuCnsResponsavelFamiliar() {
		return $this->usu_cns_responsavel_familiar;
	}

	/**
	 * @param string $usu_cns_responsavel_familiar
	 */
	public function setUsuCnsResponsavelFamiliar($usu_cns_responsavel_familiar) {
		$this->usu_cns_responsavel_familiar = $usu_cns_responsavel_familiar;
	}

	/**
	 * @return mixed
	 */
	public function getUnidade() {
		return self::_returnArray($this->unidade);
	}

	/**
	 * @param mixed $unidade
	 */
	public function setUnidade($unidade) {
		$this->unidade = $unidade;
	}

	/**
	 * @return string
	 */
	public function getEstcCodigo() {
		return $this->estc_codigo;
	}

	/**
	 * @param string $estc_codigo
	 */
	public function setEstcCodigo($estc_codigo) {
		$this->estc_codigo = $estc_codigo;
	}

	/**
	 * @return bool
	 */
	public function isUsuAsAposentado() {
		return $this->usu_as_aposentado;
	}

	/**
	 * @param bool $usu_as_aposentado
	 */
	public function setUsuAsAposentado($usu_as_aposentado) {
		$this->usu_as_aposentado = $usu_as_aposentado;
	}

	/**
	 * @return bool
	 */
	public function isUsuAsBpc() {
		return $this->usu_as_bpc;
	}

	/**
	 * @param bool $usu_as_bpc
	 */
	public function setUsuAsBpc($usu_as_bpc) {
		$this->usu_as_bpc = $usu_as_bpc;
	}

	/**
	 * @return bool
	 */
	public function isUsuAsdeficiencia() {
		return $this->usu_asdeficiencia;
	}

	/**
	 * @param bool $usu_asdeficiencia
	 */
	public function setUsuAsdeficiencia($usu_asdeficiencia) {
		$this->usu_asdeficiencia = $usu_asdeficiencia;
	}

	/**
	 * @return string
	 */
	public function getUsuAsdocCnprov() {
		return $this->usu_asdoc_cnprov;
	}

	/**
	 * @param string $usu_asdoc_cnprov
	 */
	public function setUsuAsdocCnprov($usu_asdoc_cnprov) {
		$this->usu_asdoc_cnprov = $usu_asdoc_cnprov;
	}

	/**
	 * @return string
	 */
	public function getUsuAsdocRgprov() {
		return $this->usu_asdoc_rgprov;
	}

	/**
	 * @param string $usu_asdoc_rgprov
	 */
	public function setUsuAsdocRgprov($usu_asdoc_rgprov) {
		$this->usu_asdoc_rgprov = $usu_asdoc_rgprov;
	}

	/**
	 * @return string
	 */
	public function getUsuAsdocCtpsprov() {
		return $this->usu_asdoc_ctpsprov;
	}

	/**
	 * @param string $usu_asdoc_ctpsprov
	 */
	public function setUsuAsdocCtpsprov($usu_asdoc_ctpsprov) {
		$this->usu_asdoc_ctpsprov = $usu_asdoc_ctpsprov;
	}

	/**
	 * @return string
	 */
	public function getUsuAsdocCpfprov() {
		return $this->usu_asdoc_cpfprov;
	}

	/**
	 * @param string $usu_asdoc_cpfprov
	 */
	public function setUsuAsdocCpfprov($usu_asdoc_cpfprov) {
		$this->usu_asdoc_cpfprov = $usu_asdoc_cpfprov;
	}

	/**
	 * @return string
	 */
	public function getUsuAsdocTeprov() {
		return $this->usu_asdoc_teprov;
	}

	/**
	 * @param string $usu_asdoc_teprov
	 */
	public function setUsuAsdocTeprov($usu_asdoc_teprov) {
		$this->usu_asdoc_teprov = $usu_asdoc_teprov;
	}

	/**
	 * @return string
	 */
	public function getUsuAsApelido() {
		return $this->usu_as_apelido;
	}

	/**
	 * @param string $usu_as_apelido
	 */
	public function setUsuAsApelido($usu_as_apelido) {
		$this->usu_as_apelido = $usu_as_apelido;
	}

	/**
	 * @return bool
	 */
	public function isUsuAspsAtivo() {
		return $this->usu_asps_ativo;
	}

	/**
	 * @param bool $usu_asps_ativo
	 */
	public function setUsuAspsAtivo($usu_asps_ativo) {
		$this->usu_asps_ativo = $usu_asps_ativo;
	}

	/**
	 * @return bool
	 */
	public function isUsuAspsRef() {
		return $this->usu_asps_ref;
	}

	/**
	 * @param bool $usu_asps_ref
	 */
	public function setUsuAspsRef($usu_asps_ref) {
		$this->usu_asps_ref = $usu_asps_ref;
	}

	/**
	 * @return bool
	 */
	public function isAsUsuAlfabetizado() {
		return $this->as_usu_alfabetizado;
	}

	/**
	 * @param bool $as_usu_alfabetizado
	 */
	public function setAsUsuAlfabetizado($as_usu_alfabetizado) {
		$this->as_usu_alfabetizado = $as_usu_alfabetizado;
	}

	/**
	 * @return bool
	 */
	public function isAsUsuEstuda() {
		return $this->as_usu_estuda;
	}

	/**
	 * @param bool $as_usu_estuda
	 */
	public function setAsUsuEstuda($as_usu_estuda) {
		$this->as_usu_estuda = $as_usu_estuda;
	}

	/**
	 * @return int
	 */
	public function getAsUsuEscolaridade() {
		return $this->as_usu_escolaridade;
	}

	/**
	 * @param int $as_usu_escolaridade
	 */
	public function setAsUsuEscolaridade($as_usu_escolaridade) {
		$this->as_usu_escolaridade = $as_usu_escolaridade;
	}

	/**
	 * @return int
	 */
	public function getAsCondOcupacao() {
		return $this->as_cond_ocupacao;
	}

	/**
	 * @param int $as_cond_ocupacao
	 */
	public function setAsCondOcupacao($as_cond_ocupacao) {
		$this->as_cond_ocupacao = $as_cond_ocupacao;
	}

	/**
	 * @return bool
	 */
	public function isAsPossuiQualificacao() {
		return $this->as_possui_qualificacao;
	}

	/**
	 * @param bool $as_possui_qualificacao
	 */
	public function setAsPossuiQualificacao($as_possui_qualificacao) {
		$this->as_possui_qualificacao = $as_possui_qualificacao;
	}

	/**
	 * @return string
	 */
	public function getAsPossuiQualificacaoQual() {
		return $this->as_possui_qualificacao_qual;
	}

	/**
	 * @param string $as_possui_qualificacao_qual
	 */
	public function setAsPossuiQualificacaoQual($as_possui_qualificacao_qual) {
		$this->as_possui_qualificacao_qual = $as_possui_qualificacao_qual;
	}

	/**
	 * @return float
	 */
	public function getAsRendaMensal() {
		return $this->as_renda_mensal;
	}

	/**
	 * @param float $as_renda_mensal
	 */
	public function setAsRendaMensal($as_renda_mensal) {
		$this->as_renda_mensal = $as_renda_mensal;
	}

	/**
	 * @return int
	 */
	public function getUsuAsTipoDeficiencia() {
		return $this->usu_as_tipo_deficiencia;
	}

	/**
	 * @param int $usu_as_tipo_deficiencia
	 */
	public function setUsuAsTipoDeficiencia($usu_as_tipo_deficiencia) {
		$this->usu_as_tipo_deficiencia = $usu_as_tipo_deficiencia;
	}

	/**
	 * @return bool
	 */
	public function isUsuAsCuidadoConstante() {
		return $this->usu_as_cuidado_constante;
	}

	/**
	 * @param bool $usu_as_cuidado_constante
	 */
	public function setUsuAsCuidadoConstante($usu_as_cuidado_constante) {
		$this->usu_as_cuidado_constante = $usu_as_cuidado_constante;
	}

	/**
	 * @return string
	 */
	public function getUsuAsRespCuidado() {
		return $this->usu_as_resp_cuidado;
	}

	/**
	 * @param string $usu_as_resp_cuidado
	 */
	public function setUsuAsRespCuidado($usu_as_resp_cuidado) {
		$this->usu_as_resp_cuidado = $usu_as_resp_cuidado;
	}

	/**
	 * @return bool
	 */
	public function isUsuAsDoencaGrava() {
		return $this->usu_as_doenca_grava;
	}

	/**
	 * @param bool $usu_as_doenca_grava
	 */
	public function setUsuAsDoencaGrava($usu_as_doenca_grava) {
		$this->usu_as_doenca_grava = $usu_as_doenca_grava;
	}

	/**
	 * @return bool
	 */
	public function isUsuAsRemedioControlado() {
		return $this->usu_as_remedio_controlado;
	}

	/**
	 * @param bool $usu_as_remedio_controlado
	 */
	public function setUsuAsRemedioControlado($usu_as_remedio_controlado) {
		$this->usu_as_remedio_controlado = $usu_as_remedio_controlado;
	}

	/**
	 * @return bool
	 */
	public function isUsuAsAlcoolatra() {
		return $this->usu_as_alcoolatra;
	}

	/**
	 * @param bool $usu_as_alcoolatra
	 */
	public function setUsuAsAlcoolatra($usu_as_alcoolatra) {
		$this->usu_as_alcoolatra = $usu_as_alcoolatra;
	}

	/**
	 * @return bool
	 */
	public function isUsuAsDrogado() {
		return $this->usu_as_drogado;
	}

	/**
	 * @param bool $usu_as_drogado
	 */
	public function setUsuAsDrogado($usu_as_drogado) {
		$this->usu_as_drogado = $usu_as_drogado;
	}

	/**
	 * @return bool
	 */
	public function isUsuAsSituacao() {
		return $this->usu_as_situacao;
	}

	/**
	 * @param bool $usu_as_situacao
	 */
	public function setUsuAsSituacao($usu_as_situacao) {
		$this->usu_as_situacao = $usu_as_situacao;
	}

	/**
	 * @return string
	 */
	public function getUsuSitRua() {
		return $this->usu_sit_rua;
	}

	/**
	 * @param string $usu_sit_rua
	 */
	public function setUsuSitRua($usu_sit_rua) {
		$this->usu_sit_rua = $usu_sit_rua;
	}

	/**
	 * @return bool
	 */
	public function isUsuDeficiencia() {
		return $this->usu_deficiencia;
	}

	/**
	 * @param bool $usu_deficiencia
	 */
	public function setUsuDeficiencia($usu_deficiencia) {
		$this->usu_deficiencia = $usu_deficiencia;
	}

	/**
	 * @return string
	 */
	public function getUsuRecado() {
		return $this->usu_recado;
	}

	/**
	 * @param string $usu_recado
	 */
	public function setUsuRecado($usu_recado) {
		$this->usu_recado = $usu_recado;
	}

	/**
	 * @return int
	 */
	public function getAspsuParentesco() {
		return $this->aspsu_parentesco;
	}

	/**
	 * @param int $aspsu_parentesco
	 */
	public function setAspsuParentesco($aspsu_parentesco) {
		$this->aspsu_parentesco = $aspsu_parentesco;
	}

	/**
	 * @return bool
	 */
	public function isUsuTemDiabete() {
		return $this->usu_tem_diabete;
	}

	/**
	 * @param bool $usu_tem_diabete
	 */
	public function setUsuTemDiabete($usu_tem_diabete) {
		$this->usu_tem_diabete = $usu_tem_diabete;
	}

	/**
	 * @return bool
	 */
	public function isUsuEstaGestante() {
		return $this->usu_esta_gestante;
	}

	/**
	 * @param bool $usu_esta_gestante
	 */
	public function setUsuEstaGestante($usu_esta_gestante) {
		$this->usu_esta_gestante = $usu_esta_gestante;
	}

	/**
	 * @return bool
	 */
	public function isUsuTemHipertensao() {
		return $this->usu_tem_hipertensao;
	}

	/**
	 * @param bool $usu_tem_hipertensao
	 */
	public function setUsuTemHipertensao($usu_tem_hipertensao) {
		$this->usu_tem_hipertensao = $usu_tem_hipertensao;
	}

	/**
	 * @return string
	 */
	public function getUsuFiliacao() {
		return $this->usu_filiacao;
	}

	/**
	 * @param string $usu_filiacao
	 */
	public function setUsuFiliacao($usu_filiacao) {
		$this->usu_filiacao = $usu_filiacao;
	}

	/**
	 * @return string
	 */
	public function getUsuNatural() {
		return $this->usu_natural;
	}

	/**
	 * @param string $usu_natural
	 */
	public function setUsuNatural($usu_natural) {
		$this->usu_natural = $usu_natural;
	}

	/**
	 * @return string
	 */
	public function getUsuSituacaoRenda() {
		return $this->usu_situacao_renda;
	}

	/**
	 * @param string $usu_situacao_renda
	 */
	public function setUsuSituacaoRenda($usu_situacao_renda) {
		$this->usu_situacao_renda = $usu_situacao_renda;
	}

	/**
	 * @return string
	 */
	public function getUsuFoneComercial() {
		return $this->usu_fone_comercial;
	}

	/**
	 * @param string $usu_fone_comercial
	 */
	public function setUsuFoneComercial($usu_fone_comercial) {
		$this->usu_fone_comercial = $usu_fone_comercial;
	}

	/**
	 * @return string
	 */
	public function getUsuEnderecoComercial() {
		return $this->usu_endereco_comercial;
	}

	/**
	 * @param string $usu_endereco_comercial
	 */
	public function setUsuEnderecoComercial($usu_endereco_comercial) {
		$this->usu_endereco_comercial = $usu_endereco_comercial;
	}

	/**
	 * @return string
	 */
	public function getUsuBairroComercial() {
		return $this->usu_bairro_comercial;
	}

	/**
	 * @param string $usu_bairro_comercial
	 */
	public function setUsuBairroComercial($usu_bairro_comercial) {
		$this->usu_bairro_comercial = $usu_bairro_comercial;
	}

	/**
	 * @return string
	 */
	public function getUsuComplementoComercial() {
		return $this->usu_complemento_comercial;
	}

	/**
	 * @param string $usu_complemento_comercial
	 */
	public function setUsuComplementoComercial($usu_complemento_comercial) {
		$this->usu_complemento_comercial = $usu_complemento_comercial;
	}

	/**
	 * @return string
	 */
	public function getUsuMunicipioComercial() {
		return $this->usu_municipio_comercial;
	}

	/**
	 * @param string $usu_municipio_comercial
	 */
	public function setUsuMunicipioComercial($usu_municipio_comercial) {
		$this->usu_municipio_comercial = $usu_municipio_comercial;
	}

	/**
	 * @return string
	 */
	public function getUsuUfComercial() {
		return $this->usu_uf_comercial;
	}

	/**
	 * @param string $usu_uf_comercial
	 */
	public function setUsuUfComercial($usu_uf_comercial) {
		$this->usu_uf_comercial = $usu_uf_comercial;
	}

	/**
	 * @return string
	 */
	public function getUsuTempoServico() {
		return $this->usu_tempo_servico;
	}

	/**
	 * @param string $usu_tempo_servico
	 */
	public function setUsuTempoServico($usu_tempo_servico) {
		$this->usu_tempo_servico = $usu_tempo_servico;
	}

	/**
	 * @return mixed
	 */
	public function getEsusPais() {
		return self::_returnArray($this->esus_pais);
	}

	/**
	 * @param mixed $esus_pais
	 */
	public function setEsusPais($esus_pais) {
		$this->esus_pais = $esus_pais;
	}

	/**
	 * @return bool
	 */
	public function isUsuOrigemProntuario() {
		return $this->usu_origem_prontuario;
	}

	/**
	 * @param bool $usu_origem_prontuario
	 */
	public function setUsuOrigemProntuario($usu_origem_prontuario) {
		$this->usu_origem_prontuario = $usu_origem_prontuario;
	}

	/**
	 * @return string
	 */
	public function getUsuNomeSocial() {
		return $this->usu_nome_social;
	}

	/**
	 * @param string $usu_nome_social
	 */
	public function setUsuNomeSocial($usu_nome_social) {
		$this->usu_nome_social = $usu_nome_social;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}