<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 02/04/2018
 * Time: 17:30
 */

namespace App\Entity;


use App\Entity\AbstractEntity;
use Doctrine\ORM\Mapping as ORM;
use DateTime;
/**
 * @Entity
 * @Table(name="config")
 */
class Configuracoes extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @Column(type="bigint", name="conf_codigo")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", name="conf_chave", length=100)
	 */
	private $chave;
	/**
	 * @var string
	 * @Column(type="string", name="conf_label", length=100)
	 */
	private $label;
	/**
	 * @var boolean
	 * @Column(type="boolean", name="conf_readonly")
	 */
	private $readonly;
	/**
	 * @var integer
	 * @Column(type="integer", name="conf_tipo")
	 */
	private $tipo;
	/**
	 * @var string
	 * @Column(type="string", name="conf_valor_string")
	 */
	private $valor_string;
	/**
	 * @var boolean
	 * @Column(type="boolean", name="conf_valor_bool")
	 */
	private $valor_bool;
	/**
	 * @var integer
	 * @Column(type="integer", name="conf_valor_int")
	 */
	private $valor_int;
	/**
	 * @var DateTime
	 * @Column(type="date", name="conf_valor_data")
	 */
	private $valor_data;
	/**
	 * @OneToOne(targetEntity="Categoria")
	 * @JoinColumn(name="cac_codigo", referencedColumnName="cac_codigo")
	 */
	private $categoria;
	/**
	 * @var integer
	 * @Column(type="integer", name="conf_maxlength")
	 */
	private $maxlength;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getChave() {
		return $this->chave;
	}

	/**
	 * @param string $chave
	 */
	public function setChave($chave) {
		$this->chave = $chave;
	}

	/**
	 * @return string
	 */
	public function getLabel() {
		return $this->label;
	}

	/**
	 * @param string $label
	 */
	public function setLabel($label) {
		$this->label = $label;
	}

	/**
	 * @return bool
	 */
	public function isReadonly() {
		return $this->readonly;
	}

	/**
	 * @param bool $readonly
	 */
	public function setReadonly($readonly) {
		$this->readonly = $readonly;
	}

	/**
	 * @return int
	 */
	public function getTipo() {
		return $this->tipo;
	}

	/**
	 * @param int $tipo
	 */
	public function setTipo($tipo) {
		$this->tipo = $tipo;
	}

	/**
	 * @return string
	 */
	public function getValorString() {
		return $this->valor_string;
	}

	/**
	 * @param string $valor_string
	 */
	public function setValorString($valor_string) {
		$this->valor_string = $valor_string;
	}

	/**
	 * @return bool
	 */
	public function isValorBool() {
		return $this->valor_bool;
	}

	/**
	 * @param bool $valor_bool
	 */
	public function setValorBool($valor_bool) {
		$this->valor_bool = $valor_bool;
	}

	/**
	 * @return int
	 */
	public function getValorInt() {
		return $this->valor_int;
	}

	/**
	 * @param int $valor_int
	 */
	public function setValorInt($valor_int) {
		$this->valor_int = $valor_int;
	}

	/**
	 * @return DateTime
	 */
	public function getValorData() {
		return self::_returnDate($this->valor_data);
	}

	/**
	 * @param DateTime $valor_data
	 */
	public function setValorData($valor_data) {
		$this->valor_data = $valor_data;
	}

	/**
	 * @return mixed
	 */
	public function getCategoria() {
		return self::_returnArray($this->categoria);
	}

	/**
	 * @param mixed $categoria
	 */
	public function setCategoria($categoria) {
		$this->categoria = $categoria;
	}

	/**
	 * @return int
	 */
	public function getMaxlength() {
		return $this->maxlength;
	}

	/**
	 * @param int $maxlength
	 */
	public function setMaxlength($maxlength) {
		$this->maxlength = $maxlength;
	}

	public function toArray(){
		return parent::_toArray($this);
	}
}