<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 05/04/2018
 * Time: 15:55
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="bairro")
 */
class Bairro extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @Column(name="bai_codigo", type="integer")
	 */
	private $id;
	/**
	 * @OneToOne(targetEntity="Cidade")
	 * @JoinColumn(name="cid_codigo", referencedColumnName="cid_codigo")
	 */
	private $cidade;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $bai_co_cep;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $bai_co_dne;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $bai_nome;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $bai_abreviatura;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $bai_filtro;
	/**
	 * @OneToOne(targetEntity="Distrito")
	 * @JoinColumn(name="dis_codigo", referencedColumnName="dis_codigo")
	 */
	private $dis_codigo;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return mixed
	 */
	public function getCidade() {
		return self::_returnArray($this->cidade);
	}

	/**
	 * @param mixed $cidade
	 */
	public function setCidade($cidade) {
		$this->cidade = $cidade;
	}

	/**
	 * @return string
	 */
	public function getBaiCoCep() {
		return $this->bai_co_cep;
	}

	/**
	 * @param string $bai_co_cep
	 */
	public function setBaiCoCep($bai_co_cep) {
		$this->bai_co_cep = $bai_co_cep;
	}

	/**
	 * @return string
	 */
	public function getBaiCoDne() {
		return $this->bai_co_dne;
	}

	/**
	 * @param string $bai_co_dne
	 */
	public function setBaiCoDne($bai_co_dne) {
		$this->bai_co_dne = $bai_co_dne;
	}

	/**
	 * @return string
	 */
	public function getBaiNome() {
		return $this->bai_nome;
	}

	/**
	 * @param string $bai_nome
	 */
	public function setBaiNome($bai_nome) {
		$this->bai_nome = $bai_nome;
	}

	/**
	 * @return string
	 */
	public function getBaiAbreviatura() {
		return $this->bai_abreviatura;
	}

	/**
	 * @param string $bai_abreviatura
	 */
	public function setBaiAbreviatura($bai_abreviatura) {
		$this->bai_abreviatura = $bai_abreviatura;
	}

	/**
	 * @return string
	 */
	public function getBaiFiltro() {
		return $this->bai_filtro;
	}

	/**
	 * @param string $bai_filtro
	 */
	public function setBaiFiltro($bai_filtro) {
		$this->bai_filtro = $bai_filtro;
	}

	/**
	 * @return mixed
	 */
	public function getDisCodigo() {
		return self::_returnArray($this->dis_codigo);
	}

	/**
	 * @param mixed $dis_codigo
	 */
	public function setDisCodigo($dis_codigo) {
		$this->dis_codigo = $dis_codigo;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}