<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 05/04/2018
 * Time: 15:52
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="cidade")
 */
class Cidade extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @Column(name="cid_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=60, nullable=false)
	 */
	private $cid_nome;
	/**
	 * @OneToOne(targetEntity="Estado")
	 * @JoinColumn(name="uf_codigo", referencedColumnName="uf_codigo")
	 */
	private $estado;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cid_codigo_ibge;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $uf_sigla;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $cid_nu_cep;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $cid_nu_dne;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cid_nome_abreviatura;
	/**
	 * @OneToOne(targetEntity="TbTipoLocalidade")
	 * @JoinColumn(name="tp_localidade", referencedColumnName="co_tipo_localidade")
	 */
	private $tipo_localidade;
	/**
	 * @OneToOne(targetEntity="TbSituacaoLocalidade")
	 * @JoinColumn(name="co_situacao_localidade", referencedColumnName="co_situacao_localidade")
	 */
	private $situacao_localidade;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cid_nome_filtro;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getCidNome() {
		return $this->cid_nome;
	}

	/**
	 * @param string $cid_nome
	 */
	public function setCidNome($cid_nome) {
		$this->cid_nome = $cid_nome;
	}

	/**
	 * @return mixed
	 */
	public function getEstado() {
		return self::_returnArray($this->estado);
	}

	/**
	 * @param mixed $estado
	 */
	public function setEstado($estado) {
		$this->estado = $estado;
	}

	/**
	 * @return string
	 */
	public function getCidCodigoIbge() {
		return $this->cid_codigo_ibge;
	}

	/**
	 * @param string $cid_codigo_ibge
	 */
	public function setCidCodigoIbge($cid_codigo_ibge) {
		$this->cid_codigo_ibge = $cid_codigo_ibge;
	}

	/**
	 * @return string
	 */
	public function getUfSigla() {
		return $this->uf_sigla;
	}

	/**
	 * @param string $uf_sigla
	 */
	public function setUfSigla($uf_sigla) {
		$this->uf_sigla = $uf_sigla;
	}

	/**
	 * @return string
	 */
	public function getCidNuCep() {
		return $this->cid_nu_cep;
	}

	/**
	 * @param string $cid_nu_cep
	 */
	public function setCidNuCep($cid_nu_cep) {
		$this->cid_nu_cep = $cid_nu_cep;
	}

	/**
	 * @return string
	 */
	public function getCidNuDne() {
		return $this->cid_nu_dne;
	}

	/**
	 * @param string $cid_nu_dne
	 */
	public function setCidNuDne($cid_nu_dne) {
		$this->cid_nu_dne = $cid_nu_dne;
	}

	/**
	 * @return string
	 */
	public function getCidNomeAbreviatura() {
		return $this->cid_nome_abreviatura;
	}

	/**
	 * @param string $cid_nome_abreviatura
	 */
	public function setCidNomeAbreviatura($cid_nome_abreviatura) {
		$this->cid_nome_abreviatura = $cid_nome_abreviatura;
	}

	/**
	 * @return mixed
	 */
	public function getTipoLocalidade() {
		return self::_returnArray($this->tipo_localidade);
	}

	/**
	 * @param mixed $tipo_localidade
	 */
	public function setTipoLocalidade($tipo_localidade) {
		$this->tipo_localidade = $tipo_localidade;
	}

	/**
	 * @return mixed
	 */
	public function getSituacaoLocalidade() {
		return self::_returnArray($this->situacao_localidade);
	}

	/**
	 * @param mixed $situacao_localidade
	 */
	public function setSituacaoLocalidade($situacao_localidade) {
		$this->situacao_localidade = $situacao_localidade;
	}

	/**
	 * @return string
	 */
	public function getCidNomeFiltro() {
		return $this->cid_nome_filtro;
	}

	/**
	 * @param string $cid_nome_filtro
	 */
	public function setCidNomeFiltro($cid_nome_filtro) {
		$this->cid_nome_filtro = $cid_nome_filtro;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}