<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 05/04/2018
 * Time: 16:38
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="distrito")
 */
class Distrito extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue(strategy="AUTO")
	 * @Column(name="dis_codigo", type="integer")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $dis_nome;
	/**
	 * @OneToOne(targetEntity="Cidade")
	 * @JoinColumn(name="cid_codigo", referencedColumnName="cid_codigo")
	 */
	private $cidade;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getDisNome() {
		return $this->dis_nome;
	}

	/**
	 * @param string $dis_nome
	 */
	public function setDisNome($dis_nome) {
		$this->dis_nome = $dis_nome;
	}

	/**
	 * @return mixed
	 */
	public function getCidade() {
		return self::_returnArray($this->cidade);
	}

	/**
	 * @param mixed $cidade
	 */
	public function setCidade($cidade) {
		$this->cidade = $cidade;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}