<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 16:59
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;
use DateTime;

/**
 * @Entity
 * @Table(name="domicilio")
 */
class Domicilio extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_dom_codigo")
	 * @Column(name="dom_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $dom_data_cadastro;
	/**
	 * @OneToOne(targetEntity="Rua")
	 * @JoinColumn(name="rua_codigo", referencedColumnName="rua_codigo")
	 */
	private $rua;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $dom_numero;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $dom_segmento;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $dom_complemento;
	/**
	 * @var mixed
	 * @Column(type="string", length=2)
	 */
	private $co_tipo_domicilio;
	/**
	 * @var string
	 * @Column(type="string", length=14)
	 */
	private $dom_telefone;
	/**
	 * @OneToOne(targetEntity="Cidadao")
	 * @JoinColumn(name="usu_codigo_responsavel", referencedColumnName="usu_codigo", unique=false)
	 */
	private $responsavel;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $dom_ponto_referencia;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $dom_as_localizacao;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $dom_as_abrigo;
	/**
	 * @OneToOne(targetEntity="Usuario")
	 * @JoinColumn(name="usr_codigo", referencedColumnName="usr_codigo")
	 */
	private $usuario;
	/**
	 * @OneToOne(targetEntity="Unidade")
	 * @JoinColumn(name="uni_codigo", referencedColumnName="uni_codigo")
	 */
	private $unidade;
	/**
	 * @OneToOne(targetEntity="TbEquipe")
	 * @JoinColumn(name="cod_equipe", referencedColumnName="co_seq_equipe")
	 */
	private $equipe;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $tipo_imovel;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return DateTime
	 */
	public function getDomDataCadastro() {
		return self::_returnDate($this->dom_data_cadastro);
	}

	/**
	 * @param DateTime $dom_data_cadastro
	 */
	public function setDomDataCadastro($dom_data_cadastro) {
		$this->dom_data_cadastro = $dom_data_cadastro;
	}

	/**
	 * @return int
	 */
	public function getDomNumero() {
		return $this->dom_numero;
	}

	/**
	 * @param int $dom_numero
	 */
	public function setDomNumero($dom_numero) {
		$this->dom_numero = $dom_numero;
	}

	/**
	 * @return string
	 */
	public function getDomSegmento() {
		return $this->dom_segmento;
	}

	/**
	 * @param string $dom_segmento
	 */
	public function setDomSegmento($dom_segmento) {
		$this->dom_segmento = $dom_segmento;
	}

	/**
	 * @return string
	 */
	public function getDomComplemento() {
		return $this->dom_complemento;
	}

	/**
	 * @param string $dom_complemento
	 */
	public function setDomComplemento($dom_complemento) {
		$this->dom_complemento = $dom_complemento;
	}

	/**
	 * @return mixed
	 */
	public function getCoTipoDomicilio() {
		return $this->co_tipo_domicilio;
	}

	/**
	 * @param mixed $co_tipo_domicilio
	 */
	public function setCoTipoDomicilio($co_tipo_domicilio) {
		$this->co_tipo_domicilio = $co_tipo_domicilio;
	}

	/**
	 * @return string
	 */
	public function getDomTelefone() {
		return $this->dom_telefone;
	}

	/**
	 * @param string $dom_telefone
	 */
	public function setDomTelefone($dom_telefone) {
		$this->dom_telefone = $dom_telefone;
	}

	/**
	 * @return mixed
	 */
	public function getResponsavel() {
		return self::_returnArray($this->responsavel);
	}

	/**
	 * @param mixed $responsavel
	 */
	public function setResponsavel($responsavel) {
		$this->responsavel = $responsavel;
	}

	/**
	 * @return string
	 */
	public function getDomPontoReferencia() {
		return $this->dom_ponto_referencia;
	}

	/**
	 * @param string $dom_ponto_referencia
	 */
	public function setDomPontoReferencia($dom_ponto_referencia) {
		$this->dom_ponto_referencia = $dom_ponto_referencia;
	}

	/**
	 * @return string
	 */
	public function getDomAsLocalizacao() {
		return $this->dom_as_localizacao;
	}

	/**
	 * @param string $dom_as_localizacao
	 */
	public function setDomAsLocalizacao($dom_as_localizacao) {
		$this->dom_as_localizacao = $dom_as_localizacao;
	}

	/**
	 * @return bool
	 */
	public function isDomAsAbrigo() {
		return $this->dom_as_abrigo;
	}

	/**
	 * @param bool $dom_as_abrigo
	 */
	public function setDomAsAbrigo($dom_as_abrigo) {
		$this->dom_as_abrigo = $dom_as_abrigo;
	}

	/**
	 * @return mixed
	 */
	public function getUsuario() {
		return self::_returnArray($this->usuario);
	}

	/**
	 * @param mixed $usuario
	 */
	public function setUsuario($usuario) {
		$this->usuario = $usuario;
	}

	/**
	 * @return mixed
	 */
	public function getUnidade() {
		return self::_returnArray($this->unidade);
	}

	/**
	 * @param mixed $unidade
	 */
	public function setUnidade($unidade) {
		$this->unidade = $unidade;
	}

	/**
	 * @return mixed
	 */
	public function getRua() {
		return self::_returnArray($this->rua);
	}

	/**
	 * @param mixed $rua
	 */
	public function setRua($rua) {
		$this->rua = $rua;
	}

	/**
	 * @return mixed
	 */
	public function getEquipe() {
		return self::_returnArray($this->equipe);
	}

	/**
	 * @param mixed $equipe
	 */
	public function setEquipe($equipe) {
		$this->equipe = $equipe;
	}

	/**
	 * @return int
	 */
	public function getTipoImovel() {
		return $this->tipo_imovel;
	}

	/**
	 * @param int $tipo_imovel
	 */
	public function setTipoImovel($tipo_imovel) {
		$this->tipo_imovel = $tipo_imovel;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}