<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 05/04/2018
 * Time: 11:07
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="estado")
 */
class Estado extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_uf_codigo")
	 * @Column(name="uf_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $uf_sigla;
	/**
	 * @var string
	 * @Column(type="string", length=30)
	 */
	private $uf_nome;
	/**
	 * @OneToOne(targetEntity="Pais")
	 * @JoinColumn(name="pais_codigo", referencedColumnName="pais_codigo")
	 */
	private $pais;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $uf_nu_cep;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $uf_nu_dne;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $uf_no_identificador;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $uf_cod_esus;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getUfSigla() {
		return $this->uf_sigla;
	}

	/**
	 * @param string $uf_sigla
	 */
	public function setUfSigla($uf_sigla) {
		$this->uf_sigla = $uf_sigla;
	}

	/**
	 * @return string
	 */
	public function getUfNome() {
		return $this->uf_nome;
	}

	/**
	 * @param string $uf_nome
	 */
	public function setUfNome($uf_nome) {
		$this->uf_nome = $uf_nome;
	}

	/**
	 * @return mixed
	 */
	public function getPais() {
		return self::_returnArray($this->pais);
	}

	/**
	 * @param mixed $pais
	 */
	public function setPais($pais) {
		$this->pais = $pais;
	}

	/**
	 * @return string
	 */
	public function getUfNuCep() {
		return $this->uf_nu_cep;
	}

	/**
	 * @param string $uf_nu_cep
	 */
	public function setUfNuCep($uf_nu_cep) {
		$this->uf_nu_cep = $uf_nu_cep;
	}

	/**
	 * @return string
	 */
	public function getUfNuDne() {
		return $this->uf_nu_dne;
	}

	/**
	 * @param string $uf_nu_dne
	 */
	public function setUfNuDne($uf_nu_dne) {
		$this->uf_nu_dne = $uf_nu_dne;
	}

	/**
	 * @return string
	 */
	public function getUfNoIdentificador() {
		return $this->uf_no_identificador;
	}

	/**
	 * @param string $uf_no_identificador
	 */
	public function setUfNoIdentificador($uf_no_identificador) {
		$this->uf_no_identificador = $uf_no_identificador;
	}

	/**
	 * @return string
	 */
	public function getUfCodEsus() {
		return $this->uf_cod_esus;
	}

	/**
	 * @param string $uf_cod_esus
	 */
	public function setUfCodEsus($uf_cod_esus) {
		$this->uf_cod_esus = $uf_cod_esus;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}