<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 05/04/2018
 * Time: 15:33
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="pais")
 */
class Pais extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_pais_codigo")
	 * @Column(name="pais_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $pais_nome;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $sg_pais_2;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $sg_pais_3;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $no_pais_portugues;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $no_pais_ingles;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $no_pais_frances;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $no_pais_portugues_filtro;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getPaisNome() {
		return $this->pais_nome;
	}

	/**
	 * @param string $pais_nome
	 */
	public function setPaisNome($pais_nome) {
		$this->pais_nome = $pais_nome;
	}

	/**
	 * @return string
	 */
	public function getSgPais2() {
		return $this->sg_pais_2;
	}

	/**
	 * @param string $sg_pais_2
	 */
	public function setSgPais2($sg_pais_2) {
		$this->sg_pais_2 = $sg_pais_2;
	}

	/**
	 * @return string
	 */
	public function getSgPais3() {
		return $this->sg_pais_3;
	}

	/**
	 * @param string $sg_pais_3
	 */
	public function setSgPais3($sg_pais_3) {
		$this->sg_pais_3 = $sg_pais_3;
	}

	/**
	 * @return string
	 */
	public function getNoPaisPortugues() {
		return $this->no_pais_portugues;
	}

	/**
	 * @param string $no_pais_portugues
	 */
	public function setNoPaisPortugues($no_pais_portugues) {
		$this->no_pais_portugues = $no_pais_portugues;
	}

	/**
	 * @return string
	 */
	public function getNoPaisIngles() {
		return $this->no_pais_ingles;
	}

	/**
	 * @param string $no_pais_ingles
	 */
	public function setNoPaisIngles($no_pais_ingles) {
		$this->no_pais_ingles = $no_pais_ingles;
	}

	/**
	 * @return string
	 */
	public function getNoPaisFrances() {
		return $this->no_pais_frances;
	}

	/**
	 * @param string $no_pais_frances
	 */
	public function setNoPaisFrances($no_pais_frances) {
		$this->no_pais_frances = $no_pais_frances;
	}

	/**
	 * @return string
	 */
	public function getNoPaisPortuguesFiltro() {
		return $this->no_pais_portugues_filtro;
	}

	/**
	 * @param string $no_pais_portugues_filtro
	 */
	public function setNoPaisPortuguesFiltro($no_pais_portugues_filtro) {
		$this->no_pais_portugues_filtro = $no_pais_portugues_filtro;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}