<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 05/04/2018
 * Time: 13:52
 */

namespace App\Entity;


use App\Entity\AbstractEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="rua")
 */
class Rua extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_rua_codigo")
	 * @Column(name="rua_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $rua_nome;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $rua_cod_logradouro;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $log_codigo;
	/**
	 * @OneToOne(targetEntity="Cidade")
	 * @JoinColumn(name="cid_codigo", referencedColumnName="cid_codigo")
	 */
	private $cidade;
	/**
	 * @var string
	 * @Column(type="string", length=3)
	 */
	private $co_tipo_logradouro;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $rua_cep;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_bairro;
	/**
	 * @OneToOne(targetEntity="Bairro")
	 * @JoinColumn(name="bai_codigo", referencedColumnName="bai_codigo")
	 */
	private $bairro;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_nu_cep;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_nu_dne;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_no_preposicao;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_nome_abreviatura;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_nu_inicial_trecho;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_nu_final_trecho;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_nu_seccionamento_dne;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_sg_tipo_registro;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_no_logradouro_filtro;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $rua_no_logradouro_exibicao;
	/**
	 * @OneToOne(targetEntity="TbTituloPatente")
	 * @JoinColumn(name="co_titulo_patente", referencedColumnName="co_titulo_patente")
	 */
	private $titulo_patente;
	/**
	 * @OneToOne(targetEntity="TbTipoParidade")
	 * @JoinColumn(name="tp_paridade", referencedColumnName="co_tipo_paridade")
	 */
	private $tipo_paridade;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getRuaNome() {
		return $this->rua_nome;
	}

	/**
	 * @param string $rua_nome
	 */
	public function setRuaNome($rua_nome) {
		$this->rua_nome = $rua_nome;
	}

	/**
	 * @return int
	 */
	public function getRuaCodLogradouro() {
		return $this->rua_cod_logradouro;
	}

	/**
	 * @param int $rua_cod_logradouro
	 */
	public function setRuaCodLogradouro($rua_cod_logradouro) {
		$this->rua_cod_logradouro = $rua_cod_logradouro;
	}

	/**
	 * @return int
	 */
	public function getLogCodigo() {
		return $this->log_codigo;
	}

	/**
	 * @param int $log_codigo
	 */
	public function setLogCodigo($log_codigo) {
		$this->log_codigo = $log_codigo;
	}

	/**
	 * @return mixed
	 */
	public function getCidade() {
		return self::_returnArray($this->cidade);
	}

	/**
	 * @param mixed $cidade
	 */
	public function setCidade($cidade) {
		$this->cidade = $cidade;
	}

	/**
	 * @return string
	 */
	public function getCoTipoLogradouro() {
		return $this->co_tipo_logradouro;
	}

	/**
	 * @param string $co_tipo_logradouro
	 */
	public function setCoTipoLogradouro($co_tipo_logradouro) {
		$this->co_tipo_logradouro = $co_tipo_logradouro;
	}

	/**
	 * @return string
	 */
	public function getRuaCep() {
		return $this->rua_cep;
	}

	/**
	 * @param string $rua_cep
	 */
	public function setRuaCep($rua_cep) {
		$this->rua_cep = $rua_cep;
	}

	/**
	 * @return string
	 */
	public function getRuaBairro() {
		return $this->rua_bairro;
	}

	/**
	 * @param string $rua_bairro
	 */
	public function setRuaBairro($rua_bairro) {
		$this->rua_bairro = $rua_bairro;
	}

	/**
	 * @return mixed
	 */
	public function getBairro() {
		return self::_returnArray($this->bairro);
	}

	/**
	 * @param mixed $bairro
	 */
	public function setBairro($bairro) {
		$this->bairro = $bairro;
	}

	/**
	 * @return string
	 */
	public function getRuaNuCep() {
		return $this->rua_nu_cep;
	}

	/**
	 * @param string $rua_nu_cep
	 */
	public function setRuaNuCep($rua_nu_cep) {
		$this->rua_nu_cep = $rua_nu_cep;
	}

	/**
	 * @return string
	 */
	public function getRuaNuDne() {
		return $this->rua_nu_dne;
	}

	/**
	 * @param string $rua_nu_dne
	 */
	public function setRuaNuDne($rua_nu_dne) {
		$this->rua_nu_dne = $rua_nu_dne;
	}

	/**
	 * @return string
	 */
	public function getRuaNoPreposicao() {
		return $this->rua_no_preposicao;
	}

	/**
	 * @param string $rua_no_preposicao
	 */
	public function setRuaNoPreposicao($rua_no_preposicao) {
		$this->rua_no_preposicao = $rua_no_preposicao;
	}

	/**
	 * @return string
	 */
	public function getRuaNomeAbreviatura() {
		return $this->rua_nome_abreviatura;
	}

	/**
	 * @param string $rua_nome_abreviatura
	 */
	public function setRuaNomeAbreviatura($rua_nome_abreviatura) {
		$this->rua_nome_abreviatura = $rua_nome_abreviatura;
	}

	/**
	 * @return string
	 */
	public function getRuaNuInicialTrecho() {
		return $this->rua_nu_inicial_trecho;
	}

	/**
	 * @param string $rua_nu_inicial_trecho
	 */
	public function setRuaNuInicialTrecho($rua_nu_inicial_trecho) {
		$this->rua_nu_inicial_trecho = $rua_nu_inicial_trecho;
	}

	/**
	 * @return string
	 */
	public function getRuaNuFinalTrecho() {
		return $this->rua_nu_final_trecho;
	}

	/**
	 * @param string $rua_nu_final_trecho
	 */
	public function setRuaNuFinalTrecho($rua_nu_final_trecho) {
		$this->rua_nu_final_trecho = $rua_nu_final_trecho;
	}

	/**
	 * @return string
	 */
	public function getRuaNuSeccionamentoDne() {
		return $this->rua_nu_seccionamento_dne;
	}

	/**
	 * @param string $rua_nu_seccionamento_dne
	 */
	public function setRuaNuSeccionamentoDne($rua_nu_seccionamento_dne) {
		$this->rua_nu_seccionamento_dne = $rua_nu_seccionamento_dne;
	}

	/**
	 * @return string
	 */
	public function getRuaSgTipoRegistro() {
		return $this->rua_sg_tipo_registro;
	}

	/**
	 * @param string $rua_sg_tipo_registro
	 */
	public function setRuaSgTipoRegistro($rua_sg_tipo_registro) {
		$this->rua_sg_tipo_registro = $rua_sg_tipo_registro;
	}

	/**
	 * @return string
	 */
	public function getRuaNoLogradouroFiltro() {
		return $this->rua_no_logradouro_filtro;
	}

	/**
	 * @param string $rua_no_logradouro_filtro
	 */
	public function setRuaNoLogradouroFiltro($rua_no_logradouro_filtro) {
		$this->rua_no_logradouro_filtro = $rua_no_logradouro_filtro;
	}

	/**
	 * @return string
	 */
	public function getRuaNoLogradouroExibicao() {
		return $this->rua_no_logradouro_exibicao;
	}

	/**
	 * @param string $rua_no_logradouro_exibicao
	 */
	public function setRuaNoLogradouroExibicao($rua_no_logradouro_exibicao) {
		$this->rua_no_logradouro_exibicao = $rua_no_logradouro_exibicao;
	}

	/**
	 * @return mixed
	 */
	public function getTituloPatente() {
		return self::_returnArray($this->titulo_patente);
	}

	/**
	 * @param mixed $titulo_patente
	 */
	public function setTituloPatente($titulo_patente) {
		$this->titulo_patente = $titulo_patente;
	}

	/**
	 * @return mixed
	 */
	public function getTipoParidade() {
		return self::_returnArray($this->tipo_paridade);
	}

	/**
	 * @param mixed $tipo_paridade
	 */
	public function setTipoParidade($tipo_paridade) {
		$this->tipo_paridade = $tipo_paridade;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}