<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 13:28
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;
use DateTime;

/**
 * @Entity
 * @Table(name="evento")
 */
class Evento extends AbstractEntity {
	const ABERTO    = "A";
	const ANDAMENTO = "N";
	const FECHADO   = "F";
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_eve_codigo")
	 * @Column(name="eve_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $eve_data_ini;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $eve_data_fim;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $eve_hr_ini2;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $eve_hr_fim2;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $eve_local;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $eve_objetivo;
	/**
	 * @OneToOne(targetEntity="GrupoAtendimento")
	 * @JoinColumn(name="gruate_codigo", referencedColumnName="gruate_codigo")
	 */
	private $grupo_atendimento;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $eve_responsavel;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $eve_status;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $eve_hr_ini;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $eve_obs_conclusao;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $eve_hr_fim;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return DateTime
	 */
	public function getEveDataIni() {
		return $this->eve_data_ini;
	}

	/**
	 * @param DateTime $eve_data_ini
	 */
	public function setEveDataIni($eve_data_ini) {
		$this->eve_data_ini = $eve_data_ini;
	}

	/**
	 * @return DateTime
	 */
	public function getEveDataFim() {
		return $this->eve_data_fim;
	}

	/**
	 * @param DateTime $eve_data_fim
	 */
	public function setEveDataFim($eve_data_fim) {
		$this->eve_data_fim = $eve_data_fim;
	}

	/**
	 * @return DateTime
	 */
	public function getEveHrIni2() {
		return $this->eve_hr_ini2;
	}

	/**
	 * @param DateTime $eve_hr_ini2
	 */
	public function setEveHrIni2($eve_hr_ini2) {
		$this->eve_hr_ini2 = $eve_hr_ini2;
	}

	/**
	 * @return DateTime
	 */
	public function getEveHrFim2() {
		return $this->eve_hr_fim2;
	}

	/**
	 * @param DateTime $eve_hr_fim2
	 */
	public function setEveHrFim2($eve_hr_fim2) {
		$this->eve_hr_fim2 = $eve_hr_fim2;
	}

	/**
	 * @return string
	 */
	public function getEveLocal() {
		return $this->eve_local;
	}

	/**
	 * @param string $eve_local
	 */
	public function setEveLocal($eve_local) {
		$this->eve_local = $eve_local;
	}

	/**
	 * @return string
	 */
	public function getEveObjetivo() {
		return $this->eve_objetivo;
	}

	/**
	 * @param string $eve_objetivo
	 */
	public function setEveObjetivo($eve_objetivo) {
		$this->eve_objetivo = $eve_objetivo;
	}

	/**
	 * @return mixed
	 */
	public function getGrupoAtendimento() {
		return $this->grupo_atendimento;
	}

	/**
	 * @param mixed $grupo_atendimento
	 */
	public function setGrupoAtendimento($grupo_atendimento) {
		$this->grupo_atendimento = $grupo_atendimento;
	}

	/**
	 * @return int
	 */
	public function getEveResponsavel() {
		return $this->eve_responsavel;
	}

	/**
	 * @param int $eve_responsavel
	 */
	public function setEveResponsavel($eve_responsavel) {
		$this->eve_responsavel = $eve_responsavel;
	}

	/**
	 * @return string
	 */
	public function getEveStatus() {
		return $this->eve_status;
	}

	/**
	 * @param string $eve_status
	 */
	public function setEveStatus($eve_status) {
		$this->eve_status = $eve_status;
	}

	/**
	 * @return string
	 */
	public function getEveHrIni() {
		return $this->eve_hr_ini;
	}

	/**
	 * @param string $eve_hr_ini
	 */
	public function setEveHrIni($eve_hr_ini) {
		$this->eve_hr_ini = $eve_hr_ini;
	}

	/**
	 * @return string
	 */
	public function getEveObsConclusao() {
		return $this->eve_obs_conclusao;
	}

	/**
	 * @param string $eve_obs_conclusao
	 */
	public function setEveObsConclusao($eve_obs_conclusao) {
		$this->eve_obs_conclusao = $eve_obs_conclusao;
	}

	/**
	 * @return string
	 */
	public function getEveHrFim() {
		return $this->eve_hr_fim;
	}

	/**
	 * @param string $eve_hr_fim
	 */
	public function setEveHrFim($eve_hr_fim) {
		$this->eve_hr_fim = $eve_hr_fim;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}