<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 05/04/2018
 * Time: 10:56
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="area")
 */
class Area extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_area_codigo")
	 * @Column(name="area_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=40)
	 */
	private $area_desc; //varchar(40)
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $area_obs; //varchar(100),
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $area_modulo;
	/**
	 * @OneToOne(targetEntity="Usuario")
	 * @JoinColumn(name="area_responsavel", referencedColumnName="usr_codigo")
	 */
	private $responsavel;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getAreaDesc() {
		return $this->area_desc;
	}

	/**
	 * @param string $area_desc
	 */
	public function setAreaDesc($area_desc) {
		$this->area_desc = $area_desc;
	}

	/**
	 * @return string
	 */
	public function getAreaObs() {
		return $this->area_obs;
	}

	/**
	 * @param string $area_obs
	 */
	public function setAreaObs($area_obs) {
		$this->area_obs = $area_obs;
	}

	/**
	 * @return int
	 */
	public function getAreaModulo() {
		return $this->area_modulo;
	}

	/**
	 * @param int $area_modulo
	 */
	public function setAreaModulo($area_modulo) {
		$this->area_modulo = $area_modulo;
	}

	/**
	 * @return mixed
	 */
	public function getResponsavel() {
		return $this->responsavel;
	}

	/**
	 * @param mixed $responsavel
	 */
	public function setResponsavel($responsavel) {
		$this->responsavel = $responsavel;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}