<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 17:59
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="cid10")
 */
class Cid10 extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_cid10")
	 * @Column(name="cd10_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $cd10_codigo_cid;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cd10_categoria;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cd10_subcat;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $cd10_descricao;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cd10_restricaosexo;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cd10_opc;
	/**
	 * @var string
	 * @Column(type="string", length=1, options={"default": "A"})
	 */
	private $cd10_ativo;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getCd10CodigoCid() {
		return $this->cd10_codigo_cid;
	}

	/**
	 * @param string $cd10_codigo_cid
	 */
	public function setCd10CodigoCid($cd10_codigo_cid) {
		$this->cd10_codigo_cid = $cd10_codigo_cid;
	}

	/**
	 * @return string
	 */
	public function getCd10Categoria() {
		return $this->cd10_categoria;
	}

	/**
	 * @param string $cd10_categoria
	 */
	public function setCd10Categoria($cd10_categoria) {
		$this->cd10_categoria = $cd10_categoria;
	}

	/**
	 * @return string
	 */
	public function getCd10Subcat() {
		return $this->cd10_subcat;
	}

	/**
	 * @param string $cd10_subcat
	 */
	public function setCd10Subcat($cd10_subcat) {
		$this->cd10_subcat = $cd10_subcat;
	}

	/**
	 * @return string
	 */
	public function getCd10Descricao() {
		return $this->cd10_descricao;
	}

	/**
	 * @param string $cd10_descricao
	 */
	public function setCd10Descricao($cd10_descricao) {
		$this->cd10_descricao = $cd10_descricao;
	}

	/**
	 * @return string
	 */
	public function getCd10Restricaosexo() {
		return $this->cd10_restricaosexo;
	}

	/**
	 * @param string $cd10_restricaosexo
	 */
	public function setCd10Restricaosexo($cd10_restricaosexo) {
		$this->cd10_restricaosexo = $cd10_restricaosexo;
	}

	/**
	 * @return string
	 */
	public function getCd10Opc() {
		return $this->cd10_opc;
	}

	/**
	 * @param string $cd10_opc
	 */
	public function setCd10Opc($cd10_opc) {
		$this->cd10_opc = $cd10_opc;
	}

	/**
	 * @return string
	 */
	public function getCd10Ativo() {
		return $this->cd10_ativo;
	}

	/**
	 * @param string $cd10_ativo
	 */
	public function setCd10Ativo($cd10_ativo) {
		$this->cd10_ativo = $cd10_ativo;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}