<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 12:21
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="fornecedor")
 */
class Fornecedor extends AbstractEntity {
	const JURIDICA = "J";
	const FISICA   = "F";
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_for_codigo")
	 * @Column(name="for_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $for_nome;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $for_endereco;
	/**
	 * @var string
	 * @Column(type="string", length=9)
	 */
	private $for_cep;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $cid_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $for_fone;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $for_nome_fantasia;
	/**
	 * @var string
	 * @Column(type="string", length=18)
	 */
	private $for_cnpj;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $for_insc_est;
	/**
	 * @var string
	 * @Column(type="string", length=11)
	 */
	private $for_cpf;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $for_rg;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $for_email;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $for_homepage;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $for_responsavel;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $for_cidade;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $for_uf;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $for_fax;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 * 'J - JURIDICA | F - FISICA'
	 */
	private $for_tipo;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getForNome() {
		return $this->for_nome;
	}

	/**
	 * @param string $for_nome
	 */
	public function setForNome($for_nome) {
		$this->for_nome = $for_nome;
	}

	/**
	 * @return string
	 */
	public function getForEndereco() {
		return $this->for_endereco;
	}

	/**
	 * @param string $for_endereco
	 */
	public function setForEndereco($for_endereco) {
		$this->for_endereco = $for_endereco;
	}

	/**
	 * @return string
	 */
	public function getForCep() {
		return $this->for_cep;
	}

	/**
	 * @param string $for_cep
	 */
	public function setForCep($for_cep) {
		$this->for_cep = $for_cep;
	}

	/**
	 * @return int
	 */
	public function getCidCodigo() {
		return $this->cid_codigo;
	}

	/**
	 * @param int $cid_codigo
	 */
	public function setCidCodigo($cid_codigo) {
		$this->cid_codigo = $cid_codigo;
	}

	/**
	 * @return string
	 */
	public function getForFone() {
		return $this->for_fone;
	}

	/**
	 * @param string $for_fone
	 */
	public function setForFone($for_fone) {
		$this->for_fone = $for_fone;
	}

	/**
	 * @return string
	 */
	public function getForNomeFantasia() {
		return $this->for_nome_fantasia;
	}

	/**
	 * @param string $for_nome_fantasia
	 */
	public function setForNomeFantasia($for_nome_fantasia) {
		$this->for_nome_fantasia = $for_nome_fantasia;
	}

	/**
	 * @return string
	 */
	public function getForCnpj() {
		return $this->for_cnpj;
	}

	/**
	 * @param string $for_cnpj
	 */
	public function setForCnpj($for_cnpj) {
		$this->for_cnpj = $for_cnpj;
	}

	/**
	 * @return string
	 */
	public function getForInscEst() {
		return $this->for_insc_est;
	}

	/**
	 * @param string $for_insc_est
	 */
	public function setForInscEst($for_insc_est) {
		$this->for_insc_est = $for_insc_est;
	}

	/**
	 * @return string
	 */
	public function getForCpf() {
		return $this->for_cpf;
	}

	/**
	 * @param string $for_cpf
	 */
	public function setForCpf($for_cpf) {
		$this->for_cpf = $for_cpf;
	}

	/**
	 * @return string
	 */
	public function getForRg() {
		return $this->for_rg;
	}

	/**
	 * @param string $for_rg
	 */
	public function setForRg($for_rg) {
		$this->for_rg = $for_rg;
	}

	/**
	 * @return string
	 */
	public function getForEmail() {
		return $this->for_email;
	}

	/**
	 * @param string $for_email
	 */
	public function setForEmail($for_email) {
		$this->for_email = $for_email;
	}

	/**
	 * @return string
	 */
	public function getForHomepage() {
		return $this->for_homepage;
	}

	/**
	 * @param string $for_homepage
	 */
	public function setForHomepage($for_homepage) {
		$this->for_homepage = $for_homepage;
	}

	/**
	 * @return string
	 */
	public function getForResponsavel() {
		return $this->for_responsavel;
	}

	/**
	 * @param string $for_responsavel
	 */
	public function setForResponsavel($for_responsavel) {
		$this->for_responsavel = $for_responsavel;
	}

	/**
	 * @return string
	 */
	public function getForCidade() {
		return $this->for_cidade;
	}

	/**
	 * @param string $for_cidade
	 */
	public function setForCidade($for_cidade) {
		$this->for_cidade = $for_cidade;
	}

	/**
	 * @return string
	 */
	public function getForUf() {
		return $this->for_uf;
	}

	/**
	 * @param string $for_uf
	 */
	public function setForUf($for_uf) {
		$this->for_uf = $for_uf;
	}

	/**
	 * @return string
	 */
	public function getForFax() {
		return $this->for_fax;
	}

	/**
	 * @param string $for_fax
	 */
	public function setForFax($for_fax) {
		$this->for_fax = $for_fax;
	}

	/**
	 * @return string
	 */
	public function getForTipo() {
		return $this->for_tipo;
	}

	/**
	 * @param string $for_tipo
	 */
	public function setForTipo($for_tipo) {
		$this->for_tipo = $for_tipo;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}