<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 05/04/2018
 * Time: 10:57
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="micro_area")
 */
class MicroArea extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_mic_codigo")
	 * @Column(name="mic_codigo", type="integer")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=40)
	 */
	private $mic_descricao;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $co_seq_equipe;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $mic_responsavel;
	/**
	 * @var boolean
	 * @Column(type="boolean", options={"default": true})
	 */
	private $ativo;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getMicDescricao() {
		return $this->mic_descricao;
	}

	/**
	 * @param string $mic_descricao
	 */
	public function setMicDescricao($mic_descricao) {
		$this->mic_descricao = $mic_descricao;
	}

	/**
	 * @return int
	 */
	public function getCoSeqEquipe() {
		return $this->co_seq_equipe;
	}

	/**
	 * @param int $co_seq_equipe
	 */
	public function setCoSeqEquipe($co_seq_equipe) {
		$this->co_seq_equipe = $co_seq_equipe;
	}

	/**
	 * @return int
	 */
	public function getMicResponsavel() {
		return $this->mic_responsavel;
	}

	/**
	 * @param int $mic_responsavel
	 */
	public function setMicResponsavel($mic_responsavel) {
		$this->mic_responsavel = $mic_responsavel;
	}

	/**
	 * @return bool
	 */
	public function isAtivo() {
		return $this->ativo;
	}

	/**
	 * @param bool $ativo
	 */
	public function setAtivo($ativo) {
		$this->ativo = $ativo;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}